# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/views.corr.ipynb (unless otherwise specified).

__all__ = ['CramerVLanding', 'CramerVEstimates', 'CramerV', 'TetraLanding', 'Tetra', 'CorrLanding',
           'SpearmansRhoLanding', 'PBiLanding', 'PearsonLanding', 'CorrView', 'Corr', 'SpearmansRho', 'PBi', 'Pearson']

# Cell
import ipywidgets as ipyw
import traitlets
from traitlets import observe, Unicode
import numpy as np
from fastcore.test import test_eq
from IPython.display import display, Javascript

# Cell
from ..widgets import Dropdown, BoundedFloatText, BoundedIntText, Textarea, Button
from ..widget_containers import VBox, Box, HBox
from ..models.corr import CramerVModel, TetraModel, SpearmansRhoModel, PBiModel, PearsonModel
from .ratio import RatioLanding, RatioEstimates
from ..mvc import Controller
import superpower_gui.superpower as sp

# Cell
class CramerVLanding(RatioLanding):
    pass

# Cell
class CramerVEstimates(HBox):

    def __init__(self, **kwargs):
        super().__init__(layout = ipyw.Layout(width='100%'), **kwargs)

        left = VBox(name='left', layout=ipyw.Layout(min_width='250px', width='30%'))
        self.right = VBox(name='right', layout=ipyw.Layout(width='auto'))

        ''' left '''
        self.textarea = Textarea(layout=ipyw.Layout(width="94%", height="150px"), disabled=True)
        self.effectButton = Button(description='Show effect sizes', button_style='success',
            layout=ipyw.Layout(min_width='220px', max_width='220px',margin = '2px 2px 2px 2px'))
        left.children = (self.textarea, self.effectButton)

        self.children = (left, self.right)

# Cell
class CramerV(CramerVEstimates, Controller):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)
        self.model = model

        self.effectSizes = []
        self.ratio = RatioEstimates(model)
        self.rowCompareButton = Button(layout=ipyw.Layout(width='90%', height='auto'))
        self.ratio[0,0:2] = self.rowCompareButton
        self.right.children += (self.ratio, )

        self.initialize()

        ''' observes '''
        self.rowCompareButton.on_click(self.observeRowCompare)
        self.ratio.colorIntArray.observe(self.observeColors, names='color', type='child_change')
        self.effectButton.on_click(self.observeEffectButton)

    def initialize(self):
        self.ratio.initialize()
        self.textarea.value = ''
        self.observeRowCompare(None)
        if not self.model.hasColors:
            self.rowCompareButton.disabled = True
            self.effectButton.disabled = True

    def setEstimates(self):
        self.ratio.setEstimates()
        super().setEstimates()

    def observeRowCompare(self, button):
        if self.model.rcomp:
            self.model.rcomp = False
            self.rowCompareButton.description = 'Column Compare'
        else:
            self.model.rcomp = True
            self.rowCompareButton.description = 'Row Compare'

    def observeColors(self, change):
        i, j = change['index']
        self.model.changeColor(i, j, change['new'])
        if self.model.hasColors:
            self.effectButton.disabled = False
            self.rowCompareButton.disabled = False
        else:
            self.effectButton.disabled = True
            self.rowCompareButton.disabled = True

    def observeEffectButton(self, button):
        if self.model.hasColors:
            try:
                result = self.model.runEffectSize()
                for i, string in enumerate(self.model.strings):
                    if i == len(self.model.strings) - 1:
                        self.textarea.value += string + ' = %.3f\n\n' % result['results']['power']
                    else:
                        self.textarea.value += string + ':'
                self.effectSizes.append(result)
            except Exception as e:
                display(Javascript('alert("Error: %s\\n\\nDo you mean to be comparing rows or columns?")' % str(e)))

    def run(self):
        result = self.model.run()
        if result:
            result['effectSizes'] = self.effectSizes
        return result

# Cell
class TetraLanding(RatioLanding):
    pass

class Tetra(CramerV):
    pass

# Cell
class CorrLanding(Box):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)
        self.model = model

    def setLanding(self):
        pass

class SpearmansRhoLanding(CorrLanding):
    pass

class PBiLanding(CorrLanding):
    pass

class PearsonLanding(CorrLanding):
    pass

# Cell
class CorrView(VBox):

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.function = SpearmansRhoModel()
        self.r = BoundedFloatText(description='r', min=0, max=1, step=0.01)
        self.N = BoundedIntText(description='N', min=0, max=10**6)
        self.children = (self.N, self.r)

# Cell
class Corr(CorrView):

    def __init__(self, model, **kwargs):
        super().__init__(**kwargs)
        self.model = model
        traitlets.link((self.model, 'r'), (self.r, 'value'))
        traitlets.link((self.model, 'N'), (self.N, 'value'))

    def run(self):
        return self.model.run(**self.model.getTraits())

# Cell
class SpearmansRho(Corr):
    def __init__(self, model, **kwargs):
        super().__init__(model, **kwargs)

class PBi(Corr):
    def __init__(self, model, **kwargs):
        super().__init__(model, **kwargs)

class Pearson(Corr):
    def __init__(self, model, **kwargs):
        super().__init__(model, **kwargs)