# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/settings.ipynb (unless otherwise specified).

__all__ = ['LogAccordion', 'SettingsModel', 'SettingsView', 'Settings']

# Cell
from .mvc import Model, Controller
from .widget_containers import Box, Accordion, VBox, HBox
from .widgets import Dropdown, BoundedFloatText, Output, Button, BoundedIntText
from .config import CONFIG
from .log import WIDGET_HANDLER

# Cell
from traitlets import Unicode, Float, Int
import traitlets
import ipywidgets as ipyw

# Cell
class LogAccordion(Accordion):

    def __init__(self, CONFIG, WIDGET_HANDLER, **kwargs):
        super().__init__(**kwargs)
        self.config = CONFIG
        self.widget_handler = WIDGET_HANDLER
        self.widget_handler._index = {}

        # download logfile button
        html = '''
        <a download="{filename}" href="{filename}" download>
            <button class="p-Widget jupyter-widgets jupyter-button widget-button">Download Logs</button>
        </a>
        '''
        html = html.format(filename=CONFIG['LOG']['filename'])
        self.download = ipyw.HTML(html, layout=ipyw.Layout(display='inline-flex', justify_content='flex-end'))
        self.download._index = {}

        # level options
        level_options = ('DEBUG','INFO', 'WARNING','ERROR', 'CRITICAL')
        layout = ipyw.Layout(width='163px')
        style = {'description_width': 'initial'}
        self.level = Dropdown(description='Log Level',options=level_options, value=self.config['LOG']['level'], layout=layout, style=style)
        self.button = Button(description='Save', icon='save', button_style='success', layout=ipyw.Layout(width='80px'))
        #self.button.on_click(self.saveConfig)

        self.settingsBox = HBox(children=(self.level, self.button), layout=ipyw.Layout(width='100%', justify_content='flex-end'))
        self.topBox = HBox(children=(self.download, self.settingsBox))
        self.logBox = VBox(children=(self.topBox, self.widget_handler), name = 'Logs')
        self.children += (self.logBox,)

    def saveConfig(self, b):
        self.config['LOG']['level'] = str(self.level.value)
        self.config.write_user_config()
        display(Javascript('alert("Settings saved! Restart the app for changes to take effect.");'))

# Cell
class SettingsModel(Model):

    tail = Unicode()
    alpha = Float()
    sims = Int()

    def setLanding(self):
        self.tail = 'two'
        self.alpha = 0.05
        self.sims = 1

# Cell
class SettingsView(VBox):

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.logAccordion = LogAccordion(CONFIG, WIDGET_HANDLER)

        self.settingsBox = Box(layout=ipyw.Layout(width='100%', flex_flow='wrap', padding='40px 0 40px 0'))
        style = {'description_width': 'initial'}
        tailLayout = ipyw.Layout(width = '163px', margin = '15px')
        alphaLayout = ipyw.Layout(width = '71px', margin = '15px')
        simsLayout = ipyw.Layout(width='150px', margin = '15px')
        tailOptions = [('2-tailed', 'two'), ('1-tailed, less', 'less'), ('1-tailed, greater', 'greater')]
        self.tail = Dropdown(options=tailOptions, description = 'Tail:', layout=tailLayout, style=style)
        self.alpha = BoundedFloatText(description='α: ', step=0.01, min = 0.0, max = 1.0, layout=alphaLayout, style=style)
        self.sims = BoundedIntText(description='# of Simulations', style=style, mix=1, layout=simsLayout)
        self.settingsBox.children += (self.tail, self.alpha, self.sims)

        self.children += (self.settingsBox, self.logAccordion)

# Cell
class Settings(SettingsView):

    def __init__(self, model=None, **kwargs):
        super().__init__(**kwargs)
        if model:
            self.introModel(model)

    def introModel(self, model):
        self.model = model
        traitlets.link((self.model, 'tail'), (self.tail, 'value'))
        traitlets.link((self.model, 'alpha'), (self.alpha, 'value'))
        traitlets.link((self.model, 'sims'), (self.sims, 'value'))