# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/models.error_bars.ipynb (unless otherwise specified).

__all__ = ['ErrorBarsModel']

# Cell
from traitlets import Unicode, List, observe, Bool, Float, Int
import traitlets
from traittypes import Array
import numpy as np

# Cell
from ..mvc import Model

# Cell
class ErrorBarsModel(Model):

    '''landing'''
    nBars = Int()
    nGroups = Int()
    total = Int()

    '''estimates'''
    heights = Array(dtype=np.dtype(float))
    errors = Array(dtype=np.dtype(float))
    tops = Array(dtype=np.dtype(float))
    bots = Array(dtype=np.dtype(float))
    colors = List()
    labels = List()
    title = Unicode(allow_none=True)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    def setLanding(self):
        self.nGroups = 1
        self.nBars = 1

    def setEstimates(self):
        labels = ['A', 'B', 'C', 'D', 'E', 'F']
        if self.nGroups == 1:
            self.labels = labels[:self.nBars]
        else:
            self.labels = labels[:self.nGroups]
        self.heights = np.array([100.0]*self.total)
        self.errors = np.array([10.0]*self.total)
        self.tops = np.array([105.0]*self.total)
        self.bots = np.array([95.0]*self.total)
        self.colors = ['lightblue']*self.total
        self.title = None

    def setError(self, i, error):
        self.errors[i] = error
        self.tops[i] = self.heights[i] + (error / 2)
        self.bots[i] = self.heights[i] - (error / 2)

    def setHeight(self, i, height):
        self.heights[i] = height
        self.tops[i] = height + (self.errors[i] / 2)
        self.bots[i] = height - (self.errors[i] / 2)

    def setColor(self, i, color):
        self.colors[i] = color

    @observe('nBars')
    def observe_nBars(self, change):
        self.total = change['new'] * self.nGroups

    @observe('nGroups')
    def observe_nGroups(self, change):
        self.total = self.nBars * change['new']