# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/models.chisq.ipynb (unless otherwise specified).

__all__ = ['ChiSqLandingModel', 'ChiSqModel']

# Cell
from ..superpower.chisq import ChiSqCon, ChiSqInd
from .corr import CramerVModel, CramerVLandingModel
from ..rpy import MatrixMixin

# Cell
from rpy2 import robjects

# Cell
class ChiSqLandingModel(CramerVLandingModel):
    pass

# Cell
class ChiSqModel(CramerVModel, MatrixMixin):

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.ind = ChiSqInd()
        self.con = ChiSqCon()

    def run(self):
        if self.hasColors:
            result = self.runEffectSize()
            w = result['results']['power']
            kwargs = self.getTraits(['mata', 'matb', 'rcomp', 'pVal'])
            nrow = self.matrix.shape[0]
            kwargs['mata'] = self.matrixRFunction(data=kwargs['mata'], nrow=nrow)
            kwargs['matb'] = self.matrixRFunction(data=kwargs['matb'], nrow=nrow)
            return self.con.run(**kwargs)
        else:
            kwargs = self.getTraits(['ns_cells', 'pVal', 'n_col', 'n_row', 'w'])
            kwargs['n_row'], kwargs['n_col'] = kwargs['ns_cells'].shape
            kwargs['ns_cells'] = kwargs['ns_cells'].flatten()
            return self.ind.run(**kwargs)