# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lib_users', 'lib_users.util']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['fd_users = lib_users.fd_users:fd_users',
                     'lib_users = lib_users.lib_users:lib_users']}

setup_kwargs = {
    'name': 'lib-users',
    'version': '0.14.post1',
    'description': 'Checks /proc for libraries and files being mapped/open but marked as deleted',
    'long_description': '# Lib_users\n\nLib_users is a Python script that goes through `/proc/*/maps` and finds all\ncases of libraries being mapped but marked as deleted. It then extracts the\nprograms name and arguments from `/proc/<pid>/cmdline`. This information is\npresented to the user so that those processes can be restarted.\n\nThe reason to do this is that after an update, you might end up with processes\nthat run for a long time and still use old libraries. In some cases this might\nbe a security problem, as the library may be vulnerable. The script displays\nall the distinct argument lists of processes that have deleted files mapped.\nIn essence, you get a list of processes and their PIDs. The reason why not\njust the first element of the argument list is presented is that for scripts,\nthis will always be the interpreter name (i.e. `perl`, `python` etc.) which is\nnot useful by itself.\n\nThe script cleans up the list from `/proc/<pid>/maps` to not display false\npositives - some programs have a pseudo file called `/SYSxxxx` mapped which\nobviously is not a library that was updated.\n\nAs of v0.10, there is a companion to `lib_users`, called `fd_users`. It\nbasically does the same, but for open FDs (`/proc/PID/fd`) that are marked as\ndeleted. The intended use is to spot daemons that have had their log files\ndeleted (or rotated and compressed), but not told to reopen the file.\n\n## Output formats\n\nLib_users supports two output formats/modes, human- and machine-readable:\n\nhuman-readable:\n\n```\n16341 "supervising syslog-ng"\n16342 "/usr/sbin/syslog-ng"\n27550 "/usr/sbin/exim -bd -q15m"\n12451,16244,16249,16252,16253,16254,26931,28912,29631,8810,894 "/usr/sbin/apache2 -D DEFAULT_VHOST -D INFO -D LANGUAGE -D DAV -D SVN -D MAILMAN -D PHP5 -D USERDIR -D SVN_AUTHZ -D SUEXEC -D SSL -D SSL_DEFAULT_VHOST -D AUTH_DIGEST -D PERL -d /usr/lib64/apache2 -f /etc/apache2/httpd.conf -k start"\n```\n\nHere, the first column is a comma-separated list of PIDs that share the same\ncommand line. The second column is the command line in quotation marks. If the\n-s command line option is used, there will also be information about the names\nof the deleted files in use.\n\nmachine-readable:\n\n```\n16341;/lib64/libpcre.so.0.0.1;supervising syslog-ng\n16342;/lib64/libpcre.so.0.0.1;/usr/sbin/syslog-ng\n27550;/lib64/libpcre.so.0.0.1,/usr/sbin/exim;/usr/sbin/exim -bd -q15m\n12451,16244,16249,16252,16253,16254,26931,28912,29631,8810,894;/lib64/libpcre.so.0.0.1;/usr/sbin/apache2 -D DEFAULT_VHOST -D INFO -D LANGUAGE -D DAV -D SVN -D MAILMAN -D PHP5 -D USERDIR -D SVN_AUTHZ -D SUEXEC -D SSL -D SSL_DEFAULT_VHOST -D AUTH_DIGEST -D PERL -d /usr/lib64/apache2 -f /etc/apache2/httpd.conf -k start\n```\n\nWith the -m command line parameter changes to this form:\n`<list of PIDs>;<list of deleted mapped files>;<command line>`\n\nThe lists are made up of comma-separated values. There are no provisions taken\nfor the case of one of the libraries contain a ",". The command line is also\nnot altered in any way. This may be fixed in a future version.\n\n## Dependencies\n\nThe script requires Python 2.7 or higher and should work with Python 3. It only\nuses modules from Pythons standard library, so apart from a Python\ninstallation, there are no external dependencies.\n\nIf you want to run the test suite easily, install the Nose Python testing\nframework. This is not needed for day-to-day operations. Running the tests with\nPython 2.7 also requires the backported mock submodule of unittest\n(https://github.com/jaraco/backports.unittest_mock)\n\n## Limitations\n\nThe program quite probably only works on Linux (or, at least, only on systems\nthat have the same maps file structure as a Linux system).\n\nIf the script is not run as root, it can not display all processes on the\nsystem that use deleted libs. In the spirit of graceful degradation, it will\nthen only display the information for processes it has access to. Usually this\nis the list of processes owned by the user that runs lib_users. It will also\noutput a warning to stderr that it could not read all map files.\n\nThe `-S` command line switch relies on systemdctl and its output. Therefore, it\nmay break if the command is renamed or its output changes significantly. Note\nthat the output it produces is advisory and entirely reliant on systemd.\n\n## False positives\n\nSome programs open temporary files and immediately delete them. This is done\nso they don\'t leave those files behind after a crash. As a consequence,\nlib_users may report these programs. A notable example are programs that use\nliborc, the Oil Runtime Compiler. Here\'s an example, the media player\nquodlibet:\n\n```\n$ lib_users \n2753 "/usr/bin/python2.7 /usr/bin/quodlibet"\n$ grep deleted /proc/2753/maps \n7f409dd0b000-7f409dd1b000 rw-s 00000000 08:01 1179661 /tmp/orcexec.sqa9cE (deleted)\n```\n\nThe file `/tmp/orcexec.sqa9cE` is output from the aforementioned compiler. These\nprocesses/files can be safely ignored. In fact, restarting quodlibet will just\nresult in a different liborc tempfile show up as deleted.\n\nUsing the -s command line option will show you which deleted files are in use,\nso you decide whether the listed process is a false positive.\n\nStarting with lib_users 0.8, the `-i` and `-I` command line options can be used to\nsupply additional to-be-ignored patterns and static strings.\n\n## License\n\nThis program is released under the GPL-2, which is included in distributions\nof this script as the file COPYING. If you want to use it for something that\nis incompatible with the GPL-2, feel free to contact me; I\'m sure we can work\nsomething out.\n\n## Contact & Contributions\n\nIf you want to contact me, my email address is `klausman-lu@schwarzvogel.de.`\nPatches and bug reports (or feature requests, even) are of course welcome.\n',
    'author': 'Tobias Klausmann',
    'author_email': 'klausman@schwarzvogel.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/klausman/lib_users',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
