import * as iam from '@aws-cdk/aws-iam';
import { NestedStack, IConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ICluster } from './cluster';
/**
 * Kubectl Provider Properties.
 *
 * @stability stable
 */
export interface KubectlProviderProps {
    /**
     * The cluster to control.
     *
     * @stability stable
     */
    readonly cluster: ICluster;
}
/**
 * Kubectl Provider Attributes.
 *
 * @stability stable
 */
export interface KubectlProviderAttributes {
    /**
     * The kubectl provider lambda arn.
     *
     * @stability stable
     */
    readonly functionArn: string;
    /**
     * The IAM role to assume in order to perform kubectl operations against this cluster.
     *
     * @stability stable
     */
    readonly kubectlRoleArn: string;
    /**
     * The IAM execution role of the handler.
     *
     * This role must be able to assume kubectlRoleArn
     *
     * @stability stable
     */
    readonly handlerRole: iam.IRole;
}
/**
 * Imported KubectlProvider that can be used in place of the default one created by CDK.
 *
 * @stability stable
 */
export interface IKubectlProvider extends IConstruct {
    /**
     * The custom resource provider's service token.
     *
     * @stability stable
     */
    readonly serviceToken: string;
    /**
     * The IAM role to assume in order to perform kubectl operations against this cluster.
     *
     * @stability stable
     */
    readonly roleArn: string;
    /**
     * The IAM execution role of the handler.
     *
     * @stability stable
     */
    readonly handlerRole: iam.IRole;
}
/**
 * Implementation of Kubectl Lambda.
 *
 * @stability stable
 */
export declare class KubectlProvider extends NestedStack implements IKubectlProvider {
    /**
     * Take existing provider or create new based on cluster.
     *
     * @param scope Construct.
     * @param cluster k8s cluster.
     * @stability stable
     */
    static getOrCreate(scope: Construct, cluster: ICluster): IKubectlProvider;
    /**
     * Import an existing provider.
     *
     * @param scope Construct.
     * @param id an id of resource.
     * @param attrs attributes for the provider.
     * @stability stable
     */
    static fromKubectlProviderAttributes(scope: Construct, id: string, attrs: KubectlProviderAttributes): IKubectlProvider;
    /**
     * The custom resource provider's service token.
     *
     * @stability stable
     */
    readonly serviceToken: string;
    /**
     * The IAM role to assume in order to perform kubectl operations against this cluster.
     *
     * @stability stable
     */
    readonly roleArn: string;
    /**
     * The IAM execution role of the handler.
     *
     * @stability stable
     */
    readonly handlerRole: iam.IRole;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: KubectlProviderProps);
}
