import { Asset } from '@aws-cdk/aws-s3-assets';
import { Duration } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Helm Chart options.
 *
 * @stability stable
 */
export interface HelmChartOptions {
    /**
     * The name of the chart.
     *
     * Either this or `chartAsset` must be specified.
     *
     * @default - No chart name. Implies `chartAsset` is used.
     * @stability stable
     */
    readonly chart?: string;
    /**
     * The name of the release.
     *
     * @default - If no release name is given, it will use the last 53 characters of the node's unique id.
     * @stability stable
     */
    readonly release?: string;
    /**
     * The chart version to install.
     *
     * @default - If this is not specified, the latest version is installed
     * @stability stable
     */
    readonly version?: string;
    /**
     * The repository which contains the chart.
     *
     * For example: https://kubernetes-charts.storage.googleapis.com/
     *
     * @default - No repository will be used, which means that the chart needs to be an absolute URL.
     * @stability stable
     */
    readonly repository?: string;
    /**
     * The chart in the form of an asset.
     *
     * Either this or `chart` must be specified.
     *
     * @default - No chart asset. Implies `chart` is used.
     * @stability stable
     */
    readonly chartAsset?: Asset;
    /**
     * The Kubernetes namespace scope of the requests.
     *
     * @default default
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * The values to be used by the chart.
     *
     * @default - No values are provided to the chart.
     * @stability stable
     */
    readonly values?: {
        [key: string]: any;
    };
    /**
     * Whether or not Helm should wait until all Pods, PVCs, Services, and minimum number of Pods of a Deployment, StatefulSet, or ReplicaSet are in a ready state before marking the release as successful.
     *
     * @default - Helm will not wait before marking release as successful
     * @stability stable
     */
    readonly wait?: boolean;
    /**
     * Amount of time to wait for any individual Kubernetes operation.
     *
     * Maximum 15 minutes.
     *
     * @default Duration.minutes(5)
     * @stability stable
     */
    readonly timeout?: Duration;
    /**
     * create namespace if not exist.
     *
     * @default true
     * @stability stable
     */
    readonly createNamespace?: boolean;
}
/**
 * Helm Chart properties.
 *
 * @stability stable
 */
export interface HelmChartProps extends HelmChartOptions {
    /**
     * The EKS cluster to apply this configuration to.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @stability stable
     */
    readonly cluster: ICluster;
}
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 *
 * @stability stable
 */
export declare class HelmChart extends CoreConstruct {
    /**
     * The CloudFormation resource type.
     *
     * @stability stable
     */
    static readonly RESOURCE_TYPE = "Custom::AWSCDK-EKS-HelmChart";
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: HelmChartProps);
}
