# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['glinkfix']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['glinkfix = glinkfix.__main__:main']}

setup_kwargs = {
    'name': 'glinkfix',
    'version': '1.0.13',
    'description': 'Google Drive Link Fixer',
    'long_description': '![GitHub](https://img.shields.io/github/license/geozeke/glinkfix)\n![PyPI](https://img.shields.io/pypi/v/glinkfix)\n![PyPI - Status](https://img.shields.io/pypi/status/glinkfix)\n![GitHub last commit](https://img.shields.io/github/last-commit/geozeke/glinkfix)\n![GitHub issues](https://img.shields.io/github/issues/geozeke/glinkfix)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/glinkfix)\n![GitHub repo size](https://img.shields.io/github/repo-size/geozeke/glinkfix)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/glinkfix)\n\n<br>\n\n<img src="https://github.com/geozeke/glinkfix/blob/main/assets/logo.png?raw=true" width="120"/>\n\n# Google Drive Link Fixer\n\n## A note to developers\n\nIf you\'re just using glinkfix, then carry on!\n\nIf you\'re a developer looking to fork this repository and modify glinkfix,\nthere are two important considerations:\n\n1. I used [poetry](https://python-poetry.org/) for dependency and publication\n   management when developing glinkfix. Poetry is well behaved and if you\'re a\n   Python developer you should check it out. It installs itself in a virtual\n   environment, uninstalls cleanly and easily, and doesn\'t require `sudo` for\n   installation. To install poetry, run this command:\n\n   ```shell\n   curl -sSL https://install.python-poetry.org | python3 -\n   ```\n\n2. I\'ve included a file called `global-gitignore.txt` which is a copy of the\n   `.gitignore` I placed in my home directory and configured globally for all\n   my development projects. The `global-gitignore.txt` file reflects my\n   development setup (for example using tools like vscode), but yours may be\n   different. Just cherry-pick any necessary elements from\n   `global-gitignore.txt` for your own use.\n\n   *Details on gitignore files are available on\n   [GitHub](https://docs.github.com/en/get-started/getting-started-with-git/ignoring-files).*\n\n## Installation\n\nThe Google Drive Link Fixer is lightweight, pure Python, with no third-party\ndependencies.\n\n```text\npip3 install glinkfix  \n```\n\nor\n\n```text\npoetry add glinkfix\n```\n\n## Purpose / Usage\n\nWhen you share files with Google Drive the sharing link you get is only good\nfor accessing the content through a web browser. If you want to use a Google\nDrive sharing link to embed an image in a document (e.g. in a markdown or html\nfile), or you want to directly download a file pointed-to by a Google Drive\nsharing link using something like `curl` or `wget` in linux, the link needs to\nbe adjusted ("fixed") for these purposes.\n\nIt\'s not especially hard to repackage the link, but it\'s a pain. You have to\ncopy the link to a text editor, carve it up manually, and reassemble it. If\nyou\'ve got a lot of links to deal with it starts to get very tedious. This tool\nis designed to remove the tedium.\n\n*Note: The animated gifs below are actually hosted on Google Drive and the\n"fixed" links are embedded into this README file.*\n\n---\n\nStart by getting a sharing link to a file on Google Drive. Make sure it\'s set\nup for public access (*Anyone with the link*):\n\n![Retrieving Google Link](https://drive.google.com/uc?export=view&id=1BJ5cR04cSzHa4xMIPApjLXv0IHPDu9U2)\n\n---\n\nNow run `glinkfix` and paste the link into the terminal. Copy the "fixed"\nversion and use is as required.\n\n![Using Google Link](https://drive.google.com/uc?export=view&id=1wrrGh-cm_Hf7hH5WN_aCO-wwxIsrk6j5)\n\n---\n\nTo display the help menu, run: `glinkfix -h`\n\n```text\nusage: glinkfix [-h] (-v | -d)\n\nThis program takes a Google Drive sharing link for a file and repackages it into a link\nthat can be downloaded directly (e.g. using curl) or embedded in a document to be viewed\n(e.g. an image in a markdown document). Note: there is a size limit of 40MB for a single\nfile when using Google Drive links in this manner.\n\noptional arguments:\n  -h, --help      show this help message and exit\n  -v, --view      repackage the link for viewing (e.g. as an embedded link in a markdown\n                  document).\n  -d, --download  repackage the link for downloading (e.g. downloading using curl).\n```\n\n## Usage Notes\n\n* There is a 40MB size limit for a single file when using Google Drive sharing\n  links directly for viewing or downloading. Individual files larger than 40MB\n  will not render/download properly. This limit is a function of how Google\n  Drive works and is not related to `glinkfix`.\n* When creating a download link for use with `curl` make sure to use `curl`\'s\n  `-L` option to allow for redirects.\n* `glinkfix` supports links that use Google\'s [resource\n  key](https://support.google.com/a/answer/10685032) security feature.\n\n## Version History\n\n* 1.0.13 (2022-11-03)\n  * Google made a breaking change to the format for sharing links (not that\n    they checked with me first 😊). This patch updates glinkfix to support the\n    change.\n  <br><br>\n* 1.0.12 (2022-10-22)\n  * Regression bug fixes.\n  <br><br>\n* 1.0.11 (2022-10-21)\n  * Migrated dependency/build management to [poetry](https://python-poetry.org/).\n  <br><br>\n* 1.0.9 (2022-10-13)\n  * Fixed a bug when IDs or resource keys contain underscore characters (`_`)\n  * Additional test case for bug fix.\n  * Moved task runner to make.\n  * Build local virtual environment for development.\n  * Code refactoring and linting.\n  <br><br>\n* 1.0.8 (2022-07-23)\n  * Implemented code coverage for testing infrastructure.\n  * Code refactoring and linting.\n  <br><br>\n* 1.0.7 (2022-07-15)\n  * Fixed handling of URLs with resource keys.\n  * Code cleanup and refactoring.\n  * Implemented custom exception handling.\n  * Implemented testing infrastructure.<br><br>\n* 1.0.6 (2022-01-17)\n  * Code cleanup.<br><br>\n* 1.0.5 (2021-12-23)\n  * Code linting.\n  * Documentation cleanup.<br><br>\n* 1.0.4 (2021-12-19)\n  * Initial release<br>\n',
    'author': 'Peter Nardi',
    'author_email': 'pete@nardi.com',
    'maintainer': 'Peter Nardi',
    'maintainer_email': 'pete@nardi.com',
    'url': 'https://github.com/geozeke/glinkfix',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
