import enum

ENDPOINT = "https://offerup.com"


class CONDITION(enum.Enum):
    NEW = "NEW"
    OPEN_BOX = "OPEN_BOX"
    REFURBISHED = "REFURBISHED"
    USED = "USED"
    BROKEN = "BROKEN"
    OTHER = "OTHER"


class SORT(enum.Enum):
    NEWEST_FIRST = "-posted"
    CLOSEST_FIRST = "distance"
    PRICE_LOW_TO_HIGH = "price"
    PRICE_HIGH_TO_LOW = "-price"


class DELIVERY(enum.Enum):
    PICKUP = "p"
    SHIPPING = "s"
    PICKUP_AND_SHIPPING = "p_s"


class GRAPHQL(enum.Enum):
    MODULAR_FEED = "query GetModularFeed($searchParams: [SearchParam]) {\n    modularFeed(params: $searchParams) {\n        looseTiles {\n            ...modularTileBanner\n            ...modularTileJob\n            ...modularTileEmptyState\n            ...modularTileListing\n            ...modularTileLocalDisplayAd\n            ...modularTileSearchAlert\n            ...modularTileSellerAd\n        }\n    }\n}\n\nfragment modularTileBanner on ModularFeedTileBanner {\n    tileId\n    tileType\n    title\n}\n\nfragment modularTileJob on ModularFeedTileJob {\n    tileId\n    tileType\n    job {\n        address {\n            city\n            state\n            zipcode\n        }\n        companyName\n        datePosted\n        image {\n            height\n            url\n            width\n        }\n        industry\n        jobId\n        jobListingUrl\n        pills {\n            text\n            type\n        }\n        title\n    }\n}\n\nfragment modularTileEmptyState on ModularFeedTileEmptyState {\n    tileId\n    tileType\n    title\n    description\n    iconType\n}\n\nfragment modularTileListing on ModularFeedTileListing {\n    tileId\n    listing {\n        ...modularListing\n    }\n    tileType\n}\n\nfragment modularListing on ModularFeedListing {\n    listingId\n    conditionText\n    flags\n    image {\n        height\n        url\n        width\n    }\n    isFirmPrice\n    locationName\n    price\n    title\n    vehicleMiles\n}\n\nfragment modularTileLocalDisplayAd on ModularFeedTileLocalDisplayAd {\n    tileId\n    localDisplayAd {\n        ouAdId\n        adExperimentId\n        adNetwork\n        adRequestId\n        adTileType\n        advertiserId\n        businessName\n        callToAction\n        callToActionType\n        clickFeedbackUrl\n        contentUrl\n        experimentDataHash\n        headline\n        image {\n            height\n            url\n            width\n        }\n        impressionFeedbackUrl\n        searchId\n    }\n    tileType\n}\n\nfragment modularTileSearchAlert on ModularFeedTileSearchAlert {\n    tileId\n    tileType\n    title\n}\n\nfragment modularTileSellerAd on ModularFeedTileSellerAd {\n    tileId\n    listing {\n        ...modularListing\n    }\n    sellerAd {\n        ouAdId\n        adId\n        adExperimentId\n        adNetwork\n        adRequestId\n        adTileType\n        clickFeedbackUrl\n        experimentDataHash\n        impressionFeedbackUrl\n        searchId\n    }\n    tileType\n}"
    LISTING_DETAIL = "query GetListingDetailByListingId($listingId: ID!, $isLoggedIn: Boolean = false, $deviceLocation: DeviceLocation) {\n  listing(listingId: $listingId, deviceLocation: $deviceLocation) {\n    ...listingDetail\n    __typename\n  }\n}\n\nfragment listingDetail on Listing {\n  id\n  badges\n  condition\n  description\n  discussionCount\n  distance {\n    unit\n    value\n    __typename\n  }\n  extractedAttributes {\n    attributeName\n    attributeValue\n    attributeValueSource\n    __typename\n  }\n  fulfillmentDetails {\n    buyItNowEnabled\n    canShipToBuyer\n    estimatedDeliveryDateEnd\n    estimatedDeliveryDateStart\n    localPickupEnabled\n    sellerPaysShipping\n    shippingEnabled\n    shippingParcelId\n    shippingPrice\n    showAsShipped\n    __typename\n  }\n  isFirmOnPrice\n  isLocal\n  isMerchantItem\n  lastEdited\n  listingCategory {\n    categoryAttributeMap {\n      attributeName\n      attributePriority\n      attributeUILabel\n      attributeValue\n      attributeValueSource\n      __typename\n    }\n    categoryV2 {\n      id\n      l1Id\n      l1Name\n      l2Id\n      l2Name\n      l3Id\n      l3Name\n      name\n      __typename\n    }\n    __typename\n  }\n  listingDetailAds {\n    adExperimentId\n    adTiles {\n      ...adsGoogleDisplayAd\n      __typename\n    }\n    placements {\n      adTileConfigs {\n        adSize {\n          additionalSizes\n          height\n          width\n          __typename\n        }\n        displayType\n        renderLocation\n        __typename\n      }\n      adType\n      quantity\n      __typename\n    }\n    __typename\n  }\n  listingId\n  locationDetails {\n    distance\n    latitude\n    locationName\n    longitude\n    __typename\n  }\n  merchantId\n  merchantProfile {\n    avatar {\n      small {\n        url\n        __typename\n      }\n      __typename\n    }\n    description\n    emailAddress\n    legacyUserOwner\n    phoneNumber\n    publicLocationName\n    storeName\n    ratingSummary {\n      average\n      count\n      __typename\n    }\n    __typename\n  }\n  originalPrice\n  originalTitle\n  owner {\n    id\n    profile {\n      avatars {\n        squareImage\n        __typename\n      }\n      c2cPhoneNumber {\n        countryCode\n        nationalNumber\n        __typename\n      }\n      clickToCallEnabled\n      dateJoined\n      isAutosDealer\n      isSubPrimeDealer\n      isTruyouVerified\n      name\n      notActive\n      openingHours {\n        day\n        hours\n        __typename\n      }\n      phoneNumber\n      publicLocation {\n        formattedAddress\n        latitude\n        longitude\n        name\n        __typename\n      }\n      publicLocationName\n      itemsPurchased\n      itemsSold\n      responseTime\n      ratingSummary {\n        average\n        count\n        __typename\n      }\n      reviews {\n        attributionIcon\n        average\n        readMoreUrl\n        title\n        userReviews {\n          profilePhotoUrl\n          text\n          __typename\n        }\n        __typename\n      }\n      websiteLink\n      __typename\n    }\n    __typename\n  }\n  ownerId\n  photos {\n    uuid\n    detail {\n      height\n      url\n      width\n      __typename\n    }\n    detailFull {\n      url\n      width\n      height\n      __typename\n    }\n    detailSquare {\n      height\n      url\n      width\n      __typename\n    }\n    list {\n      height\n      url\n      width\n      __typename\n    }\n    medium {\n      height\n      url\n      width\n      __typename\n    }\n    squareMedium {\n      height\n      url\n      width\n      __typename\n    }\n    __typename\n  }\n  postDate\n  price\n  quantity\n  saved @include(if: $isLoggedIn)\n  shippingOptions {\n    maxHandlingDays\n    maxShippingDays\n    minHandlingDays\n    minShippingDays\n    name\n    price\n    priority\n    __typename\n  }\n  shippingRate {\n    maxDeliveryDays\n    maxEstimatedDeliveryDate\n    minDeliveryDays\n    minEstimatedDeliveryDate\n    price\n    priority\n    __typename\n  }\n  sku\n  state\n  title\n  vehicleAttributes {\n    vehicleBody\n    vehicleCityMpg\n    vehicleColor\n    vehicleDriveTrain\n    vehicleDriveTrainClean\n    vehicleEngineCylinders\n    vehicleEpaCity\n    vehicleEpaHighway\n    vehicleExternalHistoryReport {\n      epochDate\n      imageUrl\n      issues\n      price {\n        microUnits\n        __typename\n      }\n      providerName\n      reportUrl\n      source\n      __typename\n    }\n    vehicleFuelType\n    vehicleFundamentals\n    vehicleHighwayMpg\n    vehicleId\n    vehicleMake\n    vehicleMiles\n    vehicleModel\n    vehicleStyleDisplay\n    vehicleTitleStatus\n    vehicleTransmission\n    vehicleTransmissionClean\n    vehicleTrim\n    vehicleVin\n    vehicleYear\n    __typename\n  }\n  __typename\n}\n\nfragment adsGoogleDisplayAd on GoogleDisplayAd {\n  ...baseGoogleDisplayAd\n  renderLocation\n  tileType\n  __typename\n}\n\nfragment baseGoogleDisplayAd on GoogleDisplayAd {\n  ouAdId\n  adExperimentId\n  adHeight\n  adMediationId\n  adNetwork\n  adRequestId\n  adWidth\n  clickFeedbackUrl\n  clientId\n  contentUrl\n  customTargeting {\n    key\n    values\n    __typename\n  }\n  displayAdType\n  formatIds\n  errorDrawable {\n    actionPath\n    listImage {\n      height\n      url\n      width\n      __typename\n    }\n    __typename\n  }\n  experimentDataHash\n  impressionFeedbackUrl\n  personalizationProperties {\n    key\n    values\n    __typename\n  }\n  type\n  __typename\n}\n"
