## Installation
```
pip install pyOfferUp
```

## Cities and States
places.py contains all the supported cities and states with their respective coordinates (case sensitive).
```python
from pyOfferUp import places
print(places.available_states())
print(places.available_cities("Texas"))
print(places.available_cities("Alabama"))
```
returns:
```
['Alabama', 'Alaska', 'Arizona', 'Arkansas', 'California', 'Colorado', 'Connecticut', 'Delaware', 'Florida', 'Georgia', 'Hawaii', 'Idaho', 'Illinois', 'Indiana', 'Iowa', 'Kansas', 'Kentucky', 'Louisiana', 'Maine', 'Maryland', 'Massachusetts', 'Michigan', 'Minnesota', 'Mississippi', 'Missouri', 'Montana', 'Nebraska', 'Nevada', 'New Hampshire', 'New Jersey', 'New Mexico', 'New York', 'North Carolina', 'North Dakota', 'Ohio', 'Oklahoma', 'Oregon', 'Pennsylvania', 'Rhode Island', 'South Carolina', 'South Dakota', 'Tennessee', 'Texas', 'Utah', 'Vermont', 'Virginia', 'Washington', 'West Virginia', 'Wisconsin', 'Wyoming']
['Abilene', 'Addison', 'Amarillo', 'Arlington', 'Austin', 'Baytown', 'Beaumont', 'Brownsville', 'Bryan', 'Carrollton', 'Cedar Hill', 'Channelview', 'Conroe', 'Corpus Christi', 'Dallas', 'Denton', 'Duncanville', 'El Paso', 'Euless', 'Farmers Branch', 'Fort Worth', 'Frisco', 'Garland', 'Grand Prairie', 'Harlingen', 'Houston', 'Humble', 'Irving', 'Katy', 'Killeen', 'Laredo', 'Lewisville', 'Longview', 'Lubbock', 'Lufkin', 'Mansfield', 'Mcallen', 'McKinney', 'Mesquite', 'Midland', 'Midlothian', 'Nacogdoches', 'Odessa', 'Pearland', 'Pflugerville', 'Plano', 'Port Arthur', 'Richardson', 'Round Rock', 'San Angelo', 'San Antonio', 'San Marcos', 'Sherman', 'Stafford', 'Sugar Land', 'Sweetwater', 'Temple', 'Tomball', 'Tyler', 'Victoria', 'Waco', 'Weslaco', 'Wichita Falls']
['Anniston', 'Birmingham', 'Decatur', 'Dothan', 'Huntsville', 'Mobile', 'Montgomery', 'Selma', 'Tuscaloosa']
```

## Usage
#### Example with Cities and States
Look for "luigis mansion" in Mcallen, Texas:
```python
from pyOfferUp import fetch

posts = fetch.get_listings(query="luigis mansion", state="Texas", city="Mcallen", limit=100)
```
returns:
```
[{'listingId': '820f8610-c54e-37cd-9a3a-9146cbc632c7', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/D-x_hdwcYHyYob5-Xm35YYu4GuA=/250x250/c9c1/c9c15fa3f1e34c91ba7903b13c41d9b2.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Pharr, TX', 'price': '400', 'title': 'Nintendo Switch Bundle And Games ', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/820f8610-c54e-37cd-9a3a-9146cbc632c7'}, {'listingId': '0339cbe4-6ca4-32da-8dbc-dc907724dcdc', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/1DJaVzQFqKnb5Ddf9SaBZOM-tMo=/250x250/fca8/fca8a55b49f944959aa9788f1aa9a238.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Harlingen, TX', 'price': '40', 'title': 'Nintendo Switch Games!', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/0339cbe4-6ca4-32da-8dbc-dc907724dcdc'}, {'listingId': 'e6aa5e98-71b7-3e8f-bc9f-5363825dcd33', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/zvFkuoStpnhL0NQa1upgqLt8Y3U=/250x250/096e/096edf083fc44f519257ee71f0c5c408.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Edinburg, TX', 'price': '120', 'title': 'Nitendo 2ds ', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/e6aa5e98-71b7-3e8f-bc9f-5363825dcd33'}, {'listingId': '71e0f82d-4ab5-379f-b9d6-26b6bfc2f007', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/z_3APWnVSDew8YGdNqHQJPyH7a8=/250x250/c596/c596b13855a249c9822ec3144a294d31.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Mcallen, TX', 'price': '40', 'title': 'Luigis Mansion 3 (Nintendo Switch)', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/71e0f82d-4ab5-379f-b9d6-26b6bfc2f007'}, {'listingId': '6eefd205-2d9b-39ce-a69e-45772c023107', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/7So5tPl7rC5TKTJbsozV-Ts0dCY=/250x250/ee79/ee792e71f2b943d5a4cf3e6458515603.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Mercedes, TX', 'price': '25', 'title': 'Nintendo Switch Games ', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/6eefd205-2d9b-39ce-a69e-45772c023107'}, {'listingId': 'da66684c-5bda-339d-b7c3-ee4a537f0c7c', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/F2Bac_gCvvagjYcMuOzEIYNlDA4=/250x250/9a48/9a48b423f9764ae1938edf81cd442661.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Penitas, TX', 'price': '20', 'title': 'Luigi’s Mansion Dark Moon 3DS', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/da66684c-5bda-339d-b7c3-ee4a537f0c7c'}, {'listingId': '3c4aa614-ceda-31e9-a93c-084ff489a208', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/4uJ7PAUFUxdOQ7PaNaQfXyeJRO8=/250x250/8a31/8a31c21f73ca4fd39d2a85411a14d350.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Palmview, TX', 'price': '480', 'title': 'Nintendo Switch', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/3c4aa614-ceda-31e9-a93c-084ff489a208'}, {'listingId': '1c43afb1-a68c-3e89-8fa1-6396bf35232a', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/VTlDKHB73WzV_fK1MNJr3etPOYs=/250x250/fa06/fa062a3abe4444568f241d4c94dd531b.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Edinburg, TX', 'price': '45', 'title': 'luigis mansion for sale or trade', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/1c43afb1-a68c-3e89-8fa1-6396bf35232a'}, {'listingId': 'b5f43a1e-f816-3d75-91f9-b1f6732d2b80', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/TM6yBRicemwkSGYdVbzCF6H7rwM=/250x250/8c86/8c86cbddf76349ff927e6ebf0e846316.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'San Juan, TX', 'price': '1', 'title': 'Nintendo 3ds Games', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/b5f43a1e-f816-3d75-91f9-b1f6732d2b80'}, {'listingId': 'a565f8b6-5ba1-3463-aa7a-2ebd7f9c7dae', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 514, 'url': 'https://thumbor.offerup.com/9W-NOHRA8pA2Mta0tugp6pYod7k=/250x514/4de3/4de3fbd4f78540988a9f9b265bb2a2fb.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'McAllen, TX', 'price': '75.00', 'title': 'LUIGI\'S MANSION 3 9" PVC PAINTED STATUE', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/a565f8b6-5ba1-3463-aa7a-2ebd7f9c7dae'}]
```

**NOTE:** When looking in
a city you must also provide the state the city resides in.

#### Example with Latitude and Longitude
Look for "luigis mansion" around lat=26.2043691, lon=-98.230082
```python
from pyOfferUp import fetch

posts = fetch.get_listing_details(query="luigis mansion", lat=26.2043691, lon=-98.230082, limit=100)
```
returns:
```
[{'listingId': '820f8610-c54e-37cd-9a3a-9146cbc632c7', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/D-x_hdwcYHyYob5-Xm35YYu4GuA=/250x250/c9c1/c9c15fa3f1e34c91ba7903b13c41d9b2.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Pharr, TX', 'price': '400', 'title': 'Nintendo Switch Bundle And Games ', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/820f8610-c54e-37cd-9a3a-9146cbc632c7'}, {'listingId': '0339cbe4-6ca4-32da-8dbc-dc907724dcdc', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/1DJaVzQFqKnb5Ddf9SaBZOM-tMo=/250x250/fca8/fca8a55b49f944959aa9788f1aa9a238.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Harlingen, TX', 'price': '40', 'title': 'Nintendo Switch Games!', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/0339cbe4-6ca4-32da-8dbc-dc907724dcdc'}, {'listingId': 'e6aa5e98-71b7-3e8f-bc9f-5363825dcd33', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/zvFkuoStpnhL0NQa1upgqLt8Y3U=/250x250/096e/096edf083fc44f519257ee71f0c5c408.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Edinburg, TX', 'price': '120', 'title': 'Nitendo 2ds ', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/e6aa5e98-71b7-3e8f-bc9f-5363825dcd33'}, {'listingId': '71e0f82d-4ab5-379f-b9d6-26b6bfc2f007', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/z_3APWnVSDew8YGdNqHQJPyH7a8=/250x250/c596/c596b13855a249c9822ec3144a294d31.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Mcallen, TX', 'price': '40', 'title': 'Luigis Mansion 3 (Nintendo Switch)', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/71e0f82d-4ab5-379f-b9d6-26b6bfc2f007'}, {'listingId': '6eefd205-2d9b-39ce-a69e-45772c023107', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/7So5tPl7rC5TKTJbsozV-Ts0dCY=/250x250/ee79/ee792e71f2b943d5a4cf3e6458515603.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Mercedes, TX', 'price': '25', 'title': 'Nintendo Switch Games ', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/6eefd205-2d9b-39ce-a69e-45772c023107'}, {'listingId': 'da66684c-5bda-339d-b7c3-ee4a537f0c7c', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/F2Bac_gCvvagjYcMuOzEIYNlDA4=/250x250/9a48/9a48b423f9764ae1938edf81cd442661.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Penitas, TX', 'price': '20', 'title': 'Luigi’s Mansion Dark Moon 3DS', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/da66684c-5bda-339d-b7c3-ee4a537f0c7c'}, {'listingId': '3c4aa614-ceda-31e9-a93c-084ff489a208', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/4uJ7PAUFUxdOQ7PaNaQfXyeJRO8=/250x250/8a31/8a31c21f73ca4fd39d2a85411a14d350.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Palmview, TX', 'price': '480', 'title': 'Nintendo Switch', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/3c4aa614-ceda-31e9-a93c-084ff489a208'}, {'listingId': '1c43afb1-a68c-3e89-8fa1-6396bf35232a', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/VTlDKHB73WzV_fK1MNJr3etPOYs=/250x250/fa06/fa062a3abe4444568f241d4c94dd531b.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'Edinburg, TX', 'price': '45', 'title': 'luigis mansion for sale or trade', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/1c43afb1-a68c-3e89-8fa1-6396bf35232a'}, {'listingId': 'b5f43a1e-f816-3d75-91f9-b1f6732d2b80', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 250, 'url': 'https://thumbor.offerup.com/TM6yBRicemwkSGYdVbzCF6H7rwM=/250x250/8c86/8c86cbddf76349ff927e6ebf0e846316.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'San Juan, TX', 'price': '1', 'title': 'Nintendo 3ds Games', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/b5f43a1e-f816-3d75-91f9-b1f6732d2b80'}, {'listingId': 'a565f8b6-5ba1-3463-aa7a-2ebd7f9c7dae', 'conditionText': None, 'flags': ['LOCAL_PICKUP'], 'image': {'height': 514, 'url': 'https://thumbor.offerup.com/9W-NOHRA8pA2Mta0tugp6pYod7k=/250x514/4de3/4de3fbd4f78540988a9f9b265bb2a2fb.jpg', 'width': 250}, 'isFirmPrice': None, 'locationName': 'McAllen, TX', 'price': '75.00', 'title': 'LUIGI\'S MANSION 3 9" PVC PAINTED STATUE', 'vehicleMiles': None, 'listingUrl': 'https://offerup.com/item/detail/a565f8b6-5ba1-3463-aa7a-2ebd7f9c7dae'}]
```