"""Script to convert the Diffuse Flux contour to a format where it can be
plotted as a 'butterfly contour'.

The values are taken from https://pos.sissa.it/301/1005/pdf
for the 8years Northern Track sample, tracing the 68% and 95% contours in Figure 3.


"""
import numpy as np
from astropy import units as u

contour_68 = np.array([
    (2.03012543242526, 0.7423683777687273),
    (2.034251572561308, 0.8074403176791254),
    (2.041619679947108, 0.6850712670424288),
    (2.041619679947108, 0.8550357937278739),
    (2.049724598071488, 0.8963719688900029),
    (2.057829516195868, 0.6691835726227473),
    (2.0593031376730284, 0.9386465965188671),
    (2.0696184880131483, 0.9799663297914172),
    (2.0710921094903085, 0.6661412481594038),
    (2.0806706490918487, 1.0224101191688337),
    (2.092459620909129, 1.0640096807544097),
    (2.1049854034649895, 1.1051186205708199),
    (2.1182479967594294, 1.14622756038723),
    (2.13224740079245, 1.1867167674425891),
    (2.14772042630263, 1.2277881476977237),
    (2.1639302625513905, 1.268183455849893),
    (2.180140098800151, 1.3040152773070472),
    (2.1963499350489113, 1.3360160235140652),
    (2.2125597712976717, 1.3623264961877937),
    (2.2287696075464316, 1.383791785456938),
    (2.2449794437951924, 1.3996794798766194),
    (2.2611892800439524, 1.4084684172151667),
    (2.277399116292713, 1.4094825253696146),
    (2.293608952541473, 1.4008626060568086),
    (2.3002402491886933, 0.9799739183558382),
    (2.3098187887902335, 1.3773691004787687),
    (2.3127660317445535, 1.0257633160723798),
    (2.323081382084674, 1.3383742273970274),
    (2.323081382084674, 1.0722432731512357),
    (2.3296074200549537, 1.113411235135365),
    (2.3306950930500006, 1.2917614704408034),
    (2.3338879395838474, 1.157279461292647),
    (2.3348703539019544, 1.2496196426893074),
    (2.335607164640534, 1.2011255541370345),
])

contour_95 = np.array([
    (1.9285527229722836, 0.5643923966631448),
    (1.9361083821824496, 0.5099685923744479),
    (1.9338611094297806, 0.6268656844277705),
    (1.9399397980230657, 0.6713470033522353),
    (1.9480447161474461, 0.7138606707603623),
    (1.951728769840346, 0.48647508679640783),
    (1.9568864450104062, 0.7550728993702811),
    (1.9679386060891064, 0.4787002576123087),
    (1.9664649846119464, 0.7965507277349362),
    (1.9767803349520667, 0.8398434877569565),
    (1.9841484423378666, 0.4765030232776719),
    (1.9870956852921868, 0.881277049495822),
    (1.997411035632307, 0.9227106112346879),
    (2.000358278586627, 0.47717909538063674),
    (2.0084631967110074, 0.963612973464081),
    (2.0165681148353873, 0.4819116001013932),
    (2.0195153577897074, 1.003933545754528),
    (2.030567518868408, 1.0449528983520788),
    (2.0327779510841477, 0.4876582129765974),
    (2.042356490685688, 1.0867848597230492),
    (2.048987787332908, 0.4930667898003187),
    (2.054145462502968, 1.127454822167048),
    (2.0659344343202486, 1.1681247846110467),
    (2.0777234061375287, 1.2067031489864972),
    (2.081407459830429, 0.5126728807863086),
    (2.090249188693389, 1.2472440004386103),
    (2.0976172960791892, 0.5231519983822688),
    (2.1035117819878293, 1.2885595178420377),
    (2.1138271323279496, 0.5344762061069357),
    (2.1167743752822696, 1.3265697938531908),
    (2.13003696857671, 0.5474905940890156),
    (2.14624680482547, 0.5610120361483188),
    (2.1624566410742303, 0.5757166043878112),
    (2.1786664773229907, 0.5914352807817518),
    (2.194876313571751, 0.6071539571756919),
    (2.2110861498205114, 0.6259149580329755),
    (2.227295986069272, 0.6448449769160005),
    (2.243505822318032, 0.6656341940821799),
    (2.2597156585667926, 0.6882826095315133),
    (2.275925494815553, 0.7121141511610358),
    (2.292135331064313, 0.7391570352796426),
    (2.3083451673130737, 0.7670450095269561),
    (2.3245550035618336, 0.7988203983663191),
    (2.328975867993314, 1.6608123296469188),
    (2.3407648398105945, 0.8329620395660609),
    (2.3451857042420743, 1.6498261579737348),
    (2.3562378653207743, 0.8699093799931077),
    (2.3613955404908347, 1.6307271210649685),
    (2.3702372693537948, 0.9094896456655912),
    (2.377605376739595, 1.5996278043285703),
    (2.382763051909655, 0.9492041867696357),
    (2.3916047807726155, 1.5622748206397443),
    (2.3938152129883554, 0.9913491764229738),
    (2.4019201311127354, 1.523541523074031),
    (2.4026569418513155, 1.0308229914001066),
    (2.410025049237116, 1.4853040117171592),
    (2.4116828733989206, 1.074235271311758),
    (2.416410742304809, 1.4381216908424448),
    (2.417393156622916, 1.1151376335411511),
    (2.421814021054396, 1.3924680441116577),
    (2.422919237162266, 1.1611527910492183),
    (2.425252471167769, 1.2074778149378114),
    (2.425813850778116, 1.3410302249443906),
    (2.4271190583721722, 1.2874853143895486),
    (2.4267260926449294, 1.2480703107866788),
])


units = 10 ** -18  #/ u.GeV /u.cm**2 / u.s / u.sr

for contour in [contour_68, contour_95]:
    contour.T[1] *= units

# Fit is valid from 119 TeV to 4.8 PeV.
e_range = np.logspace(np.log10(119) + 3, np.log10(4.8) + 6, 100)

best_fit_flux = 1.01 * units * (
        u.GeV ** -1 * u.cm ** -2 * u.s ** -1 * u.sr ** -1
)
best_fit_gamma = 2.19

nt_17 = {
    "northern_tracks_17": (
        best_fit_flux,
        best_fit_gamma,
        contour_68,
        contour_95,
        e_range,
        "https://doi.org/10.22323/1.301.1005"
    )
}

