"use strict";
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
// React
const react_1 = __importDefault(require("react"));
const react_dom_1 = __importDefault(require("react-dom"));
// Components
const Mito_1 = __importDefault(require("./components/Mito"));
class ExampleModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: ExampleModel.model_name, _model_module: ExampleModel.model_module, _model_module_version: ExampleModel.model_module_version, _view_name: ExampleModel.view_name, _view_module: ExampleModel.view_module, _view_module_version: ExampleModel.view_module_version, df_json: '' });
    }
}
exports.ExampleModel = ExampleModel;
ExampleModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
ExampleModel.model_name = 'ExampleModel';
ExampleModel.model_module = version_1.MODULE_NAME;
ExampleModel.model_module_version = version_1.MODULE_VERSION;
ExampleModel.view_name = 'ExampleView'; // Set to null if no view
ExampleModel.view_module = version_1.MODULE_NAME; // Set to null if no view
ExampleModel.view_module_version = version_1.MODULE_VERSION;
class ExampleView extends base_1.DOMWidgetView {
    render() {
        const send = (msg) => {
            this.send(msg);
        };
        // TODO: there is a memory leak, in the case where
        // we rerender the component (e.g. we run the mito.sheet)
        // cell again. We need to clean up the component somehow!
        react_dom_1.default.render(react_1.default.createElement(Mito_1.default, { sheetJSON: this.getSheetJSON(), codeJSON: this.getCodeJSON(), send: send, ref: (Mito) => { window.Mito = Mito; } }), this.el);
        this.model.on('msg:custom', this.handleMessage, this);
    }
    getSheetJSON() {
        let sheetJSON = {
            columns: [],
            index: [],
            data: []
        };
        const unparsedSheetJSON = this.model.get('sheet_json');
        try {
            sheetJSON['columns'] = JSON.parse(unparsedSheetJSON)['columns'];
            sheetJSON['index'] = JSON.parse(unparsedSheetJSON)['index'];
            sheetJSON['data'] = JSON.parse(unparsedSheetJSON)['data'];
        }
        catch (e) {
            // Suppress error
        }
        return sheetJSON;
    }
    getCodeJSON() {
        let codeJSON = {
            code: '# No code has been written yet!'
        };
        const unparsedCodeJSON = this.model.get('code_json');
        try {
            codeJSON['code'] = JSON.parse(unparsedCodeJSON)['code'];
        }
        catch (e) {
            // Suppress error
        }
        return codeJSON;
    }
    handleMessage(message) {
        /*
          This route handles the messages sent from the Python widget
        */
        console.log("Got a message, ", message);
        if (message.type === 'update_sheet') {
            console.log("Updating sheet");
        }
        else if (message.type === 'update_code') {
            console.log("Updating code 1");
            const code_json = this.model.get('code_json');
            if (code_json !== '') {
                window.Mito.setState({
                    codeJSON: JSON.parse(code_json)
                });
            }
        }
    }
}
exports.ExampleView = ExampleView;
//# sourceMappingURL=widget.js.map