﻿<a href="http://www.kios.ucy.ac.cy"><img src="https://www.kios.ucy.ac.cy/wp-content/uploads/2021/07/Logotype-KIOS.svg" width="200" height="100"/><a>


EPANET Python Toolkit (EPyT) - Examples
=======================================

## Table of Contents

- [Examples](#examples)

## Examples

- Toolkit Example 2: Hydrant rating curve ([ipynb](./Toolkit_EX2_Hydrant_rating_curve.ipynb), [py](./Toolkit_EX2_Hydrant_rating_curve.py)).
- Toolkit Example 3: Minimum chlorine residual ([ipynb](./Toolkit_EX3_Minimum_chlorine_residual.ipynb), [py](./Toolkit_EX3_Minimum_chlorine_residual.py)).
- Toolkit Example 4: Network building ([ipynb](./Toolkit_EX4_Network_Building.ipynb), [py](./Toolkit_EX4_Network_Building.py)).
- Example 1: Plot network topology ([ipynb](./EX1_Plot_network_topology.ipynb), [py](./EX1_Plot_network_topology.py)).
- Example 2: Hydraulic analysis ([ipynb](./EX2_Hydraulic_analysis.ipynb), [py](./EX2_Hydraulic_analysis.py)).
- Example 3: Quality analysis ([ipynb](./EX3_Quality_analysis.ipynb), [py](./EX3_Quality_analysis.ipynb)).
- Example 4: Plot time series ([ipynb](./EX4_Plot_time_series.ipynb), [py](./EX4_Plot_time_series.py)).
- Example 5: Plot net attributes ([ipynb](./EX5_Plot_values_parameters.ipynb), [py](./EX5_Plot_values_parameters.py)).
- Example 6: Load two inp files ([ipynb](./EX6_load_two_inp_files.ipynb), [py](./EX6_load_two_inp_files.py)).
- Example 7: Set pump curves ([ipynb](./EX7_Set_Pump_Curves.ipynb), [py](./EX7_Set_Pump_Curves.py)).
- Example 9: Compares hydraulics and quality analysis functions ([ipynb](./EX9_compare_simulations.ipynb), [py](./EX9_compare_simulations.py)).
- Example 10: Close pipes during simulation ([ipynb](./EX10_close_pipes_during_sim.ipynb), [py](./EX10_close_pipes_during_sim.py)).
- Example 11: Assign a new curve to a pump ([ipynb](./EX11_assing_new_curve_pump.ipynb), [py](./EX11_assing_new_curve_pump.py)).
- Example 13: Adds a CV Pipe in a network ([ipynb](./EX13c_add_cvpipe.ipynb), [py](./EX13c_add_cvpipe.py)).
- Example 14: Hydraulic and Quality analysis ([ipynb](./EX14_hydraulic_and_quality_analysis.ipynb), [py](./EX14_hydraulic_and_quality_analysis.py)).
- Example 16: Create multiple scenarios ([ipynb](./EX16_create_multiple_scenarios.ipynb), [py](./EX16_create_multiple_scenarios.py)).
- Example 17b: Add controls via normal functions ([ipynb](./EX17b_add_multiple_controls_pipestatus.ipynb), [py](./EX17b_add_multiple_controls_pipestatus.py)).
- Example 18: Change status of pipe during simulation ([ipynb](./EX18_change_status_pipes.ipynb), [py](./EX18_change_status_pipes.py)).
- Example 20a: Change of external Controls ([ipynb](./EX20a_external_controls.ipynb), [py](./EX20a_external_controls.py)).
- Example 20b: Addition of external Controls ([ipynb](./EX20b_external_controls.ipynb), [py](./EX20b_external_controls.py)).
- Example 21: Pressure driven analysis ([ipynb](./EX21_Pressure_driven_analysis_option.ipynb), [py](./EX21_Pressure_driven_analysis_option.py)).
- Example 22: Overflow of tanks ([ipynb](./EX22_Overflow_option_for_tanks.ipynb), [py](./EX22_Overflow_option_for_tanks.py)).
- Example 23: Change connection of the links ([ipynb](./EX23_Change_connection_links.ipynb), [py](./EX23_Change_connection_links.py)).
- Example 24: Delete all patterns ([ipynb](./EX24_delete_all_patterns.ipynb), [py](./EX24_delete_all_patterns.py)).
- Example 25: Set node name IDs ([ipynb](./EX25_set_node_name_ids.ipynb), [py](./EX25_set_node_name_ids.py)).
- Plt Example 1: Create a gif with the flows of Net1. ([ipynb](./Plt_EX1_Create_Flow_gif.ipynb), [py](./Plt_EX1_Create_Flow_gif.py)).
- Plt Example 2: Create a gif with the pressure of net2-cl2 ([ipynb](./Plt_EX2_Create_Pressure_gif.ipynb), [py](./Plt_EX2_Create_Pressure_gif.py)).
- API EN Example 1: Create a network with EN functions, eliminitating the need to an EPANET formatted input file ([ipynb](./Toolkit_api_EX1_using_EN_functions.ipynb), [py](./Toolkit_api_EX1_using_EN_functions.py)).
- Example Export data: Use/Save results in different formats/types and files ([py](./EX_to_excel_json.py)).

- &uparrow; [Back to top](#table-of-contents)
