# GPS clock
This package contains two Python files which rely on very specific hardware and software conditions. 
The project implements a clock which is governed by an Adafruit GPS module or a GY-GPSv3-NEO-M8N board. 
The intention is to demonstrate the data available from the GPS module and use it to display the accurate time and your location. 
I am a novice Python programmer, so I am sure that the code can be optimised. 
However the goal is to demonstrate the GPS function rather than to create a real clock. Who needs another clock?  

## clock_v2.py

The clock_v2.py project implements a clock which can display UTC and local time, your latitude, longitude, and Maidenhead grid square. 
The local date can be set to dd/mm/yy or mm/dd/yy format. The local time can be set to 12 hour or 24 hour format.
The UTC time is always displayed in 24 hour format.
The Maidenhead grid is calculated from the GPS latitude and longitude. It can be displayed in 8 digit or 6 digit format.
Lat and Lon are displayed as degrees east/west and south/north. 
The 4th page displays the number of received satellites, altitude, speed, and bearing. As with all GPS devices the altitude, speed, and bearing are inaccurate when the device is at rest.
The display can be set to dim after a time (up to one hour). Or you can set the brightness using a slide control on the display.

## tftwrite.py
The tftwrite.py script uploads a Nextion tft file created using the Nextion editor, to a Nextion display.
tftwrite.py was origonally 'nextion.py' written by Alex Koren in 2016. I have adapted it for Python3 and simplified the command line by putting the device and file name into the Python script. I got sick of typing it in :-)
It is currently configured to upload a file called GPS_clock.tft over /dev/ttyUSB0' (Serial USB adapter). It is easy to change the file name and modify the script for /dev/ttyS0 Serial or /dev/ttyAMA Serial. 

The script starts with a display baudrate of 38400 but if necessary it will try to connect at other speeds.

NOTE: If you are using a USB serial adapter it is much faster and easier to write the tft file directly from the Nextion editor by plugging the device into a USB port on your PC. 

## Hardware requirements
This software has been tested on a Raspberry Pi Zero2, running headless. The program is started via SSH or the Linux terminal but can be configured to run on boot.
The clock code probably will not run fast enough on a standard Raspberry Pi Zero or a Nano. It should run fine on a Raspberry Pi 3B or above. (Not tested).

The Adafruit 'Ultimate GPS breakout v3' GPS module is connected to the UART GPIO pins 14/15. +5V =pin4, GND =pin6, UART0_TXD GPIO14 = pin8, UART0_RXD GPIO15 = pin10. 
TXD is connected to RXD on the GPS board. RXD is connected to TXD on the GPS board. 

The 2.4" Nextion display is a NX3224F024 'discovery' model.
You should be able to modify the HMI file using the Nextion Editor to use any Nextion display.


## Software requirements
The clock imports PySerial and serial.tools.list_ports which must be installed separately using PIP.
It also imports, time, and threading 

The tft writer imports
serial, time, sys, os, and re. I think they are all standard Python things and no special installation is required.


## HMI and TFT files
The HMI file can be edited with the Nextion Editor software. The file in the package is sepcific to the NX3224F024 display, but you should be able to modify it using the Nextion Editor "Device ID" to use any Nextion display.
The TFT file cannot be edited. It is generated by the nextion Editor. It can only be used by uploading it to the Nextion NX3224F024 display using a direct upload from the Nextion Editor or tftwrite.py on the Rapberry Pi.  
