# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TwingateResourceArgs', 'TwingateResource']

@pulumi.input_type
class TwingateResourceArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 remote_network_id: pulumi.Input[str],
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input['TwingateResourceProtocolsArgs']] = None):
        """
        The set of arguments for constructing a TwingateResource resource.
        :param pulumi.Input[str] address: The Resource's IP/CIDR or FQDN/DNS zone
        :param pulumi.Input[str] remote_network_id: Remote Network ID where the Resource lives
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_ids: List of Group IDs that have permission to access the Resource, cannot be generated by Terraform and must be retrieved
               from the Twingate Admin Console or API
        :param pulumi.Input[str] name: The name of the Resource
        :param pulumi.Input['TwingateResourceProtocolsArgs'] protocols: Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no
               restriction, and all protocols and ports are allowed.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "remote_network_id", remote_network_id)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The Resource's IP/CIDR or FQDN/DNS zone
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="remoteNetworkId")
    def remote_network_id(self) -> pulumi.Input[str]:
        """
        Remote Network ID where the Resource lives
        """
        return pulumi.get(self, "remote_network_id")

    @remote_network_id.setter
    def remote_network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_network_id", value)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Group IDs that have permission to access the Resource, cannot be generated by Terraform and must be retrieved
        from the Twingate Admin Console or API
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input['TwingateResourceProtocolsArgs']]:
        """
        Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no
        restriction, and all protocols and ports are allowed.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input['TwingateResourceProtocolsArgs']]):
        pulumi.set(self, "protocols", value)


@pulumi.input_type
class _TwingateResourceState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input['TwingateResourceProtocolsArgs']] = None,
                 remote_network_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TwingateResource resources.
        :param pulumi.Input[str] address: The Resource's IP/CIDR or FQDN/DNS zone
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_ids: List of Group IDs that have permission to access the Resource, cannot be generated by Terraform and must be retrieved
               from the Twingate Admin Console or API
        :param pulumi.Input[str] name: The name of the Resource
        :param pulumi.Input['TwingateResourceProtocolsArgs'] protocols: Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no
               restriction, and all protocols and ports are allowed.
        :param pulumi.Input[str] remote_network_id: Remote Network ID where the Resource lives
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if remote_network_id is not None:
            pulumi.set(__self__, "remote_network_id", remote_network_id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The Resource's IP/CIDR or FQDN/DNS zone
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Group IDs that have permission to access the Resource, cannot be generated by Terraform and must be retrieved
        from the Twingate Admin Console or API
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input['TwingateResourceProtocolsArgs']]:
        """
        Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no
        restriction, and all protocols and ports are allowed.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input['TwingateResourceProtocolsArgs']]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="remoteNetworkId")
    def remote_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Network ID where the Resource lives
        """
        return pulumi.get(self, "remote_network_id")

    @remote_network_id.setter
    def remote_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_network_id", value)


class TwingateResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[pulumi.InputType['TwingateResourceProtocolsArgs']]] = None,
                 remote_network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a TwingateResource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The Resource's IP/CIDR or FQDN/DNS zone
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_ids: List of Group IDs that have permission to access the Resource, cannot be generated by Terraform and must be retrieved
               from the Twingate Admin Console or API
        :param pulumi.Input[str] name: The name of the Resource
        :param pulumi.Input[pulumi.InputType['TwingateResourceProtocolsArgs']] protocols: Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no
               restriction, and all protocols and ports are allowed.
        :param pulumi.Input[str] remote_network_id: Remote Network ID where the Resource lives
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TwingateResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a TwingateResource resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param TwingateResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TwingateResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[pulumi.InputType['TwingateResourceProtocolsArgs']]] = None,
                 remote_network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TwingateResourceArgs.__new__(TwingateResourceArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["group_ids"] = group_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["protocols"] = protocols
            if remote_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'remote_network_id'")
            __props__.__dict__["remote_network_id"] = remote_network_id
        super(TwingateResource, __self__).__init__(
            'twingate:index/twingateResource:TwingateResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            protocols: Optional[pulumi.Input[pulumi.InputType['TwingateResourceProtocolsArgs']]] = None,
            remote_network_id: Optional[pulumi.Input[str]] = None) -> 'TwingateResource':
        """
        Get an existing TwingateResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The Resource's IP/CIDR or FQDN/DNS zone
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_ids: List of Group IDs that have permission to access the Resource, cannot be generated by Terraform and must be retrieved
               from the Twingate Admin Console or API
        :param pulumi.Input[str] name: The name of the Resource
        :param pulumi.Input[pulumi.InputType['TwingateResourceProtocolsArgs']] protocols: Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no
               restriction, and all protocols and ports are allowed.
        :param pulumi.Input[str] remote_network_id: Remote Network ID where the Resource lives
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TwingateResourceState.__new__(_TwingateResourceState)

        __props__.__dict__["address"] = address
        __props__.__dict__["group_ids"] = group_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["remote_network_id"] = remote_network_id
        return TwingateResource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The Resource's IP/CIDR or FQDN/DNS zone
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of Group IDs that have permission to access the Resource, cannot be generated by Terraform and must be retrieved
        from the Twingate Admin Console or API
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Optional['outputs.TwingateResourceProtocols']]:
        """
        Restrict access to certain protocols and ports. By default or when this argument is not defined, there is no
        restriction, and all protocols and ports are allowed.
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="remoteNetworkId")
    def remote_network_id(self) -> pulumi.Output[str]:
        """
        Remote Network ID where the Resource lives
        """
        return pulumi.get(self, "remote_network_id")

