#
# Copyright The NOMAD Authors.
#
# This file is part of NOMAD. See https://nomad-lab.eu for further info.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# pylint: disable=E1101

# this is a copy of downloadable data from ase
# from ase.data.isotopes import download_isotope_data
# isotopes = download_isotope_data()
# to avoid having to download the data on-the-fly because ase uses requests

isotopes = {1: {1: {"mass": 1.00782503223, "composition": 0.999885},
  2: {"mass": 2.01410177812, "composition": 0.000115},
  3: {"mass": 3.0160492779, "composition": 0.0},
  4: {"mass": 4.02643, "composition": 0.0},
  5: {"mass": 5.035311, "composition": 0.0},
  6: {"mass": 6.04496, "composition": 0.0},
  7: {"mass": 7.0527, "composition": 0.0}},
 2: {3: {"mass": 3.0160293201, "composition": 1.34e-06},
  4: {"mass": 4.00260325413, "composition": 0.99999866},
  5: {"mass": 5.012057, "composition": 0.0},
  6: {"mass": 6.018885891, "composition": 0.0},
  7: {"mass": 7.0279907, "composition": 0.0},
  8: {"mass": 8.03393439, "composition": 0.0},
  9: {"mass": 9.043946, "composition": 0.0},
  10: {"mass": 10.05279, "composition": 0.0}},
 3: {3: {"mass": 3.0308, "composition": 0.0},
  4: {"mass": 4.02719, "composition": 0.0},
  5: {"mass": 5.012538, "composition": 0.0},
  6: {"mass": 6.0151228874, "composition": 0.0759},
  7: {"mass": 7.0160034366, "composition": 0.9241},
  8: {"mass": 8.022486246, "composition": 0.0},
  9: {"mass": 9.02679019, "composition": 0.0},
  10: {"mass": 10.035483, "composition": 0.0},
  11: {"mass": 11.04372358, "composition": 0.0},
  12: {"mass": 12.052517, "composition": 0.0},
  13: {"mass": 13.06263, "composition": 0.0}},
 4: {5: {"mass": 5.0399, "composition": 0.0},
  6: {"mass": 6.0197264, "composition": 0.0},
  7: {"mass": 7.016928717, "composition": 0.0},
  8: {"mass": 8.005305102, "composition": 0.0},
  9: {"mass": 9.012183065, "composition": 1.0},
  10: {"mass": 10.013534695, "composition": 0.0},
  11: {"mass": 11.02166108, "composition": 0.0},
  12: {"mass": 12.0269221, "composition": 0.0},
  13: {"mass": 13.036135, "composition": 0.0},
  14: {"mass": 14.04289, "composition": 0.0},
  15: {"mass": 15.05342, "composition": 0.0},
  16: {"mass": 16.06167, "composition": 0.0}},
 5: {6: {"mass": 6.0508, "composition": 0.0},
  7: {"mass": 7.029712, "composition": 0.0},
  8: {"mass": 8.0246073, "composition": 0.0},
  9: {"mass": 9.01332965, "composition": 0.0},
  10: {"mass": 10.01293695, "composition": 0.199},
  11: {"mass": 11.00930536, "composition": 0.801},
  12: {"mass": 12.0143527, "composition": 0.0},
  13: {"mass": 13.0177802, "composition": 0.0},
  14: {"mass": 14.025404, "composition": 0.0},
  15: {"mass": 15.031088, "composition": 0.0},
  16: {"mass": 16.039842, "composition": 0.0},
  17: {"mass": 17.04699, "composition": 0.0},
  18: {"mass": 18.05566, "composition": 0.0},
  19: {"mass": 19.0631, "composition": 0.0},
  20: {"mass": 20.07207, "composition": 0.0},
  21: {"mass": 21.08129, "composition": 0.0}},
 6: {8: {"mass": 8.037643, "composition": 0.0},
  9: {"mass": 9.0310372, "composition": 0.0},
  10: {"mass": 10.01685331, "composition": 0.0},
  11: {"mass": 11.0114336, "composition": 0.0},
  12: {"mass": 12.0, "composition": 0.9893},
  13: {"mass": 13.00335483507, "composition": 0.0107},
  14: {"mass": 14.0032419884, "composition": 0.0},
  15: {"mass": 15.01059926, "composition": 0.0},
  16: {"mass": 16.0147013, "composition": 0.0},
  17: {"mass": 17.022577, "composition": 0.0},
  18: {"mass": 18.026751, "composition": 0.0},
  19: {"mass": 19.0348, "composition": 0.0},
  20: {"mass": 20.04032, "composition": 0.0},
  21: {"mass": 21.049, "composition": 0.0},
  22: {"mass": 22.05753, "composition": 0.0},
  23: {"mass": 23.0689, "composition": 0.0}},
 7: {10: {"mass": 10.04165, "composition": 0.0},
  11: {"mass": 11.026091, "composition": 0.0},
  12: {"mass": 12.0186132, "composition": 0.0},
  13: {"mass": 13.00573861, "composition": 0.0},
  14: {"mass": 14.00307400443, "composition": 0.99636},
  15: {"mass": 15.00010889888, "composition": 0.00364},
  16: {"mass": 16.0061019, "composition": 0.0},
  17: {"mass": 17.008449, "composition": 0.0},
  18: {"mass": 18.014078, "composition": 0.0},
  19: {"mass": 19.017022, "composition": 0.0},
  20: {"mass": 20.023366, "composition": 0.0},
  21: {"mass": 21.02711, "composition": 0.0},
  22: {"mass": 22.03439, "composition": 0.0},
  23: {"mass": 23.04114, "composition": 0.0},
  24: {"mass": 24.05039, "composition": 0.0},
  25: {"mass": 25.0601, "composition": 0.0}},
 8: {12: {"mass": 12.034262, "composition": 0.0},
  13: {"mass": 13.024815, "composition": 0.0},
  14: {"mass": 14.00859636, "composition": 0.0},
  15: {"mass": 15.00306562, "composition": 0.0},
  16: {"mass": 15.99491461957, "composition": 0.99757},
  17: {"mass": 16.9991317565, "composition": 0.00038},
  18: {"mass": 17.99915961286, "composition": 0.00205},
  19: {"mass": 19.003578, "composition": 0.0},
  20: {"mass": 20.00407535, "composition": 0.0},
  21: {"mass": 21.008655, "composition": 0.0},
  22: {"mass": 22.009966, "composition": 0.0},
  23: {"mass": 23.015696, "composition": 0.0},
  24: {"mass": 24.01986, "composition": 0.0},
  25: {"mass": 25.02936, "composition": 0.0},
  26: {"mass": 26.03729, "composition": 0.0},
  27: {"mass": 27.04772, "composition": 0.0},
  28: {"mass": 28.05591, "composition": 0.0}},
 9: {14: {"mass": 14.034315, "composition": 0.0},
  15: {"mass": 15.018043, "composition": 0.0},
  16: {"mass": 16.0114657, "composition": 0.0},
  17: {"mass": 17.00209524, "composition": 0.0},
  18: {"mass": 18.00093733, "composition": 0.0},
  19: {"mass": 18.99840316273, "composition": 1.0},
  20: {"mass": 19.999981252, "composition": 0.0},
  21: {"mass": 20.9999489, "composition": 0.0},
  22: {"mass": 22.002999, "composition": 0.0},
  23: {"mass": 23.003557, "composition": 0.0},
  24: {"mass": 24.008115, "composition": 0.0},
  25: {"mass": 25.012199, "composition": 0.0},
  26: {"mass": 26.020038, "composition": 0.0},
  27: {"mass": 27.02644, "composition": 0.0},
  28: {"mass": 28.03534, "composition": 0.0},
  29: {"mass": 29.04254, "composition": 0.0},
  30: {"mass": 30.05165, "composition": 0.0},
  31: {"mass": 31.05971, "composition": 0.0}},
 10: {16: {"mass": 16.02575, "composition": 0.0},
  17: {"mass": 17.01771396, "composition": 0.0},
  18: {"mass": 18.0057087, "composition": 0.0},
  19: {"mass": 19.00188091, "composition": 0.0},
  20: {"mass": 19.9924401762, "composition": 0.9048},
  21: {"mass": 20.993846685, "composition": 0.0027},
  22: {"mass": 21.991385114, "composition": 0.0925},
  23: {"mass": 22.99446691, "composition": 0.0},
  24: {"mass": 23.99361065, "composition": 0.0},
  25: {"mass": 24.997789, "composition": 0.0},
  26: {"mass": 26.000515, "composition": 0.0},
  27: {"mass": 27.007553, "composition": 0.0},
  28: {"mass": 28.01212, "composition": 0.0},
  29: {"mass": 29.01975, "composition": 0.0},
  30: {"mass": 30.02473, "composition": 0.0},
  31: {"mass": 31.0331, "composition": 0.0},
  32: {"mass": 32.03972, "composition": 0.0},
  33: {"mass": 33.04938, "composition": 0.0},
  34: {"mass": 34.05673, "composition": 0.0}},
 11: {18: {"mass": 18.02688, "composition": 0.0},
  19: {"mass": 19.01388, "composition": 0.0},
  20: {"mass": 20.0073544, "composition": 0.0},
  21: {"mass": 20.99765469, "composition": 0.0},
  22: {"mass": 21.99443741, "composition": 0.0},
  23: {"mass": 22.989769282, "composition": 1.0},
  24: {"mass": 23.99096295, "composition": 0.0},
  25: {"mass": 24.989954, "composition": 0.0},
  26: {"mass": 25.9926346, "composition": 0.0},
  27: {"mass": 26.9940765, "composition": 0.0},
  28: {"mass": 27.998939, "composition": 0.0},
  29: {"mass": 29.0028771, "composition": 0.0},
  30: {"mass": 30.0090979, "composition": 0.0},
  31: {"mass": 31.013163, "composition": 0.0},
  32: {"mass": 32.02019, "composition": 0.0},
  33: {"mass": 33.02573, "composition": 0.0},
  34: {"mass": 34.03359, "composition": 0.0},
  35: {"mass": 35.04062, "composition": 0.0},
  36: {"mass": 36.04929, "composition": 0.0},
  37: {"mass": 37.05705, "composition": 0.0}},
 12: {19: {"mass": 19.034169, "composition": 0.0},
  20: {"mass": 20.01885, "composition": 0.0},
  21: {"mass": 21.011716, "composition": 0.0},
  22: {"mass": 21.99957065, "composition": 0.0},
  23: {"mass": 22.99412421, "composition": 0.0},
  24: {"mass": 23.985041697, "composition": 0.7899},
  25: {"mass": 24.985836976, "composition": 0.1},
  26: {"mass": 25.982592968, "composition": 0.1101},
  27: {"mass": 26.984340624, "composition": 0.0},
  28: {"mass": 27.9838767, "composition": 0.0},
  29: {"mass": 28.988617, "composition": 0.0},
  30: {"mass": 29.9904629, "composition": 0.0},
  31: {"mass": 30.996648, "composition": 0.0},
  32: {"mass": 31.9991102, "composition": 0.0},
  33: {"mass": 33.0053271, "composition": 0.0},
  34: {"mass": 34.008935, "composition": 0.0},
  35: {"mass": 35.01679, "composition": 0.0},
  36: {"mass": 36.02188, "composition": 0.0},
  37: {"mass": 37.03037, "composition": 0.0},
  38: {"mass": 38.03658, "composition": 0.0},
  39: {"mass": 39.04538, "composition": 0.0},
  40: {"mass": 40.05218, "composition": 0.0}},
 13: {21: {"mass": 21.02897, "composition": 0.0},
  22: {"mass": 22.01954, "composition": 0.0},
  23: {"mass": 23.00724435, "composition": 0.0},
  24: {"mass": 23.9999489, "composition": 0.0},
  25: {"mass": 24.9904281, "composition": 0.0},
  26: {"mass": 25.986891904, "composition": 0.0},
  27: {"mass": 26.98153853, "composition": 1.0},
  28: {"mass": 27.98191021, "composition": 0.0},
  29: {"mass": 28.9804565, "composition": 0.0},
  30: {"mass": 29.98296, "composition": 0.0},
  31: {"mass": 30.983945, "composition": 0.0},
  32: {"mass": 31.988085, "composition": 0.0},
  33: {"mass": 32.990909, "composition": 0.0},
  34: {"mass": 33.996705, "composition": 0.0},
  35: {"mass": 34.999764, "composition": 0.0},
  36: {"mass": 36.00639, "composition": 0.0},
  37: {"mass": 37.01053, "composition": 0.0},
  38: {"mass": 38.0174, "composition": 0.0},
  39: {"mass": 39.02254, "composition": 0.0},
  40: {"mass": 40.03003, "composition": 0.0},
  41: {"mass": 41.03638, "composition": 0.0},
  42: {"mass": 42.04384, "composition": 0.0},
  43: {"mass": 43.05147, "composition": 0.0}},
 14: {22: {"mass": 22.03579, "composition": 0.0},
  23: {"mass": 23.02544, "composition": 0.0},
  24: {"mass": 24.011535, "composition": 0.0},
  25: {"mass": 25.004109, "composition": 0.0},
  26: {"mass": 25.99233384, "composition": 0.0},
  27: {"mass": 26.98670481, "composition": 0.0},
  28: {"mass": 27.97692653465, "composition": 0.92223},
  29: {"mass": 28.9764946649, "composition": 0.04685},
  30: {"mass": 29.973770136, "composition": 0.03092},
  31: {"mass": 30.975363194, "composition": 0.0},
  32: {"mass": 31.97415154, "composition": 0.0},
  33: {"mass": 32.97797696, "composition": 0.0},
  34: {"mass": 33.978576, "composition": 0.0},
  35: {"mass": 34.984583, "composition": 0.0},
  36: {"mass": 35.986695, "composition": 0.0},
  37: {"mass": 36.992921, "composition": 0.0},
  38: {"mass": 37.995523, "composition": 0.0},
  39: {"mass": 39.002491, "composition": 0.0},
  40: {"mass": 40.00583, "composition": 0.0},
  41: {"mass": 41.01301, "composition": 0.0},
  42: {"mass": 42.01778, "composition": 0.0},
  43: {"mass": 43.0248, "composition": 0.0},
  44: {"mass": 44.03061, "composition": 0.0},
  45: {"mass": 45.03995, "composition": 0.0}},
 15: {24: {"mass": 24.03577, "composition": 0.0},
  25: {"mass": 25.02119, "composition": 0.0},
  26: {"mass": 26.01178, "composition": 0.0},
  27: {"mass": 26.999224, "composition": 0.0},
  28: {"mass": 27.9923266, "composition": 0.0},
  29: {"mass": 28.98180079, "composition": 0.0},
  30: {"mass": 29.97831375, "composition": 0.0},
  31: {"mass": 30.97376199842, "composition": 1.0},
  32: {"mass": 31.973907643, "composition": 0.0},
  33: {"mass": 32.9717257, "composition": 0.0},
  34: {"mass": 33.97364589, "composition": 0.0},
  35: {"mass": 34.9733141, "composition": 0.0},
  36: {"mass": 35.97826, "composition": 0.0},
  37: {"mass": 36.979607, "composition": 0.0},
  38: {"mass": 37.984252, "composition": 0.0},
  39: {"mass": 38.986227, "composition": 0.0},
  40: {"mass": 39.99133, "composition": 0.0},
  41: {"mass": 40.994654, "composition": 0.0},
  42: {"mass": 42.00108, "composition": 0.0},
  43: {"mass": 43.00502, "composition": 0.0},
  44: {"mass": 44.01121, "composition": 0.0},
  45: {"mass": 45.01645, "composition": 0.0},
  46: {"mass": 46.02446, "composition": 0.0},
  47: {"mass": 47.03139, "composition": 0.0}},
 16: {26: {"mass": 26.02907, "composition": 0.0},
  27: {"mass": 27.01828, "composition": 0.0},
  28: {"mass": 28.00437, "composition": 0.0},
  29: {"mass": 28.996611, "composition": 0.0},
  30: {"mass": 29.98490703, "composition": 0.0},
  31: {"mass": 30.97955701, "composition": 0.0},
  32: {"mass": 31.9720711744, "composition": 0.9499},
  33: {"mass": 32.9714589098, "composition": 0.0075},
  34: {"mass": 33.967867004, "composition": 0.0425},
  35: {"mass": 34.96903231, "composition": 0.0},
  36: {"mass": 35.96708071, "composition": 0.0001},
  37: {"mass": 36.97112551, "composition": 0.0},
  38: {"mass": 37.9711633, "composition": 0.0},
  39: {"mass": 38.975134, "composition": 0.0},
  40: {"mass": 39.9754826, "composition": 0.0},
  41: {"mass": 40.9795935, "composition": 0.0},
  42: {"mass": 41.9810651, "composition": 0.0},
  43: {"mass": 42.9869076, "composition": 0.0},
  44: {"mass": 43.9901188, "composition": 0.0},
  45: {"mass": 44.99572, "composition": 0.0},
  46: {"mass": 46.00004, "composition": 0.0},
  47: {"mass": 47.00795, "composition": 0.0},
  48: {"mass": 48.0137, "composition": 0.0},
  49: {"mass": 49.02276, "composition": 0.0}},
 17: {28: {"mass": 28.02954, "composition": 0.0},
  29: {"mass": 29.01478, "composition": 0.0},
  30: {"mass": 30.00477, "composition": 0.0},
  31: {"mass": 30.992414, "composition": 0.0},
  32: {"mass": 31.98568464, "composition": 0.0},
  33: {"mass": 32.97745199, "composition": 0.0},
  34: {"mass": 33.973762485, "composition": 0.0},
  35: {"mass": 34.968852682, "composition": 0.7576},
  36: {"mass": 35.968306809, "composition": 0.0},
  37: {"mass": 36.965902602, "composition": 0.2424},
  38: {"mass": 37.96801044, "composition": 0.0},
  39: {"mass": 38.9680082, "composition": 0.0},
  40: {"mass": 39.970415, "composition": 0.0},
  41: {"mass": 40.970685, "composition": 0.0},
  42: {"mass": 41.97325, "composition": 0.0},
  43: {"mass": 42.97389, "composition": 0.0},
  44: {"mass": 43.97787, "composition": 0.0},
  45: {"mass": 44.98029, "composition": 0.0},
  46: {"mass": 45.98517, "composition": 0.0},
  47: {"mass": 46.98916, "composition": 0.0},
  48: {"mass": 47.99564, "composition": 0.0},
  49: {"mass": 49.00123, "composition": 0.0},
  50: {"mass": 50.00905, "composition": 0.0},
  51: {"mass": 51.01554, "composition": 0.0}},
 18: {30: {"mass": 30.02307, "composition": 0.0},
  31: {"mass": 31.01212, "composition": 0.0},
  32: {"mass": 31.9976378, "composition": 0.0},
  33: {"mass": 32.98992555, "composition": 0.0},
  34: {"mass": 33.98027009, "composition": 0.0},
  35: {"mass": 34.97525759, "composition": 0.0},
  36: {"mass": 35.967545105, "composition": 0.003336},
  37: {"mass": 36.96677633, "composition": 0.0},
  38: {"mass": 37.96273211, "composition": 0.000629},
  39: {"mass": 38.964313, "composition": 0.0},
  40: {"mass": 39.9623831237, "composition": 0.996035},
  41: {"mass": 40.96450057, "composition": 0.0},
  42: {"mass": 41.9630457, "composition": 0.0},
  43: {"mass": 42.9656361, "composition": 0.0},
  44: {"mass": 43.9649238, "composition": 0.0},
  45: {"mass": 44.96803973, "composition": 0.0},
  46: {"mass": 45.968083, "composition": 0.0},
  47: {"mass": 46.972935, "composition": 0.0},
  48: {"mass": 47.97591, "composition": 0.0},
  49: {"mass": 48.9819, "composition": 0.0},
  50: {"mass": 49.98613, "composition": 0.0},
  51: {"mass": 50.9937, "composition": 0.0},
  52: {"mass": 51.99896, "composition": 0.0},
  53: {"mass": 53.00729, "composition": 0.0}},
 19: {32: {"mass": 32.02265, "composition": 0.0},
  33: {"mass": 33.00756, "composition": 0.0},
  34: {"mass": 33.99869, "composition": 0.0},
  35: {"mass": 34.98800541, "composition": 0.0},
  36: {"mass": 35.98130201, "composition": 0.0},
  37: {"mass": 36.97337589, "composition": 0.0},
  38: {"mass": 37.96908112, "composition": 0.0},
  39: {"mass": 38.9637064864, "composition": 0.932581},
  40: {"mass": 39.963998166, "composition": 0.000117},
  41: {"mass": 40.9618252579, "composition": 0.067302},
  42: {"mass": 41.96240231, "composition": 0.0},
  43: {"mass": 42.9607347, "composition": 0.0},
  44: {"mass": 43.96158699, "composition": 0.0},
  45: {"mass": 44.96069149, "composition": 0.0},
  46: {"mass": 45.96198159, "composition": 0.0},
  47: {"mass": 46.9616616, "composition": 0.0},
  48: {"mass": 47.96534119, "composition": 0.0},
  49: {"mass": 48.96821075, "composition": 0.0},
  50: {"mass": 49.97238, "composition": 0.0},
  51: {"mass": 50.975828, "composition": 0.0},
  52: {"mass": 51.98224, "composition": 0.0},
  53: {"mass": 52.98746, "composition": 0.0},
  54: {"mass": 53.99463, "composition": 0.0},
  55: {"mass": 55.00076, "composition": 0.0},
  56: {"mass": 56.00851, "composition": 0.0}},
 20: {34: {"mass": 34.01487, "composition": 0.0},
  35: {"mass": 35.00514, "composition": 0.0},
  36: {"mass": 35.993074, "composition": 0.0},
  37: {"mass": 36.98589785, "composition": 0.0},
  38: {"mass": 37.97631922, "composition": 0.0},
  39: {"mass": 38.97071081, "composition": 0.0},
  40: {"mass": 39.962590863, "composition": 0.96941},
  41: {"mass": 40.96227792, "composition": 0.0},
  42: {"mass": 41.95861783, "composition": 0.00647},
  43: {"mass": 42.95876644, "composition": 0.00135},
  44: {"mass": 43.95548156, "composition": 0.02086},
  45: {"mass": 44.95618635, "composition": 0.0},
  46: {"mass": 45.953689, "composition": 4e-05},
  47: {"mass": 46.9545424, "composition": 0.0},
  48: {"mass": 47.95252276, "composition": 0.00187},
  49: {"mass": 48.95566274, "composition": 0.0},
  50: {"mass": 49.9574992, "composition": 0.0},
  51: {"mass": 50.960989, "composition": 0.0},
  52: {"mass": 51.963217, "composition": 0.0},
  53: {"mass": 52.96945, "composition": 0.0},
  54: {"mass": 53.9734, "composition": 0.0},
  55: {"mass": 54.9803, "composition": 0.0},
  56: {"mass": 55.98508, "composition": 0.0},
  57: {"mass": 56.99262, "composition": 0.0},
  58: {"mass": 57.99794, "composition": 0.0}},
 21: {36: {"mass": 36.01648, "composition": 0.0},
  37: {"mass": 37.00374, "composition": 0.0},
  38: {"mass": 37.99512, "composition": 0.0},
  39: {"mass": 38.984785, "composition": 0.0},
  40: {"mass": 39.9779673, "composition": 0.0},
  41: {"mass": 40.969251105, "composition": 0.0},
  42: {"mass": 41.96551653, "composition": 0.0},
  43: {"mass": 42.9611505, "composition": 0.0},
  44: {"mass": 43.9594029, "composition": 0.0},
  45: {"mass": 44.95590828, "composition": 1.0},
  46: {"mass": 45.95516826, "composition": 0.0},
  47: {"mass": 46.9524037, "composition": 0.0},
  48: {"mass": 47.9522236, "composition": 0.0},
  49: {"mass": 48.9500146, "composition": 0.0},
  50: {"mass": 49.952176, "composition": 0.0},
  51: {"mass": 50.953592, "composition": 0.0},
  52: {"mass": 51.95688, "composition": 0.0},
  53: {"mass": 52.95909, "composition": 0.0},
  54: {"mass": 53.96393, "composition": 0.0},
  55: {"mass": 54.96782, "composition": 0.0},
  56: {"mass": 55.97345, "composition": 0.0},
  57: {"mass": 56.97777, "composition": 0.0},
  58: {"mass": 57.98403, "composition": 0.0},
  59: {"mass": 58.98894, "composition": 0.0},
  60: {"mass": 59.99565, "composition": 0.0},
  61: {"mass": 61.001, "composition": 0.0}},
 22: {38: {"mass": 38.01145, "composition": 0.0},
  39: {"mass": 39.00236, "composition": 0.0},
  40: {"mass": 39.9905, "composition": 0.0},
  41: {"mass": 40.983148, "composition": 0.0},
  42: {"mass": 41.97304903, "composition": 0.0},
  43: {"mass": 42.9685225, "composition": 0.0},
  44: {"mass": 43.95968995, "composition": 0.0},
  45: {"mass": 44.95812198, "composition": 0.0},
  46: {"mass": 45.95262772, "composition": 0.0825},
  47: {"mass": 46.95175879, "composition": 0.0744},
  48: {"mass": 47.94794198, "composition": 0.7372},
  49: {"mass": 48.94786568, "composition": 0.0541},
  50: {"mass": 49.94478689, "composition": 0.0518},
  51: {"mass": 50.94661065, "composition": 0.0},
  52: {"mass": 51.946893, "composition": 0.0},
  53: {"mass": 52.94973, "composition": 0.0},
  54: {"mass": 53.95105, "composition": 0.0},
  55: {"mass": 54.95527, "composition": 0.0},
  56: {"mass": 55.95791, "composition": 0.0},
  57: {"mass": 56.96364, "composition": 0.0},
  58: {"mass": 57.9666, "composition": 0.0},
  59: {"mass": 58.97247, "composition": 0.0},
  60: {"mass": 59.97603, "composition": 0.0},
  61: {"mass": 60.98245, "composition": 0.0},
  62: {"mass": 61.98651, "composition": 0.0},
  63: {"mass": 62.99375, "composition": 0.0}},
 23: {40: {"mass": 40.01276, "composition": 0.0},
  41: {"mass": 41.00021, "composition": 0.0},
  42: {"mass": 41.99182, "composition": 0.0},
  43: {"mass": 42.980766, "composition": 0.0},
  44: {"mass": 43.97411, "composition": 0.0},
  45: {"mass": 44.9657748, "composition": 0.0},
  46: {"mass": 45.96019878, "composition": 0.0},
  47: {"mass": 46.95490491, "composition": 0.0},
  48: {"mass": 47.9522522, "composition": 0.0},
  49: {"mass": 48.9485118, "composition": 0.0},
  50: {"mass": 49.94715601, "composition": 0.0025},
  51: {"mass": 50.94395704, "composition": 0.9975},
  52: {"mass": 51.94477301, "composition": 0.0},
  53: {"mass": 52.9443367, "composition": 0.0},
  54: {"mass": 53.946439, "composition": 0.0},
  55: {"mass": 54.94724, "composition": 0.0},
  56: {"mass": 55.95048, "composition": 0.0},
  57: {"mass": 56.95252, "composition": 0.0},
  58: {"mass": 57.95672, "composition": 0.0},
  59: {"mass": 58.95939, "composition": 0.0},
  60: {"mass": 59.96431, "composition": 0.0},
  61: {"mass": 60.96725, "composition": 0.0},
  62: {"mass": 61.97265, "composition": 0.0},
  63: {"mass": 62.97639, "composition": 0.0},
  64: {"mass": 63.98264, "composition": 0.0},
  65: {"mass": 64.9875, "composition": 0.0},
  66: {"mass": 65.99398, "composition": 0.0}},
 24: {42: {"mass": 42.0067, "composition": 0.0},
  43: {"mass": 42.99753, "composition": 0.0},
  44: {"mass": 43.98536, "composition": 0.0},
  45: {"mass": 44.97905, "composition": 0.0},
  46: {"mass": 45.968359, "composition": 0.0},
  47: {"mass": 46.9628974, "composition": 0.0},
  48: {"mass": 47.9540291, "composition": 0.0},
  49: {"mass": 48.9513333, "composition": 0.0},
  50: {"mass": 49.94604183, "composition": 0.04345},
  51: {"mass": 50.94476502, "composition": 0.0},
  52: {"mass": 51.94050623, "composition": 0.83789},
  53: {"mass": 52.94064815, "composition": 0.09501},
  54: {"mass": 53.93887916, "composition": 0.02365},
  55: {"mass": 54.94083843, "composition": 0.0},
  56: {"mass": 55.9406531, "composition": 0.0},
  57: {"mass": 56.943613, "composition": 0.0},
  58: {"mass": 57.94435, "composition": 0.0},
  59: {"mass": 58.94859, "composition": 0.0},
  60: {"mass": 59.95008, "composition": 0.0},
  61: {"mass": 60.95442, "composition": 0.0},
  62: {"mass": 61.9561, "composition": 0.0},
  63: {"mass": 62.96165, "composition": 0.0},
  64: {"mass": 63.96408, "composition": 0.0},
  65: {"mass": 64.96996, "composition": 0.0},
  66: {"mass": 65.97366, "composition": 0.0},
  67: {"mass": 66.98016, "composition": 0.0},
  68: {"mass": 67.98403, "composition": 0.0}},
 25: {44: {"mass": 44.00715, "composition": 0.0},
  45: {"mass": 44.99449, "composition": 0.0},
  46: {"mass": 45.98609, "composition": 0.0},
  47: {"mass": 46.975775, "composition": 0.0},
  48: {"mass": 47.96852, "composition": 0.0},
  49: {"mass": 48.959595, "composition": 0.0},
  50: {"mass": 49.95423778, "composition": 0.0},
  51: {"mass": 50.94820847, "composition": 0.0},
  52: {"mass": 51.9455639, "composition": 0.0},
  53: {"mass": 52.94128889, "composition": 0.0},
  54: {"mass": 53.9403576, "composition": 0.0},
  55: {"mass": 54.93804391, "composition": 1.0},
  56: {"mass": 55.93890369, "composition": 0.0},
  57: {"mass": 56.9382861, "composition": 0.0},
  58: {"mass": 57.9400666, "composition": 0.0},
  59: {"mass": 58.9403911, "composition": 0.0},
  60: {"mass": 59.9431366, "composition": 0.0},
  61: {"mass": 60.9444525, "composition": 0.0},
  62: {"mass": 61.94795, "composition": 0.0},
  63: {"mass": 62.9496647, "composition": 0.0},
  64: {"mass": 63.9538494, "composition": 0.0},
  65: {"mass": 64.9560198, "composition": 0.0},
  66: {"mass": 65.960547, "composition": 0.0},
  67: {"mass": 66.96424, "composition": 0.0},
  68: {"mass": 67.96962, "composition": 0.0},
  69: {"mass": 68.97366, "composition": 0.0},
  70: {"mass": 69.97937, "composition": 0.0},
  71: {"mass": 70.98368, "composition": 0.0}},
 26: {45: {"mass": 45.01442, "composition": 0.0},
  46: {"mass": 46.00063, "composition": 0.0},
  47: {"mass": 46.99185, "composition": 0.0},
  48: {"mass": 47.98023, "composition": 0.0},
  49: {"mass": 48.973429, "composition": 0.0},
  50: {"mass": 49.962975, "composition": 0.0},
  51: {"mass": 50.956841, "composition": 0.0},
  52: {"mass": 51.9481131, "composition": 0.0},
  53: {"mass": 52.9453064, "composition": 0.0},
  54: {"mass": 53.93960899, "composition": 0.05845},
  55: {"mass": 54.93829199, "composition": 0.0},
  56: {"mass": 55.93493633, "composition": 0.91754},
  57: {"mass": 56.93539284, "composition": 0.02119},
  58: {"mass": 57.93327443, "composition": 0.00282},
  59: {"mass": 58.93487434, "composition": 0.0},
  60: {"mass": 59.9340711, "composition": 0.0},
  61: {"mass": 60.9367462, "composition": 0.0},
  62: {"mass": 61.9367918, "composition": 0.0},
  63: {"mass": 62.9402727, "composition": 0.0},
  64: {"mass": 63.9409878, "composition": 0.0},
  65: {"mass": 64.9450115, "composition": 0.0},
  66: {"mass": 65.94625, "composition": 0.0},
  67: {"mass": 66.95054, "composition": 0.0},
  68: {"mass": 67.95295, "composition": 0.0},
  69: {"mass": 68.95807, "composition": 0.0},
  70: {"mass": 69.96102, "composition": 0.0},
  71: {"mass": 70.96672, "composition": 0.0},
  72: {"mass": 71.96983, "composition": 0.0},
  73: {"mass": 72.97572, "composition": 0.0},
  74: {"mass": 73.97935, "composition": 0.0}},
 27: {47: {"mass": 47.01057, "composition": 0.0},
  48: {"mass": 48.00093, "composition": 0.0},
  49: {"mass": 48.98891, "composition": 0.0},
  50: {"mass": 49.98091, "composition": 0.0},
  51: {"mass": 50.970647, "composition": 0.0},
  52: {"mass": 51.96351, "composition": 0.0},
  53: {"mass": 52.9542041, "composition": 0.0},
  54: {"mass": 53.94845987, "composition": 0.0},
  55: {"mass": 54.9419972, "composition": 0.0},
  56: {"mass": 55.9398388, "composition": 0.0},
  57: {"mass": 56.93629057, "composition": 0.0},
  58: {"mass": 57.9357521, "composition": 0.0},
  59: {"mass": 58.93319429, "composition": 1.0},
  60: {"mass": 59.9338163, "composition": 0.0},
  61: {"mass": 60.93247662, "composition": 0.0},
  62: {"mass": 61.934059, "composition": 0.0},
  63: {"mass": 62.9336, "composition": 0.0},
  64: {"mass": 63.935811, "composition": 0.0},
  65: {"mass": 64.9364621, "composition": 0.0},
  66: {"mass": 65.939443, "composition": 0.0},
  67: {"mass": 66.9406096, "composition": 0.0},
  68: {"mass": 67.94426, "composition": 0.0},
  69: {"mass": 68.94614, "composition": 0.0},
  70: {"mass": 69.94963, "composition": 0.0},
  71: {"mass": 70.95237, "composition": 0.0},
  72: {"mass": 71.95729, "composition": 0.0},
  73: {"mass": 72.96039, "composition": 0.0},
  74: {"mass": 73.96515, "composition": 0.0},
  75: {"mass": 74.96876, "composition": 0.0},
  76: {"mass": 75.97413, "composition": 0.0}},
 28: {48: {"mass": 48.01769, "composition": 0.0},
  49: {"mass": 49.0077, "composition": 0.0},
  50: {"mass": 49.99474, "composition": 0.0},
  51: {"mass": 50.98611, "composition": 0.0},
  52: {"mass": 51.9748, "composition": 0.0},
  53: {"mass": 52.96819, "composition": 0.0},
  54: {"mass": 53.957892, "composition": 0.0},
  55: {"mass": 54.95133063, "composition": 0.0},
  56: {"mass": 55.94212855, "composition": 0.0},
  57: {"mass": 56.93979218, "composition": 0.0},
  58: {"mass": 57.93534241, "composition": 0.68077},
  59: {"mass": 58.9343462, "composition": 0.0},
  60: {"mass": 59.93078588, "composition": 0.26223},
  61: {"mass": 60.93105557, "composition": 0.011399},
  62: {"mass": 61.92834537, "composition": 0.036346},
  63: {"mass": 62.92966963, "composition": 0.0},
  64: {"mass": 63.92796682, "composition": 0.009255},
  65: {"mass": 64.93008517, "composition": 0.0},
  66: {"mass": 65.9291393, "composition": 0.0},
  67: {"mass": 66.9315694, "composition": 0.0},
  68: {"mass": 67.9318688, "composition": 0.0},
  69: {"mass": 68.9356103, "composition": 0.0},
  70: {"mass": 69.9364313, "composition": 0.0},
  71: {"mass": 70.940519, "composition": 0.0},
  72: {"mass": 71.9417859, "composition": 0.0},
  73: {"mass": 72.9462067, "composition": 0.0},
  74: {"mass": 73.94798, "composition": 0.0},
  75: {"mass": 74.9525, "composition": 0.0},
  76: {"mass": 75.95533, "composition": 0.0},
  77: {"mass": 76.96055, "composition": 0.0},
  78: {"mass": 77.96336, "composition": 0.0},
  79: {"mass": 78.97025, "composition": 0.0}},
 29: {52: {"mass": 51.99671, "composition": 0.0},
  53: {"mass": 52.98459, "composition": 0.0},
  54: {"mass": 53.97666, "composition": 0.0},
  55: {"mass": 54.96604, "composition": 0.0},
  56: {"mass": 55.95895, "composition": 0.0},
  57: {"mass": 56.9492125, "composition": 0.0},
  58: {"mass": 57.94453305, "composition": 0.0},
  59: {"mass": 58.93949748, "composition": 0.0},
  60: {"mass": 59.9373645, "composition": 0.0},
  61: {"mass": 60.9334576, "composition": 0.0},
  62: {"mass": 61.93259541, "composition": 0.0},
  63: {"mass": 62.92959772, "composition": 0.6915},
  64: {"mass": 63.92976434, "composition": 0.0},
  65: {"mass": 64.9277897, "composition": 0.3085},
  66: {"mass": 65.92886903, "composition": 0.0},
  67: {"mass": 66.9277303, "composition": 0.0},
  68: {"mass": 67.9296109, "composition": 0.0},
  69: {"mass": 68.9294293, "composition": 0.0},
  70: {"mass": 69.9323921, "composition": 0.0},
  71: {"mass": 70.9326768, "composition": 0.0},
  72: {"mass": 71.9358203, "composition": 0.0},
  73: {"mass": 72.9366744, "composition": 0.0},
  74: {"mass": 73.9398749, "composition": 0.0},
  75: {"mass": 74.9415226, "composition": 0.0},
  76: {"mass": 75.945275, "composition": 0.0},
  77: {"mass": 76.94792, "composition": 0.0},
  78: {"mass": 77.95223, "composition": 0.0},
  79: {"mass": 78.95502, "composition": 0.0},
  80: {"mass": 79.96089, "composition": 0.0},
  81: {"mass": 80.96587, "composition": 0.0},
  82: {"mass": 81.97244, "composition": 0.0}},
 30: {54: {"mass": 53.99204, "composition": 0.0},
  55: {"mass": 54.98398, "composition": 0.0},
  56: {"mass": 55.97254, "composition": 0.0},
  57: {"mass": 56.96506, "composition": 0.0},
  58: {"mass": 57.954591, "composition": 0.0},
  59: {"mass": 58.94931266, "composition": 0.0},
  60: {"mass": 59.9418421, "composition": 0.0},
  61: {"mass": 60.939507, "composition": 0.0},
  62: {"mass": 61.93433397, "composition": 0.0},
  63: {"mass": 62.9332115, "composition": 0.0},
  64: {"mass": 63.92914201, "composition": 0.4917},
  65: {"mass": 64.92924077, "composition": 0.0},
  66: {"mass": 65.92603381, "composition": 0.2773},
  67: {"mass": 66.92712775, "composition": 0.0404},
  68: {"mass": 67.92484455, "composition": 0.1845},
  69: {"mass": 68.9265507, "composition": 0.0},
  70: {"mass": 69.9253192, "composition": 0.0061},
  71: {"mass": 70.9277196, "composition": 0.0},
  72: {"mass": 71.9268428, "composition": 0.0},
  73: {"mass": 72.9295826, "composition": 0.0},
  74: {"mass": 73.9294073, "composition": 0.0},
  75: {"mass": 74.9328402, "composition": 0.0},
  76: {"mass": 75.933115, "composition": 0.0},
  77: {"mass": 76.9368872, "composition": 0.0},
  78: {"mass": 77.9382892, "composition": 0.0},
  79: {"mass": 78.9426381, "composition": 0.0},
  80: {"mass": 79.9445529, "composition": 0.0},
  81: {"mass": 80.9504026, "composition": 0.0},
  82: {"mass": 81.95426, "composition": 0.0},
  83: {"mass": 82.96056, "composition": 0.0},
  84: {"mass": 83.96521, "composition": 0.0},
  85: {"mass": 84.97226, "composition": 0.0}},
 31: {56: {"mass": 55.99536, "composition": 0.0},
  57: {"mass": 56.9832, "composition": 0.0},
  58: {"mass": 57.97478, "composition": 0.0},
  59: {"mass": 58.96353, "composition": 0.0},
  60: {"mass": 59.95729, "composition": 0.0},
  61: {"mass": 60.949399, "composition": 0.0},
  62: {"mass": 61.94419025, "composition": 0.0},
  63: {"mass": 62.9392942, "composition": 0.0},
  64: {"mass": 63.9368404, "composition": 0.0},
  65: {"mass": 64.93273459, "composition": 0.0},
  66: {"mass": 65.9315894, "composition": 0.0},
  67: {"mass": 66.9282025, "composition": 0.0},
  68: {"mass": 67.9279805, "composition": 0.0},
  69: {"mass": 68.9255735, "composition": 0.60108},
  70: {"mass": 69.9260219, "composition": 0.0},
  71: {"mass": 70.92470258, "composition": 0.39892},
  72: {"mass": 71.92636747, "composition": 0.0},
  73: {"mass": 72.9251747, "composition": 0.0},
  74: {"mass": 73.9269457, "composition": 0.0},
  75: {"mass": 74.9265002, "composition": 0.0},
  76: {"mass": 75.9288276, "composition": 0.0},
  77: {"mass": 76.9291543, "composition": 0.0},
  78: {"mass": 77.9316088, "composition": 0.0},
  79: {"mass": 78.9328523, "composition": 0.0},
  80: {"mass": 79.9364208, "composition": 0.0},
  81: {"mass": 80.9381338, "composition": 0.0},
  82: {"mass": 81.9431765, "composition": 0.0},
  83: {"mass": 82.9471203, "composition": 0.0},
  84: {"mass": 83.95246, "composition": 0.0},
  85: {"mass": 84.95699, "composition": 0.0},
  86: {"mass": 85.96301, "composition": 0.0},
  87: {"mass": 86.96824, "composition": 0.0}},
 32: {58: {"mass": 57.99172, "composition": 0.0},
  59: {"mass": 58.98249, "composition": 0.0},
  60: {"mass": 59.97036, "composition": 0.0},
  61: {"mass": 60.96379, "composition": 0.0},
  62: {"mass": 61.95502, "composition": 0.0},
  63: {"mass": 62.949628, "composition": 0.0},
  64: {"mass": 63.9416899, "composition": 0.0},
  65: {"mass": 64.9393681, "composition": 0.0},
  66: {"mass": 65.9338621, "composition": 0.0},
  67: {"mass": 66.9327339, "composition": 0.0},
  68: {"mass": 67.9280953, "composition": 0.0},
  69: {"mass": 68.9279645, "composition": 0.0},
  70: {"mass": 69.92424875, "composition": 0.2057},
  71: {"mass": 70.92495233, "composition": 0.0},
  72: {"mass": 71.922075826, "composition": 0.2745},
  73: {"mass": 72.923458956, "composition": 0.0775},
  74: {"mass": 73.921177761, "composition": 0.365},
  75: {"mass": 74.92285837, "composition": 0.0},
  76: {"mass": 75.921402726, "composition": 0.0773},
  77: {"mass": 76.923549843, "composition": 0.0},
  78: {"mass": 77.9228529, "composition": 0.0},
  79: {"mass": 78.92536, "composition": 0.0},
  80: {"mass": 79.9253508, "composition": 0.0},
  81: {"mass": 80.9288329, "composition": 0.0},
  82: {"mass": 81.929774, "composition": 0.0},
  83: {"mass": 82.9345391, "composition": 0.0},
  84: {"mass": 83.9375751, "composition": 0.0},
  85: {"mass": 84.9429697, "composition": 0.0},
  86: {"mass": 85.94658, "composition": 0.0},
  87: {"mass": 86.95268, "composition": 0.0},
  88: {"mass": 87.95691, "composition": 0.0},
  89: {"mass": 88.96379, "composition": 0.0},
  90: {"mass": 89.96863, "composition": 0.0}},
 33: {60: {"mass": 59.99388, "composition": 0.0},
  61: {"mass": 60.98112, "composition": 0.0},
  62: {"mass": 61.97361, "composition": 0.0},
  63: {"mass": 62.9639, "composition": 0.0},
  64: {"mass": 63.95743, "composition": 0.0},
  65: {"mass": 64.949611, "composition": 0.0},
  66: {"mass": 65.9441488, "composition": 0.0},
  67: {"mass": 66.93925111, "composition": 0.0},
  68: {"mass": 67.9367741, "composition": 0.0},
  69: {"mass": 68.932246, "composition": 0.0},
  70: {"mass": 69.930926, "composition": 0.0},
  71: {"mass": 70.9271138, "composition": 0.0},
  72: {"mass": 71.9267523, "composition": 0.0},
  73: {"mass": 72.9238291, "composition": 0.0},
  74: {"mass": 73.9239286, "composition": 0.0},
  75: {"mass": 74.92159457, "composition": 1.0},
  76: {"mass": 75.92239202, "composition": 0.0},
  77: {"mass": 76.9206476, "composition": 0.0},
  78: {"mass": 77.921828, "composition": 0.0},
  79: {"mass": 78.9209484, "composition": 0.0},
  80: {"mass": 79.9224746, "composition": 0.0},
  81: {"mass": 80.9221323, "composition": 0.0},
  82: {"mass": 81.9247412, "composition": 0.0},
  83: {"mass": 82.9252069, "composition": 0.0},
  84: {"mass": 83.9293033, "composition": 0.0},
  85: {"mass": 84.9321637, "composition": 0.0},
  86: {"mass": 85.9367015, "composition": 0.0},
  87: {"mass": 86.9402917, "composition": 0.0},
  88: {"mass": 87.94555, "composition": 0.0},
  89: {"mass": 88.94976, "composition": 0.0},
  90: {"mass": 89.95563, "composition": 0.0},
  91: {"mass": 90.96039, "composition": 0.0},
  92: {"mass": 91.96674, "composition": 0.0}},
 34: {64: {"mass": 63.97109, "composition": 0.0},
  65: {"mass": 64.9644, "composition": 0.0},
  66: {"mass": 65.95559, "composition": 0.0},
  67: {"mass": 66.949994, "composition": 0.0},
  68: {"mass": 67.94182524, "composition": 0.0},
  69: {"mass": 68.9394148, "composition": 0.0},
  70: {"mass": 69.9335155, "composition": 0.0},
  71: {"mass": 70.9322094, "composition": 0.0},
  72: {"mass": 71.9271405, "composition": 0.0},
  73: {"mass": 72.9267549, "composition": 0.0},
  74: {"mass": 73.922475934, "composition": 0.0089},
  75: {"mass": 74.92252287, "composition": 0.0},
  76: {"mass": 75.919213704, "composition": 0.0937},
  77: {"mass": 76.919914154, "composition": 0.0763},
  78: {"mass": 77.91730928, "composition": 0.2377},
  79: {"mass": 78.91849929, "composition": 0.0},
  80: {"mass": 79.9165218, "composition": 0.4961},
  81: {"mass": 80.917993, "composition": 0.0},
  82: {"mass": 81.9166995, "composition": 0.0873},
  83: {"mass": 82.9191186, "composition": 0.0},
  84: {"mass": 83.9184668, "composition": 0.0},
  85: {"mass": 84.9222608, "composition": 0.0},
  86: {"mass": 85.9243117, "composition": 0.0},
  87: {"mass": 86.9286886, "composition": 0.0},
  88: {"mass": 87.9314175, "composition": 0.0},
  89: {"mass": 88.9366691, "composition": 0.0},
  90: {"mass": 89.9401, "composition": 0.0},
  91: {"mass": 90.94596, "composition": 0.0},
  92: {"mass": 91.94984, "composition": 0.0},
  93: {"mass": 92.95629, "composition": 0.0},
  94: {"mass": 93.96049, "composition": 0.0},
  95: {"mass": 94.9673, "composition": 0.0}},
 35: {67: {"mass": 66.96465, "composition": 0.0},
  68: {"mass": 67.95873, "composition": 0.0},
  69: {"mass": 68.950497, "composition": 0.0},
  70: {"mass": 69.944792, "composition": 0.0},
  71: {"mass": 70.9393422, "composition": 0.0},
  72: {"mass": 71.9365886, "composition": 0.0},
  73: {"mass": 72.9316715, "composition": 0.0},
  74: {"mass": 73.9299102, "composition": 0.0},
  75: {"mass": 74.9258105, "composition": 0.0},
  76: {"mass": 75.924542, "composition": 0.0},
  77: {"mass": 76.9213792, "composition": 0.0},
  78: {"mass": 77.9211459, "composition": 0.0},
  79: {"mass": 78.9183376, "composition": 0.5069},
  80: {"mass": 79.9185298, "composition": 0.0},
  81: {"mass": 80.9162897, "composition": 0.4931},
  82: {"mass": 81.9168032, "composition": 0.0},
  83: {"mass": 82.9151756, "composition": 0.0},
  84: {"mass": 83.916496, "composition": 0.0},
  85: {"mass": 84.9156458, "composition": 0.0},
  86: {"mass": 85.9188054, "composition": 0.0},
  87: {"mass": 86.920674, "composition": 0.0},
  88: {"mass": 87.9240833, "composition": 0.0},
  89: {"mass": 88.9267046, "composition": 0.0},
  90: {"mass": 89.9312928, "composition": 0.0},
  91: {"mass": 90.9343986, "composition": 0.0},
  92: {"mass": 91.9396316, "composition": 0.0},
  93: {"mass": 92.94313, "composition": 0.0},
  94: {"mass": 93.9489, "composition": 0.0},
  95: {"mass": 94.95301, "composition": 0.0},
  96: {"mass": 95.95903, "composition": 0.0},
  97: {"mass": 96.96344, "composition": 0.0},
  98: {"mass": 97.96946, "composition": 0.0}},
 36: {69: {"mass": 68.96518, "composition": 0.0},
  70: {"mass": 69.95604, "composition": 0.0},
  71: {"mass": 70.95027, "composition": 0.0},
  72: {"mass": 71.9420924, "composition": 0.0},
  73: {"mass": 72.9392892, "composition": 0.0},
  74: {"mass": 73.933084, "composition": 0.0},
  75: {"mass": 74.9309457, "composition": 0.0},
  76: {"mass": 75.9259103, "composition": 0.0},
  77: {"mass": 76.92467, "composition": 0.0},
  78: {"mass": 77.92036494, "composition": 0.00355},
  79: {"mass": 78.9200829, "composition": 0.0},
  80: {"mass": 79.91637808, "composition": 0.02286},
  81: {"mass": 80.9165912, "composition": 0.0},
  82: {"mass": 81.91348273, "composition": 0.11593},
  83: {"mass": 82.91412716, "composition": 0.115},
  84: {"mass": 83.9114977282, "composition": 0.56987},
  85: {"mass": 84.9125273, "composition": 0.0},
  86: {"mass": 85.9106106269, "composition": 0.17279},
  87: {"mass": 86.91335476, "composition": 0.0},
  88: {"mass": 87.9144479, "composition": 0.0},
  89: {"mass": 88.9178355, "composition": 0.0},
  90: {"mass": 89.9195279, "composition": 0.0},
  91: {"mass": 90.9238063, "composition": 0.0},
  92: {"mass": 91.9261731, "composition": 0.0},
  93: {"mass": 92.9311472, "composition": 0.0},
  94: {"mass": 93.93414, "composition": 0.0},
  95: {"mass": 94.939711, "composition": 0.0},
  96: {"mass": 95.943017, "composition": 0.0},
  97: {"mass": 96.94909, "composition": 0.0},
  98: {"mass": 97.95243, "composition": 0.0},
  99: {"mass": 98.95839, "composition": 0.0},
  100: {"mass": 99.96237, "composition": 0.0},
  101: {"mass": 100.96873, "composition": 0.0}},
 37: {71: {"mass": 70.96532, "composition": 0.0},
  72: {"mass": 71.95908, "composition": 0.0},
  73: {"mass": 72.95053, "composition": 0.0},
  74: {"mass": 73.9442659, "composition": 0.0},
  75: {"mass": 74.9385732, "composition": 0.0},
  76: {"mass": 75.935073, "composition": 0.0},
  77: {"mass": 76.9304016, "composition": 0.0},
  78: {"mass": 77.9281419, "composition": 0.0},
  79: {"mass": 78.9239899, "composition": 0.0},
  80: {"mass": 79.9225164, "composition": 0.0},
  81: {"mass": 80.9189939, "composition": 0.0},
  82: {"mass": 81.918209, "composition": 0.0},
  83: {"mass": 82.9151142, "composition": 0.0},
  84: {"mass": 83.9143752, "composition": 0.0},
  85: {"mass": 84.9117897379, "composition": 0.7217},
  86: {"mass": 85.91116743, "composition": 0.0},
  87: {"mass": 86.909180531, "composition": 0.2783},
  88: {"mass": 87.91131559, "composition": 0.0},
  89: {"mass": 88.9122783, "composition": 0.0},
  90: {"mass": 89.9147985, "composition": 0.0},
  91: {"mass": 90.9165372, "composition": 0.0},
  92: {"mass": 91.9197284, "composition": 0.0},
  93: {"mass": 92.9220393, "composition": 0.0},
  94: {"mass": 93.9263948, "composition": 0.0},
  95: {"mass": 94.92926, "composition": 0.0},
  96: {"mass": 95.9341334, "composition": 0.0},
  97: {"mass": 96.9371771, "composition": 0.0},
  98: {"mass": 97.9416869, "composition": 0.0},
  99: {"mass": 98.94503, "composition": 0.0},
  100: {"mass": 99.95003, "composition": 0.0},
  101: {"mass": 100.95404, "composition": 0.0},
  102: {"mass": 101.95952, "composition": 0.0},
  103: {"mass": 102.96392, "composition": 0.0}},
 38: {73: {"mass": 72.9657, "composition": 0.0},
  74: {"mass": 73.95617, "composition": 0.0},
  75: {"mass": 74.94995, "composition": 0.0},
  76: {"mass": 75.941763, "composition": 0.0},
  77: {"mass": 76.9379455, "composition": 0.0},
  78: {"mass": 77.93218, "composition": 0.0},
  79: {"mass": 78.9297077, "composition": 0.0},
  80: {"mass": 79.9245175, "composition": 0.0},
  81: {"mass": 80.9232114, "composition": 0.0},
  82: {"mass": 81.9183999, "composition": 0.0},
  83: {"mass": 82.9175544, "composition": 0.0},
  84: {"mass": 83.9134191, "composition": 0.0056},
  85: {"mass": 84.912932, "composition": 0.0},
  86: {"mass": 85.9092606, "composition": 0.0986},
  87: {"mass": 86.9088775, "composition": 0.07},
  88: {"mass": 87.9056125, "composition": 0.8258},
  89: {"mass": 88.9074511, "composition": 0.0},
  90: {"mass": 89.90773, "composition": 0.0},
  91: {"mass": 90.9101954, "composition": 0.0},
  92: {"mass": 91.9110382, "composition": 0.0},
  93: {"mass": 92.9140242, "composition": 0.0},
  94: {"mass": 93.9153556, "composition": 0.0},
  95: {"mass": 94.9193529, "composition": 0.0},
  96: {"mass": 95.9217066, "composition": 0.0},
  97: {"mass": 96.926374, "composition": 0.0},
  98: {"mass": 97.9286888, "composition": 0.0},
  99: {"mass": 98.9328907, "composition": 0.0},
  100: {"mass": 99.93577, "composition": 0.0},
  101: {"mass": 100.940352, "composition": 0.0},
  102: {"mass": 101.943791, "composition": 0.0},
  103: {"mass": 102.94909, "composition": 0.0},
  104: {"mass": 103.95265, "composition": 0.0},
  105: {"mass": 104.95855, "composition": 0.0},
  106: {"mass": 105.96265, "composition": 0.0},
  107: {"mass": 106.96897, "composition": 0.0}},
 39: {76: {"mass": 75.95856, "composition": 0.0},
  77: {"mass": 76.949781, "composition": 0.0},
  78: {"mass": 77.94361, "composition": 0.0},
  79: {"mass": 78.93735, "composition": 0.0},
  80: {"mass": 79.9343561, "composition": 0.0},
  81: {"mass": 80.9294556, "composition": 0.0},
  82: {"mass": 81.9269314, "composition": 0.0},
  83: {"mass": 82.922485, "composition": 0.0},
  84: {"mass": 83.9206721, "composition": 0.0},
  85: {"mass": 84.916433, "composition": 0.0},
  86: {"mass": 85.914886, "composition": 0.0},
  87: {"mass": 86.9108761, "composition": 0.0},
  88: {"mass": 87.9095016, "composition": 0.0},
  89: {"mass": 88.9058403, "composition": 1.0},
  90: {"mass": 89.9071439, "composition": 0.0},
  91: {"mass": 90.9072974, "composition": 0.0},
  92: {"mass": 91.9089451, "composition": 0.0},
  93: {"mass": 92.909578, "composition": 0.0},
  94: {"mass": 93.9115906, "composition": 0.0},
  95: {"mass": 94.9128161, "composition": 0.0},
  96: {"mass": 95.9158968, "composition": 0.0},
  97: {"mass": 96.9182741, "composition": 0.0},
  98: {"mass": 97.9223821, "composition": 0.0},
  99: {"mass": 98.924148, "composition": 0.0},
  100: {"mass": 99.927715, "composition": 0.0},
  101: {"mass": 100.9301477, "composition": 0.0},
  102: {"mass": 101.9343277, "composition": 0.0},
  103: {"mass": 102.937243, "composition": 0.0},
  104: {"mass": 103.94196, "composition": 0.0},
  105: {"mass": 104.94544, "composition": 0.0},
  106: {"mass": 105.95056, "composition": 0.0},
  107: {"mass": 106.95452, "composition": 0.0},
  108: {"mass": 107.95996, "composition": 0.0},
  109: {"mass": 108.96436, "composition": 0.0}},
 40: {78: {"mass": 77.95566, "composition": 0.0},
  79: {"mass": 78.94948, "composition": 0.0},
  80: {"mass": 79.9404, "composition": 0.0},
  81: {"mass": 80.93731, "composition": 0.0},
  82: {"mass": 81.93135, "composition": 0.0},
  83: {"mass": 82.9292421, "composition": 0.0},
  84: {"mass": 83.9233269, "composition": 0.0},
  85: {"mass": 84.9214444, "composition": 0.0},
  86: {"mass": 85.9162972, "composition": 0.0},
  87: {"mass": 86.914818, "composition": 0.0},
  88: {"mass": 87.9102213, "composition": 0.0},
  89: {"mass": 88.9088814, "composition": 0.0},
  90: {"mass": 89.9046977, "composition": 0.5145},
  91: {"mass": 90.9056396, "composition": 0.1122},
  92: {"mass": 91.9050347, "composition": 0.1715},
  93: {"mass": 92.9064699, "composition": 0.0},
  94: {"mass": 93.9063108, "composition": 0.1738},
  95: {"mass": 94.9080385, "composition": 0.0},
  96: {"mass": 95.9082714, "composition": 0.028},
  97: {"mass": 96.9109512, "composition": 0.0},
  98: {"mass": 97.9127289, "composition": 0.0},
  99: {"mass": 98.916667, "composition": 0.0},
  100: {"mass": 99.9180006, "composition": 0.0},
  101: {"mass": 100.921448, "composition": 0.0},
  102: {"mass": 101.9231409, "composition": 0.0},
  103: {"mass": 102.927191, "composition": 0.0},
  104: {"mass": 103.929436, "composition": 0.0},
  105: {"mass": 104.934008, "composition": 0.0},
  106: {"mass": 105.93676, "composition": 0.0},
  107: {"mass": 106.94174, "composition": 0.0},
  108: {"mass": 107.94487, "composition": 0.0},
  109: {"mass": 108.95041, "composition": 0.0},
  110: {"mass": 109.95396, "composition": 0.0},
  111: {"mass": 110.95968, "composition": 0.0},
  112: {"mass": 111.9637, "composition": 0.0}},
 41: {81: {"mass": 80.9496, "composition": 0.0},
  82: {"mass": 81.94396, "composition": 0.0},
  83: {"mass": 82.93729, "composition": 0.0},
  84: {"mass": 83.93449, "composition": 0.0},
  85: {"mass": 84.9288458, "composition": 0.0},
  86: {"mass": 85.9257828, "composition": 0.0},
  87: {"mass": 86.9206937, "composition": 0.0},
  88: {"mass": 87.918222, "composition": 0.0},
  89: {"mass": 88.913445, "composition": 0.0},
  90: {"mass": 89.9112584, "composition": 0.0},
  91: {"mass": 90.9069897, "composition": 0.0},
  92: {"mass": 91.9071881, "composition": 0.0},
  93: {"mass": 92.906373, "composition": 1.0},
  94: {"mass": 93.9072788, "composition": 0.0},
  95: {"mass": 94.9068324, "composition": 0.0},
  96: {"mass": 95.9080973, "composition": 0.0},
  97: {"mass": 96.9080959, "composition": 0.0},
  98: {"mass": 97.9103265, "composition": 0.0},
  99: {"mass": 98.911613, "composition": 0.0},
  100: {"mass": 99.9143276, "composition": 0.0},
  101: {"mass": 100.9153103, "composition": 0.0},
  102: {"mass": 101.9180772, "composition": 0.0},
  103: {"mass": 102.9194572, "composition": 0.0},
  104: {"mass": 103.9228925, "composition": 0.0},
  105: {"mass": 104.9249465, "composition": 0.0},
  106: {"mass": 105.9289317, "composition": 0.0},
  107: {"mass": 106.9315937, "composition": 0.0},
  108: {"mass": 107.9360748, "composition": 0.0},
  109: {"mass": 108.93922, "composition": 0.0},
  110: {"mass": 109.94403, "composition": 0.0},
  111: {"mass": 110.94753, "composition": 0.0},
  112: {"mass": 111.95247, "composition": 0.0},
  113: {"mass": 112.95651, "composition": 0.0},
  114: {"mass": 113.96201, "composition": 0.0},
  115: {"mass": 114.96634, "composition": 0.0}},
 42: {83: {"mass": 82.94988, "composition": 0.0},
  84: {"mass": 83.94149, "composition": 0.0},
  85: {"mass": 84.938261, "composition": 0.0},
  86: {"mass": 85.9311748, "composition": 0.0},
  87: {"mass": 86.9281962, "composition": 0.0},
  88: {"mass": 87.9219678, "composition": 0.0},
  89: {"mass": 88.9194682, "composition": 0.0},
  90: {"mass": 89.9139309, "composition": 0.0},
  91: {"mass": 90.9117453, "composition": 0.0},
  92: {"mass": 91.90680796, "composition": 0.1453},
  93: {"mass": 92.90680958, "composition": 0.0},
  94: {"mass": 93.9050849, "composition": 0.0915},
  95: {"mass": 94.90583877, "composition": 0.1584},
  96: {"mass": 95.90467612, "composition": 0.1667},
  97: {"mass": 96.90601812, "composition": 0.096},
  98: {"mass": 97.90540482, "composition": 0.2439},
  99: {"mass": 98.90770851, "composition": 0.0},
  100: {"mass": 99.9074718, "composition": 0.0982},
  101: {"mass": 100.9103414, "composition": 0.0},
  102: {"mass": 101.9102834, "composition": 0.0},
  103: {"mass": 102.913079, "composition": 0.0},
  104: {"mass": 103.9137344, "composition": 0.0},
  105: {"mass": 104.916969, "composition": 0.0},
  106: {"mass": 105.918259, "composition": 0.0},
  107: {"mass": 106.922106, "composition": 0.0},
  108: {"mass": 107.924033, "composition": 0.0},
  109: {"mass": 108.928424, "composition": 0.0},
  110: {"mass": 109.930704, "composition": 0.0},
  111: {"mass": 110.935654, "composition": 0.0},
  112: {"mass": 111.93831, "composition": 0.0},
  113: {"mass": 112.94335, "composition": 0.0},
  114: {"mass": 113.94653, "composition": 0.0},
  115: {"mass": 114.95196, "composition": 0.0},
  116: {"mass": 115.95545, "composition": 0.0},
  117: {"mass": 116.96117, "composition": 0.0}},
 43: {85: {"mass": 84.95058, "composition": 0.0},
  86: {"mass": 85.94493, "composition": 0.0},
  87: {"mass": 86.9380672, "composition": 0.0},
  88: {"mass": 87.93378, "composition": 0.0},
  89: {"mass": 88.9276487, "composition": 0.0},
  90: {"mass": 89.9240739, "composition": 0.0},
  91: {"mass": 90.9184254, "composition": 0.0},
  92: {"mass": 91.9152698, "composition": 0.0},
  93: {"mass": 92.910246, "composition": 0.0},
  94: {"mass": 93.9096536, "composition": 0.0},
  95: {"mass": 94.9076536, "composition": 0.0},
  96: {"mass": 95.907868, "composition": 0.0},
  97: {"mass": 96.9063667, "composition": 0.0},
  98: {"mass": 97.9072124, "composition": 0.0},
  99: {"mass": 98.9062508, "composition": 0.0},
  100: {"mass": 99.9076539, "composition": 0.0},
  101: {"mass": 100.907309, "composition": 0.0},
  102: {"mass": 101.9092097, "composition": 0.0},
  103: {"mass": 102.909176, "composition": 0.0},
  104: {"mass": 103.911425, "composition": 0.0},
  105: {"mass": 104.911655, "composition": 0.0},
  106: {"mass": 105.914358, "composition": 0.0},
  107: {"mass": 106.9154606, "composition": 0.0},
  108: {"mass": 107.9184957, "composition": 0.0},
  109: {"mass": 108.920256, "composition": 0.0},
  110: {"mass": 109.923744, "composition": 0.0},
  111: {"mass": 110.925901, "composition": 0.0},
  112: {"mass": 111.9299458, "composition": 0.0},
  113: {"mass": 112.932569, "composition": 0.0},
  114: {"mass": 113.93691, "composition": 0.0},
  115: {"mass": 114.93998, "composition": 0.0},
  116: {"mass": 115.94476, "composition": 0.0},
  117: {"mass": 116.94806, "composition": 0.0},
  118: {"mass": 117.95299, "composition": 0.0},
  119: {"mass": 118.95666, "composition": 0.0},
  120: {"mass": 119.96187, "composition": 0.0}},
 44: {87: {"mass": 86.95069, "composition": 0.0},
  88: {"mass": 87.9416, "composition": 0.0},
  89: {"mass": 88.93762, "composition": 0.0},
  90: {"mass": 89.9303444, "composition": 0.0},
  91: {"mass": 90.9267419, "composition": 0.0},
  92: {"mass": 91.9202344, "composition": 0.0},
  93: {"mass": 92.9171044, "composition": 0.0},
  94: {"mass": 93.9113429, "composition": 0.0},
  95: {"mass": 94.910406, "composition": 0.0},
  96: {"mass": 95.90759025, "composition": 0.0554},
  97: {"mass": 96.9075471, "composition": 0.0},
  98: {"mass": 97.9052868, "composition": 0.0187},
  99: {"mass": 98.9059341, "composition": 0.1276},
  100: {"mass": 99.9042143, "composition": 0.126},
  101: {"mass": 100.9055769, "composition": 0.1706},
  102: {"mass": 101.9043441, "composition": 0.3155},
  103: {"mass": 102.9063186, "composition": 0.0},
  104: {"mass": 103.9054275, "composition": 0.1862},
  105: {"mass": 104.9077476, "composition": 0.0},
  106: {"mass": 105.9073291, "composition": 0.0},
  107: {"mass": 106.909972, "composition": 0.0},
  108: {"mass": 107.910188, "composition": 0.0},
  109: {"mass": 108.913326, "composition": 0.0},
  110: {"mass": 109.9140407, "composition": 0.0},
  111: {"mass": 110.91757, "composition": 0.0},
  112: {"mass": 111.918809, "composition": 0.0},
  113: {"mass": 112.922844, "composition": 0.0},
  114: {"mass": 113.9246136, "composition": 0.0},
  115: {"mass": 114.92882, "composition": 0.0},
  116: {"mass": 115.9312192, "composition": 0.0},
  117: {"mass": 116.9361, "composition": 0.0},
  118: {"mass": 117.93853, "composition": 0.0},
  119: {"mass": 118.94357, "composition": 0.0},
  120: {"mass": 119.94631, "composition": 0.0},
  121: {"mass": 120.95164, "composition": 0.0},
  122: {"mass": 121.95447, "composition": 0.0},
  123: {"mass": 122.95989, "composition": 0.0},
  124: {"mass": 123.96305, "composition": 0.0}},
 45: {89: {"mass": 88.95058, "composition": 0.0},
  90: {"mass": 89.94422, "composition": 0.0},
  91: {"mass": 90.93688, "composition": 0.0},
  92: {"mass": 91.9323677, "composition": 0.0},
  93: {"mass": 92.9259128, "composition": 0.0},
  94: {"mass": 93.9217305, "composition": 0.0},
  95: {"mass": 94.9158979, "composition": 0.0},
  96: {"mass": 95.914453, "composition": 0.0},
  97: {"mass": 96.911329, "composition": 0.0},
  98: {"mass": 97.910708, "composition": 0.0},
  99: {"mass": 98.9081282, "composition": 0.0},
  100: {"mass": 99.908117, "composition": 0.0},
  101: {"mass": 100.9061606, "composition": 0.0},
  102: {"mass": 101.9068374, "composition": 0.0},
  103: {"mass": 102.905498, "composition": 1.0},
  104: {"mass": 103.9066492, "composition": 0.0},
  105: {"mass": 104.9056885, "composition": 0.0},
  106: {"mass": 105.9072868, "composition": 0.0},
  107: {"mass": 106.906748, "composition": 0.0},
  108: {"mass": 107.908714, "composition": 0.0},
  109: {"mass": 108.9087488, "composition": 0.0},
  110: {"mass": 109.911079, "composition": 0.0},
  111: {"mass": 110.9116423, "composition": 0.0},
  112: {"mass": 111.914403, "composition": 0.0},
  113: {"mass": 112.9154393, "composition": 0.0},
  114: {"mass": 113.918718, "composition": 0.0},
  115: {"mass": 114.9203116, "composition": 0.0},
  116: {"mass": 115.924059, "composition": 0.0},
  117: {"mass": 116.9260354, "composition": 0.0},
  118: {"mass": 117.93034, "composition": 0.0},
  119: {"mass": 118.932557, "composition": 0.0},
  120: {"mass": 119.93686, "composition": 0.0},
  121: {"mass": 120.93942, "composition": 0.0},
  122: {"mass": 121.94399, "composition": 0.0},
  123: {"mass": 122.94685, "composition": 0.0},
  124: {"mass": 123.95151, "composition": 0.0},
  125: {"mass": 124.95469, "composition": 0.0},
  126: {"mass": 125.95946, "composition": 0.0}},
 46: {91: {"mass": 90.95032, "composition": 0.0},
  92: {"mass": 91.94088, "composition": 0.0},
  93: {"mass": 92.93651, "composition": 0.0},
  94: {"mass": 93.9290376, "composition": 0.0},
  95: {"mass": 94.9248898, "composition": 0.0},
  96: {"mass": 95.9182151, "composition": 0.0},
  97: {"mass": 96.916472, "composition": 0.0},
  98: {"mass": 97.9126983, "composition": 0.0},
  99: {"mass": 98.9117748, "composition": 0.0},
  100: {"mass": 99.908505, "composition": 0.0},
  101: {"mass": 100.9082864, "composition": 0.0},
  102: {"mass": 101.9056022, "composition": 0.0102},
  103: {"mass": 102.9060809, "composition": 0.0},
  104: {"mass": 103.9040305, "composition": 0.1114},
  105: {"mass": 104.9050796, "composition": 0.2233},
  106: {"mass": 105.9034804, "composition": 0.2733},
  107: {"mass": 106.9051282, "composition": 0.0},
  108: {"mass": 107.9038916, "composition": 0.2646},
  109: {"mass": 108.9059504, "composition": 0.0},
  110: {"mass": 109.9051722, "composition": 0.1172},
  111: {"mass": 110.90768968, "composition": 0.0},
  112: {"mass": 111.9073297, "composition": 0.0},
  113: {"mass": 112.910261, "composition": 0.0},
  114: {"mass": 113.9103686, "composition": 0.0},
  115: {"mass": 114.913659, "composition": 0.0},
  116: {"mass": 115.914297, "composition": 0.0},
  117: {"mass": 116.9179547, "composition": 0.0},
  118: {"mass": 117.9190667, "composition": 0.0},
  119: {"mass": 118.9233402, "composition": 0.0},
  120: {"mass": 119.9245511, "composition": 0.0},
  121: {"mass": 120.9289503, "composition": 0.0},
  122: {"mass": 121.930632, "composition": 0.0},
  123: {"mass": 122.93514, "composition": 0.0},
  124: {"mass": 123.93714, "composition": 0.0},
  125: {"mass": 124.94179, "composition": 0.0},
  126: {"mass": 125.94416, "composition": 0.0},
  127: {"mass": 126.94907, "composition": 0.0},
  128: {"mass": 127.95183, "composition": 0.0}},
 47: {93: {"mass": 92.95033, "composition": 0.0},
  94: {"mass": 93.94373, "composition": 0.0},
  95: {"mass": 94.93602, "composition": 0.0},
  96: {"mass": 95.930744, "composition": 0.0},
  97: {"mass": 96.92397, "composition": 0.0},
  98: {"mass": 97.92156, "composition": 0.0},
  99: {"mass": 98.9176458, "composition": 0.0},
  100: {"mass": 99.9161154, "composition": 0.0},
  101: {"mass": 100.912684, "composition": 0.0},
  102: {"mass": 101.9117047, "composition": 0.0},
  103: {"mass": 102.9089631, "composition": 0.0},
  104: {"mass": 103.9086239, "composition": 0.0},
  105: {"mass": 104.9065256, "composition": 0.0},
  106: {"mass": 105.9066636, "composition": 0.0},
  107: {"mass": 106.9050916, "composition": 0.51839},
  108: {"mass": 107.9059503, "composition": 0.0},
  109: {"mass": 108.9047553, "composition": 0.48161},
  110: {"mass": 109.9061102, "composition": 0.0},
  111: {"mass": 110.9052959, "composition": 0.0},
  112: {"mass": 111.9070486, "composition": 0.0},
  113: {"mass": 112.906573, "composition": 0.0},
  114: {"mass": 113.908823, "composition": 0.0},
  115: {"mass": 114.908767, "composition": 0.0},
  116: {"mass": 115.9113868, "composition": 0.0},
  117: {"mass": 116.911774, "composition": 0.0},
  118: {"mass": 117.9145955, "composition": 0.0},
  119: {"mass": 118.91557, "composition": 0.0},
  120: {"mass": 119.9187848, "composition": 0.0},
  121: {"mass": 120.920125, "composition": 0.0},
  122: {"mass": 121.923664, "composition": 0.0},
  123: {"mass": 122.925337, "composition": 0.0},
  124: {"mass": 123.92893, "composition": 0.0},
  125: {"mass": 124.93105, "composition": 0.0},
  126: {"mass": 125.93475, "composition": 0.0},
  127: {"mass": 126.93711, "composition": 0.0},
  128: {"mass": 127.94106, "composition": 0.0},
  129: {"mass": 128.94395, "composition": 0.0},
  130: {"mass": 129.9507, "composition": 0.0}},
 48: {95: {"mass": 94.94994, "composition": 0.0},
  96: {"mass": 95.94034, "composition": 0.0},
  97: {"mass": 96.9351, "composition": 0.0},
  98: {"mass": 97.927389, "composition": 0.0},
  99: {"mass": 98.9249258, "composition": 0.0},
  100: {"mass": 99.9203488, "composition": 0.0},
  101: {"mass": 100.9185862, "composition": 0.0},
  102: {"mass": 101.914482, "composition": 0.0},
  103: {"mass": 102.9134165, "composition": 0.0},
  104: {"mass": 103.9098564, "composition": 0.0},
  105: {"mass": 104.9094639, "composition": 0.0},
  106: {"mass": 105.9064599, "composition": 0.0125},
  107: {"mass": 106.9066121, "composition": 0.0},
  108: {"mass": 107.9041834, "composition": 0.0089},
  109: {"mass": 108.9049867, "composition": 0.0},
  110: {"mass": 109.90300661, "composition": 0.1249},
  111: {"mass": 110.90418287, "composition": 0.128},
  112: {"mass": 111.90276287, "composition": 0.2413},
  113: {"mass": 112.90440813, "composition": 0.1222},
  114: {"mass": 113.90336509, "composition": 0.2873},
  115: {"mass": 114.90543751, "composition": 0.0},
  116: {"mass": 115.90476315, "composition": 0.0749},
  117: {"mass": 116.907226, "composition": 0.0},
  118: {"mass": 117.906922, "composition": 0.0},
  119: {"mass": 118.909847, "composition": 0.0},
  120: {"mass": 119.9098681, "composition": 0.0},
  121: {"mass": 120.9129637, "composition": 0.0},
  122: {"mass": 121.9134591, "composition": 0.0},
  123: {"mass": 122.9168925, "composition": 0.0},
  124: {"mass": 123.9176574, "composition": 0.0},
  125: {"mass": 124.9212576, "composition": 0.0},
  126: {"mass": 125.9224291, "composition": 0.0},
  127: {"mass": 126.926472, "composition": 0.0},
  128: {"mass": 127.9278129, "composition": 0.0},
  129: {"mass": 128.93182, "composition": 0.0},
  130: {"mass": 129.93394, "composition": 0.0},
  131: {"mass": 130.9406, "composition": 0.0},
  132: {"mass": 131.94604, "composition": 0.0},
  133: {"mass": 132.95285, "composition": 0.0}},
 49: {97: {"mass": 96.94934, "composition": 0.0},
  98: {"mass": 97.94214, "composition": 0.0},
  99: {"mass": 98.93411, "composition": 0.0},
  100: {"mass": 99.93096, "composition": 0.0},
  101: {"mass": 100.92634, "composition": 0.0},
  102: {"mass": 101.9241071, "composition": 0.0},
  103: {"mass": 102.9198819, "composition": 0.0},
  104: {"mass": 103.9182145, "composition": 0.0},
  105: {"mass": 104.914502, "composition": 0.0},
  106: {"mass": 105.913464, "composition": 0.0},
  107: {"mass": 106.91029, "composition": 0.0},
  108: {"mass": 107.9096935, "composition": 0.0},
  109: {"mass": 108.9071514, "composition": 0.0},
  110: {"mass": 109.90717, "composition": 0.0},
  111: {"mass": 110.9051085, "composition": 0.0},
  112: {"mass": 111.9055377, "composition": 0.0},
  113: {"mass": 112.90406184, "composition": 0.0429},
  114: {"mass": 113.90491791, "composition": 0.0},
  115: {"mass": 114.903878776, "composition": 0.9571},
  116: {"mass": 115.90525999, "composition": 0.0},
  117: {"mass": 116.9045157, "composition": 0.0},
  118: {"mass": 117.9063566, "composition": 0.0},
  119: {"mass": 118.9058507, "composition": 0.0},
  120: {"mass": 119.907967, "composition": 0.0},
  121: {"mass": 120.907851, "composition": 0.0},
  122: {"mass": 121.910281, "composition": 0.0},
  123: {"mass": 122.910434, "composition": 0.0},
  124: {"mass": 123.913182, "composition": 0.0},
  125: {"mass": 124.913605, "composition": 0.0},
  126: {"mass": 125.916507, "composition": 0.0},
  127: {"mass": 126.917446, "composition": 0.0},
  128: {"mass": 127.9204, "composition": 0.0},
  129: {"mass": 128.9218053, "composition": 0.0},
  130: {"mass": 129.924977, "composition": 0.0},
  131: {"mass": 130.9269715, "composition": 0.0},
  132: {"mass": 131.933001, "composition": 0.0},
  133: {"mass": 132.93831, "composition": 0.0},
  134: {"mass": 133.94454, "composition": 0.0},
  135: {"mass": 134.95005, "composition": 0.0}},
 50: {99: {"mass": 98.94853, "composition": 0.0},
  100: {"mass": 99.9385, "composition": 0.0},
  101: {"mass": 100.93526, "composition": 0.0},
  102: {"mass": 101.93029, "composition": 0.0},
  103: {"mass": 102.928105, "composition": 0.0},
  104: {"mass": 103.9231052, "composition": 0.0},
  105: {"mass": 104.9212684, "composition": 0.0},
  106: {"mass": 105.9169574, "composition": 0.0},
  107: {"mass": 106.9157137, "composition": 0.0},
  108: {"mass": 107.9118943, "composition": 0.0},
  109: {"mass": 108.9112921, "composition": 0.0},
  110: {"mass": 109.907845, "composition": 0.0},
  111: {"mass": 110.9077401, "composition": 0.0},
  112: {"mass": 111.90482387, "composition": 0.0097},
  113: {"mass": 112.9051757, "composition": 0.0},
  114: {"mass": 113.9027827, "composition": 0.0066},
  115: {"mass": 114.903344699, "composition": 0.0034},
  116: {"mass": 115.9017428, "composition": 0.1454},
  117: {"mass": 116.90295398, "composition": 0.0768},
  118: {"mass": 117.90160657, "composition": 0.2422},
  119: {"mass": 118.90331117, "composition": 0.0859},
  120: {"mass": 119.90220163, "composition": 0.3258},
  121: {"mass": 120.9042426, "composition": 0.0},
  122: {"mass": 121.9034438, "composition": 0.0463},
  123: {"mass": 122.9057252, "composition": 0.0},
  124: {"mass": 123.9052766, "composition": 0.0579},
  125: {"mass": 124.9077864, "composition": 0.0},
  126: {"mass": 125.907659, "composition": 0.0},
  127: {"mass": 126.91039, "composition": 0.0},
  128: {"mass": 127.910507, "composition": 0.0},
  129: {"mass": 128.913465, "composition": 0.0},
  130: {"mass": 129.9139738, "composition": 0.0},
  131: {"mass": 130.917045, "composition": 0.0},
  132: {"mass": 131.9178267, "composition": 0.0},
  133: {"mass": 132.9239134, "composition": 0.0},
  134: {"mass": 133.9286821, "composition": 0.0},
  135: {"mass": 134.9349086, "composition": 0.0},
  136: {"mass": 135.93999, "composition": 0.0},
  137: {"mass": 136.94655, "composition": 0.0},
  138: {"mass": 137.95184, "composition": 0.0}},
 51: {103: {"mass": 102.93969, "composition": 0.0},
  104: {"mass": 103.93648, "composition": 0.0},
  105: {"mass": 104.931276, "composition": 0.0},
  106: {"mass": 105.928638, "composition": 0.0},
  107: {"mass": 106.9241506, "composition": 0.0},
  108: {"mass": 107.9222267, "composition": 0.0},
  109: {"mass": 108.9181411, "composition": 0.0},
  110: {"mass": 109.9168543, "composition": 0.0},
  111: {"mass": 110.9132182, "composition": 0.0},
  112: {"mass": 111.9124, "composition": 0.0},
  113: {"mass": 112.909375, "composition": 0.0},
  114: {"mass": 113.90929, "composition": 0.0},
  115: {"mass": 114.906598, "composition": 0.0},
  116: {"mass": 115.9067931, "composition": 0.0},
  117: {"mass": 116.9048415, "composition": 0.0},
  118: {"mass": 117.9055321, "composition": 0.0},
  119: {"mass": 118.9039455, "composition": 0.0},
  120: {"mass": 119.9050794, "composition": 0.0},
  121: {"mass": 120.903812, "composition": 0.5721},
  122: {"mass": 121.9051699, "composition": 0.0},
  123: {"mass": 122.9042132, "composition": 0.4279},
  124: {"mass": 123.905935, "composition": 0.0},
  125: {"mass": 124.905253, "composition": 0.0},
  126: {"mass": 125.907253, "composition": 0.0},
  127: {"mass": 126.9069243, "composition": 0.0},
  128: {"mass": 127.909146, "composition": 0.0},
  129: {"mass": 128.909147, "composition": 0.0},
  130: {"mass": 129.911662, "composition": 0.0},
  131: {"mass": 130.9119888, "composition": 0.0},
  132: {"mass": 131.9145077, "composition": 0.0},
  133: {"mass": 132.9152732, "composition": 0.0},
  134: {"mass": 133.9205357, "composition": 0.0},
  135: {"mass": 134.9251851, "composition": 0.0},
  136: {"mass": 135.9307459, "composition": 0.0},
  137: {"mass": 136.93555, "composition": 0.0},
  138: {"mass": 137.94145, "composition": 0.0},
  139: {"mass": 138.94655, "composition": 0.0},
  140: {"mass": 139.95283, "composition": 0.0}},
 52: {105: {"mass": 104.9433, "composition": 0.0},
  106: {"mass": 105.9375, "composition": 0.0},
  107: {"mass": 106.935012, "composition": 0.0},
  108: {"mass": 107.9293805, "composition": 0.0},
  109: {"mass": 108.9273045, "composition": 0.0},
  110: {"mass": 109.9224581, "composition": 0.0},
  111: {"mass": 110.9210006, "composition": 0.0},
  112: {"mass": 111.9167279, "composition": 0.0},
  113: {"mass": 112.915891, "composition": 0.0},
  114: {"mass": 113.912089, "composition": 0.0},
  115: {"mass": 114.911902, "composition": 0.0},
  116: {"mass": 115.90846, "composition": 0.0},
  117: {"mass": 116.908646, "composition": 0.0},
  118: {"mass": 117.905854, "composition": 0.0},
  119: {"mass": 118.9064071, "composition": 0.0},
  120: {"mass": 119.9040593, "composition": 0.0009},
  121: {"mass": 120.904944, "composition": 0.0},
  122: {"mass": 121.9030435, "composition": 0.0255},
  123: {"mass": 122.9042698, "composition": 0.0089},
  124: {"mass": 123.9028171, "composition": 0.0474},
  125: {"mass": 124.9044299, "composition": 0.0707},
  126: {"mass": 125.9033109, "composition": 0.1884},
  127: {"mass": 126.9052257, "composition": 0.0},
  128: {"mass": 127.90446128, "composition": 0.3174},
  129: {"mass": 128.90659646, "composition": 0.0},
  130: {"mass": 129.906222748, "composition": 0.3408},
  131: {"mass": 130.908522213, "composition": 0.0},
  132: {"mass": 131.9085467, "composition": 0.0},
  133: {"mass": 132.9109688, "composition": 0.0},
  134: {"mass": 133.911394, "composition": 0.0},
  135: {"mass": 134.9165557, "composition": 0.0},
  136: {"mass": 135.9201006, "composition": 0.0},
  137: {"mass": 136.9255989, "composition": 0.0},
  138: {"mass": 137.9294722, "composition": 0.0},
  139: {"mass": 138.9353672, "composition": 0.0},
  140: {"mass": 139.939499, "composition": 0.0},
  141: {"mass": 140.9458, "composition": 0.0},
  142: {"mass": 141.95022, "composition": 0.0},
  143: {"mass": 142.95676, "composition": 0.0}},
 53: {107: {"mass": 106.94678, "composition": 0.0},
  108: {"mass": 107.94348, "composition": 0.0},
  109: {"mass": 108.9380853, "composition": 0.0},
  110: {"mass": 109.935089, "composition": 0.0},
  111: {"mass": 110.9302692, "composition": 0.0},
  112: {"mass": 111.928005, "composition": 0.0},
  113: {"mass": 112.9236501, "composition": 0.0},
  114: {"mass": 113.92185, "composition": 0.0},
  115: {"mass": 114.918048, "composition": 0.0},
  116: {"mass": 115.91681, "composition": 0.0},
  117: {"mass": 116.913648, "composition": 0.0},
  118: {"mass": 117.913074, "composition": 0.0},
  119: {"mass": 118.910074, "composition": 0.0},
  120: {"mass": 119.910087, "composition": 0.0},
  121: {"mass": 120.9074051, "composition": 0.0},
  122: {"mass": 121.9075888, "composition": 0.0},
  123: {"mass": 122.9055885, "composition": 0.0},
  124: {"mass": 123.906209, "composition": 0.0},
  125: {"mass": 124.9046294, "composition": 0.0},
  126: {"mass": 125.9056233, "composition": 0.0},
  127: {"mass": 126.9044719, "composition": 1.0},
  128: {"mass": 127.9058086, "composition": 0.0},
  129: {"mass": 128.9049837, "composition": 0.0},
  130: {"mass": 129.9066702, "composition": 0.0},
  131: {"mass": 130.9061263, "composition": 0.0},
  132: {"mass": 131.9079935, "composition": 0.0},
  133: {"mass": 132.907797, "composition": 0.0},
  134: {"mass": 133.9097588, "composition": 0.0},
  135: {"mass": 134.9100488, "composition": 0.0},
  136: {"mass": 135.914604, "composition": 0.0},
  137: {"mass": 136.9180282, "composition": 0.0},
  138: {"mass": 137.9227264, "composition": 0.0},
  139: {"mass": 138.926506, "composition": 0.0},
  140: {"mass": 139.93173, "composition": 0.0},
  141: {"mass": 140.93569, "composition": 0.0},
  142: {"mass": 141.9412, "composition": 0.0},
  143: {"mass": 142.94565, "composition": 0.0},
  144: {"mass": 143.95139, "composition": 0.0},
  145: {"mass": 144.95605, "composition": 0.0}},
 54: {109: {"mass": 108.95043, "composition": 0.0},
  110: {"mass": 109.94426, "composition": 0.0},
  111: {"mass": 110.941607, "composition": 0.0},
  112: {"mass": 111.935559, "composition": 0.0},
  113: {"mass": 112.9332217, "composition": 0.0},
  114: {"mass": 113.92798, "composition": 0.0},
  115: {"mass": 114.926294, "composition": 0.0},
  116: {"mass": 115.921581, "composition": 0.0},
  117: {"mass": 116.920359, "composition": 0.0},
  118: {"mass": 117.916179, "composition": 0.0},
  119: {"mass": 118.915411, "composition": 0.0},
  120: {"mass": 119.911784, "composition": 0.0},
  121: {"mass": 120.911453, "composition": 0.0},
  122: {"mass": 121.908368, "composition": 0.0},
  123: {"mass": 122.908482, "composition": 0.0},
  124: {"mass": 123.905892, "composition": 0.000952},
  125: {"mass": 124.9063944, "composition": 0.0},
  126: {"mass": 125.9042983, "composition": 0.00089},
  127: {"mass": 126.9051829, "composition": 0.0},
  128: {"mass": 127.903531, "composition": 0.019102},
  129: {"mass": 128.9047808611, "composition": 0.264006},
  130: {"mass": 129.903509349, "composition": 0.04071},
  131: {"mass": 130.90508406, "composition": 0.212324},
  132: {"mass": 131.9041550856, "composition": 0.269086},
  133: {"mass": 132.9059108, "composition": 0.0},
  134: {"mass": 133.90539466, "composition": 0.104357},
  135: {"mass": 134.9072278, "composition": 0.0},
  136: {"mass": 135.907214484, "composition": 0.088573},
  137: {"mass": 136.91155778, "composition": 0.0},
  138: {"mass": 137.9141463, "composition": 0.0},
  139: {"mass": 138.9187922, "composition": 0.0},
  140: {"mass": 139.9216458, "composition": 0.0},
  141: {"mass": 140.9267872, "composition": 0.0},
  142: {"mass": 141.9299731, "composition": 0.0},
  143: {"mass": 142.9353696, "composition": 0.0},
  144: {"mass": 143.9389451, "composition": 0.0},
  145: {"mass": 144.94472, "composition": 0.0},
  146: {"mass": 145.948518, "composition": 0.0},
  147: {"mass": 146.95426, "composition": 0.0},
  148: {"mass": 147.95813, "composition": 0.0}},
 55: {112: {"mass": 111.950309, "composition": 0.0},
  113: {"mass": 112.9444291, "composition": 0.0},
  114: {"mass": 113.941296, "composition": 0.0},
  115: {"mass": 114.93591, "composition": 0.0},
  116: {"mass": 115.93337, "composition": 0.0},
  117: {"mass": 116.928617, "composition": 0.0},
  118: {"mass": 117.92656, "composition": 0.0},
  119: {"mass": 118.922377, "composition": 0.0},
  120: {"mass": 119.920677, "composition": 0.0},
  121: {"mass": 120.917227, "composition": 0.0},
  122: {"mass": 121.916108, "composition": 0.0},
  123: {"mass": 122.912996, "composition": 0.0},
  124: {"mass": 123.9122578, "composition": 0.0},
  125: {"mass": 124.909728, "composition": 0.0},
  126: {"mass": 125.909446, "composition": 0.0},
  127: {"mass": 126.9074174, "composition": 0.0},
  128: {"mass": 127.9077487, "composition": 0.0},
  129: {"mass": 128.9060657, "composition": 0.0},
  130: {"mass": 129.9067093, "composition": 0.0},
  131: {"mass": 130.9054649, "composition": 0.0},
  132: {"mass": 131.9064339, "composition": 0.0},
  133: {"mass": 132.905451961, "composition": 1.0},
  134: {"mass": 133.906718503, "composition": 0.0},
  135: {"mass": 134.905977, "composition": 0.0},
  136: {"mass": 135.9073114, "composition": 0.0},
  137: {"mass": 136.90708923, "composition": 0.0},
  138: {"mass": 137.9110171, "composition": 0.0},
  139: {"mass": 138.9133638, "composition": 0.0},
  140: {"mass": 139.9172831, "composition": 0.0},
  141: {"mass": 140.9200455, "composition": 0.0},
  142: {"mass": 141.924296, "composition": 0.0},
  143: {"mass": 142.927349, "composition": 0.0},
  144: {"mass": 143.932076, "composition": 0.0},
  145: {"mass": 144.935527, "composition": 0.0},
  146: {"mass": 145.940344, "composition": 0.0},
  147: {"mass": 146.944156, "composition": 0.0},
  148: {"mass": 147.94923, "composition": 0.0},
  149: {"mass": 148.95302, "composition": 0.0},
  150: {"mass": 149.95833, "composition": 0.0},
  151: {"mass": 150.96258, "composition": 0.0}},
 56: {114: {"mass": 113.95066, "composition": 0.0},
  115: {"mass": 114.94737, "composition": 0.0},
  116: {"mass": 115.94128, "composition": 0.0},
  117: {"mass": 116.93814, "composition": 0.0},
  118: {"mass": 117.93306, "composition": 0.0},
  119: {"mass": 118.93066, "composition": 0.0},
  120: {"mass": 119.92605, "composition": 0.0},
  121: {"mass": 120.92405, "composition": 0.0},
  122: {"mass": 121.919904, "composition": 0.0},
  123: {"mass": 122.918781, "composition": 0.0},
  124: {"mass": 123.915094, "composition": 0.0},
  125: {"mass": 124.914472, "composition": 0.0},
  126: {"mass": 125.91125, "composition": 0.0},
  127: {"mass": 126.911091, "composition": 0.0},
  128: {"mass": 127.908342, "composition": 0.0},
  129: {"mass": 128.908681, "composition": 0.0},
  130: {"mass": 129.9063207, "composition": 0.00106},
  131: {"mass": 130.906941, "composition": 0.0},
  132: {"mass": 131.9050611, "composition": 0.00101},
  133: {"mass": 132.9060074, "composition": 0.0},
  134: {"mass": 133.90450818, "composition": 0.02417},
  135: {"mass": 134.90568838, "composition": 0.06592},
  136: {"mass": 135.90457573, "composition": 0.07854},
  137: {"mass": 136.90582714, "composition": 0.11232},
  138: {"mass": 137.905247, "composition": 0.71698},
  139: {"mass": 138.9088411, "composition": 0.0},
  140: {"mass": 139.9106057, "composition": 0.0},
  141: {"mass": 140.9144033, "composition": 0.0},
  142: {"mass": 141.9164324, "composition": 0.0},
  143: {"mass": 142.9206253, "composition": 0.0},
  144: {"mass": 143.9229549, "composition": 0.0},
  145: {"mass": 144.9275184, "composition": 0.0},
  146: {"mass": 145.930284, "composition": 0.0},
  147: {"mass": 146.935304, "composition": 0.0},
  148: {"mass": 147.938171, "composition": 0.0},
  149: {"mass": 148.94308, "composition": 0.0},
  150: {"mass": 149.94605, "composition": 0.0},
  151: {"mass": 150.95127, "composition": 0.0},
  152: {"mass": 151.95481, "composition": 0.0},
  153: {"mass": 152.96036, "composition": 0.0}},
 57: {116: {"mass": 115.9563, "composition": 0.0},
  117: {"mass": 116.94999, "composition": 0.0},
  118: {"mass": 117.94673, "composition": 0.0},
  119: {"mass": 118.94099, "composition": 0.0},
  120: {"mass": 119.93807, "composition": 0.0},
  121: {"mass": 120.93315, "composition": 0.0},
  122: {"mass": 121.93071, "composition": 0.0},
  123: {"mass": 122.9263, "composition": 0.0},
  124: {"mass": 123.924574, "composition": 0.0},
  125: {"mass": 124.920816, "composition": 0.0},
  126: {"mass": 125.919513, "composition": 0.0},
  127: {"mass": 126.916375, "composition": 0.0},
  128: {"mass": 127.915592, "composition": 0.0},
  129: {"mass": 128.912694, "composition": 0.0},
  130: {"mass": 129.912369, "composition": 0.0},
  131: {"mass": 130.91007, "composition": 0.0},
  132: {"mass": 131.910119, "composition": 0.0},
  133: {"mass": 132.908218, "composition": 0.0},
  134: {"mass": 133.908514, "composition": 0.0},
  135: {"mass": 134.906984, "composition": 0.0},
  136: {"mass": 135.907635, "composition": 0.0},
  137: {"mass": 136.9064504, "composition": 0.0},
  138: {"mass": 137.9071149, "composition": 0.0008881},
  139: {"mass": 138.9063563, "composition": 0.9991119},
  140: {"mass": 139.9094806, "composition": 0.0},
  141: {"mass": 140.910966, "composition": 0.0},
  142: {"mass": 141.9140909, "composition": 0.0},
  143: {"mass": 142.9160795, "composition": 0.0},
  144: {"mass": 143.919646, "composition": 0.0},
  145: {"mass": 144.921808, "composition": 0.0},
  146: {"mass": 145.925875, "composition": 0.0},
  147: {"mass": 146.928418, "composition": 0.0},
  148: {"mass": 147.932679, "composition": 0.0},
  149: {"mass": 148.93535, "composition": 0.0},
  150: {"mass": 149.93947, "composition": 0.0},
  151: {"mass": 150.94232, "composition": 0.0},
  152: {"mass": 151.94682, "composition": 0.0},
  153: {"mass": 152.95036, "composition": 0.0},
  154: {"mass": 153.95517, "composition": 0.0},
  155: {"mass": 154.95901, "composition": 0.0}},
 58: {119: {"mass": 118.95271, "composition": 0.0},
  120: {"mass": 119.94654, "composition": 0.0},
  121: {"mass": 120.94335, "composition": 0.0},
  122: {"mass": 121.93787, "composition": 0.0},
  123: {"mass": 122.93528, "composition": 0.0},
  124: {"mass": 123.93031, "composition": 0.0},
  125: {"mass": 124.92844, "composition": 0.0},
  126: {"mass": 125.923971, "composition": 0.0},
  127: {"mass": 126.922727, "composition": 0.0},
  128: {"mass": 127.918911, "composition": 0.0},
  129: {"mass": 128.918102, "composition": 0.0},
  130: {"mass": 129.914736, "composition": 0.0},
  131: {"mass": 130.914429, "composition": 0.0},
  132: {"mass": 131.911464, "composition": 0.0},
  133: {"mass": 132.91152, "composition": 0.0},
  134: {"mass": 133.908928, "composition": 0.0},
  135: {"mass": 134.909161, "composition": 0.0},
  136: {"mass": 135.90712921, "composition": 0.00185},
  137: {"mass": 136.90776236, "composition": 0.0},
  138: {"mass": 137.905991, "composition": 0.00251},
  139: {"mass": 138.9066551, "composition": 0.0},
  140: {"mass": 139.9054431, "composition": 0.8845},
  141: {"mass": 140.9082807, "composition": 0.0},
  142: {"mass": 141.9092504, "composition": 0.11114},
  143: {"mass": 142.9123921, "composition": 0.0},
  144: {"mass": 143.9136529, "composition": 0.0},
  145: {"mass": 144.917265, "composition": 0.0},
  146: {"mass": 145.918802, "composition": 0.0},
  147: {"mass": 146.9226899, "composition": 0.0},
  148: {"mass": 147.924424, "composition": 0.0},
  149: {"mass": 148.928427, "composition": 0.0},
  150: {"mass": 149.930384, "composition": 0.0},
  151: {"mass": 150.934272, "composition": 0.0},
  152: {"mass": 151.9366, "composition": 0.0},
  153: {"mass": 152.94093, "composition": 0.0},
  154: {"mass": 153.9438, "composition": 0.0},
  155: {"mass": 154.94855, "composition": 0.0},
  156: {"mass": 155.95183, "composition": 0.0},
  157: {"mass": 156.95705, "composition": 0.0}},
 59: {121: {"mass": 120.95532, "composition": 0.0},
  122: {"mass": 121.95175, "composition": 0.0},
  123: {"mass": 122.94596, "composition": 0.0},
  124: {"mass": 123.94294, "composition": 0.0},
  125: {"mass": 124.9377, "composition": 0.0},
  126: {"mass": 125.93524, "composition": 0.0},
  127: {"mass": 126.93071, "composition": 0.0},
  128: {"mass": 127.928791, "composition": 0.0},
  129: {"mass": 128.925095, "composition": 0.0},
  130: {"mass": 129.92359, "composition": 0.0},
  131: {"mass": 130.920235, "composition": 0.0},
  132: {"mass": 131.919255, "composition": 0.0},
  133: {"mass": 132.916331, "composition": 0.0},
  134: {"mass": 133.915697, "composition": 0.0},
  135: {"mass": 134.913112, "composition": 0.0},
  136: {"mass": 135.912677, "composition": 0.0},
  137: {"mass": 136.9106792, "composition": 0.0},
  138: {"mass": 137.910754, "composition": 0.0},
  139: {"mass": 138.9089408, "composition": 0.0},
  140: {"mass": 139.9090803, "composition": 0.0},
  141: {"mass": 140.9076576, "composition": 1.0},
  142: {"mass": 141.9100496, "composition": 0.0},
  143: {"mass": 142.9108228, "composition": 0.0},
  144: {"mass": 143.9133109, "composition": 0.0},
  145: {"mass": 144.9145182, "composition": 0.0},
  146: {"mass": 145.91768, "composition": 0.0},
  147: {"mass": 146.919008, "composition": 0.0},
  148: {"mass": 147.92213, "composition": 0.0},
  149: {"mass": 148.923736, "composition": 0.0},
  150: {"mass": 149.9266765, "composition": 0.0},
  151: {"mass": 150.928309, "composition": 0.0},
  152: {"mass": 151.931553, "composition": 0.0},
  153: {"mass": 152.933904, "composition": 0.0},
  154: {"mass": 153.93753, "composition": 0.0},
  155: {"mass": 154.940509, "composition": 0.0},
  156: {"mass": 155.94464, "composition": 0.0},
  157: {"mass": 156.94789, "composition": 0.0},
  158: {"mass": 157.95241, "composition": 0.0},
  159: {"mass": 158.95589, "composition": 0.0}},
 60: {124: {"mass": 123.9522, "composition": 0.0},
  125: {"mass": 124.9489, "composition": 0.0},
  126: {"mass": 125.94311, "composition": 0.0},
  127: {"mass": 126.94038, "composition": 0.0},
  128: {"mass": 127.93525, "composition": 0.0},
  129: {"mass": 128.9331, "composition": 0.0},
  130: {"mass": 129.928506, "composition": 0.0},
  131: {"mass": 130.927248, "composition": 0.0},
  132: {"mass": 131.923321, "composition": 0.0},
  133: {"mass": 132.922348, "composition": 0.0},
  134: {"mass": 133.91879, "composition": 0.0},
  135: {"mass": 134.918181, "composition": 0.0},
  136: {"mass": 135.914976, "composition": 0.0},
  137: {"mass": 136.914562, "composition": 0.0},
  138: {"mass": 137.91195, "composition": 0.0},
  139: {"mass": 138.911954, "composition": 0.0},
  140: {"mass": 139.90955, "composition": 0.0},
  141: {"mass": 140.9096147, "composition": 0.0},
  142: {"mass": 141.907729, "composition": 0.27152},
  143: {"mass": 142.90982, "composition": 0.12174},
  144: {"mass": 143.910093, "composition": 0.23798},
  145: {"mass": 144.9125793, "composition": 0.08293},
  146: {"mass": 145.9131226, "composition": 0.17189},
  147: {"mass": 146.9161061, "composition": 0.0},
  148: {"mass": 147.9168993, "composition": 0.05756},
  149: {"mass": 148.9201548, "composition": 0.0},
  150: {"mass": 149.9209022, "composition": 0.05638},
  151: {"mass": 150.9238403, "composition": 0.0},
  152: {"mass": 151.924692, "composition": 0.0},
  153: {"mass": 152.927718, "composition": 0.0},
  154: {"mass": 153.92948, "composition": 0.0},
  155: {"mass": 154.9331357, "composition": 0.0},
  156: {"mass": 155.93508, "composition": 0.0},
  157: {"mass": 156.939386, "composition": 0.0},
  158: {"mass": 157.94197, "composition": 0.0},
  159: {"mass": 158.94653, "composition": 0.0},
  160: {"mass": 159.9494, "composition": 0.0},
  161: {"mass": 160.95428, "composition": 0.0}},
 61: {126: {"mass": 125.95792, "composition": 0.0},
  127: {"mass": 126.95192, "composition": 0.0},
  128: {"mass": 127.9487, "composition": 0.0},
  129: {"mass": 128.94323, "composition": 0.0},
  130: {"mass": 129.94053, "composition": 0.0},
  131: {"mass": 130.93567, "composition": 0.0},
  132: {"mass": 131.93384, "composition": 0.0},
  133: {"mass": 132.929782, "composition": 0.0},
  134: {"mass": 133.928353, "composition": 0.0},
  135: {"mass": 134.924823, "composition": 0.0},
  136: {"mass": 135.923585, "composition": 0.0},
  137: {"mass": 136.92048, "composition": 0.0},
  138: {"mass": 137.919548, "composition": 0.0},
  139: {"mass": 138.9168, "composition": 0.0},
  140: {"mass": 139.91604, "composition": 0.0},
  141: {"mass": 140.913555, "composition": 0.0},
  142: {"mass": 141.91289, "composition": 0.0},
  143: {"mass": 142.9109383, "composition": 0.0},
  144: {"mass": 143.9125964, "composition": 0.0},
  145: {"mass": 144.9127559, "composition": 0.0},
  146: {"mass": 145.9147024, "composition": 0.0},
  147: {"mass": 146.915145, "composition": 0.0},
  148: {"mass": 147.9174819, "composition": 0.0},
  149: {"mass": 148.9183423, "composition": 0.0},
  150: {"mass": 149.920991, "composition": 0.0},
  151: {"mass": 150.9212175, "composition": 0.0},
  152: {"mass": 151.923506, "composition": 0.0},
  153: {"mass": 152.9241567, "composition": 0.0},
  154: {"mass": 153.926472, "composition": 0.0},
  155: {"mass": 154.928137, "composition": 0.0},
  156: {"mass": 155.9311175, "composition": 0.0},
  157: {"mass": 156.9331214, "composition": 0.0},
  158: {"mass": 157.936565, "composition": 0.0},
  159: {"mass": 158.939287, "composition": 0.0},
  160: {"mass": 159.9431, "composition": 0.0},
  161: {"mass": 160.94607, "composition": 0.0},
  162: {"mass": 161.95022, "composition": 0.0},
  163: {"mass": 162.95357, "composition": 0.0}},
 62: {128: {"mass": 127.95842, "composition": 0.0},
  129: {"mass": 128.95476, "composition": 0.0},
  130: {"mass": 129.949, "composition": 0.0},
  131: {"mass": 130.94618, "composition": 0.0},
  132: {"mass": 131.94087, "composition": 0.0},
  133: {"mass": 132.93856, "composition": 0.0},
  134: {"mass": 133.93411, "composition": 0.0},
  135: {"mass": 134.93252, "composition": 0.0},
  136: {"mass": 135.928276, "composition": 0.0},
  137: {"mass": 136.926971, "composition": 0.0},
  138: {"mass": 137.923244, "composition": 0.0},
  139: {"mass": 138.922297, "composition": 0.0},
  140: {"mass": 139.918995, "composition": 0.0},
  141: {"mass": 140.9184816, "composition": 0.0},
  142: {"mass": 141.9152044, "composition": 0.0},
  143: {"mass": 142.9146353, "composition": 0.0},
  144: {"mass": 143.9120065, "composition": 0.0307},
  145: {"mass": 144.9134173, "composition": 0.0},
  146: {"mass": 145.913047, "composition": 0.0},
  147: {"mass": 146.9149044, "composition": 0.1499},
  148: {"mass": 147.9148292, "composition": 0.1124},
  149: {"mass": 148.9171921, "composition": 0.1382},
  150: {"mass": 149.9172829, "composition": 0.0738},
  151: {"mass": 150.9199398, "composition": 0.0},
  152: {"mass": 151.9197397, "composition": 0.2675},
  153: {"mass": 152.9221047, "composition": 0.0},
  154: {"mass": 153.9222169, "composition": 0.2275},
  155: {"mass": 154.9246477, "composition": 0.0},
  156: {"mass": 155.925536, "composition": 0.0},
  157: {"mass": 156.9284187, "composition": 0.0},
  158: {"mass": 157.929951, "composition": 0.0},
  159: {"mass": 158.9332172, "composition": 0.0},
  160: {"mass": 159.9353353, "composition": 0.0},
  161: {"mass": 160.9391602, "composition": 0.0},
  162: {"mass": 161.94146, "composition": 0.0},
  163: {"mass": 162.94555, "composition": 0.0},
  164: {"mass": 163.94836, "composition": 0.0},
  165: {"mass": 164.95297, "composition": 0.0}},
 63: {130: {"mass": 129.96369, "composition": 0.0},
  131: {"mass": 130.95784, "composition": 0.0},
  132: {"mass": 131.95467, "composition": 0.0},
  133: {"mass": 132.94929, "composition": 0.0},
  134: {"mass": 133.9464, "composition": 0.0},
  135: {"mass": 134.94187, "composition": 0.0},
  136: {"mass": 135.93962, "composition": 0.0},
  137: {"mass": 136.93546, "composition": 0.0},
  138: {"mass": 137.933709, "composition": 0.0},
  139: {"mass": 138.929792, "composition": 0.0},
  140: {"mass": 139.928088, "composition": 0.0},
  141: {"mass": 140.924932, "composition": 0.0},
  142: {"mass": 141.923442, "composition": 0.0},
  143: {"mass": 142.920299, "composition": 0.0},
  144: {"mass": 143.91882, "composition": 0.0},
  145: {"mass": 144.9162726, "composition": 0.0},
  146: {"mass": 145.917211, "composition": 0.0},
  147: {"mass": 146.9167527, "composition": 0.0},
  148: {"mass": 147.918089, "composition": 0.0},
  149: {"mass": 148.9179378, "composition": 0.0},
  150: {"mass": 149.9197077, "composition": 0.0},
  151: {"mass": 150.9198578, "composition": 0.4781},
  152: {"mass": 151.9217522, "composition": 0.0},
  153: {"mass": 152.921238, "composition": 0.5219},
  154: {"mass": 153.922987, "composition": 0.0},
  155: {"mass": 154.9229011, "composition": 0.0},
  156: {"mass": 155.9247605, "composition": 0.0},
  157: {"mass": 156.9254334, "composition": 0.0},
  158: {"mass": 157.927799, "composition": 0.0},
  159: {"mass": 158.9291001, "composition": 0.0},
  160: {"mass": 159.931851, "composition": 0.0},
  161: {"mass": 160.933664, "composition": 0.0},
  162: {"mass": 161.936989, "composition": 0.0},
  163: {"mass": 162.939196, "composition": 0.0},
  164: {"mass": 163.94274, "composition": 0.0},
  165: {"mass": 164.94559, "composition": 0.0},
  166: {"mass": 165.94962, "composition": 0.0},
  167: {"mass": 166.95289, "composition": 0.0}},
 64: {133: {"mass": 132.96133, "composition": 0.0},
  134: {"mass": 133.95566, "composition": 0.0},
  135: {"mass": 134.95245, "composition": 0.0},
  136: {"mass": 135.9473, "composition": 0.0},
  137: {"mass": 136.94502, "composition": 0.0},
  138: {"mass": 137.94025, "composition": 0.0},
  139: {"mass": 138.93813, "composition": 0.0},
  140: {"mass": 139.933674, "composition": 0.0},
  141: {"mass": 140.932126, "composition": 0.0},
  142: {"mass": 141.928116, "composition": 0.0},
  143: {"mass": 142.92675, "composition": 0.0},
  144: {"mass": 143.922963, "composition": 0.0},
  145: {"mass": 144.921713, "composition": 0.0},
  146: {"mass": 145.9183188, "composition": 0.0},
  147: {"mass": 146.9191014, "composition": 0.0},
  148: {"mass": 147.9181215, "composition": 0.0},
  149: {"mass": 148.9193481, "composition": 0.0},
  150: {"mass": 149.9186644, "composition": 0.0},
  151: {"mass": 150.920356, "composition": 0.0},
  152: {"mass": 151.9197995, "composition": 0.002},
  153: {"mass": 152.921758, "composition": 0.0},
  154: {"mass": 153.9208741, "composition": 0.0218},
  155: {"mass": 154.9226305, "composition": 0.148},
  156: {"mass": 155.9221312, "composition": 0.2047},
  157: {"mass": 156.9239686, "composition": 0.1565},
  158: {"mass": 157.9241123, "composition": 0.2484},
  159: {"mass": 158.926397, "composition": 0.0},
  160: {"mass": 159.9270624, "composition": 0.2186},
  161: {"mass": 160.9296775, "composition": 0.0},
  162: {"mass": 161.930993, "composition": 0.0},
  163: {"mass": 162.9341769, "composition": 0.0},
  164: {"mass": 163.93583, "composition": 0.0},
  165: {"mass": 164.93936, "composition": 0.0},
  166: {"mass": 165.94146, "composition": 0.0},
  167: {"mass": 166.94545, "composition": 0.0},
  168: {"mass": 167.94808, "composition": 0.0},
  169: {"mass": 168.9526, "composition": 0.0}},
 65: {135: {"mass": 134.96476, "composition": 0.0},
  136: {"mass": 135.96129, "composition": 0.0},
  137: {"mass": 136.95602, "composition": 0.0},
  138: {"mass": 137.95312, "composition": 0.0},
  139: {"mass": 138.94833, "composition": 0.0},
  140: {"mass": 139.94581, "composition": 0.0},
  141: {"mass": 140.94145, "composition": 0.0},
  142: {"mass": 141.93928, "composition": 0.0},
  143: {"mass": 142.935137, "composition": 0.0},
  144: {"mass": 143.933045, "composition": 0.0},
  145: {"mass": 144.92882, "composition": 0.0},
  146: {"mass": 145.927253, "composition": 0.0},
  147: {"mass": 146.9240548, "composition": 0.0},
  148: {"mass": 147.924282, "composition": 0.0},
  149: {"mass": 148.9232535, "composition": 0.0},
  150: {"mass": 149.9236649, "composition": 0.0},
  151: {"mass": 150.9231096, "composition": 0.0},
  152: {"mass": 151.924083, "composition": 0.0},
  153: {"mass": 152.9234424, "composition": 0.0},
  154: {"mass": 153.924685, "composition": 0.0},
  155: {"mass": 154.923511, "composition": 0.0},
  156: {"mass": 155.9247552, "composition": 0.0},
  157: {"mass": 156.924033, "composition": 0.0},
  158: {"mass": 157.9254209, "composition": 0.0},
  159: {"mass": 158.9253547, "composition": 1.0},
  160: {"mass": 159.9271756, "composition": 0.0},
  161: {"mass": 160.9275778, "composition": 0.0},
  162: {"mass": 161.929495, "composition": 0.0},
  163: {"mass": 162.9306547, "composition": 0.0},
  164: {"mass": 163.93336, "composition": 0.0},
  165: {"mass": 164.93498, "composition": 0.0},
  166: {"mass": 165.93786, "composition": 0.0},
  167: {"mass": 166.93996, "composition": 0.0},
  168: {"mass": 167.9434, "composition": 0.0},
  169: {"mass": 168.94597, "composition": 0.0},
  170: {"mass": 169.94984, "composition": 0.0},
  171: {"mass": 170.95273, "composition": 0.0}},
 66: {138: {"mass": 137.9625, "composition": 0.0},
  139: {"mass": 138.95959, "composition": 0.0},
  140: {"mass": 139.95402, "composition": 0.0},
  141: {"mass": 140.95128, "composition": 0.0},
  142: {"mass": 141.94619, "composition": 0.0},
  143: {"mass": 142.943994, "composition": 0.0},
  144: {"mass": 143.9392695, "composition": 0.0},
  145: {"mass": 144.937474, "composition": 0.0},
  146: {"mass": 145.9328445, "composition": 0.0},
  147: {"mass": 146.9310827, "composition": 0.0},
  148: {"mass": 147.927157, "composition": 0.0},
  149: {"mass": 148.927322, "composition": 0.0},
  150: {"mass": 149.9255933, "composition": 0.0},
  151: {"mass": 150.9261916, "composition": 0.0},
  152: {"mass": 151.9247253, "composition": 0.0},
  153: {"mass": 152.9257724, "composition": 0.0},
  154: {"mass": 153.9244293, "composition": 0.0},
  155: {"mass": 154.925759, "composition": 0.0},
  156: {"mass": 155.9242847, "composition": 0.00056},
  157: {"mass": 156.9254707, "composition": 0.0},
  158: {"mass": 157.9244159, "composition": 0.00095},
  159: {"mass": 158.925747, "composition": 0.0},
  160: {"mass": 159.9252046, "composition": 0.02329},
  161: {"mass": 160.9269405, "composition": 0.18889},
  162: {"mass": 161.9268056, "composition": 0.25475},
  163: {"mass": 162.9287383, "composition": 0.24896},
  164: {"mass": 163.9291819, "composition": 0.2826},
  165: {"mass": 164.9317105, "composition": 0.0},
  166: {"mass": 165.9328139, "composition": 0.0},
  167: {"mass": 166.935661, "composition": 0.0},
  168: {"mass": 167.93713, "composition": 0.0},
  169: {"mass": 168.94031, "composition": 0.0},
  170: {"mass": 169.94239, "composition": 0.0},
  171: {"mass": 170.94612, "composition": 0.0},
  172: {"mass": 171.94846, "composition": 0.0},
  173: {"mass": 172.95283, "composition": 0.0}},
 67: {140: {"mass": 139.96859, "composition": 0.0},
  141: {"mass": 140.96311, "composition": 0.0},
  142: {"mass": 141.96001, "composition": 0.0},
  143: {"mass": 142.95486, "composition": 0.0},
  144: {"mass": 143.9521097, "composition": 0.0},
  145: {"mass": 144.9472674, "composition": 0.0},
  146: {"mass": 145.9449935, "composition": 0.0},
  147: {"mass": 146.9401423, "composition": 0.0},
  148: {"mass": 147.937744, "composition": 0.0},
  149: {"mass": 148.933803, "composition": 0.0},
  150: {"mass": 149.933498, "composition": 0.0},
  151: {"mass": 150.9316983, "composition": 0.0},
  152: {"mass": 151.931724, "composition": 0.0},
  153: {"mass": 152.9302064, "composition": 0.0},
  154: {"mass": 153.9306068, "composition": 0.0},
  155: {"mass": 154.929104, "composition": 0.0},
  156: {"mass": 155.929706, "composition": 0.0},
  157: {"mass": 156.928254, "composition": 0.0},
  158: {"mass": 157.928946, "composition": 0.0},
  159: {"mass": 158.9277197, "composition": 0.0},
  160: {"mass": 159.928737, "composition": 0.0},
  161: {"mass": 160.9278615, "composition": 0.0},
  162: {"mass": 161.9291023, "composition": 0.0},
  163: {"mass": 162.928741, "composition": 0.0},
  164: {"mass": 163.9302403, "composition": 0.0},
  165: {"mass": 164.9303288, "composition": 1.0},
  166: {"mass": 165.9322909, "composition": 0.0},
  167: {"mass": 166.9331385, "composition": 0.0},
  168: {"mass": 167.935522, "composition": 0.0},
  169: {"mass": 168.936878, "composition": 0.0},
  170: {"mass": 169.939625, "composition": 0.0},
  171: {"mass": 170.94147, "composition": 0.0},
  172: {"mass": 171.94473, "composition": 0.0},
  173: {"mass": 172.94702, "composition": 0.0},
  174: {"mass": 173.95095, "composition": 0.0},
  175: {"mass": 174.95362, "composition": 0.0}},
 68: {142: {"mass": 141.9701, "composition": 0.0},
  143: {"mass": 142.96662, "composition": 0.0},
  144: {"mass": 143.9607, "composition": 0.0},
  145: {"mass": 144.95805, "composition": 0.0},
  146: {"mass": 145.9524184, "composition": 0.0},
  147: {"mass": 146.949964, "composition": 0.0},
  148: {"mass": 147.944735, "composition": 0.0},
  149: {"mass": 148.942306, "composition": 0.0},
  150: {"mass": 149.937916, "composition": 0.0},
  151: {"mass": 150.937449, "composition": 0.0},
  152: {"mass": 151.935057, "composition": 0.0},
  153: {"mass": 152.93508, "composition": 0.0},
  154: {"mass": 153.9327908, "composition": 0.0},
  155: {"mass": 154.9332159, "composition": 0.0},
  156: {"mass": 155.931067, "composition": 0.0},
  157: {"mass": 156.931949, "composition": 0.0},
  158: {"mass": 157.929893, "composition": 0.0},
  159: {"mass": 158.9306918, "composition": 0.0},
  160: {"mass": 159.929077, "composition": 0.0},
  161: {"mass": 160.9300046, "composition": 0.0},
  162: {"mass": 161.9287884, "composition": 0.00139},
  163: {"mass": 162.9300408, "composition": 0.0},
  164: {"mass": 163.9292088, "composition": 0.01601},
  165: {"mass": 164.9307345, "composition": 0.0},
  166: {"mass": 165.9302995, "composition": 0.33503},
  167: {"mass": 166.9320546, "composition": 0.22869},
  168: {"mass": 167.9323767, "composition": 0.26978},
  169: {"mass": 168.9345968, "composition": 0.0},
  170: {"mass": 169.9354702, "composition": 0.1491},
  171: {"mass": 170.9380357, "composition": 0.0},
  172: {"mass": 171.9393619, "composition": 0.0},
  173: {"mass": 172.9424, "composition": 0.0},
  174: {"mass": 173.94423, "composition": 0.0},
  175: {"mass": 174.94777, "composition": 0.0},
  176: {"mass": 175.94994, "composition": 0.0},
  177: {"mass": 176.95399, "composition": 0.0}},
 69: {144: {"mass": 143.97628, "composition": 0.0},
  145: {"mass": 144.97039, "composition": 0.0},
  146: {"mass": 145.96684, "composition": 0.0},
  147: {"mass": 146.9613799, "composition": 0.0},
  148: {"mass": 147.958384, "composition": 0.0},
  149: {"mass": 148.95289, "composition": 0.0},
  150: {"mass": 149.95009, "composition": 0.0},
  151: {"mass": 150.945488, "composition": 0.0},
  152: {"mass": 151.944422, "composition": 0.0},
  153: {"mass": 152.94204, "composition": 0.0},
  154: {"mass": 153.94157, "composition": 0.0},
  155: {"mass": 154.93921, "composition": 0.0},
  156: {"mass": 155.938992, "composition": 0.0},
  157: {"mass": 156.936944, "composition": 0.0},
  158: {"mass": 157.93698, "composition": 0.0},
  159: {"mass": 158.934975, "composition": 0.0},
  160: {"mass": 159.935263, "composition": 0.0},
  161: {"mass": 160.933549, "composition": 0.0},
  162: {"mass": 161.934002, "composition": 0.0},
  163: {"mass": 162.9326592, "composition": 0.0},
  164: {"mass": 163.933544, "composition": 0.0},
  165: {"mass": 164.9324431, "composition": 0.0},
  166: {"mass": 165.933561, "composition": 0.0},
  167: {"mass": 166.9328562, "composition": 0.0},
  168: {"mass": 167.9341774, "composition": 0.0},
  169: {"mass": 168.9342179, "composition": 1.0},
  170: {"mass": 169.935806, "composition": 0.0},
  171: {"mass": 170.9364339, "composition": 0.0},
  172: {"mass": 171.9384055, "composition": 0.0},
  173: {"mass": 172.9396084, "composition": 0.0},
  174: {"mass": 173.942173, "composition": 0.0},
  175: {"mass": 174.943841, "composition": 0.0},
  176: {"mass": 175.947, "composition": 0.0},
  177: {"mass": 176.94904, "composition": 0.0},
  178: {"mass": 177.95264, "composition": 0.0},
  179: {"mass": 178.95534, "composition": 0.0}},
 70: {148: {"mass": 147.96758, "composition": 0.0},
  149: {"mass": 148.96436, "composition": 0.0},
  150: {"mass": 149.95852, "composition": 0.0},
  151: {"mass": 150.9554, "composition": 0.0},
  152: {"mass": 151.95027, "composition": 0.0},
  153: {"mass": 152.94932, "composition": 0.0},
  154: {"mass": 153.946396, "composition": 0.0},
  155: {"mass": 154.945783, "composition": 0.0},
  156: {"mass": 155.942825, "composition": 0.0},
  157: {"mass": 156.942645, "composition": 0.0},
  158: {"mass": 157.9398705, "composition": 0.0},
  159: {"mass": 158.940055, "composition": 0.0},
  160: {"mass": 159.937557, "composition": 0.0},
  161: {"mass": 160.937907, "composition": 0.0},
  162: {"mass": 161.935774, "composition": 0.0},
  163: {"mass": 162.93634, "composition": 0.0},
  164: {"mass": 163.934495, "composition": 0.0},
  165: {"mass": 164.93527, "composition": 0.0},
  166: {"mass": 165.9338747, "composition": 0.0},
  167: {"mass": 166.934953, "composition": 0.0},
  168: {"mass": 167.9338896, "composition": 0.00123},
  169: {"mass": 168.9351825, "composition": 0.0},
  170: {"mass": 169.9347664, "composition": 0.02982},
  171: {"mass": 170.9363302, "composition": 0.1409},
  172: {"mass": 171.9363859, "composition": 0.2168},
  173: {"mass": 172.9382151, "composition": 0.16103},
  174: {"mass": 173.9388664, "composition": 0.32026},
  175: {"mass": 174.9412808, "composition": 0.0},
  176: {"mass": 175.9425764, "composition": 0.12996},
  177: {"mass": 176.9452656, "composition": 0.0},
  178: {"mass": 177.946651, "composition": 0.0},
  179: {"mass": 178.95004, "composition": 0.0},
  180: {"mass": 179.95212, "composition": 0.0},
  181: {"mass": 180.95589, "composition": 0.0}},
 71: {150: {"mass": 149.97355, "composition": 0.0},
  151: {"mass": 150.96768, "composition": 0.0},
  152: {"mass": 151.96412, "composition": 0.0},
  153: {"mass": 152.95875, "composition": 0.0},
  154: {"mass": 153.95736, "composition": 0.0},
  155: {"mass": 154.954321, "composition": 0.0},
  156: {"mass": 155.953033, "composition": 0.0},
  157: {"mass": 156.950127, "composition": 0.0},
  158: {"mass": 157.949316, "composition": 0.0},
  159: {"mass": 158.946636, "composition": 0.0},
  160: {"mass": 159.946033, "composition": 0.0},
  161: {"mass": 160.943572, "composition": 0.0},
  162: {"mass": 161.943283, "composition": 0.0},
  163: {"mass": 162.941179, "composition": 0.0},
  164: {"mass": 163.941339, "composition": 0.0},
  165: {"mass": 164.939407, "composition": 0.0},
  166: {"mass": 165.939859, "composition": 0.0},
  167: {"mass": 166.93827, "composition": 0.0},
  168: {"mass": 167.938736, "composition": 0.0},
  169: {"mass": 168.9376441, "composition": 0.0},
  170: {"mass": 169.938478, "composition": 0.0},
  171: {"mass": 170.937917, "composition": 0.0},
  172: {"mass": 171.9390891, "composition": 0.0},
  173: {"mass": 172.938934, "composition": 0.0},
  174: {"mass": 173.9403409, "composition": 0.0},
  175: {"mass": 174.9407752, "composition": 0.97401},
  176: {"mass": 175.9426897, "composition": 0.02599},
  177: {"mass": 176.9437615, "composition": 0.0},
  178: {"mass": 177.945958, "composition": 0.0},
  179: {"mass": 178.9473309, "composition": 0.0},
  180: {"mass": 179.949888, "composition": 0.0},
  181: {"mass": 180.95191, "composition": 0.0},
  182: {"mass": 181.95504, "composition": 0.0},
  183: {"mass": 182.957363, "composition": 0.0},
  184: {"mass": 183.96091, "composition": 0.0},
  185: {"mass": 184.96362, "composition": 0.0}},
 72: {153: {"mass": 152.97069, "composition": 0.0},
  154: {"mass": 153.96486, "composition": 0.0},
  155: {"mass": 154.96311, "composition": 0.0},
  156: {"mass": 155.95935, "composition": 0.0},
  157: {"mass": 156.95824, "composition": 0.0},
  158: {"mass": 157.954801, "composition": 0.0},
  159: {"mass": 158.953996, "composition": 0.0},
  160: {"mass": 159.950691, "composition": 0.0},
  161: {"mass": 160.950278, "composition": 0.0},
  162: {"mass": 161.9472148, "composition": 0.0},
  163: {"mass": 162.947113, "composition": 0.0},
  164: {"mass": 163.944371, "composition": 0.0},
  165: {"mass": 164.944567, "composition": 0.0},
  166: {"mass": 165.94218, "composition": 0.0},
  167: {"mass": 166.9426, "composition": 0.0},
  168: {"mass": 167.940568, "composition": 0.0},
  169: {"mass": 168.941259, "composition": 0.0},
  170: {"mass": 169.939609, "composition": 0.0},
  171: {"mass": 170.940492, "composition": 0.0},
  172: {"mass": 171.93945, "composition": 0.0},
  173: {"mass": 172.940513, "composition": 0.0},
  174: {"mass": 173.9400461, "composition": 0.0016},
  175: {"mass": 174.9415092, "composition": 0.0},
  176: {"mass": 175.9414076, "composition": 0.0526},
  177: {"mass": 176.9432277, "composition": 0.186},
  178: {"mass": 177.9437058, "composition": 0.2728},
  179: {"mass": 178.9458232, "composition": 0.1362},
  180: {"mass": 179.946557, "composition": 0.3508},
  181: {"mass": 180.9491083, "composition": 0.0},
  182: {"mass": 181.9505612, "composition": 0.0},
  183: {"mass": 182.95353, "composition": 0.0},
  184: {"mass": 183.955446, "composition": 0.0},
  185: {"mass": 184.958862, "composition": 0.0},
  186: {"mass": 185.960897, "composition": 0.0},
  187: {"mass": 186.96477, "composition": 0.0},
  188: {"mass": 187.96685, "composition": 0.0},
  189: {"mass": 188.97084, "composition": 0.0}},
 73: {155: {"mass": 154.97424, "composition": 0.0},
  156: {"mass": 155.97203, "composition": 0.0},
  157: {"mass": 156.96818, "composition": 0.0},
  158: {"mass": 157.96654, "composition": 0.0},
  159: {"mass": 158.963023, "composition": 0.0},
  160: {"mass": 159.961488, "composition": 0.0},
  161: {"mass": 160.958452, "composition": 0.0},
  162: {"mass": 161.957294, "composition": 0.0},
  163: {"mass": 162.954337, "composition": 0.0},
  164: {"mass": 163.953534, "composition": 0.0},
  165: {"mass": 164.950781, "composition": 0.0},
  166: {"mass": 165.950512, "composition": 0.0},
  167: {"mass": 166.948093, "composition": 0.0},
  168: {"mass": 167.948047, "composition": 0.0},
  169: {"mass": 168.946011, "composition": 0.0},
  170: {"mass": 169.946175, "composition": 0.0},
  171: {"mass": 170.944476, "composition": 0.0},
  172: {"mass": 171.944895, "composition": 0.0},
  173: {"mass": 172.94375, "composition": 0.0},
  174: {"mass": 173.944454, "composition": 0.0},
  175: {"mass": 174.943737, "composition": 0.0},
  176: {"mass": 175.944857, "composition": 0.0},
  177: {"mass": 176.9444795, "composition": 0.0},
  178: {"mass": 177.945678, "composition": 0.0},
  179: {"mass": 178.9459366, "composition": 0.0},
  180: {"mass": 179.9474648, "composition": 0.0001201},
  181: {"mass": 180.9479958, "composition": 0.9998799},
  182: {"mass": 181.9501519, "composition": 0.0},
  183: {"mass": 182.9513726, "composition": 0.0},
  184: {"mass": 183.954008, "composition": 0.0},
  185: {"mass": 184.955559, "composition": 0.0},
  186: {"mass": 185.958551, "composition": 0.0},
  187: {"mass": 186.960386, "composition": 0.0},
  188: {"mass": 187.963916, "composition": 0.0},
  189: {"mass": 188.96583, "composition": 0.0},
  190: {"mass": 189.96939, "composition": 0.0},
  191: {"mass": 190.97156, "composition": 0.0},
  192: {"mass": 191.97514, "composition": 0.0}},
 74: {157: {"mass": 156.97884, "composition": 0.0},
  158: {"mass": 157.97456, "composition": 0.0},
  159: {"mass": 158.97264, "composition": 0.0},
  160: {"mass": 159.96846, "composition": 0.0},
  161: {"mass": 160.9672, "composition": 0.0},
  162: {"mass": 161.963499, "composition": 0.0},
  163: {"mass": 162.962524, "composition": 0.0},
  164: {"mass": 163.958961, "composition": 0.0},
  165: {"mass": 164.958281, "composition": 0.0},
  166: {"mass": 165.955031, "composition": 0.0},
  167: {"mass": 166.954805, "composition": 0.0},
  168: {"mass": 167.951806, "composition": 0.0},
  169: {"mass": 168.951779, "composition": 0.0},
  170: {"mass": 169.949232, "composition": 0.0},
  171: {"mass": 170.949451, "composition": 0.0},
  172: {"mass": 171.947292, "composition": 0.0},
  173: {"mass": 172.947689, "composition": 0.0},
  174: {"mass": 173.946079, "composition": 0.0},
  175: {"mass": 174.946717, "composition": 0.0},
  176: {"mass": 175.945634, "composition": 0.0},
  177: {"mass": 176.946643, "composition": 0.0},
  178: {"mass": 177.945883, "composition": 0.0},
  179: {"mass": 178.947077, "composition": 0.0},
  180: {"mass": 179.9467108, "composition": 0.0012},
  181: {"mass": 180.9481978, "composition": 0.0},
  182: {"mass": 181.94820394, "composition": 0.265},
  183: {"mass": 182.95022275, "composition": 0.1431},
  184: {"mass": 183.95093092, "composition": 0.3064},
  185: {"mass": 184.95341897, "composition": 0.0},
  186: {"mass": 185.9543628, "composition": 0.2843},
  187: {"mass": 186.9571588, "composition": 0.0},
  188: {"mass": 187.9584862, "composition": 0.0},
  189: {"mass": 188.961763, "composition": 0.0},
  190: {"mass": 189.963091, "composition": 0.0},
  191: {"mass": 190.966531, "composition": 0.0},
  192: {"mass": 191.96817, "composition": 0.0},
  193: {"mass": 192.97178, "composition": 0.0},
  194: {"mass": 193.97367, "composition": 0.0}},
 75: {159: {"mass": 158.98418, "composition": 0.0},
  160: {"mass": 159.98182, "composition": 0.0},
  161: {"mass": 160.97757, "composition": 0.0},
  162: {"mass": 161.97584, "composition": 0.0},
  163: {"mass": 162.97208, "composition": 0.0},
  164: {"mass": 163.970453, "composition": 0.0},
  165: {"mass": 164.967103, "composition": 0.0},
  166: {"mass": 165.965761, "composition": 0.0},
  167: {"mass": 166.962595, "composition": 0.0},
  168: {"mass": 167.961573, "composition": 0.0},
  169: {"mass": 168.958766, "composition": 0.0},
  170: {"mass": 169.95822, "composition": 0.0},
  171: {"mass": 170.955716, "composition": 0.0},
  172: {"mass": 171.95542, "composition": 0.0},
  173: {"mass": 172.953243, "composition": 0.0},
  174: {"mass": 173.953115, "composition": 0.0},
  175: {"mass": 174.951381, "composition": 0.0},
  176: {"mass": 175.951623, "composition": 0.0},
  177: {"mass": 176.950328, "composition": 0.0},
  178: {"mass": 177.950989, "composition": 0.0},
  179: {"mass": 178.949989, "composition": 0.0},
  180: {"mass": 179.950792, "composition": 0.0},
  181: {"mass": 180.950058, "composition": 0.0},
  182: {"mass": 181.95121, "composition": 0.0},
  183: {"mass": 182.9508196, "composition": 0.0},
  184: {"mass": 183.9525228, "composition": 0.0},
  185: {"mass": 184.9529545, "composition": 0.374},
  186: {"mass": 185.9549856, "composition": 0.0},
  187: {"mass": 186.9557501, "composition": 0.626},
  188: {"mass": 187.9581115, "composition": 0.0},
  189: {"mass": 188.959226, "composition": 0.0},
  190: {"mass": 189.961744, "composition": 0.0},
  191: {"mass": 190.963122, "composition": 0.0},
  192: {"mass": 191.966088, "composition": 0.0},
  193: {"mass": 192.967541, "composition": 0.0},
  194: {"mass": 193.97076, "composition": 0.0},
  195: {"mass": 194.97254, "composition": 0.0},
  196: {"mass": 195.9758, "composition": 0.0},
  197: {"mass": 196.97799, "composition": 0.0},
  198: {"mass": 197.9816, "composition": 0.0}},
 76: {161: {"mass": 160.98903, "composition": 0.0},
  162: {"mass": 161.98443, "composition": 0.0},
  163: {"mass": 162.98241, "composition": 0.0},
  164: {"mass": 163.97802, "composition": 0.0},
  165: {"mass": 164.9766, "composition": 0.0},
  166: {"mass": 165.972692, "composition": 0.0},
  167: {"mass": 166.971549, "composition": 0.0},
  168: {"mass": 167.967808, "composition": 0.0},
  169: {"mass": 168.967018, "composition": 0.0},
  170: {"mass": 169.963578, "composition": 0.0},
  171: {"mass": 170.963174, "composition": 0.0},
  172: {"mass": 171.960017, "composition": 0.0},
  173: {"mass": 172.959808, "composition": 0.0},
  174: {"mass": 173.957064, "composition": 0.0},
  175: {"mass": 174.956945, "composition": 0.0},
  176: {"mass": 175.954806, "composition": 0.0},
  177: {"mass": 176.954966, "composition": 0.0},
  178: {"mass": 177.953254, "composition": 0.0},
  179: {"mass": 178.953817, "composition": 0.0},
  180: {"mass": 179.952375, "composition": 0.0},
  181: {"mass": 180.953247, "composition": 0.0},
  182: {"mass": 181.95211, "composition": 0.0},
  183: {"mass": 182.953125, "composition": 0.0},
  184: {"mass": 183.9524885, "composition": 0.0002},
  185: {"mass": 184.9540417, "composition": 0.0},
  186: {"mass": 185.953835, "composition": 0.0159},
  187: {"mass": 186.9557474, "composition": 0.0196},
  188: {"mass": 187.9558352, "composition": 0.1324},
  189: {"mass": 188.9581442, "composition": 0.1615},
  190: {"mass": 189.9584437, "composition": 0.2626},
  191: {"mass": 190.9609264, "composition": 0.0},
  192: {"mass": 191.961477, "composition": 0.4078},
  193: {"mass": 192.9641479, "composition": 0.0},
  194: {"mass": 193.9651772, "composition": 0.0},
  195: {"mass": 194.968318, "composition": 0.0},
  196: {"mass": 195.969641, "composition": 0.0},
  197: {"mass": 196.97283, "composition": 0.0},
  198: {"mass": 197.97441, "composition": 0.0},
  199: {"mass": 198.97801, "composition": 0.0},
  200: {"mass": 199.97984, "composition": 0.0},
  201: {"mass": 200.98364, "composition": 0.0},
  202: {"mass": 201.98595, "composition": 0.0}},
 77: {164: {"mass": 163.99191, "composition": 0.0},
  165: {"mass": 164.9875, "composition": 0.0},
  166: {"mass": 165.98566, "composition": 0.0},
  167: {"mass": 166.981666, "composition": 0.0},
  168: {"mass": 167.979907, "composition": 0.0},
  169: {"mass": 168.976298, "composition": 0.0},
  170: {"mass": 169.974922, "composition": 0.0},
  171: {"mass": 170.97164, "composition": 0.0},
  172: {"mass": 171.970607, "composition": 0.0},
  173: {"mass": 172.967506, "composition": 0.0},
  174: {"mass": 173.966861, "composition": 0.0},
  175: {"mass": 174.96415, "composition": 0.0},
  176: {"mass": 175.96365, "composition": 0.0},
  177: {"mass": 176.961301, "composition": 0.0},
  178: {"mass": 177.961082, "composition": 0.0},
  179: {"mass": 178.95912, "composition": 0.0},
  180: {"mass": 179.959229, "composition": 0.0},
  181: {"mass": 180.957625, "composition": 0.0},
  182: {"mass": 181.958076, "composition": 0.0},
  183: {"mass": 182.95684, "composition": 0.0},
  184: {"mass": 183.957476, "composition": 0.0},
  185: {"mass": 184.956698, "composition": 0.0},
  186: {"mass": 185.957944, "composition": 0.0},
  187: {"mass": 186.957542, "composition": 0.0},
  188: {"mass": 187.958828, "composition": 0.0},
  189: {"mass": 188.958715, "composition": 0.0},
  190: {"mass": 189.9605412, "composition": 0.0},
  191: {"mass": 190.9605893, "composition": 0.373},
  192: {"mass": 191.9626002, "composition": 0.0},
  193: {"mass": 192.9629216, "composition": 0.627},
  194: {"mass": 193.9650735, "composition": 0.0},
  195: {"mass": 194.9659747, "composition": 0.0},
  196: {"mass": 195.968397, "composition": 0.0},
  197: {"mass": 196.969655, "composition": 0.0},
  198: {"mass": 197.97228, "composition": 0.0},
  199: {"mass": 198.973805, "composition": 0.0},
  200: {"mass": 199.9768, "composition": 0.0},
  201: {"mass": 200.97864, "composition": 0.0},
  202: {"mass": 201.98199, "composition": 0.0},
  203: {"mass": 202.98423, "composition": 0.0},
  204: {"mass": 203.9896, "composition": 0.0}},
 78: {166: {"mass": 165.99486, "composition": 0.0},
  167: {"mass": 166.99269, "composition": 0.0},
  168: {"mass": 167.98813, "composition": 0.0},
  169: {"mass": 168.98657, "composition": 0.0},
  170: {"mass": 169.982496, "composition": 0.0},
  171: {"mass": 170.981245, "composition": 0.0},
  172: {"mass": 171.977351, "composition": 0.0},
  173: {"mass": 172.976443, "composition": 0.0},
  174: {"mass": 173.97282, "composition": 0.0},
  175: {"mass": 174.97241, "composition": 0.0},
  176: {"mass": 175.968938, "composition": 0.0},
  177: {"mass": 176.96847, "composition": 0.0},
  178: {"mass": 177.96565, "composition": 0.0},
  179: {"mass": 178.965359, "composition": 0.0},
  180: {"mass": 179.963032, "composition": 0.0},
  181: {"mass": 180.963098, "composition": 0.0},
  182: {"mass": 181.961172, "composition": 0.0},
  183: {"mass": 182.961597, "composition": 0.0},
  184: {"mass": 183.959915, "composition": 0.0},
  185: {"mass": 184.960614, "composition": 0.0},
  186: {"mass": 185.959351, "composition": 0.0},
  187: {"mass": 186.960617, "composition": 0.0},
  188: {"mass": 187.9593889, "composition": 0.0},
  189: {"mass": 188.960831, "composition": 0.0},
  190: {"mass": 189.9599297, "composition": 0.00012},
  191: {"mass": 190.9616729, "composition": 0.0},
  192: {"mass": 191.9610387, "composition": 0.00782},
  193: {"mass": 192.9629824, "composition": 0.0},
  194: {"mass": 193.9626809, "composition": 0.3286},
  195: {"mass": 194.9647917, "composition": 0.3378},
  196: {"mass": 195.96495209, "composition": 0.2521},
  197: {"mass": 196.96734069, "composition": 0.0},
  198: {"mass": 197.9678949, "composition": 0.07356},
  199: {"mass": 198.9705952, "composition": 0.0},
  200: {"mass": 199.971443, "composition": 0.0},
  201: {"mass": 200.974513, "composition": 0.0},
  202: {"mass": 201.975639, "composition": 0.0},
  203: {"mass": 202.97893, "composition": 0.0},
  204: {"mass": 203.98076, "composition": 0.0},
  205: {"mass": 204.98608, "composition": 0.0},
  206: {"mass": 205.98966, "composition": 0.0}},
 79: {169: {"mass": 168.99808, "composition": 0.0},
  170: {"mass": 169.99597, "composition": 0.0},
  171: {"mass": 170.991876, "composition": 0.0},
  172: {"mass": 171.989942, "composition": 0.0},
  173: {"mass": 172.986241, "composition": 0.0},
  174: {"mass": 173.984717, "composition": 0.0},
  175: {"mass": 174.981304, "composition": 0.0},
  176: {"mass": 175.98025, "composition": 0.0},
  177: {"mass": 176.97687, "composition": 0.0},
  178: {"mass": 177.976032, "composition": 0.0},
  179: {"mass": 178.973174, "composition": 0.0},
  180: {"mass": 179.972523, "composition": 0.0},
  181: {"mass": 180.970079, "composition": 0.0},
  182: {"mass": 181.969618, "composition": 0.0},
  183: {"mass": 182.967591, "composition": 0.0},
  184: {"mass": 183.967452, "composition": 0.0},
  185: {"mass": 184.96579, "composition": 0.0},
  186: {"mass": 185.965953, "composition": 0.0},
  187: {"mass": 186.964543, "composition": 0.0},
  188: {"mass": 187.965349, "composition": 0.0},
  189: {"mass": 188.963948, "composition": 0.0},
  190: {"mass": 189.964698, "composition": 0.0},
  191: {"mass": 190.963702, "composition": 0.0},
  192: {"mass": 191.964814, "composition": 0.0},
  193: {"mass": 192.9641373, "composition": 0.0},
  194: {"mass": 193.9654178, "composition": 0.0},
  195: {"mass": 194.9650352, "composition": 0.0},
  196: {"mass": 195.9665699, "composition": 0.0},
  197: {"mass": 196.96656879, "composition": 1.0},
  198: {"mass": 197.96824242, "composition": 0.0},
  199: {"mass": 198.96876528, "composition": 0.0},
  200: {"mass": 199.970756, "composition": 0.0},
  201: {"mass": 200.9716575, "composition": 0.0},
  202: {"mass": 201.973856, "composition": 0.0},
  203: {"mass": 202.9751544, "composition": 0.0},
  204: {"mass": 203.97783, "composition": 0.0},
  205: {"mass": 204.97985, "composition": 0.0},
  206: {"mass": 205.98474, "composition": 0.0},
  207: {"mass": 206.9884, "composition": 0.0},
  208: {"mass": 207.99345, "composition": 0.0},
  209: {"mass": 208.99735, "composition": 0.0},
  210: {"mass": 210.0025, "composition": 0.0}},
 80: {171: {"mass": 171.00353, "composition": 0.0},
  172: {"mass": 171.99881, "composition": 0.0},
  173: {"mass": 172.99709, "composition": 0.0},
  174: {"mass": 173.992865, "composition": 0.0},
  175: {"mass": 174.991441, "composition": 0.0},
  176: {"mass": 175.987361, "composition": 0.0},
  177: {"mass": 176.986277, "composition": 0.0},
  178: {"mass": 177.982484, "composition": 0.0},
  179: {"mass": 178.981831, "composition": 0.0},
  180: {"mass": 179.97826, "composition": 0.0},
  181: {"mass": 180.977819, "composition": 0.0},
  182: {"mass": 181.974689, "composition": 0.0},
  183: {"mass": 182.9744448, "composition": 0.0},
  184: {"mass": 183.971714, "composition": 0.0},
  185: {"mass": 184.971899, "composition": 0.0},
  186: {"mass": 185.969362, "composition": 0.0},
  187: {"mass": 186.969814, "composition": 0.0},
  188: {"mass": 187.967567, "composition": 0.0},
  189: {"mass": 188.968195, "composition": 0.0},
  190: {"mass": 189.966323, "composition": 0.0},
  191: {"mass": 190.967157, "composition": 0.0},
  192: {"mass": 191.965635, "composition": 0.0},
  193: {"mass": 192.966653, "composition": 0.0},
  194: {"mass": 193.9654491, "composition": 0.0},
  195: {"mass": 194.966721, "composition": 0.0},
  196: {"mass": 195.9658326, "composition": 0.0015},
  197: {"mass": 196.9672128, "composition": 0.0},
  198: {"mass": 197.9667686, "composition": 0.0997},
  199: {"mass": 198.96828064, "composition": 0.1687},
  200: {"mass": 199.96832659, "composition": 0.231},
  201: {"mass": 200.97030284, "composition": 0.1318},
  202: {"mass": 201.9706434, "composition": 0.2986},
  203: {"mass": 202.9728728, "composition": 0.0},
  204: {"mass": 203.97349398, "composition": 0.0687},
  205: {"mass": 204.9760734, "composition": 0.0},
  206: {"mass": 205.977514, "composition": 0.0},
  207: {"mass": 206.9823, "composition": 0.0},
  208: {"mass": 207.985759, "composition": 0.0},
  209: {"mass": 208.99072, "composition": 0.0},
  210: {"mass": 209.99424, "composition": 0.0},
  211: {"mass": 210.99933, "composition": 0.0},
  212: {"mass": 212.00296, "composition": 0.0},
  213: {"mass": 213.00823, "composition": 0.0},
  214: {"mass": 214.012, "composition": 0.0},
  215: {"mass": 215.0174, "composition": 0.0},
  216: {"mass": 216.02132, "composition": 0.0}},
 81: {176: {"mass": 176.000624, "composition": 0.0},
  177: {"mass": 176.996431, "composition": 0.0},
  178: {"mass": 177.99485, "composition": 0.0},
  179: {"mass": 178.991111, "composition": 0.0},
  180: {"mass": 179.990057, "composition": 0.0},
  181: {"mass": 180.98626, "composition": 0.0},
  182: {"mass": 181.985713, "composition": 0.0},
  183: {"mass": 182.982193, "composition": 0.0},
  184: {"mass": 183.981886, "composition": 0.0},
  185: {"mass": 184.978789, "composition": 0.0},
  186: {"mass": 185.978651, "composition": 0.0},
  187: {"mass": 186.9759063, "composition": 0.0},
  188: {"mass": 187.976021, "composition": 0.0},
  189: {"mass": 188.973588, "composition": 0.0},
  190: {"mass": 189.973828, "composition": 0.0},
  191: {"mass": 190.9717842, "composition": 0.0},
  192: {"mass": 191.972225, "composition": 0.0},
  193: {"mass": 192.970502, "composition": 0.0},
  194: {"mass": 193.971081, "composition": 0.0},
  195: {"mass": 194.969774, "composition": 0.0},
  196: {"mass": 195.970481, "composition": 0.0},
  197: {"mass": 196.969576, "composition": 0.0},
  198: {"mass": 197.970483, "composition": 0.0},
  199: {"mass": 198.969877, "composition": 0.0},
  200: {"mass": 199.9709633, "composition": 0.0},
  201: {"mass": 200.970822, "composition": 0.0},
  202: {"mass": 201.972102, "composition": 0.0},
  203: {"mass": 202.9723446, "composition": 0.2952},
  204: {"mass": 203.9738639, "composition": 0.0},
  205: {"mass": 204.9744278, "composition": 0.7048},
  206: {"mass": 205.9761106, "composition": 0.0},
  207: {"mass": 206.9774197, "composition": 0.0},
  208: {"mass": 207.982019, "composition": 0.0},
  209: {"mass": 208.9853594, "composition": 0.0},
  210: {"mass": 209.990074, "composition": 0.0},
  211: {"mass": 210.993475, "composition": 0.0},
  212: {"mass": 211.99834, "composition": 0.0},
  213: {"mass": 213.001915, "composition": 0.0},
  214: {"mass": 214.00694, "composition": 0.0},
  215: {"mass": 215.01064, "composition": 0.0},
  216: {"mass": 216.0158, "composition": 0.0},
  217: {"mass": 217.01966, "composition": 0.0},
  218: {"mass": 218.02479, "composition": 0.0}},
 82: {178: {"mass": 178.003831, "composition": 0.0},
  179: {"mass": 179.002201, "composition": 0.0},
  180: {"mass": 179.997928, "composition": 0.0},
  181: {"mass": 180.996653, "composition": 0.0},
  182: {"mass": 181.992672, "composition": 0.0},
  183: {"mass": 182.991872, "composition": 0.0},
  184: {"mass": 183.988136, "composition": 0.0},
  185: {"mass": 184.98761, "composition": 0.0},
  186: {"mass": 185.984238, "composition": 0.0},
  187: {"mass": 186.9839109, "composition": 0.0},
  188: {"mass": 187.980875, "composition": 0.0},
  189: {"mass": 188.980807, "composition": 0.0},
  190: {"mass": 189.978082, "composition": 0.0},
  191: {"mass": 190.978276, "composition": 0.0},
  192: {"mass": 191.975775, "composition": 0.0},
  193: {"mass": 192.976173, "composition": 0.0},
  194: {"mass": 193.974012, "composition": 0.0},
  195: {"mass": 194.974543, "composition": 0.0},
  196: {"mass": 195.972774, "composition": 0.0},
  197: {"mass": 196.9734312, "composition": 0.0},
  198: {"mass": 197.972034, "composition": 0.0},
  199: {"mass": 198.972913, "composition": 0.0},
  200: {"mass": 199.971819, "composition": 0.0},
  201: {"mass": 200.972883, "composition": 0.0},
  202: {"mass": 201.972152, "composition": 0.0},
  203: {"mass": 202.9733911, "composition": 0.0},
  204: {"mass": 203.973044, "composition": 0.014},
  205: {"mass": 204.9744822, "composition": 0.0},
  206: {"mass": 205.9744657, "composition": 0.241},
  207: {"mass": 206.9758973, "composition": 0.221},
  208: {"mass": 207.9766525, "composition": 0.524},
  209: {"mass": 208.9810905, "composition": 0.0},
  210: {"mass": 209.9841889, "composition": 0.0},
  211: {"mass": 210.9887371, "composition": 0.0},
  212: {"mass": 211.9918977, "composition": 0.0},
  213: {"mass": 212.9965629, "composition": 0.0},
  214: {"mass": 213.9998059, "composition": 0.0},
  215: {"mass": 215.00474, "composition": 0.0},
  216: {"mass": 216.00803, "composition": 0.0},
  217: {"mass": 217.01314, "composition": 0.0},
  218: {"mass": 218.01659, "composition": 0.0},
  219: {"mass": 219.02177, "composition": 0.0},
  220: {"mass": 220.02541, "composition": 0.0}},
 83: {184: {"mass": 184.001275, "composition": 0.0},
  185: {"mass": 184.9976, "composition": 0.0},
  186: {"mass": 185.996644, "composition": 0.0},
  187: {"mass": 186.993147, "composition": 0.0},
  188: {"mass": 187.992287, "composition": 0.0},
  189: {"mass": 188.989195, "composition": 0.0},
  190: {"mass": 189.988622, "composition": 0.0},
  191: {"mass": 190.9857866, "composition": 0.0},
  192: {"mass": 191.985469, "composition": 0.0},
  193: {"mass": 192.98296, "composition": 0.0},
  194: {"mass": 193.982785, "composition": 0.0},
  195: {"mass": 194.9806488, "composition": 0.0},
  196: {"mass": 195.980667, "composition": 0.0},
  197: {"mass": 196.9788651, "composition": 0.0},
  198: {"mass": 197.979206, "composition": 0.0},
  199: {"mass": 198.977673, "composition": 0.0},
  200: {"mass": 199.978131, "composition": 0.0},
  201: {"mass": 200.97701, "composition": 0.0},
  202: {"mass": 201.977734, "composition": 0.0},
  203: {"mass": 202.976893, "composition": 0.0},
  204: {"mass": 203.9778361, "composition": 0.0},
  205: {"mass": 204.9773867, "composition": 0.0},
  206: {"mass": 205.9784993, "composition": 0.0},
  207: {"mass": 206.978471, "composition": 0.0},
  208: {"mass": 207.9797425, "composition": 0.0},
  209: {"mass": 208.9803991, "composition": 1.0},
  210: {"mass": 209.9841207, "composition": 0.0},
  211: {"mass": 210.9872697, "composition": 0.0},
  212: {"mass": 211.991286, "composition": 0.0},
  213: {"mass": 212.9943851, "composition": 0.0},
  214: {"mass": 213.998712, "composition": 0.0},
  215: {"mass": 215.00177, "composition": 0.0},
  216: {"mass": 216.006306, "composition": 0.0},
  217: {"mass": 217.009372, "composition": 0.0},
  218: {"mass": 218.014188, "composition": 0.0},
  219: {"mass": 219.01748, "composition": 0.0},
  220: {"mass": 220.02235, "composition": 0.0},
  221: {"mass": 221.02587, "composition": 0.0},
  222: {"mass": 222.03078, "composition": 0.0},
  223: {"mass": 223.0345, "composition": 0.0},
  224: {"mass": 224.03947, "composition": 0.0}},
 84: {186: {"mass": 186.004393, "composition": 0.0},
  187: {"mass": 187.003041, "composition": 0.0},
  188: {"mass": 187.999416, "composition": 0.0},
  189: {"mass": 188.998473, "composition": 0.0},
  190: {"mass": 189.995101, "composition": 0.0},
  191: {"mass": 190.9945585, "composition": 0.0},
  192: {"mass": 191.991336, "composition": 0.0},
  193: {"mass": 192.991026, "composition": 0.0},
  194: {"mass": 193.988186, "composition": 0.0},
  195: {"mass": 194.988126, "composition": 0.0},
  196: {"mass": 195.985526, "composition": 0.0},
  197: {"mass": 196.98566, "composition": 0.0},
  198: {"mass": 197.983389, "composition": 0.0},
  199: {"mass": 198.983667, "composition": 0.0},
  200: {"mass": 199.981799, "composition": 0.0},
  201: {"mass": 200.9822598, "composition": 0.0},
  202: {"mass": 201.980758, "composition": 0.0},
  203: {"mass": 202.9814161, "composition": 0.0},
  204: {"mass": 203.98031, "composition": 0.0},
  205: {"mass": 204.981203, "composition": 0.0},
  206: {"mass": 205.980474, "composition": 0.0},
  207: {"mass": 206.9815938, "composition": 0.0},
  208: {"mass": 207.9812461, "composition": 0.0},
  209: {"mass": 208.9824308, "composition": 0.0},
  210: {"mass": 209.9828741, "composition": 0.0},
  211: {"mass": 210.9866536, "composition": 0.0},
  212: {"mass": 211.9888684, "composition": 0.0},
  213: {"mass": 212.9928576, "composition": 0.0},
  214: {"mass": 213.9952017, "composition": 0.0},
  215: {"mass": 214.9994201, "composition": 0.0},
  216: {"mass": 216.0019152, "composition": 0.0},
  217: {"mass": 217.0063182, "composition": 0.0},
  218: {"mass": 218.0089735, "composition": 0.0},
  219: {"mass": 219.013614, "composition": 0.0},
  220: {"mass": 220.016386, "composition": 0.0},
  221: {"mass": 221.021228, "composition": 0.0},
  222: {"mass": 222.02414, "composition": 0.0},
  223: {"mass": 223.02907, "composition": 0.0},
  224: {"mass": 224.03211, "composition": 0.0},
  225: {"mass": 225.03707, "composition": 0.0},
  226: {"mass": 226.04031, "composition": 0.0},
  227: {"mass": 227.04539, "composition": 0.0}},
 85: {191: {"mass": 191.004148, "composition": 0.0},
  192: {"mass": 192.003152, "composition": 0.0},
  193: {"mass": 192.999927, "composition": 0.0},
  194: {"mass": 193.999236, "composition": 0.0},
  195: {"mass": 194.9962685, "composition": 0.0},
  196: {"mass": 195.9958, "composition": 0.0},
  197: {"mass": 196.993189, "composition": 0.0},
  198: {"mass": 197.992784, "composition": 0.0},
  199: {"mass": 198.9905277, "composition": 0.0},
  200: {"mass": 199.990351, "composition": 0.0},
  201: {"mass": 200.9884171, "composition": 0.0},
  202: {"mass": 201.98863, "composition": 0.0},
  203: {"mass": 202.986943, "composition": 0.0},
  204: {"mass": 203.987251, "composition": 0.0},
  205: {"mass": 204.986076, "composition": 0.0},
  206: {"mass": 205.986657, "composition": 0.0},
  207: {"mass": 206.9858, "composition": 0.0},
  208: {"mass": 207.9866133, "composition": 0.0},
  209: {"mass": 208.9861702, "composition": 0.0},
  210: {"mass": 209.9871479, "composition": 0.0},
  211: {"mass": 210.9874966, "composition": 0.0},
  212: {"mass": 211.9907377, "composition": 0.0},
  213: {"mass": 212.992937, "composition": 0.0},
  214: {"mass": 213.9963721, "composition": 0.0},
  215: {"mass": 214.9986528, "composition": 0.0},
  216: {"mass": 216.0024236, "composition": 0.0},
  217: {"mass": 217.0047192, "composition": 0.0},
  218: {"mass": 218.008695, "composition": 0.0},
  219: {"mass": 219.0111618, "composition": 0.0},
  220: {"mass": 220.015433, "composition": 0.0},
  221: {"mass": 221.018017, "composition": 0.0},
  222: {"mass": 222.022494, "composition": 0.0},
  223: {"mass": 223.025151, "composition": 0.0},
  224: {"mass": 224.029749, "composition": 0.0},
  225: {"mass": 225.03263, "composition": 0.0},
  226: {"mass": 226.03716, "composition": 0.0},
  227: {"mass": 227.04024, "composition": 0.0},
  228: {"mass": 228.04475, "composition": 0.0},
  229: {"mass": 229.04812, "composition": 0.0}},
 86: {193: {"mass": 193.009708, "composition": 0.0},
  194: {"mass": 194.006144, "composition": 0.0},
  195: {"mass": 195.005422, "composition": 0.0},
  196: {"mass": 196.002116, "composition": 0.0},
  197: {"mass": 197.001585, "composition": 0.0},
  198: {"mass": 197.998679, "composition": 0.0},
  199: {"mass": 198.99839, "composition": 0.0},
  200: {"mass": 199.99569, "composition": 0.0},
  201: {"mass": 200.995628, "composition": 0.0},
  202: {"mass": 201.993264, "composition": 0.0},
  203: {"mass": 202.993388, "composition": 0.0},
  204: {"mass": 203.99143, "composition": 0.0},
  205: {"mass": 204.991719, "composition": 0.0},
  206: {"mass": 205.990214, "composition": 0.0},
  207: {"mass": 206.9907303, "composition": 0.0},
  208: {"mass": 207.989635, "composition": 0.0},
  209: {"mass": 208.990415, "composition": 0.0},
  210: {"mass": 209.9896891, "composition": 0.0},
  211: {"mass": 210.9906011, "composition": 0.0},
  212: {"mass": 211.9907039, "composition": 0.0},
  213: {"mass": 212.9938831, "composition": 0.0},
  214: {"mass": 213.995363, "composition": 0.0},
  215: {"mass": 214.9987459, "composition": 0.0},
  216: {"mass": 216.0002719, "composition": 0.0},
  217: {"mass": 217.003928, "composition": 0.0},
  218: {"mass": 218.0056016, "composition": 0.0},
  219: {"mass": 219.0094804, "composition": 0.0},
  220: {"mass": 220.0113941, "composition": 0.0},
  221: {"mass": 221.0155371, "composition": 0.0},
  222: {"mass": 222.0175782, "composition": 0.0},
  223: {"mass": 223.0218893, "composition": 0.0},
  224: {"mass": 224.024096, "composition": 0.0},
  225: {"mass": 225.028486, "composition": 0.0},
  226: {"mass": 226.030861, "composition": 0.0},
  227: {"mass": 227.035304, "composition": 0.0},
  228: {"mass": 228.037835, "composition": 0.0},
  229: {"mass": 229.042257, "composition": 0.0},
  230: {"mass": 230.04514, "composition": 0.0},
  231: {"mass": 231.04987, "composition": 0.0}},
 87: {199: {"mass": 199.007259, "composition": 0.0},
  200: {"mass": 200.006586, "composition": 0.0},
  201: {"mass": 201.003867, "composition": 0.0},
  202: {"mass": 202.00332, "composition": 0.0},
  203: {"mass": 203.0009407, "composition": 0.0},
  204: {"mass": 204.000652, "composition": 0.0},
  205: {"mass": 204.9985939, "composition": 0.0},
  206: {"mass": 205.998666, "composition": 0.0},
  207: {"mass": 206.996946, "composition": 0.0},
  208: {"mass": 207.997138, "composition": 0.0},
  209: {"mass": 208.995955, "composition": 0.0},
  210: {"mass": 209.996422, "composition": 0.0},
  211: {"mass": 210.995556, "composition": 0.0},
  212: {"mass": 211.9962257, "composition": 0.0},
  213: {"mass": 212.996186, "composition": 0.0},
  214: {"mass": 213.9989713, "composition": 0.0},
  215: {"mass": 215.0003418, "composition": 0.0},
  216: {"mass": 216.0031899, "composition": 0.0},
  217: {"mass": 217.0046323, "composition": 0.0},
  218: {"mass": 218.0075787, "composition": 0.0},
  219: {"mass": 219.0092524, "composition": 0.0},
  220: {"mass": 220.0123277, "composition": 0.0},
  221: {"mass": 221.0142552, "composition": 0.0},
  222: {"mass": 222.017552, "composition": 0.0},
  223: {"mass": 223.019736, "composition": 0.0},
  224: {"mass": 224.023398, "composition": 0.0},
  225: {"mass": 225.025573, "composition": 0.0},
  226: {"mass": 226.029566, "composition": 0.0},
  227: {"mass": 227.031869, "composition": 0.0},
  228: {"mass": 228.035823, "composition": 0.0},
  229: {"mass": 229.038298, "composition": 0.0},
  230: {"mass": 230.042416, "composition": 0.0},
  231: {"mass": 231.045158, "composition": 0.0},
  232: {"mass": 232.04937, "composition": 0.0},
  233: {"mass": 233.05264, "composition": 0.0}},
 88: {201: {"mass": 201.01271, "composition": 0.0},
  202: {"mass": 202.00976, "composition": 0.0},
  203: {"mass": 203.009304, "composition": 0.0},
  204: {"mass": 204.006492, "composition": 0.0},
  205: {"mass": 205.006268, "composition": 0.0},
  206: {"mass": 206.003828, "composition": 0.0},
  207: {"mass": 207.003799, "composition": 0.0},
  208: {"mass": 208.001841, "composition": 0.0},
  209: {"mass": 209.00199, "composition": 0.0},
  210: {"mass": 210.000494, "composition": 0.0},
  211: {"mass": 211.0008932, "composition": 0.0},
  212: {"mass": 211.999787, "composition": 0.0},
  213: {"mass": 213.000384, "composition": 0.0},
  214: {"mass": 214.0000997, "composition": 0.0},
  215: {"mass": 215.0027204, "composition": 0.0},
  216: {"mass": 216.0035334, "composition": 0.0},
  217: {"mass": 217.0063207, "composition": 0.0},
  218: {"mass": 218.007141, "composition": 0.0},
  219: {"mass": 219.0100855, "composition": 0.0},
  220: {"mass": 220.0110259, "composition": 0.0},
  221: {"mass": 221.0139177, "composition": 0.0},
  222: {"mass": 222.0153748, "composition": 0.0},
  223: {"mass": 223.0185023, "composition": 0.0},
  224: {"mass": 224.020212, "composition": 0.0},
  225: {"mass": 225.0236119, "composition": 0.0},
  226: {"mass": 226.0254103, "composition": 0.0},
  227: {"mass": 227.0291783, "composition": 0.0},
  228: {"mass": 228.0310707, "composition": 0.0},
  229: {"mass": 229.034942, "composition": 0.0},
  230: {"mass": 230.037055, "composition": 0.0},
  231: {"mass": 231.041027, "composition": 0.0},
  232: {"mass": 232.0434753, "composition": 0.0},
  233: {"mass": 233.047582, "composition": 0.0},
  234: {"mass": 234.050342, "composition": 0.0},
  235: {"mass": 235.05497, "composition": 0.0}},
 89: {206: {"mass": 206.014452, "composition": 0.0},
  207: {"mass": 207.011966, "composition": 0.0},
  208: {"mass": 208.01155, "composition": 0.0},
  209: {"mass": 209.009495, "composition": 0.0},
  210: {"mass": 210.009436, "composition": 0.0},
  211: {"mass": 211.007732, "composition": 0.0},
  212: {"mass": 212.007813, "composition": 0.0},
  213: {"mass": 213.006609, "composition": 0.0},
  214: {"mass": 214.006918, "composition": 0.0},
  215: {"mass": 215.006475, "composition": 0.0},
  216: {"mass": 216.008743, "composition": 0.0},
  217: {"mass": 217.009344, "composition": 0.0},
  218: {"mass": 218.011642, "composition": 0.0},
  219: {"mass": 219.012421, "composition": 0.0},
  220: {"mass": 220.0147549, "composition": 0.0},
  221: {"mass": 221.015592, "composition": 0.0},
  222: {"mass": 222.0178442, "composition": 0.0},
  223: {"mass": 223.0191377, "composition": 0.0},
  224: {"mass": 224.0217232, "composition": 0.0},
  225: {"mass": 225.02323, "composition": 0.0},
  226: {"mass": 226.0260984, "composition": 0.0},
  227: {"mass": 227.0277523, "composition": 0.0},
  228: {"mass": 228.0310215, "composition": 0.0},
  229: {"mass": 229.032956, "composition": 0.0},
  230: {"mass": 230.036327, "composition": 0.0},
  231: {"mass": 231.038393, "composition": 0.0},
  232: {"mass": 232.042034, "composition": 0.0},
  233: {"mass": 233.044346, "composition": 0.0},
  234: {"mass": 234.048139, "composition": 0.0},
  235: {"mass": 235.05084, "composition": 0.0},
  236: {"mass": 236.054988, "composition": 0.0},
  237: {"mass": 237.05827, "composition": 0.0}},
 90: {208: {"mass": 208.0179, "composition": 0.0},
  209: {"mass": 209.017753, "composition": 0.0},
  210: {"mass": 210.015094, "composition": 0.0},
  211: {"mass": 211.014929, "composition": 0.0},
  212: {"mass": 212.012988, "composition": 0.0},
  213: {"mass": 213.013009, "composition": 0.0},
  214: {"mass": 214.0115, "composition": 0.0},
  215: {"mass": 215.0117248, "composition": 0.0},
  216: {"mass": 216.011056, "composition": 0.0},
  217: {"mass": 217.013117, "composition": 0.0},
  218: {"mass": 218.013276, "composition": 0.0},
  219: {"mass": 219.015537, "composition": 0.0},
  220: {"mass": 220.015748, "composition": 0.0},
  221: {"mass": 221.018184, "composition": 0.0},
  222: {"mass": 222.018469, "composition": 0.0},
  223: {"mass": 223.0208119, "composition": 0.0},
  224: {"mass": 224.021464, "composition": 0.0},
  225: {"mass": 225.0239514, "composition": 0.0},
  226: {"mass": 226.0249034, "composition": 0.0},
  227: {"mass": 227.0277042, "composition": 0.0},
  228: {"mass": 228.0287413, "composition": 0.0},
  229: {"mass": 229.0317627, "composition": 0.0},
  230: {"mass": 230.0331341, "composition": 0.0},
  231: {"mass": 231.0363046, "composition": 0.0},
  232: {"mass": 232.0380558, "composition": 1.0},
  233: {"mass": 233.0415823, "composition": 0.0},
  234: {"mass": 234.0436014, "composition": 0.0},
  235: {"mass": 235.047255, "composition": 0.0},
  236: {"mass": 236.049657, "composition": 0.0},
  237: {"mass": 237.053629, "composition": 0.0},
  238: {"mass": 238.0565, "composition": 0.0},
  239: {"mass": 239.06077, "composition": 0.0}},
 91: {212: {"mass": 212.023203, "composition": 0.0},
  213: {"mass": 213.021109, "composition": 0.0},
  214: {"mass": 214.020918, "composition": 0.0},
  215: {"mass": 215.019183, "composition": 0.0},
  216: {"mass": 216.019109, "composition": 0.0},
  217: {"mass": 217.018325, "composition": 0.0},
  218: {"mass": 218.020059, "composition": 0.0},
  219: {"mass": 219.019904, "composition": 0.0},
  220: {"mass": 220.021705, "composition": 0.0},
  221: {"mass": 221.021875, "composition": 0.0},
  222: {"mass": 222.023784, "composition": 0.0},
  223: {"mass": 223.023963, "composition": 0.0},
  224: {"mass": 224.0256176, "composition": 0.0},
  225: {"mass": 225.026131, "composition": 0.0},
  226: {"mass": 226.027948, "composition": 0.0},
  227: {"mass": 227.0288054, "composition": 0.0},
  228: {"mass": 228.0310517, "composition": 0.0},
  229: {"mass": 229.0320972, "composition": 0.0},
  230: {"mass": 230.034541, "composition": 0.0},
  231: {"mass": 231.0358842, "composition": 1.0},
  232: {"mass": 232.0385917, "composition": 0.0},
  233: {"mass": 233.0402472, "composition": 0.0},
  234: {"mass": 234.0433072, "composition": 0.0},
  235: {"mass": 235.045399, "composition": 0.0},
  236: {"mass": 236.048668, "composition": 0.0},
  237: {"mass": 237.051023, "composition": 0.0},
  238: {"mass": 238.054637, "composition": 0.0},
  239: {"mass": 239.05726, "composition": 0.0},
  240: {"mass": 240.06098, "composition": 0.0},
  241: {"mass": 241.06408, "composition": 0.0}},
 92: {217: {"mass": 217.02466, "composition": 0.0},
  218: {"mass": 218.023523, "composition": 0.0},
  219: {"mass": 219.024999, "composition": 0.0},
  220: {"mass": 220.02462, "composition": 0.0},
  221: {"mass": 221.02628, "composition": 0.0},
  222: {"mass": 222.026, "composition": 0.0},
  223: {"mass": 223.027739, "composition": 0.0},
  224: {"mass": 224.027605, "composition": 0.0},
  225: {"mass": 225.029391, "composition": 0.0},
  226: {"mass": 226.029339, "composition": 0.0},
  227: {"mass": 227.031157, "composition": 0.0},
  228: {"mass": 228.031371, "composition": 0.0},
  229: {"mass": 229.0335063, "composition": 0.0},
  230: {"mass": 230.0339401, "composition": 0.0},
  231: {"mass": 231.0362939, "composition": 0.0},
  232: {"mass": 232.0371563, "composition": 0.0},
  233: {"mass": 233.0396355, "composition": 0.0},
  234: {"mass": 234.0409523, "composition": 5.4e-05},
  235: {"mass": 235.0439301, "composition": 0.007204},
  236: {"mass": 236.0455682, "composition": 0.0},
  237: {"mass": 237.0487304, "composition": 0.0},
  238: {"mass": 238.0507884, "composition": 0.992742},
  239: {"mass": 239.0542935, "composition": 0.0},
  240: {"mass": 240.0565934, "composition": 0.0},
  241: {"mass": 241.06033, "composition": 0.0},
  242: {"mass": 242.06293, "composition": 0.0},
  243: {"mass": 243.06699, "composition": 0.0}},
 93: {219: {"mass": 219.03143, "composition": 0.0},
  220: {"mass": 220.03254, "composition": 0.0},
  221: {"mass": 221.03204, "composition": 0.0},
  222: {"mass": 222.0333, "composition": 0.0},
  223: {"mass": 223.03285, "composition": 0.0},
  224: {"mass": 224.03422, "composition": 0.0},
  225: {"mass": 225.033911, "composition": 0.0},
  226: {"mass": 226.035188, "composition": 0.0},
  227: {"mass": 227.034957, "composition": 0.0},
  228: {"mass": 228.036067, "composition": 0.0},
  229: {"mass": 229.036264, "composition": 0.0},
  230: {"mass": 230.037828, "composition": 0.0},
  231: {"mass": 231.038245, "composition": 0.0},
  232: {"mass": 232.04011, "composition": 0.0},
  233: {"mass": 233.040741, "composition": 0.0},
  234: {"mass": 234.0428953, "composition": 0.0},
  235: {"mass": 235.0440635, "composition": 0.0},
  236: {"mass": 236.04657, "composition": 0.0},
  237: {"mass": 237.0481736, "composition": 0.0},
  238: {"mass": 238.0509466, "composition": 0.0},
  239: {"mass": 239.0529392, "composition": 0.0},
  240: {"mass": 240.056165, "composition": 0.0},
  241: {"mass": 241.058253, "composition": 0.0},
  242: {"mass": 242.06164, "composition": 0.0},
  243: {"mass": 243.06428, "composition": 0.0},
  244: {"mass": 244.06785, "composition": 0.0},
  245: {"mass": 245.0708, "composition": 0.0}},
 94: {228: {"mass": 228.038732, "composition": 0.0},
  229: {"mass": 229.040144, "composition": 0.0},
  230: {"mass": 230.03965, "composition": 0.0},
  231: {"mass": 231.041102, "composition": 0.0},
  232: {"mass": 232.041185, "composition": 0.0},
  233: {"mass": 233.042998, "composition": 0.0},
  234: {"mass": 234.0433174, "composition": 0.0},
  235: {"mass": 235.045286, "composition": 0.0},
  236: {"mass": 236.0460581, "composition": 0.0},
  237: {"mass": 237.0484098, "composition": 0.0},
  238: {"mass": 238.0495601, "composition": 0.0},
  239: {"mass": 239.0521636, "composition": 0.0},
  240: {"mass": 240.0538138, "composition": 0.0},
  241: {"mass": 241.0568517, "composition": 0.0},
  242: {"mass": 242.0587428, "composition": 0.0},
  243: {"mass": 243.0620036, "composition": 0.0},
  244: {"mass": 244.0642053, "composition": 0.0},
  245: {"mass": 245.067826, "composition": 0.0},
  246: {"mass": 246.070205, "composition": 0.0},
  247: {"mass": 247.07419, "composition": 0.0}},
 95: {230: {"mass": 230.04609, "composition": 0.0},
  231: {"mass": 231.04556, "composition": 0.0},
  232: {"mass": 232.04645, "composition": 0.0},
  233: {"mass": 233.04644, "composition": 0.0},
  234: {"mass": 234.04773, "composition": 0.0},
  235: {"mass": 235.047908, "composition": 0.0},
  236: {"mass": 236.04943, "composition": 0.0},
  237: {"mass": 237.049996, "composition": 0.0},
  238: {"mass": 238.051985, "composition": 0.0},
  239: {"mass": 239.0530247, "composition": 0.0},
  240: {"mass": 240.0553, "composition": 0.0},
  241: {"mass": 241.0568293, "composition": 0.0},
  242: {"mass": 242.0595494, "composition": 0.0},
  243: {"mass": 243.0613813, "composition": 0.0},
  244: {"mass": 244.0642851, "composition": 0.0},
  245: {"mass": 245.0664548, "composition": 0.0},
  246: {"mass": 246.069775, "composition": 0.0},
  247: {"mass": 247.07209, "composition": 0.0},
  248: {"mass": 248.07575, "composition": 0.0},
  249: {"mass": 249.07848, "composition": 0.0}},
 96: {232: {"mass": 232.04982, "composition": 0.0},
  233: {"mass": 233.05077, "composition": 0.0},
  234: {"mass": 234.05016, "composition": 0.0},
  235: {"mass": 235.05154, "composition": 0.0},
  236: {"mass": 236.051374, "composition": 0.0},
  237: {"mass": 237.052869, "composition": 0.0},
  238: {"mass": 238.053081, "composition": 0.0},
  239: {"mass": 239.05491, "composition": 0.0},
  240: {"mass": 240.0555297, "composition": 0.0},
  241: {"mass": 241.0576532, "composition": 0.0},
  242: {"mass": 242.058836, "composition": 0.0},
  243: {"mass": 243.0613893, "composition": 0.0},
  244: {"mass": 244.0627528, "composition": 0.0},
  245: {"mass": 245.0654915, "composition": 0.0},
  246: {"mass": 246.0672238, "composition": 0.0},
  247: {"mass": 247.0703541, "composition": 0.0},
  248: {"mass": 248.0723499, "composition": 0.0},
  249: {"mass": 249.0759548, "composition": 0.0},
  250: {"mass": 250.078358, "composition": 0.0},
  251: {"mass": 251.082286, "composition": 0.0},
  252: {"mass": 252.08487, "composition": 0.0}},
 97: {234: {"mass": 234.05727, "composition": 0.0},
  235: {"mass": 235.05658, "composition": 0.0},
  236: {"mass": 236.05748, "composition": 0.0},
  237: {"mass": 237.0571, "composition": 0.0},
  238: {"mass": 238.0582, "composition": 0.0},
  239: {"mass": 239.05824, "composition": 0.0},
  240: {"mass": 240.05976, "composition": 0.0},
  241: {"mass": 241.06016, "composition": 0.0},
  242: {"mass": 242.06198, "composition": 0.0},
  243: {"mass": 243.0630078, "composition": 0.0},
  244: {"mass": 244.065181, "composition": 0.0},
  245: {"mass": 245.0663618, "composition": 0.0},
  246: {"mass": 246.068673, "composition": 0.0},
  247: {"mass": 247.0703073, "composition": 0.0},
  248: {"mass": 248.073088, "composition": 0.0},
  249: {"mass": 249.0749877, "composition": 0.0},
  250: {"mass": 250.0783167, "composition": 0.0},
  251: {"mass": 251.080762, "composition": 0.0},
  252: {"mass": 252.08431, "composition": 0.0},
  253: {"mass": 253.08688, "composition": 0.0},
  254: {"mass": 254.0906, "composition": 0.0}},
 98: {237: {"mass": 237.062198, "composition": 0.0},
  238: {"mass": 238.06149, "composition": 0.0},
  239: {"mass": 239.06253, "composition": 0.0},
  240: {"mass": 240.062256, "composition": 0.0},
  241: {"mass": 241.06369, "composition": 0.0},
  242: {"mass": 242.063754, "composition": 0.0},
  243: {"mass": 243.06548, "composition": 0.0},
  244: {"mass": 244.0660008, "composition": 0.0},
  245: {"mass": 245.0680487, "composition": 0.0},
  246: {"mass": 246.0688055, "composition": 0.0},
  247: {"mass": 247.070965, "composition": 0.0},
  248: {"mass": 248.0721851, "composition": 0.0},
  249: {"mass": 249.0748539, "composition": 0.0},
  250: {"mass": 250.0764062, "composition": 0.0},
  251: {"mass": 251.0795886, "composition": 0.0},
  252: {"mass": 252.0816272, "composition": 0.0},
  253: {"mass": 253.0851345, "composition": 0.0},
  254: {"mass": 254.087324, "composition": 0.0},
  255: {"mass": 255.09105, "composition": 0.0},
  256: {"mass": 256.09344, "composition": 0.0}},
 99: {239: {"mass": 239.06823, "composition": 0.0},
  240: {"mass": 240.06892, "composition": 0.0},
  241: {"mass": 241.06856, "composition": 0.0},
  242: {"mass": 242.06957, "composition": 0.0},
  243: {"mass": 243.06951, "composition": 0.0},
  244: {"mass": 244.07088, "composition": 0.0},
  245: {"mass": 245.07125, "composition": 0.0},
  246: {"mass": 246.0729, "composition": 0.0},
  247: {"mass": 247.073622, "composition": 0.0},
  248: {"mass": 248.075471, "composition": 0.0},
  249: {"mass": 249.076411, "composition": 0.0},
  250: {"mass": 250.07861, "composition": 0.0},
  251: {"mass": 251.0799936, "composition": 0.0},
  252: {"mass": 252.08298, "composition": 0.0},
  253: {"mass": 253.0848257, "composition": 0.0},
  254: {"mass": 254.0880222, "composition": 0.0},
  255: {"mass": 255.090275, "composition": 0.0},
  256: {"mass": 256.0936, "composition": 0.0},
  257: {"mass": 257.09598, "composition": 0.0},
  258: {"mass": 258.09952, "composition": 0.0}},
 100: {241: {"mass": 241.07421, "composition": 0.0},
  242: {"mass": 242.07343, "composition": 0.0},
  243: {"mass": 243.07446, "composition": 0.0},
  244: {"mass": 244.07404, "composition": 0.0},
  245: {"mass": 245.07535, "composition": 0.0},
  246: {"mass": 246.07535, "composition": 0.0},
  247: {"mass": 247.07694, "composition": 0.0},
  248: {"mass": 248.0771865, "composition": 0.0},
  249: {"mass": 249.0789275, "composition": 0.0},
  250: {"mass": 250.079521, "composition": 0.0},
  251: {"mass": 251.08154, "composition": 0.0},
  252: {"mass": 252.0824671, "composition": 0.0},
  253: {"mass": 253.0851846, "composition": 0.0},
  254: {"mass": 254.0868544, "composition": 0.0},
  255: {"mass": 255.089964, "composition": 0.0},
  256: {"mass": 256.0917745, "composition": 0.0},
  257: {"mass": 257.0951061, "composition": 0.0},
  258: {"mass": 258.09708, "composition": 0.0},
  259: {"mass": 259.1006, "composition": 0.0},
  260: {"mass": 260.10281, "composition": 0.0}},
 101: {245: {"mass": 245.08081, "composition": 0.0},
  246: {"mass": 246.08171, "composition": 0.0},
  247: {"mass": 247.08152, "composition": 0.0},
  248: {"mass": 248.08282, "composition": 0.0},
  249: {"mass": 249.08291, "composition": 0.0},
  250: {"mass": 250.08441, "composition": 0.0},
  251: {"mass": 251.084774, "composition": 0.0},
  252: {"mass": 252.08643, "composition": 0.0},
  253: {"mass": 253.087144, "composition": 0.0},
  254: {"mass": 254.08959, "composition": 0.0},
  255: {"mass": 255.0910841, "composition": 0.0},
  256: {"mass": 256.09389, "composition": 0.0},
  257: {"mass": 257.0955424, "composition": 0.0},
  258: {"mass": 258.0984315, "composition": 0.0},
  259: {"mass": 259.10051, "composition": 0.0},
  260: {"mass": 260.10365, "composition": 0.0},
  261: {"mass": 261.10583, "composition": 0.0},
  262: {"mass": 262.1091, "composition": 0.0}},
 102: {248: {"mass": 248.08655, "composition": 0.0},
  249: {"mass": 249.0878, "composition": 0.0},
  250: {"mass": 250.08756, "composition": 0.0},
  251: {"mass": 251.08894, "composition": 0.0},
  252: {"mass": 252.088967, "composition": 0.0},
  253: {"mass": 253.0905641, "composition": 0.0},
  254: {"mass": 254.090956, "composition": 0.0},
  255: {"mass": 255.093191, "composition": 0.0},
  256: {"mass": 256.0942829, "composition": 0.0},
  257: {"mass": 257.0968878, "composition": 0.0},
  258: {"mass": 258.09821, "composition": 0.0},
  259: {"mass": 259.10103, "composition": 0.0},
  260: {"mass": 260.10264, "composition": 0.0},
  261: {"mass": 261.1057, "composition": 0.0},
  262: {"mass": 262.10746, "composition": 0.0},
  263: {"mass": 263.11071, "composition": 0.0},
  264: {"mass": 264.11273, "composition": 0.0}},
 103: {251: {"mass": 251.09418, "composition": 0.0},
  252: {"mass": 252.09526, "composition": 0.0},
  253: {"mass": 253.09509, "composition": 0.0},
  254: {"mass": 254.09648, "composition": 0.0},
  255: {"mass": 255.096562, "composition": 0.0},
  256: {"mass": 256.098494, "composition": 0.0},
  257: {"mass": 257.099418, "composition": 0.0},
  258: {"mass": 258.10176, "composition": 0.0},
  259: {"mass": 259.102902, "composition": 0.0},
  260: {"mass": 260.1055, "composition": 0.0},
  261: {"mass": 261.10688, "composition": 0.0},
  262: {"mass": 262.10961, "composition": 0.0},
  263: {"mass": 263.11136, "composition": 0.0},
  264: {"mass": 264.1142, "composition": 0.0},
  265: {"mass": 265.11619, "composition": 0.0},
  266: {"mass": 266.11983, "composition": 0.0}},
 104: {253: {"mass": 253.10044, "composition": 0.0},
  254: {"mass": 254.10005, "composition": 0.0},
  255: {"mass": 255.10127, "composition": 0.0},
  256: {"mass": 256.101152, "composition": 0.0},
  257: {"mass": 257.102918, "composition": 0.0},
  258: {"mass": 258.103428, "composition": 0.0},
  259: {"mass": 259.105596, "composition": 0.0},
  260: {"mass": 260.10644, "composition": 0.0},
  261: {"mass": 261.108773, "composition": 0.0},
  262: {"mass": 262.10992, "composition": 0.0},
  263: {"mass": 263.11249, "composition": 0.0},
  264: {"mass": 264.11388, "composition": 0.0},
  265: {"mass": 265.11668, "composition": 0.0},
  266: {"mass": 266.11817, "composition": 0.0},
  267: {"mass": 267.12179, "composition": 0.0},
  268: {"mass": 268.12397, "composition": 0.0}},
 105: {255: {"mass": 255.10707, "composition": 0.0},
  256: {"mass": 256.10789, "composition": 0.0},
  257: {"mass": 257.10758, "composition": 0.0},
  258: {"mass": 258.10928, "composition": 0.0},
  259: {"mass": 259.109492, "composition": 0.0},
  260: {"mass": 260.1113, "composition": 0.0},
  261: {"mass": 261.11192, "composition": 0.0},
  262: {"mass": 262.11407, "composition": 0.0},
  263: {"mass": 263.11499, "composition": 0.0},
  264: {"mass": 264.11741, "composition": 0.0},
  265: {"mass": 265.11861, "composition": 0.0},
  266: {"mass": 266.12103, "composition": 0.0},
  267: {"mass": 267.12247, "composition": 0.0},
  268: {"mass": 268.12567, "composition": 0.0},
  269: {"mass": 269.12791, "composition": 0.0},
  270: {"mass": 270.13136, "composition": 0.0}},
 106: {258: {"mass": 258.11298, "composition": 0.0},
  259: {"mass": 259.1144, "composition": 0.0},
  260: {"mass": 260.114384, "composition": 0.0},
  261: {"mass": 261.115949, "composition": 0.0},
  262: {"mass": 262.116337, "composition": 0.0},
  263: {"mass": 263.11829, "composition": 0.0},
  264: {"mass": 264.11893, "composition": 0.0},
  265: {"mass": 265.12109, "composition": 0.0},
  266: {"mass": 266.12198, "composition": 0.0},
  267: {"mass": 267.12436, "composition": 0.0},
  268: {"mass": 268.12539, "composition": 0.0},
  269: {"mass": 269.12863, "composition": 0.0},
  270: {"mass": 270.13043, "composition": 0.0},
  271: {"mass": 271.13393, "composition": 0.0},
  272: {"mass": 272.13589, "composition": 0.0},
  273: {"mass": 273.13958, "composition": 0.0}},
 107: {260: {"mass": 260.12166, "composition": 0.0},
  261: {"mass": 261.12145, "composition": 0.0},
  262: {"mass": 262.12297, "composition": 0.0},
  263: {"mass": 263.12292, "composition": 0.0},
  264: {"mass": 264.12459, "composition": 0.0},
  265: {"mass": 265.12491, "composition": 0.0},
  266: {"mass": 266.12679, "composition": 0.0},
  267: {"mass": 267.1275, "composition": 0.0},
  268: {"mass": 268.12969, "composition": 0.0},
  269: {"mass": 269.13042, "composition": 0.0},
  270: {"mass": 270.13336, "composition": 0.0},
  271: {"mass": 271.13526, "composition": 0.0},
  272: {"mass": 272.13826, "composition": 0.0},
  273: {"mass": 273.14024, "composition": 0.0},
  274: {"mass": 274.14355, "composition": 0.0},
  275: {"mass": 275.14567, "composition": 0.0}},
 108: {263: {"mass": 263.12852, "composition": 0.0},
  264: {"mass": 264.128357, "composition": 0.0},
  265: {"mass": 265.129793, "composition": 0.0},
  266: {"mass": 266.130046, "composition": 0.0},
  267: {"mass": 267.13167, "composition": 0.0},
  268: {"mass": 268.13186, "composition": 0.0},
  269: {"mass": 269.13375, "composition": 0.0},
  270: {"mass": 270.13429, "composition": 0.0},
  271: {"mass": 271.13717, "composition": 0.0},
  272: {"mass": 272.1385, "composition": 0.0},
  273: {"mass": 273.14168, "composition": 0.0},
  274: {"mass": 274.1433, "composition": 0.0},
  275: {"mass": 275.14667, "composition": 0.0},
  276: {"mass": 276.14846, "composition": 0.0},
  277: {"mass": 277.1519, "composition": 0.0}},
 109: {265: {"mass": 265.136, "composition": 0.0},
  266: {"mass": 266.13737, "composition": 0.0},
  267: {"mass": 267.13719, "composition": 0.0},
  268: {"mass": 268.13865, "composition": 0.0},
  269: {"mass": 269.13882, "composition": 0.0},
  270: {"mass": 270.14033, "composition": 0.0},
  271: {"mass": 271.14074, "composition": 0.0},
  272: {"mass": 272.14341, "composition": 0.0},
  273: {"mass": 273.1444, "composition": 0.0},
  274: {"mass": 274.14724, "composition": 0.0},
  275: {"mass": 275.14882, "composition": 0.0},
  276: {"mass": 276.15159, "composition": 0.0},
  277: {"mass": 277.15327, "composition": 0.0},
  278: {"mass": 278.15631, "composition": 0.0},
  279: {"mass": 279.15808, "composition": 0.0}},
 110: {267: {"mass": 267.14377, "composition": 0.0},
  268: {"mass": 268.14348, "composition": 0.0},
  269: {"mass": 269.144752, "composition": 0.0},
  270: {"mass": 270.144584, "composition": 0.0},
  271: {"mass": 271.14595, "composition": 0.0},
  272: {"mass": 272.14602, "composition": 0.0},
  273: {"mass": 273.14856, "composition": 0.0},
  274: {"mass": 274.14941, "composition": 0.0},
  275: {"mass": 275.15203, "composition": 0.0},
  276: {"mass": 276.15303, "composition": 0.0},
  277: {"mass": 277.15591, "composition": 0.0},
  278: {"mass": 278.15704, "composition": 0.0},
  279: {"mass": 279.1601, "composition": 0.0},
  280: {"mass": 280.16131, "composition": 0.0},
  281: {"mass": 281.16451, "composition": 0.0}},
 111: {272: {"mass": 272.15327, "composition": 0.0},
  273: {"mass": 273.15313, "composition": 0.0},
  274: {"mass": 274.15525, "composition": 0.0},
  275: {"mass": 275.15594, "composition": 0.0},
  276: {"mass": 276.15833, "composition": 0.0},
  277: {"mass": 277.15907, "composition": 0.0},
  278: {"mass": 278.16149, "composition": 0.0},
  279: {"mass": 279.16272, "composition": 0.0},
  280: {"mass": 280.16514, "composition": 0.0},
  281: {"mass": 281.16636, "composition": 0.0},
  282: {"mass": 282.16912, "composition": 0.0},
  283: {"mass": 283.17054, "composition": 0.0}},
 112: {276: {"mass": 276.16141, "composition": 0.0},
  277: {"mass": 277.16364, "composition": 0.0},
  278: {"mass": 278.16416, "composition": 0.0},
  279: {"mass": 279.16654, "composition": 0.0},
  280: {"mass": 280.16715, "composition": 0.0},
  281: {"mass": 281.16975, "composition": 0.0},
  282: {"mass": 282.1705, "composition": 0.0},
  283: {"mass": 283.17327, "composition": 0.0},
  284: {"mass": 284.17416, "composition": 0.0},
  285: {"mass": 285.17712, "composition": 0.0}},
 113: {278: {"mass": 278.17058, "composition": 0.0},
  279: {"mass": 279.17095, "composition": 0.0},
  280: {"mass": 280.17293, "composition": 0.0},
  281: {"mass": 281.17348, "composition": 0.0},
  282: {"mass": 282.17567, "composition": 0.0},
  283: {"mass": 283.17657, "composition": 0.0},
  284: {"mass": 284.17873, "composition": 0.0},
  285: {"mass": 285.17973, "composition": 0.0},
  286: {"mass": 286.18221, "composition": 0.0},
  287: {"mass": 287.18339, "composition": 0.0}},
 114: {285: {"mass": 285.18364, "composition": 0.0},
  286: {"mass": 286.18423, "composition": 0.0},
  287: {"mass": 287.18678, "composition": 0.0},
  288: {"mass": 288.18757, "composition": 0.0},
  289: {"mass": 289.19042, "composition": 0.0}},
 115: {287: {"mass": 287.1907, "composition": 0.0},
  288: {"mass": 288.19274, "composition": 0.0},
  289: {"mass": 289.19363, "composition": 0.0},
  290: {"mass": 290.19598, "composition": 0.0},
  291: {"mass": 291.19707, "composition": 0.0}},
 116: {289: {"mass": 289.19816, "composition": 0.0},
  290: {"mass": 290.19864, "composition": 0.0},
  291: {"mass": 291.20108, "composition": 0.0},
  292: {"mass": 292.20174, "composition": 0.0},
  293: {"mass": 293.20449, "composition": 0.0}},
 117: {291: {"mass": 291.20553, "composition": 0.0},
  292: {"mass": 292.20746, "composition": 0.0},
  293: {"mass": 293.20824, "composition": 0.0},
  294: {"mass": 294.21046, "composition": 0.0}},
 118: {293: {"mass": 293.21356, "composition": 0.0},
  294: {"mass": 294.21392, "composition": 0.0},
  295: {"mass": 295.21624, "composition": 0.0}}}