"""Due Diligence API."""
import os
from openbb_terminal.helper_classes import ModelsNamespace as _models

# flake8: noqa
# pylint: disable=unused-import

# Menu commands
from .glassnode_view import display_non_zero_addresses as nonzero
from .glassnode_view import display_active_addresses as active
from .glassnode_view import display_exchange_net_position_change as change
from .glassnode_view import display_exchange_balances as eb
from .glassnode_view import display_hashrate as hr
from .coinglass_view import display_open_interest as oi
from .pycoingecko_view import display_info as info
from .pycoingecko_view import display_market as market
from .pycoingecko_view import display_web as web
from .pycoingecko_view import display_social as social
from .pycoingecko_view import display_dev as dev
from .pycoingecko_view import display_ath as ath
from .pycoingecko_view import display_atl as atl
from .pycoingecko_view import display_score as score
from .pycoingecko_view import display_bc as bc
from .binance_view import display_order_book as book
from .coinbase_view import display_order_book as cbbook
from .binance_view import display_balance as balance
from .coinbase_view import display_trades as trades
from .coinbase_view import display_stats as stats
from .coinpaprika_view import display_price_supply as ps
from .coinpaprika_view import display_basic as basic
from .coinpaprika_view import display_markets as mkt
from .coinpaprika_view import display_exchanges as ex
from .coinpaprika_view import display_events as events
from .coinpaprika_view import display_twitter as twitter
from .santiment_view import display_github_activity as gh
from .cryptopanic_view import display_news as news
from .messari_view import display_messari_timeseries_list as get_mt
from .messari_view import display_messari_timeseries as mt
from .messari_view import display_marketcap_dominance as mcapdom
from .messari_view import display_links as links
from .messari_view import display_roadmap as rm
from .messari_view import display_tokenomics as tk
from .messari_view import display_project_info as pi
from .messari_view import display_investors as inv
from .messari_view import display_team as team
from .messari_view import display_governance as gov
from .messari_view import display_fundraising as fr
from .tokenterminal_view import (
    display_fundamental_metric_from_project_over_time as funot,
    display_description as desc,
)


# Models
models = _models(os.path.abspath(os.path.dirname(__file__)))
