/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.reporting;

import org.jpmml.evaluator.FloatValue;
import org.jpmml.evaluator.HasReport;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.Value;

public class ReportingFloatValue
extends FloatValue
implements HasReport {
    private Report report = null;

    public ReportingFloatValue(float value, Report report) {
        super(value);
        this.setReport(report);
        this.report(new StringBuilder(256).append("<cn>").append(value).append("</cn>").toString());
    }

    public ReportingFloatValue(float value, Report report, String expression) {
        super(value);
        this.setReport(report);
        if (expression != null) {
            this.report(expression);
        }
    }

    public ReportingFloatValue(Number value, Report report) {
        super(value);
        this.setReport(report);
        this.report(new StringBuilder(256).append("<cn>").append(value.floatValue()).append("</cn>").toString());
    }

    public ReportingFloatValue(Number value, Report report, String expression) {
        super(value);
        this.setReport(report);
        if (expression != null) {
            this.report(expression);
        }
    }

    public ReportingFloatValue copy() {
        Report report = this.getReport();
        return new ReportingFloatValue(this.value, report.copy(), null);
    }

    public ReportingFloatValue reset(Number value) {
        ReportingFloatValue result = (ReportingFloatValue)super.reset(value);
        this.report(new StringBuilder(256).append("<cn>").append(value.floatValue()).append("</cn>").toString());
        return result;
    }

    public ReportingFloatValue add(Number value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.add(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<cn>").append(value.floatValue()).append("</cn>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue add(Value<? extends Number> value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.add(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<cn>").append(value.floatValue()).append("</cn>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue add(Number coefficient, Number factor) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.add(coefficient, factor);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append("<cn>").append(factor.floatValue()).append("</cn>").append("</apply></apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append("<cn>").append(factor.floatValue()).append("</cn>").append("</apply>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue add(Number coefficient, Number firstFactor, Number secondFactor) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.add(coefficient, firstFactor, secondFactor);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append("<cn>").append(firstFactor.floatValue()).append("</cn>").append("<cn>").append(secondFactor.floatValue()).append("</cn>").append("</apply></apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append("<cn>").append(firstFactor.floatValue()).append("</cn>").append("<cn>").append(secondFactor.floatValue()).append("</cn>").append("</apply>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue add(Number coefficient, Number ... factors) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.add(coefficient);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append(ReportingFloatValue.format(factors)).append("</apply></apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append(ReportingFloatValue.format(factors)).append("</apply>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue add(Number coefficient, Number factor, int exponent) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.add(coefficient, factor, exponent);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append("<apply><power/>").append("<cn>").append(factor.floatValue()).append("</cn>").append("<cn>").append((float)exponent).append("</cn>").append("</apply></apply></apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient.floatValue()).append("</cn>").append("<apply><power/>").append("<cn>").append(factor.floatValue()).append("</cn>").append("<cn>").append((float)exponent).append("</cn>").append("</apply></apply>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue subtract(Number value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.subtract(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><minus/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<apply><minus/>").append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue subtract(Value<? extends Number> value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.subtract(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            if (this.hasExpression()) {
                this.report(new StringBuilder(256).append("<apply><minus/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
            } else {
                this.report(new StringBuilder(256).append("<apply><minus/>").append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
            }
        }
        return result;
    }

    public ReportingFloatValue multiply(Number value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.multiply(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    public ReportingFloatValue multiply(Value<? extends Number> value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.multiply(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    public ReportingFloatValue multiply(Number factor, Number exponent) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.multiply(factor, exponent);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<apply><power/>").append("<cn>").append(factor.floatValue()).append("</cn>").append("<cn>").append(exponent.floatValue()).append("</cn>").append("</apply></apply>").toString());
        }
        return result;
    }

    public ReportingFloatValue divide(Number value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.divide(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            this.report(new StringBuilder(256).append("<apply><divide/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    public ReportingFloatValue divide(Value<? extends Number> value) {
        float oldValue = this.floatValue();
        ReportingFloatValue result = (ReportingFloatValue)super.divide(value);
        float newValue = this.floatValue();
        if (oldValue != newValue) {
            this.report(new StringBuilder(256).append("<apply><divide/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    public ReportingFloatValue residual(Value<? extends Number> value) {
        ReportingFloatValue result = (ReportingFloatValue)super.residual(value);
        this.report(new StringBuilder(256).append("<apply><minus/><cn>1</cn>").append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue square() {
        ReportingFloatValue result = (ReportingFloatValue)super.square();
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("<cn>2</cn></apply>").toString());
        return result;
    }

    public ReportingFloatValue power(Number value) {
        ReportingFloatValue result = (ReportingFloatValue)super.power(value);
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("{0}</apply>").toString());
        return result;
    }

    public ReportingFloatValue reciprocal() {
        ReportingFloatValue result = (ReportingFloatValue)super.reciprocal();
        this.report(new StringBuilder(256).append("<apply><divide/><cn>1</cn>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue elliott() {
        ReportingFloatValue result = (ReportingFloatValue)super.elliott();
        this.report(new StringBuilder(256).append("<apply><ci>elliott</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue exp() {
        ReportingFloatValue result = (ReportingFloatValue)super.exp();
        this.report(new StringBuilder(256).append("<apply><exp/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue ln() {
        ReportingFloatValue result = (ReportingFloatValue)super.ln();
        this.report(new StringBuilder(256).append("<apply><ln/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue gauss() {
        ReportingFloatValue result = (ReportingFloatValue)super.gauss();
        this.report(new StringBuilder(256).append("<apply><ci>gauss</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseLogit() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseLogit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>logit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseCloglog() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseCloglog();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>cloglog</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseLoglog() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseLoglog();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>loglog</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseLogc() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseLogc();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>logc</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseNegbin(Number value) {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseNegbin(value);
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>negbin</ci></apply>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseOddspower(Number value) {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseOddspower(value);
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>oddspower</ci></apply>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inversePower(Number value) {
        ReportingFloatValue result = (ReportingFloatValue)super.inversePower(value);
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("<apply><divide/><cn>1</cn>").append("<cn>").append(value.floatValue()).append("</cn>").append("</apply></apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseCauchit() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseCauchit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>cauchit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue inverseProbit() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseProbit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>probit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue sin() {
        ReportingFloatValue result = (ReportingFloatValue)super.sin();
        this.report(new StringBuilder(256).append("<apply><sin/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue cos() {
        ReportingFloatValue result = (ReportingFloatValue)super.cos();
        this.report(new StringBuilder(256).append("<apply><cos/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue arctan() {
        ReportingFloatValue result = (ReportingFloatValue)super.arctan();
        this.report(new StringBuilder(256).append("<apply><divide/><apply><times/><cn>2</cn><apply><arctan/>").append(this.getExpression()).append("</apply></apply><pi/></apply>").toString());
        return result;
    }

    public ReportingFloatValue tanh() {
        ReportingFloatValue result = (ReportingFloatValue)super.tanh();
        this.report(new StringBuilder(256).append("<apply><tanh/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue threshold(Number value) {
        ReportingFloatValue result = (ReportingFloatValue)super.threshold(value);
        this.report(new StringBuilder(256).append("<apply><ci>threshold</ci>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue relu() {
        ReportingFloatValue result = (ReportingFloatValue)super.relu();
        this.report(new StringBuilder(256).append("<apply><max/><cn>0</cn>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue abs() {
        ReportingFloatValue result = (ReportingFloatValue)super.abs();
        this.report(new StringBuilder(256).append("<apply><abs/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue gaussSim(Number value) {
        ReportingFloatValue result = (ReportingFloatValue)super.gaussSim(value);
        this.report(new StringBuilder(256).append("<apply><ci>gaussSim</ci>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue restrict(Number lowValue, Number highValue) {
        ReportingFloatValue result = (ReportingFloatValue)super.restrict(lowValue, highValue);
        this.report(new StringBuilder(256).append("<apply><max/>").append("<cn>").append(lowValue.floatValue()).append("</cn>").append("<apply><min/>").append("<cn>").append(highValue.floatValue()).append("</cn>").append(this.getExpression()).append("</apply></apply>").toString());
        return result;
    }

    public ReportingFloatValue round() {
        ReportingFloatValue result = (ReportingFloatValue)super.round();
        this.report(new StringBuilder(256).append("<apply><ci>round</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue ceiling() {
        ReportingFloatValue result = (ReportingFloatValue)super.ceiling();
        this.report(new StringBuilder(256).append("<apply><ceiling/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue floor() {
        ReportingFloatValue result = (ReportingFloatValue)super.floor();
        this.report(new StringBuilder(256).append("<apply><floor/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue normalize(Number leftOrig, Number leftNorm, Number rightOrig, Number rightNorm) {
        ReportingFloatValue result = (ReportingFloatValue)super.normalize(leftOrig, leftNorm, rightOrig, rightNorm);
        this.report(new StringBuilder(256).append("<apply><ci>normalize</ci>").append(this.getExpression()).append("<cn>").append(leftOrig.floatValue()).append("</cn>").append("<cn>").append(leftNorm.floatValue()).append("</cn>").append("<cn>").append(rightOrig.floatValue()).append("</cn>").append("<cn>").append(rightNorm.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingFloatValue denormalize(Number leftOrig, Number leftNorm, Number rightOrig, Number rightNorm) {
        ReportingFloatValue result = (ReportingFloatValue)super.denormalize(leftOrig, leftNorm, rightOrig, rightNorm);
        this.report(new StringBuilder(256).append("<apply><ci>denormalize</ci>").append(this.getExpression()).append("<cn>").append(leftOrig.floatValue()).append("</cn>").append("<cn>").append(leftNorm.floatValue()).append("</cn>").append("<cn>").append(rightOrig.floatValue()).append("</cn>").append("<cn>").append(rightNorm.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    private void report(String expression) {
        Report report = this.getReport();
        Report.Entry entry = new Report.Entry(expression, (Number)this.getValue());
        report.add(entry);
    }

    private boolean hasExpression() {
        Report report = this.getReport();
        return report.hasEntries();
    }

    private String getExpression() {
        Report report = this.getReport();
        Report.Entry entry = report.tailEntry();
        return entry.getExpression();
    }

    public Report getReport() {
        return this.report;
    }

    private void setReport(Report report) {
        this.report = report;
    }

    private static String format(Number ... values) {
        StringBuilder sb = new StringBuilder(values.length * 32);
        for (Number value : values) {
            sb.append("<cn>").append(value.floatValue()).append("</cn>").toString();
        }
        return sb.toString();
    }
}

