/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.python;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.razorvine.pickle.Pickler;
import net.razorvine.pickle.Unpickler;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.Scalar;
import numpy.core.ScalarUtil;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.python.PickleUtil;

public class PythonUtil {
    private PythonUtil() {
    }

    public static byte[] evaluateAll(Evaluator evaluator, byte[] dictBytes) throws IOException {
        Map argumentsDict = (Map)PythonUtil.unpickle(dictBytes);
        Map<String, ?> resultsDict = PythonUtil.evaluateAll(evaluator, argumentsDict);
        return PythonUtil.pickle(resultsDict);
    }

    public static Map<String, ?> evaluateAll(Evaluator evaluator, Map<String, ?> argumentsDict) {
        ColumnMapper argumentMapper = new ColumnMapper((List)argumentsDict.get("columns"));
        List argumentData = (List)argumentsDict.get("data");
        ColumnMapper resultMapper = new ColumnMapper();
        ArrayList resultData = new ArrayList();
        TabularArguments arguments = new TabularArguments(argumentMapper);
        for (int i = 0; i < argumentData.size(); ++i) {
            List argumentRow = (List)argumentData.get(i);
            arguments.setRow(argumentRow);
            Map results = evaluator.evaluate((Map)arguments);
            int numberOfColumns = resultMapper.size();
            ArrayList<Object> resultRow = new ArrayList<Object>(numberOfColumns);
            for (int j = 0; j < numberOfColumns; ++j) {
                resultRow.add(null);
            }
            Set entries = results.entrySet();
            for (Map.Entry entry : entries) {
                String name = (String)entry.getKey();
                Object value = EvaluatorUtil.decode(entry.getValue());
                Integer index = resultMapper.putIfAbsent(name, numberOfColumns);
                if (index == null) {
                    resultRow.add(value);
                    ++numberOfColumns;
                    continue;
                }
                resultRow.set(index, value);
            }
            resultData.add(resultRow);
        }
        HashMap<String, ArrayList<Object>> resultsDict = new HashMap<String, ArrayList<Object>>();
        resultsDict.put("columns", new ArrayList<String>(resultMapper.getColumns()));
        resultsDict.put("data", resultData);
        return resultsDict;
    }

    public static byte[] evaluate(Evaluator evaluator, byte[] dictBytes) throws IOException {
        Map arguments = (Map)PythonUtil.unpickle(dictBytes);
        Map<String, ?> results = PythonUtil.evaluate(evaluator, arguments);
        return PythonUtil.pickle(results);
    }

    public static Map<String, ?> evaluate(Evaluator evaluator, final Map<String, ?> arguments) {
        AbstractMap<String, Object> pmmlArguments = new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                Object value = arguments.get(key);
                return PythonUtil.toJavaPrimitive(value);
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                throw new UnsupportedOperationException();
            }
        };
        Map pmmlResults = evaluator.evaluate((Map)pmmlArguments);
        return EvaluatorUtil.decodeAll((Map)pmmlResults);
    }

    public static byte[] argumentsToResults(byte[] dictBytes) throws IOException {
        Map arguments = (Map)PythonUtil.unpickle(dictBytes);
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        Set entries = arguments.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            results.put(key, PythonUtil.toJavaPrimitive(value));
        }
        return PythonUtil.pickle(results);
    }

    public static Object toJavaPrimitive(Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return value;
        }
        if (value instanceof Scalar) {
            Scalar scalar = (Scalar)value;
            return ScalarUtil.decode((Object)scalar);
        }
        if (value instanceof ClassDict) {
            ClassDict classDict = (ClassDict)value;
            throw new IllegalArgumentException("Python type " + classDict.getClassName() + " is not supported");
        }
        throw new IllegalArgumentException("Java type " + value.getClass().getName() + " is not supported");
    }

    private static Object unpickle(byte[] bytes) throws IOException {
        Unpickler unpickler = new Unpickler();
        return unpickler.loads(bytes);
    }

    private static byte[] pickle(Object object) throws IOException {
        Pickler pickler = new Pickler();
        return pickler.dumps(object);
    }

    static {
        ClassLoader clazzLoader = PythonUtil.class.getClassLoader();
        PickleUtil.init((ClassLoader)clazzLoader, (String)"python2pmml.properties");
    }

    private static class TabularArguments
    extends AbstractMap<String, Object> {
        private ColumnMapper mapper = null;
        private List<?> row = null;

        public TabularArguments(ColumnMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public Object get(Object key) {
            Integer index = (Integer)this.mapper.get(key);
            if (index != null) {
                return this.getValue(index);
            }
            return null;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        public Object getValue(int index) {
            List<?> row = this.getRow();
            return row.get(index);
        }

        public List<?> getRow() {
            return this.row;
        }

        public void setRow(List<?> row) {
            this.row = row;
        }
    }

    private static class ColumnMapper
    extends HashMap<String, Integer> {
        public ColumnMapper() {
        }

        public ColumnMapper(List<String> columns) {
            for (int i = 0; i < columns.size(); ++i) {
                String column = columns.get(i);
                this.putIfAbsent(column, this.size());
            }
        }

        public List<String> getColumns() {
            Set entries = this.entrySet();
            return entries.stream().sorted((left, right) -> ((Integer)left.getValue()).compareTo((Integer)right.getValue())).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        }
    }
}

