/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.naive_bayes;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.math3.util.Precision;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.GaussianDistribution;
import org.dmg.pmml.HasType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.PoissonDistribution;
import org.dmg.pmml.naive_bayes.BayesInput;
import org.dmg.pmml.naive_bayes.BayesInputs;
import org.dmg.pmml.naive_bayes.BayesOutput;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.naive_bayes.PMMLAttributes;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.naive_bayes.TargetValueCount;
import org.dmg.pmml.naive_bayes.TargetValueCounts;
import org.dmg.pmml.naive_bayes.TargetValueStat;
import org.dmg.pmml.naive_bayes.TargetValueStats;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.DistributionUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.MapHolder;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NumberUtil;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueUtil;
import org.jpmml.evaluator.VerificationUtil;
import org.jpmml.evaluator.naive_bayes.ProbabilityMap;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.MisplacedElementException;

public class NaiveBayesModelEvaluator
extends ModelEvaluator<NaiveBayesModel> {
    private Map<String, Map<Object, Number>> fieldCountSums = Collections.emptyMap();

    private NaiveBayesModelEvaluator() {
    }

    public NaiveBayesModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, NaiveBayesModel.class));
    }

    public NaiveBayesModelEvaluator(PMML pmml, NaiveBayesModel naiveBayesModel) {
        super(pmml, naiveBayesModel);
        List bayesInputs = naiveBayesModel.requireBayesInputs().requireBayesInputs();
        this.fieldCountSums = ImmutableMap.copyOf(NaiveBayesModelEvaluator.toImmutableMapMap(NaiveBayesModelEvaluator.calculateFieldCountSums(bayesInputs)));
        BayesOutput bayesOutput = naiveBayesModel.requireBayesOutput();
        List targetValueCounts = bayesOutput.requireTargetValueCounts().requireTargetValueCounts();
    }

    @Override
    public String getSummary() {
        return "Naive Bayes model";
    }

    @Override
    protected <V extends Number> Map<String, ? extends Classification<?, V>> evaluateClassification(final ValueFactory<V> valueFactory, EvaluationContext context) {
        NaiveBayesModel naiveBayesModel = (NaiveBayesModel)this.getModel();
        BayesInputs bayesInputs = naiveBayesModel.requireBayesInputs();
        BayesOutput bayesOutput = naiveBayesModel.requireBayesOutput();
        TargetField targetField = this.getTargetField();
        String targetFieldName = bayesOutput.getTargetField();
        if (targetFieldName != null && !Objects.equals(targetField.getFieldName(), targetFieldName)) {
            throw new InvalidAttributeException((PMMLObject)bayesOutput, PMMLAttributes.BAYESOUTPUT_TARGETFIELD, (Object)targetFieldName);
        }
        ProbabilityMap probabilities = new ProbabilityMap<Object, V>(){

            @Override
            public ValueFactory<V> getValueFactory() {
                return valueFactory;
            }

            @Override
            public void multiply(Object key, Number probability) {
                ValueFactory valueFactory2 = this.getValueFactory();
                Value value = this.ensureValue(key);
                Value probabilityValue = valueFactory2.newValue(probability).ln();
                value.add(probabilityValue);
            }
        };
        TargetValueCounts targetValueCounts = bayesOutput.requireTargetValueCounts();
        this.calculatePriorProbabilities(probabilities, targetValueCounts);
        Number threshold = naiveBayesModel.requireThreshold();
        Map<String, Map<Object, Number>> fieldCountSums = this.getFieldCountSums();
        for (BayesInput bayesInput : bayesInputs) {
            String fieldName = bayesInput.requireField();
            FieldValue value = context.evaluate(fieldName);
            if (FieldValueUtil.isMissing(value)) continue;
            TargetValueStats targetValueStats = NaiveBayesModelEvaluator.getTargetValueStats(bayesInput);
            if (targetValueStats != null) {
                this.calculateContinuousProbabilities(probabilities, targetValueStats, threshold, value);
                continue;
            }
            DerivedField derivedField = bayesInput.getDerivedField();
            if (derivedField != null && FieldValueUtil.isMissing(value = this.discretize(derivedField, value))) continue;
            Map<Object, Number> countSums = fieldCountSums.get(fieldName);
            TargetValueCounts targetValueCounts2 = NaiveBayesModelEvaluator.getTargetValueCounts(bayesInput, value);
            if (targetValueCounts2 == null) continue;
            this.calculateDiscreteProbabilities(probabilities, targetValueCounts2, threshold, countSums);
        }
        ValueUtil.normalizeSoftMax(probabilities);
        ProbabilityDistribution result = new ProbabilityDistribution(probabilities);
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private FieldValue discretize(DerivedField derivedField, FieldValue value) {
        Expression expression = derivedField.requireExpression();
        if (expression instanceof Discretize) {
            Discretize discretize = (Discretize)expression;
            if (FieldValueUtil.isMissing(value = DiscretizationUtil.discretize(discretize, value))) {
                return FieldValues.MISSING_VALUE;
            }
            return value.cast((HasType<?>)derivedField);
        }
        throw new MisplacedElementException((PMMLObject)expression);
    }

    private void calculateContinuousProbabilities(ProbabilityMap<Object, ?> probabilities, TargetValueStats targetValueStats, Number threshold, FieldValue value) {
        Number x = value.asNumber();
        for (TargetValueStat targetValueStat : targetValueStats) {
            Object targetCategory = targetValueStat.requireValue();
            ContinuousDistribution distribution = targetValueStat.requireContinuousDistribution();
            if (!(distribution instanceof GaussianDistribution) && !(distribution instanceof PoissonDistribution)) {
                throw new MisplacedElementException((PMMLObject)distribution);
            }
            Number probability = DistributionUtil.probability(distribution, x);
            if (NumberUtil.compare(probability, threshold) < 0) {
                probability = threshold;
            }
            probabilities.multiply(targetCategory, probability);
        }
    }

    private void calculateDiscreteProbabilities(ProbabilityMap<Object, ?> probabilities, TargetValueCounts targetValueCounts, Number threshold, Map<?, Number> countSums) {
        for (TargetValueCount targetValueCount : targetValueCounts) {
            Number probability;
            Object targetCategory = targetValueCount.requireValue();
            Number count = targetValueCount.requireCount();
            if (VerificationUtil.isZero(count, Precision.EPSILON)) {
                probability = threshold;
            } else {
                Number countSum = countSums.get(targetCategory);
                probability = Functions.DIVIDE.evaluate(count, NumberUtil.asDouble(countSum));
            }
            probabilities.multiply(targetCategory, probability);
        }
    }

    private void calculatePriorProbabilities(ProbabilityMap<Object, ?> probabilities, TargetValueCounts targetValueCounts) {
        for (TargetValueCount targetValueCount : targetValueCounts) {
            Number count;
            Object targetCategory = targetValueCount.requireValue();
            Number probability = count = targetValueCount.requireCount();
            probabilities.multiply(targetCategory, probability);
        }
    }

    protected Map<String, Map<Object, Number>> getFieldCountSums() {
        return this.fieldCountSums;
    }

    private static TargetValueStats getTargetValueStats(BayesInput bayesInput) {
        return bayesInput.getTargetValueStats();
    }

    private static TargetValueCounts getTargetValueCounts(BayesInput bayesInput, FieldValue value) {
        if (bayesInput instanceof MapHolder) {
            MapHolder mapHolder = (MapHolder)bayesInput;
            return (TargetValueCounts)mapHolder.get(value.getDataType(), value.getValue());
        }
        List pairCounts = bayesInput.getPairCounts();
        int max = pairCounts.size();
        for (int i = 0; i < max; ++i) {
            PairCounts pairCount = (PairCounts)pairCounts.get(i);
            Object category = pairCount.requireValue();
            if (!value.equalsValue(category)) continue;
            TargetValueCounts targetValueCounts = pairCount.requireTargetValueCounts();
            return targetValueCounts;
        }
        return null;
    }

    private static Map<String, Map<Object, Number>> calculateFieldCountSums(List<BayesInput> bayesInputs) {
        LinkedHashMap<String, Map<Object, Number>> result = new LinkedHashMap<String, Map<Object, Number>>();
        for (BayesInput bayesInput : bayesInputs) {
            LinkedHashMap<Object, Number> countSums = new LinkedHashMap<Object, Number>();
            List pairCounts = bayesInput.getPairCounts();
            for (PairCounts pairCount : pairCounts) {
                TargetValueCounts targetValueCounts = pairCount.getTargetValueCounts();
                for (TargetValueCount targetValueCount : targetValueCounts) {
                    Object targetCategory = targetValueCount.requireValue();
                    Number count = targetValueCount.requireCount();
                    Number countSum = (Number)countSums.get(targetCategory);
                    countSum = countSum == null ? (Number)count : (Number)Functions.ADD.evaluate(countSum, count);
                    countSums.put(targetCategory, countSum);
                }
            }
            result.put(bayesInput.requireField(), countSums);
        }
        return result;
    }
}

