/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.MultiaryFunction;

public class StandardDeviationFunction
extends MultiaryFunction {
    public StandardDeviationFunction() {
        this(StandardDeviationFunction.class.getName());
    }

    public StandardDeviationFunction(String name) {
        super(name, Arrays.asList("values", "biasCorrected"));
    }

    public Double evaluate(Collection<?> values, boolean biasCorrected) {
        StandardDeviation statistic = new StandardDeviation();
        statistic.setBiasCorrected(biasCorrected);
        for (Object value : values) {
            Number number = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, value);
            statistic.increment(number.doubleValue());
        }
        return statistic.getResult();
    }

    @Override
    public FieldValue evaluate(List<FieldValue> arguments) {
        this.checkVariableArityArguments(arguments, 1, 2);
        Double result = arguments.size() > 1 ? this.evaluate(this.getRequiredArgument(arguments, 0).asCollection(), this.getRequiredArgument(arguments, 1).asBoolean()) : this.evaluate(this.getRequiredArgument(arguments, 0).asCollection(), Boolean.FALSE);
        return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
    }
}

