/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.ValueStatusHolder;
import org.jpmml.model.InvalidAttributeException;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.UnsupportedAttributeException;

public class RichOutputField
extends OutputField
implements ValueStatusHolder {
    @XmlTransient
    private Map<?, Integer> valueMap = null;

    public RichOutputField() {
    }

    public RichOutputField(OutputField outputField) {
        ReflectionUtil.copyState((PMMLObject)outputField, (PMMLObject)this);
    }

    @Override
    public Map<?, Integer> getMap() {
        if (this.valueMap == null) {
            this.valueMap = ImmutableMap.copyOf(this.parseValues());
        }
        return this.valueMap;
    }

    @Override
    public boolean hasValidValues() {
        return this.hasValues();
    }

    private Map<Object, Integer> parseValues() {
        DataType dataType = this.requireDataType();
        LinkedHashMap<Object, Integer> result = new LinkedHashMap<Object, Integer>();
        int validIndex = 0;
        List pmmlValues = this.getValues();
        block4: for (Value pmmlValue : pmmlValues) {
            Object objectValue = pmmlValue.requireValue();
            Value.Property property = pmmlValue.getProperty();
            switch (property) {
                case VALID: {
                    Object value = TypeUtil.parseOrCast(dataType, objectValue);
                    result.put(value, ++validIndex);
                    continue block4;
                }
                case INVALID: 
                case MISSING: {
                    throw new InvalidAttributeException((PMMLObject)pmmlValue, (Enum)property);
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum)property);
        }
        return result;
    }
}

