/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.math.IntMath;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.summary.Product;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.InvalidArgumentException;
import org.jpmml.evaluator.MathUtil;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.RegExUtil;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AggregateFunction;
import org.jpmml.evaluator.functions.ArithmeticFunction;
import org.jpmml.evaluator.functions.BinaryFunction;
import org.jpmml.evaluator.functions.BooleanFunction;
import org.jpmml.evaluator.functions.ComparisonFunction;
import org.jpmml.evaluator.functions.DoubleMathFunction;
import org.jpmml.evaluator.functions.EqualityFunction;
import org.jpmml.evaluator.functions.LogicalFunction;
import org.jpmml.evaluator.functions.MathFunction;
import org.jpmml.evaluator.functions.MultiaryFunction;
import org.jpmml.evaluator.functions.RoundingFunction;
import org.jpmml.evaluator.functions.StatisticalFunction;
import org.jpmml.evaluator.functions.StringFunction;
import org.jpmml.evaluator.functions.TernaryFunction;
import org.jpmml.evaluator.functions.TrigonometricFunction;
import org.jpmml.evaluator.functions.UnaryFunction;
import org.jpmml.evaluator.functions.ValueFunction;
import org.jpmml.evaluator.functions.ValueSetFunction;
import org.jpmml.model.temporals.DaysSinceDate;
import org.jpmml.model.temporals.Instant;
import org.jpmml.model.temporals.SecondsSinceDate;
import org.jpmml.model.temporals.SecondsSinceMidnight;

public interface Functions {
    public static final ArithmeticFunction ADD = new ArithmeticFunction("+"){

        @Override
        public Number evaluate(Number left, Number right) {
            if (left instanceof Integer && right instanceof Integer) {
                return IntMath.checkedAdd((int)left.intValue(), (int)right.intValue());
            }
            return left.doubleValue() + right.doubleValue();
        }
    };
    public static final ArithmeticFunction SUBTRACT = new ArithmeticFunction("-"){

        @Override
        public Number evaluate(Number left, Number right) {
            if (left instanceof Integer && right instanceof Integer) {
                return IntMath.checkedSubtract((int)left.intValue(), (int)right.intValue());
            }
            return left.doubleValue() - right.doubleValue();
        }
    };
    public static final ArithmeticFunction MULTIPLY = new ArithmeticFunction("*"){

        @Override
        public Number evaluate(Number left, Number right) {
            if (left instanceof Integer && right instanceof Integer) {
                return IntMath.checkedMultiply((int)left.intValue(), (int)right.intValue());
            }
            return left.doubleValue() * right.doubleValue();
        }
    };
    public static final ArithmeticFunction DIVIDE = new ArithmeticFunction("/"){

        @Override
        public Number evaluate(Number left, Number right) {
            if (left instanceof Integer && right instanceof Integer) {
                return left.intValue() / right.intValue();
            }
            return left.doubleValue() / right.doubleValue();
        }
    };
    public static final ArithmeticFunction MODULO = new ArithmeticFunction("modulo"){

        @Override
        public Number evaluate(Number left, Number right) {
            if (left instanceof Integer && right instanceof Integer) {
                int leftValue = left.intValue();
                int rightValue = right.intValue();
                int floorDivResult = leftValue / rightValue;
                if ((leftValue ^ rightValue) < 0 && leftValue != floorDivResult * rightValue) {
                    --floorDivResult;
                }
                return leftValue - floorDivResult * rightValue;
            }
            double leftValue = left.doubleValue();
            double rightValue = right.doubleValue();
            return leftValue - Math.floor(leftValue / rightValue) * rightValue;
        }
    };
    public static final StatisticalFunction MIN = new StatisticalFunction("min"){

        public Min createStatistic() {
            return new Min();
        }
    };
    public static final StatisticalFunction MAX = new StatisticalFunction("max"){

        public Max createStatistic() {
            return new Max();
        }
    };
    public static final StatisticalFunction AVG = new StatisticalFunction("avg"){

        public Mean createStatistic() {
            return new Mean();
        }

        @Override
        public DataType getResultDataType(DataType dataType) {
            if (dataType == DataType.INTEGER) {
                return DataType.DOUBLE;
            }
            return dataType;
        }
    };
    public static final StatisticalFunction SUM = new StatisticalFunction("sum"){

        public Sum createStatistic() {
            return new Sum();
        }
    };
    public static final StatisticalFunction PRODUCT = new StatisticalFunction("product"){

        public Product createStatistic() {
            return new Product();
        }
    };
    public static final DoubleMathFunction LOG10 = new DoubleMathFunction("log10"){

        @Override
        public Double evaluate(Number value) {
            return Math.log10(value.doubleValue());
        }
    };
    public static final DoubleMathFunction LN = new DoubleMathFunction("ln"){

        @Override
        public Double evaluate(Number value) {
            return Math.log(value.doubleValue());
        }
    };
    public static final DoubleMathFunction LN1P = new DoubleMathFunction("ln1p"){

        @Override
        public Double evaluate(Number value) {
            return Math.log1p(value.doubleValue());
        }
    };
    public static final DoubleMathFunction EXP = new DoubleMathFunction("exp"){

        @Override
        public Double evaluate(Number value) {
            return Math.exp(value.doubleValue());
        }
    };
    public static final DoubleMathFunction EXPM1 = new DoubleMathFunction("expm1"){

        @Override
        public Double evaluate(Number value) {
            return Math.expm1(value.doubleValue());
        }
    };
    public static final DoubleMathFunction SQRT = new DoubleMathFunction("sqrt"){

        @Override
        public Double evaluate(Number value) {
            return Math.sqrt(value.doubleValue());
        }
    };
    public static final MathFunction ABS = new MathFunction("abs"){

        @Override
        public Number evaluate(Number value) {
            if (value instanceof Float) {
                return Float.valueOf(Math.abs(value.floatValue()));
            }
            return Math.abs(value.doubleValue());
        }
    };
    public static final BinaryFunction POW = new BinaryFunction("pow"){

        public Number evaluate(Number base, Number exponent) {
            if (base instanceof Integer && exponent instanceof Integer) {
                if (exponent.intValue() < 0) {
                    throw new InvalidArgumentException(this, InvalidArgumentException.formatMessage(this, "exponent", exponent) + ". Must be equal to or greater than 0");
                }
                return IntMath.checkedPow((int)base.intValue(), (int)exponent.intValue());
            }
            return Math.pow(base.doubleValue(), exponent.doubleValue());
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            DataType dataType = TypeUtil.getCommonDataType(first.getDataType(), second.getDataType());
            Number result = this.evaluate(first.asNumber(), second.asNumber());
            return FieldValueUtil.create(OpType.CONTINUOUS, dataType, result);
        }
    };
    public static final BinaryFunction THRESHOLD = new BinaryFunction("threshold"){

        public Integer evaluate(Number x, Number y) {
            int order = Double.compare(x.doubleValue(), y.doubleValue());
            return order > 0 ? Numbers.INTEGER_ONE : Numbers.INTEGER_ZERO;
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            DataType dataType = TypeUtil.getCommonDataType(first.getDataType(), second.getDataType());
            Integer result = this.evaluate(first.asNumber(), second.asNumber());
            return FieldValueUtil.create(OpType.CONTINUOUS, dataType, result);
        }
    };
    public static final RoundingFunction FLOOR = new RoundingFunction("floor"){

        @Override
        public Integer evaluate(Number number) {
            long result = (long)Math.floor(number.doubleValue());
            return MathUtil.toIntExact(result);
        }
    };
    public static final RoundingFunction CEIL = new RoundingFunction("ceil"){

        @Override
        public Integer evaluate(Number number) {
            long result = (long)Math.ceil(number.doubleValue());
            return MathUtil.toIntExact(result);
        }
    };
    public static final RoundingFunction ROUND = new RoundingFunction("round"){

        @Override
        public Integer evaluate(Number number) {
            long result = number instanceof Float ? (long)Math.round(number.floatValue()) : Math.round(number.doubleValue());
            return MathUtil.toIntExact(result);
        }
    };
    public static final MathFunction RINT = new MathFunction("rint"){

        @Override
        public Number evaluate(Number number) {
            if (number instanceof Float) {
                return Math.rint(number.floatValue());
            }
            return Math.rint(number.doubleValue());
        }
    };
    public static final ValueFunction IS_MISSING = new ValueFunction("isMissing"){

        @Override
        public FieldValue evaluate(FieldValue value) {
            Boolean result = FieldValueUtil.isMissing(value);
            return FieldValue.create(TypeInfos.CATEGORICAL_BOOLEAN, result);
        }
    };
    public static final ValueFunction IS_NOT_MISSING = new ValueFunction("isNotMissing"){

        @Override
        public FieldValue evaluate(FieldValue value) {
            Boolean result = !FieldValueUtil.isMissing(value);
            return FieldValue.create(TypeInfos.CATEGORICAL_BOOLEAN, result);
        }
    };
    public static final ValueFunction IS_VALID = new ValueFunction("isValid"){

        @Override
        public FieldValue evaluate(FieldValue value) {
            Boolean result = !FieldValueUtil.isMissing(value) && !FieldValueUtil.isInvalid(value);
            return FieldValue.create(TypeInfos.CATEGORICAL_BOOLEAN, result);
        }
    };
    public static final ValueFunction IS_NOT_VALID = new ValueFunction("isNotValid"){

        @Override
        public FieldValue evaluate(FieldValue value) {
            Boolean result = !FieldValueUtil.isMissing(value) && FieldValueUtil.isInvalid(value);
            return FieldValue.create(TypeInfos.CATEGORICAL_BOOLEAN, result);
        }
    };
    public static final EqualityFunction EQUAL = new EqualityFunction("equal"){

        @Override
        public Boolean evaluate(boolean equals) {
            return equals;
        }
    };
    public static final EqualityFunction NOT_EQUAL = new EqualityFunction("notEqual"){

        @Override
        public Boolean evaluate(boolean equals) {
            return !equals;
        }
    };
    public static final ComparisonFunction LESS_THAN = new ComparisonFunction("lessThan"){

        @Override
        public Boolean evaluate(int order) {
            return order < 0;
        }
    };
    public static final ComparisonFunction LESS_OR_EQUAL = new ComparisonFunction("lessOrEqual"){

        @Override
        public Boolean evaluate(int order) {
            return order <= 0;
        }
    };
    public static final ComparisonFunction GREATER_THAN = new ComparisonFunction("greaterThan"){

        @Override
        public Boolean evaluate(int order) {
            return order > 0;
        }
    };
    public static final ComparisonFunction GREATER_OR_EQUAL = new ComparisonFunction("greaterOrEqual"){

        @Override
        public Boolean evaluate(int order) {
            return order >= 0;
        }
    };
    public static final LogicalFunction AND = new LogicalFunction("and"){

        @Override
        public Boolean evaluate(Boolean left, Boolean right) {
            return left & right;
        }
    };
    public static final LogicalFunction OR = new LogicalFunction("or"){

        @Override
        public Boolean evaluate(Boolean left, Boolean right) {
            return left | right;
        }
    };
    public static final BooleanFunction NOT = new BooleanFunction("not"){

        @Override
        public Boolean evaluate(Boolean value) {
            return value == false;
        }
    };
    public static final ValueSetFunction IS_IN = new ValueSetFunction("isIn"){

        @Override
        public Boolean evaluate(boolean isIn) {
            return isIn;
        }
    };
    public static final ValueSetFunction IS_NOT_IN = new ValueSetFunction("isNotIn"){

        @Override
        public Boolean evaluate(boolean isIn) {
            return !isIn;
        }
    };
    public static final MultiaryFunction IF = new MultiaryFunction("if"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkVariableArityArguments(arguments, 2, 3);
            Boolean flag = this.getRequiredArgument(arguments, 0).asBoolean();
            if (flag.booleanValue()) {
                return this.getOptionalArgument(arguments, 1);
            }
            if (arguments.size() > 2) {
                return this.getOptionalArgument(arguments, 2);
            }
            return FieldValues.MISSING_VALUE;
        }
    };
    public static final StringFunction UPPERCASE = new StringFunction("uppercase"){

        @Override
        public String evaluate(String value) {
            return value.toUpperCase();
        }
    };
    public static final StringFunction LOWERCASE = new StringFunction("lowercase"){

        @Override
        public String evaluate(String value) {
            return value.toLowerCase();
        }
    };
    public static final UnaryFunction STRING_LENGTH = new UnaryFunction("stringLength"){

        @Override
        public FieldValue evaluate(FieldValue value) {
            String string = value.asString();
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, string.length());
        }
    };
    public static final TernaryFunction SUBSTRING = new TernaryFunction("substring", (List)Arrays.asList("input", "startPos", "length")){

        public String evaluate(String string, int position, int length) {
            if (position < 1) {
                throw new InvalidArgumentException(this, InvalidArgumentException.formatMessage(this, "startPos", position) + ". Must be equal to or greater than 1");
            }
            if (length < 0) {
                throw new InvalidArgumentException(this, InvalidArgumentException.formatMessage(this, "length", length));
            }
            int javaPosition = Math.min(position - 1, string.length());
            int javaLength = Math.min(length, string.length() - javaPosition);
            return string.substring(javaPosition, javaPosition + javaLength);
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second, FieldValue third) {
            String result = this.evaluate(first.asString(), second.asInteger(), third.asInteger());
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final StringFunction TRIM_BLANKS = new StringFunction("trimBlanks"){

        @Override
        public String evaluate(String value) {
            return value.trim();
        }
    };
    public static final AggregateFunction CONCAT = new AggregateFunction("concat"){

        @Override
        public FieldValue evaluate(List<FieldValue> arguments) {
            this.checkVariableArityArguments(arguments, 2);
            StringBuilder sb = new StringBuilder();
            int max = arguments.size();
            for (int i = 0; i < max; ++i) {
                FieldValue value = this.getOptionalArgument(arguments, i);
                if (FieldValueUtil.isMissing(value)) continue;
                sb.append(value.asString());
            }
            String result = sb.toString();
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final TernaryFunction REPLACE = new TernaryFunction("replace", (List)Arrays.asList("input", "pattern", "replacement")){

        public String evaluate(String input, String regex, String replacement) {
            Pattern pattern = RegExUtil.compile(regex, null);
            Matcher matcher = pattern.matcher(input);
            return matcher.replaceAll(replacement);
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second, FieldValue third) {
            String result = this.evaluate(first.asString(), second.asString(), third.asString());
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final BinaryFunction MATCHES = new BinaryFunction("matches", (List)Arrays.asList("input", "pattern")){

        public Boolean evaluate(String input, String regex) {
            Pattern pattern = RegExUtil.compile(regex, null);
            Matcher matcher = pattern.matcher(input);
            return matcher.find();
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            Boolean result = this.evaluate(first.asString(), second.asString());
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_BOOLEAN, result);
        }
    };
    public static final BinaryFunction FORMAT_NUMBER = new BinaryFunction("formatNumber", (List)Arrays.asList("input", "pattern")){

        public String evaluate(Number input, String pattern) {
            try {
                return String.format(pattern, input);
            }
            catch (IllegalFormatException ife) {
                throw new InvalidArgumentException(this, InvalidArgumentException.formatMessage(this, "pattern", pattern)).initCause(ife);
            }
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            String result = this.evaluate(first.asNumber(), second.asString());
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }
    };
    public static final BinaryFunction FORMAT_DATETIME = new BinaryFunction("formatDatetime", (List)Arrays.asList("input", "pattern")){

        public String evaluate(Instant<?> input, String pattern) {
            pattern = this.translatePattern(pattern);
            try {
                return input.format(pattern);
            }
            catch (IllegalFormatException ife) {
                throw new InvalidArgumentException(this, InvalidArgumentException.formatMessage(this, "pattern", pattern)).initCause(ife);
            }
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            String result = this.evaluate(first.asInstant(), second.asString());
            return FieldValueUtil.create(TypeInfos.CATEGORICAL_STRING, result);
        }

        private String translatePattern(String pattern) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                sb.append(c);
                if (c != '%' || i >= pattern.length() - 1 || pattern.charAt(i + 1) == '%') continue;
                sb.append("1$t");
            }
            return sb.toString();
        }
    };
    public static final BinaryFunction DATE_DAYS_SINCE_YEAR = new BinaryFunction("dateDaysSinceYear", (List)Arrays.asList("input", "referenceYear")){

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            DaysSinceDate result = first.asDate().toDaysSinceYear(second.asInteger().intValue());
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, result);
        }
    };
    public static final UnaryFunction DATE_SECONDS_SINCE_MIDNIGHT = new UnaryFunction("dateSecondsSinceMidnight", (List)Arrays.asList("input")){

        @Override
        public FieldValue evaluate(FieldValue value) {
            SecondsSinceMidnight result = value.asTime().toSecondsSinceMidnight();
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, result);
        }
    };
    public static final BinaryFunction DATE_SECONDS_SINCE_YEAR = new BinaryFunction("dateSecondsSinceYear", (List)Arrays.asList("input", "referenceYear")){

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            SecondsSinceDate result = first.asDateTime().toSecondsSinceYear(second.asInteger().intValue());
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_INTEGER, result);
        }
    };
    public static final BinaryFunction HYPOT = new BinaryFunction("hypot"){

        public Double evaluate(Number x, Number y) {
            return Math.hypot(x.doubleValue(), y.doubleValue());
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            Double result = this.evaluate(first.asNumber(), second.asNumber());
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
        }
    };
    public static final TrigonometricFunction SIN = new TrigonometricFunction("sin"){

        @Override
        public Double evaluate(Number value) {
            return Math.sin(value.doubleValue());
        }
    };
    public static final TrigonometricFunction COS = new TrigonometricFunction("cos"){

        @Override
        public Double evaluate(Number value) {
            return Math.cos(value.doubleValue());
        }
    };
    public static final TrigonometricFunction TAN = new TrigonometricFunction("tan"){

        @Override
        public Double evaluate(Number value) {
            return Math.tan(value.doubleValue());
        }
    };
    public static final TrigonometricFunction ASIN = new TrigonometricFunction("asin"){

        @Override
        public Double evaluate(Number value) {
            return Math.asin(value.doubleValue());
        }
    };
    public static final TrigonometricFunction ACOS = new TrigonometricFunction("acos"){

        @Override
        public Double evaluate(Number value) {
            return Math.acos(value.doubleValue());
        }
    };
    public static final TrigonometricFunction ATAN = new TrigonometricFunction("atan"){

        @Override
        public Double evaluate(Number value) {
            return Math.atan(value.doubleValue());
        }
    };
    public static final BinaryFunction ATAN2 = new BinaryFunction("x-atan2"){

        public Double evaluate(Number y, Number x) {
            return Math.atan2(y.doubleValue(), x.doubleValue());
        }

        @Override
        public FieldValue evaluate(FieldValue first, FieldValue second) {
            Double result = this.evaluate(first.asNumber(), second.asNumber());
            return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
        }
    };
    public static final TrigonometricFunction SINH = new TrigonometricFunction("sinh"){

        @Override
        public Double evaluate(Number value) {
            return Math.sinh(value.doubleValue());
        }
    };
    public static final TrigonometricFunction COSH = new TrigonometricFunction("cosh"){

        @Override
        public Double evaluate(Number value) {
            return Math.cosh(value.doubleValue());
        }
    };
    public static final TrigonometricFunction TANH = new TrigonometricFunction("tanh"){

        @Override
        public Double evaluate(Number value) {
            return Math.tanh(value.doubleValue());
        }
    };
}

