from __future__ import annotations
from datetime import datetime, timedelta


def datetime_range(start: datetime, stop: datetime, step: timedelta) -> list[datetime]:

    """
    Generate range of datetime

    Parameters
    ----------
    start : datetime
        start time
    stop : datetime
        stop time
    step : timedelta
        time step

    Returns
    -------
    times : list of datetime
        times requested
    """
    return [start + i * step for i in range((stop - start) // step)]
