#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['facet',
 'facet.crossfit',
 'facet.data',
 'facet.inspection',
 'facet.selection',
 'facet.simulation',
 'facet.simulation.partition',
 'facet.simulation.viz',
 'facet.validation']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['boruta >=0.3',
 'lightgbm >=3.0',
 'shap >=0.34,<0.36',
 'matplotlib >=3.1,<3.4',
 'scikit-learn >=0.21,<0.24',
 'pandas >=0.24,<1.3',
 'numpy >=1.16,<1.20',
 'scipy >=1.2,<1.6',
 'pyyaml >=5.0',
 'joblib >=0.13,<1.0',
 'gamma-pytools >=1.0.1',
 'sklearndf >=1.0.1']

extras_require = \
{'docs': ['sphinx == 3.2.*',
          'sphinx-autodoc-typehints == 1.11.*',
          'pydata-sphinx-theme == 0.4.*',
          'nbsphinx == 0.7.*',
          'jupyter >= 1.0',
          'docutils',
          'xlrd == 1.2.*',
          'm2r == 0.2.*'],
 'testing': ['pytest >= 5.2.*',
             'pytest-cov == 2.8.*',
             'flake8 == 3.8.*',
             'flake8-comprehensions == 3.2.*',
             'isort == 5.5.*']}

setup(name='gamma-facet',
      version='1.0.1',
      description='Human-explainable AI.',
      author='Boston Consulting Group (BCG)',
      author_email=None,
      url='https://github.com/BCG-Gamma/facet',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6,<4',
     )
