# coding: utf-8

"""
    fatcat

    Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata.   # noqa: E501

    The version of the OpenAPI document: 0.3.1
    Contact: webservices@archive.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ReleaseEntity(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'state': 'str',
        'ident': 'str',
        'revision': 'str',
        'redirect': 'str',
        'extra': 'dict(str, object)',
        'edit_extra': 'dict(str, object)',
        'title': 'str',
        'subtitle': 'str',
        'original_title': 'str',
        'work_id': 'str',
        'container': 'ContainerEntity',
        'files': 'list[FileEntity]',
        'filesets': 'list[FilesetEntity]',
        'webcaptures': 'list[WebcaptureEntity]',
        'container_id': 'str',
        'release_type': 'str',
        'release_stage': 'str',
        'release_date': 'date',
        'release_year': 'int',
        'withdrawn_status': 'str',
        'withdrawn_date': 'date',
        'withdrawn_year': 'int',
        'ext_ids': 'ReleaseExtIds',
        'volume': 'str',
        'issue': 'str',
        'pages': 'str',
        'number': 'str',
        'version': 'str',
        'publisher': 'str',
        'language': 'str',
        'license_slug': 'str',
        'contribs': 'list[ReleaseContrib]',
        'refs': 'list[ReleaseRef]',
        'abstracts': 'list[ReleaseAbstract]'
    }

    attribute_map = {
        'state': 'state',
        'ident': 'ident',
        'revision': 'revision',
        'redirect': 'redirect',
        'extra': 'extra',
        'edit_extra': 'edit_extra',
        'title': 'title',
        'subtitle': 'subtitle',
        'original_title': 'original_title',
        'work_id': 'work_id',
        'container': 'container',
        'files': 'files',
        'filesets': 'filesets',
        'webcaptures': 'webcaptures',
        'container_id': 'container_id',
        'release_type': 'release_type',
        'release_stage': 'release_stage',
        'release_date': 'release_date',
        'release_year': 'release_year',
        'withdrawn_status': 'withdrawn_status',
        'withdrawn_date': 'withdrawn_date',
        'withdrawn_year': 'withdrawn_year',
        'ext_ids': 'ext_ids',
        'volume': 'volume',
        'issue': 'issue',
        'pages': 'pages',
        'number': 'number',
        'version': 'version',
        'publisher': 'publisher',
        'language': 'language',
        'license_slug': 'license_slug',
        'contribs': 'contribs',
        'refs': 'refs',
        'abstracts': 'abstracts'
    }

    def __init__(self, state=None, ident=None, revision=None, redirect=None, extra=None, edit_extra=None, title=None, subtitle=None, original_title=None, work_id=None, container=None, files=None, filesets=None, webcaptures=None, container_id=None, release_type=None, release_stage=None, release_date=None, release_year=None, withdrawn_status=None, withdrawn_date=None, withdrawn_year=None, ext_ids=None, volume=None, issue=None, pages=None, number=None, version=None, publisher=None, language=None, license_slug=None, contribs=None, refs=None, abstracts=None):  # noqa: E501
        """ReleaseEntity - a model defined in OpenAPI"""  # noqa: E501

        self._state = None
        self._ident = None
        self._revision = None
        self._redirect = None
        self._extra = None
        self._edit_extra = None
        self._title = None
        self._subtitle = None
        self._original_title = None
        self._work_id = None
        self._container = None
        self._files = None
        self._filesets = None
        self._webcaptures = None
        self._container_id = None
        self._release_type = None
        self._release_stage = None
        self._release_date = None
        self._release_year = None
        self._withdrawn_status = None
        self._withdrawn_date = None
        self._withdrawn_year = None
        self._ext_ids = None
        self._volume = None
        self._issue = None
        self._pages = None
        self._number = None
        self._version = None
        self._publisher = None
        self._language = None
        self._license_slug = None
        self._contribs = None
        self._refs = None
        self._abstracts = None
        self.discriminator = None

        if state is not None:
            self.state = state
        if ident is not None:
            self.ident = ident
        if revision is not None:
            self.revision = revision
        if redirect is not None:
            self.redirect = redirect
        if extra is not None:
            self.extra = extra
        if edit_extra is not None:
            self.edit_extra = edit_extra
        if title is not None:
            self.title = title
        if subtitle is not None:
            self.subtitle = subtitle
        if original_title is not None:
            self.original_title = original_title
        if work_id is not None:
            self.work_id = work_id
        if container is not None:
            self.container = container
        if files is not None:
            self.files = files
        if filesets is not None:
            self.filesets = filesets
        if webcaptures is not None:
            self.webcaptures = webcaptures
        if container_id is not None:
            self.container_id = container_id
        if release_type is not None:
            self.release_type = release_type
        if release_stage is not None:
            self.release_stage = release_stage
        if release_date is not None:
            self.release_date = release_date
        if release_year is not None:
            self.release_year = release_year
        if withdrawn_status is not None:
            self.withdrawn_status = withdrawn_status
        if withdrawn_date is not None:
            self.withdrawn_date = withdrawn_date
        if withdrawn_year is not None:
            self.withdrawn_year = withdrawn_year
        self.ext_ids = ext_ids
        if volume is not None:
            self.volume = volume
        if issue is not None:
            self.issue = issue
        if pages is not None:
            self.pages = pages
        if number is not None:
            self.number = number
        if version is not None:
            self.version = version
        if publisher is not None:
            self.publisher = publisher
        if language is not None:
            self.language = language
        if license_slug is not None:
            self.license_slug = license_slug
        if contribs is not None:
            self.contribs = contribs
        if refs is not None:
            self.refs = refs
        if abstracts is not None:
            self.abstracts = abstracts

    @property
    def state(self):
        """Gets the state of this ReleaseEntity.  # noqa: E501


        :return: The state of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ReleaseEntity.


        :param state: The state of this ReleaseEntity.  # noqa: E501
        :type: str
        """
        allowed_values = ["wip", "active", "redirect", "deleted"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def ident(self):
        """Gets the ident of this ReleaseEntity.  # noqa: E501

        base32-encoded unique identifier  # noqa: E501

        :return: The ident of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._ident

    @ident.setter
    def ident(self, ident):
        """Sets the ident of this ReleaseEntity.

        base32-encoded unique identifier  # noqa: E501

        :param ident: The ident of this ReleaseEntity.  # noqa: E501
        :type: str
        """
        if ident is not None and len(ident) > 26:
            raise ValueError("Invalid value for `ident`, length must be less than or equal to `26`")  # noqa: E501
        if ident is not None and len(ident) < 26:
            raise ValueError("Invalid value for `ident`, length must be greater than or equal to `26`")  # noqa: E501
        if ident is not None and not re.search(r'[a-zA-Z2-7]{26}', ident):  # noqa: E501
            raise ValueError(r"Invalid value for `ident`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._ident = ident

    @property
    def revision(self):
        """Gets the revision of this ReleaseEntity.  # noqa: E501

        UUID (lower-case, dash-separated, hex-encoded 128-bit)  # noqa: E501

        :return: The revision of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this ReleaseEntity.

        UUID (lower-case, dash-separated, hex-encoded 128-bit)  # noqa: E501

        :param revision: The revision of this ReleaseEntity.  # noqa: E501
        :type: str
        """
        if revision is not None and len(revision) > 36:
            raise ValueError("Invalid value for `revision`, length must be less than or equal to `36`")  # noqa: E501
        if revision is not None and len(revision) < 36:
            raise ValueError("Invalid value for `revision`, length must be greater than or equal to `36`")  # noqa: E501
        if revision is not None and not re.search(r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}', revision):  # noqa: E501
            raise ValueError(r"Invalid value for `revision`, must be a follow pattern or equal to `/[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}/`")  # noqa: E501

        self._revision = revision

    @property
    def redirect(self):
        """Gets the redirect of this ReleaseEntity.  # noqa: E501

        base32-encoded unique identifier  # noqa: E501

        :return: The redirect of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._redirect

    @redirect.setter
    def redirect(self, redirect):
        """Sets the redirect of this ReleaseEntity.

        base32-encoded unique identifier  # noqa: E501

        :param redirect: The redirect of this ReleaseEntity.  # noqa: E501
        :type: str
        """
        if redirect is not None and len(redirect) > 26:
            raise ValueError("Invalid value for `redirect`, length must be less than or equal to `26`")  # noqa: E501
        if redirect is not None and len(redirect) < 26:
            raise ValueError("Invalid value for `redirect`, length must be greater than or equal to `26`")  # noqa: E501
        if redirect is not None and not re.search(r'[a-zA-Z2-7]{26}', redirect):  # noqa: E501
            raise ValueError(r"Invalid value for `redirect`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._redirect = redirect

    @property
    def extra(self):
        """Gets the extra of this ReleaseEntity.  # noqa: E501

        Free-form JSON metadata that will be stored with the other entity metadata. See guide for (unenforced) schema conventions.   # noqa: E501

        :return: The extra of this ReleaseEntity.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._extra

    @extra.setter
    def extra(self, extra):
        """Sets the extra of this ReleaseEntity.

        Free-form JSON metadata that will be stored with the other entity metadata. See guide for (unenforced) schema conventions.   # noqa: E501

        :param extra: The extra of this ReleaseEntity.  # noqa: E501
        :type: dict(str, object)
        """

        self._extra = extra

    @property
    def edit_extra(self):
        """Gets the edit_extra of this ReleaseEntity.  # noqa: E501

        Free-form JSON metadata that will be stored with specific entity edits (eg, creation/update/delete).   # noqa: E501

        :return: The edit_extra of this ReleaseEntity.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._edit_extra

    @edit_extra.setter
    def edit_extra(self, edit_extra):
        """Sets the edit_extra of this ReleaseEntity.

        Free-form JSON metadata that will be stored with specific entity edits (eg, creation/update/delete).   # noqa: E501

        :param edit_extra: The edit_extra of this ReleaseEntity.  # noqa: E501
        :type: dict(str, object)
        """

        self._edit_extra = edit_extra

    @property
    def title(self):
        """Gets the title of this ReleaseEntity.  # noqa: E501

        Required for valid entities. The title used in citations and for display. Sometimes the English translation of title e even if release content is not English.   # noqa: E501

        :return: The title of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ReleaseEntity.

        Required for valid entities. The title used in citations and for display. Sometimes the English translation of title e even if release content is not English.   # noqa: E501

        :param title: The title of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def subtitle(self):
        """Gets the subtitle of this ReleaseEntity.  # noqa: E501

        Subtitle of release. In many cases, better to merge with title than include as separate field (unless combined title would be very long). See guide for details.   # noqa: E501

        :return: The subtitle of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._subtitle

    @subtitle.setter
    def subtitle(self, subtitle):
        """Sets the subtitle of this ReleaseEntity.

        Subtitle of release. In many cases, better to merge with title than include as separate field (unless combined title would be very long). See guide for details.   # noqa: E501

        :param subtitle: The subtitle of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._subtitle = subtitle

    @property
    def original_title(self):
        """Gets the original_title of this ReleaseEntity.  # noqa: E501

        Title in original language if `title` field has been translated. See guide for details.   # noqa: E501

        :return: The original_title of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._original_title

    @original_title.setter
    def original_title(self, original_title):
        """Sets the original_title of this ReleaseEntity.

        Title in original language if `title` field has been translated. See guide for details.   # noqa: E501

        :param original_title: The original_title of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._original_title = original_title

    @property
    def work_id(self):
        """Gets the work_id of this ReleaseEntity.  # noqa: E501

        Identifier of work this release is part of. In creation (POST) requests, a work entity will be created automatically if this field is not set.   # noqa: E501

        :return: The work_id of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._work_id

    @work_id.setter
    def work_id(self, work_id):
        """Sets the work_id of this ReleaseEntity.

        Identifier of work this release is part of. In creation (POST) requests, a work entity will be created automatically if this field is not set.   # noqa: E501

        :param work_id: The work_id of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._work_id = work_id

    @property
    def container(self):
        """Gets the container of this ReleaseEntity.  # noqa: E501


        :return: The container of this ReleaseEntity.  # noqa: E501
        :rtype: ContainerEntity
        """
        return self._container

    @container.setter
    def container(self, container):
        """Sets the container of this ReleaseEntity.


        :param container: The container of this ReleaseEntity.  # noqa: E501
        :type: ContainerEntity
        """

        self._container = container

    @property
    def files(self):
        """Gets the files of this ReleaseEntity.  # noqa: E501

        Complete file entities identified by `file_ids` field. Only included in GET responses when `files` included in `expand` parameter; ignored in PUT or POST requests.   # noqa: E501

        :return: The files of this ReleaseEntity.  # noqa: E501
        :rtype: list[FileEntity]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this ReleaseEntity.

        Complete file entities identified by `file_ids` field. Only included in GET responses when `files` included in `expand` parameter; ignored in PUT or POST requests.   # noqa: E501

        :param files: The files of this ReleaseEntity.  # noqa: E501
        :type: list[FileEntity]
        """

        self._files = files

    @property
    def filesets(self):
        """Gets the filesets of this ReleaseEntity.  # noqa: E501

        Complete file entities identified by `filesets_ids` field. Only included in GET responses when `filesets` included in `expand` parameter; ignored in PUT or POST requests.   # noqa: E501

        :return: The filesets of this ReleaseEntity.  # noqa: E501
        :rtype: list[FilesetEntity]
        """
        return self._filesets

    @filesets.setter
    def filesets(self, filesets):
        """Sets the filesets of this ReleaseEntity.

        Complete file entities identified by `filesets_ids` field. Only included in GET responses when `filesets` included in `expand` parameter; ignored in PUT or POST requests.   # noqa: E501

        :param filesets: The filesets of this ReleaseEntity.  # noqa: E501
        :type: list[FilesetEntity]
        """

        self._filesets = filesets

    @property
    def webcaptures(self):
        """Gets the webcaptures of this ReleaseEntity.  # noqa: E501

        Complete webcapture entities identified by `webcapture_ids` field. Only included in GET responses when `webcaptures` included in `expand` parameter; ignored in PUT or POST requests.   # noqa: E501

        :return: The webcaptures of this ReleaseEntity.  # noqa: E501
        :rtype: list[WebcaptureEntity]
        """
        return self._webcaptures

    @webcaptures.setter
    def webcaptures(self, webcaptures):
        """Sets the webcaptures of this ReleaseEntity.

        Complete webcapture entities identified by `webcapture_ids` field. Only included in GET responses when `webcaptures` included in `expand` parameter; ignored in PUT or POST requests.   # noqa: E501

        :param webcaptures: The webcaptures of this ReleaseEntity.  # noqa: E501
        :type: list[WebcaptureEntity]
        """

        self._webcaptures = webcaptures

    @property
    def container_id(self):
        """Gets the container_id of this ReleaseEntity.  # noqa: E501

        Used to link this release to a container entity that the release was published as part of.   # noqa: E501

        :return: The container_id of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this ReleaseEntity.

        Used to link this release to a container entity that the release was published as part of.   # noqa: E501

        :param container_id: The container_id of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._container_id = container_id

    @property
    def release_type(self):
        """Gets the release_type of this ReleaseEntity.  # noqa: E501

        \"Type\" or \"medium\" that this release is published as. See guide for valid values.   # noqa: E501

        :return: The release_type of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._release_type

    @release_type.setter
    def release_type(self, release_type):
        """Sets the release_type of this ReleaseEntity.

        \"Type\" or \"medium\" that this release is published as. See guide for valid values.   # noqa: E501

        :param release_type: The release_type of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._release_type = release_type

    @property
    def release_stage(self):
        """Gets the release_stage of this ReleaseEntity.  # noqa: E501

        The stage of publication of this specific release. See guide for valid values and semantics.   # noqa: E501

        :return: The release_stage of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._release_stage

    @release_stage.setter
    def release_stage(self, release_stage):
        """Sets the release_stage of this ReleaseEntity.

        The stage of publication of this specific release. See guide for valid values and semantics.   # noqa: E501

        :param release_stage: The release_stage of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._release_stage = release_stage

    @property
    def release_date(self):
        """Gets the release_date of this ReleaseEntity.  # noqa: E501

        Full date when this release was formally published. ISO format, like `2019-03-05`. See guide for semantics.   # noqa: E501

        :return: The release_date of this ReleaseEntity.  # noqa: E501
        :rtype: date
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date):
        """Sets the release_date of this ReleaseEntity.

        Full date when this release was formally published. ISO format, like `2019-03-05`. See guide for semantics.   # noqa: E501

        :param release_date: The release_date of this ReleaseEntity.  # noqa: E501
        :type: date
        """

        self._release_date = release_date

    @property
    def release_year(self):
        """Gets the release_year of this ReleaseEntity.  # noqa: E501

        Year when this release was formally published. Must match `release_date` if that field is set; this field exists because sometimes only the year is known.   # noqa: E501

        :return: The release_year of this ReleaseEntity.  # noqa: E501
        :rtype: int
        """
        return self._release_year

    @release_year.setter
    def release_year(self, release_year):
        """Sets the release_year of this ReleaseEntity.

        Year when this release was formally published. Must match `release_date` if that field is set; this field exists because sometimes only the year is known.   # noqa: E501

        :param release_year: The release_year of this ReleaseEntity.  # noqa: E501
        :type: int
        """

        self._release_year = release_year

    @property
    def withdrawn_status(self):
        """Gets the withdrawn_status of this ReleaseEntity.  # noqa: E501

        Type of withdrawl or retraction of this release, if applicable. If release has not been withdrawn, should be `null` (aka, not set, not the string \"null\" or an empty string).   # noqa: E501

        :return: The withdrawn_status of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._withdrawn_status

    @withdrawn_status.setter
    def withdrawn_status(self, withdrawn_status):
        """Sets the withdrawn_status of this ReleaseEntity.

        Type of withdrawl or retraction of this release, if applicable. If release has not been withdrawn, should be `null` (aka, not set, not the string \"null\" or an empty string).   # noqa: E501

        :param withdrawn_status: The withdrawn_status of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._withdrawn_status = withdrawn_status

    @property
    def withdrawn_date(self):
        """Gets the withdrawn_date of this ReleaseEntity.  # noqa: E501

        Full date when this release was formally withdrawn (if applicable). ISO format, like `release_date`.   # noqa: E501

        :return: The withdrawn_date of this ReleaseEntity.  # noqa: E501
        :rtype: date
        """
        return self._withdrawn_date

    @withdrawn_date.setter
    def withdrawn_date(self, withdrawn_date):
        """Sets the withdrawn_date of this ReleaseEntity.

        Full date when this release was formally withdrawn (if applicable). ISO format, like `release_date`.   # noqa: E501

        :param withdrawn_date: The withdrawn_date of this ReleaseEntity.  # noqa: E501
        :type: date
        """

        self._withdrawn_date = withdrawn_date

    @property
    def withdrawn_year(self):
        """Gets the withdrawn_year of this ReleaseEntity.  # noqa: E501

        Year corresponding with `withdrawn_date` like `release_year`/`release_date`.   # noqa: E501

        :return: The withdrawn_year of this ReleaseEntity.  # noqa: E501
        :rtype: int
        """
        return self._withdrawn_year

    @withdrawn_year.setter
    def withdrawn_year(self, withdrawn_year):
        """Sets the withdrawn_year of this ReleaseEntity.

        Year corresponding with `withdrawn_date` like `release_year`/`release_date`.   # noqa: E501

        :param withdrawn_year: The withdrawn_year of this ReleaseEntity.  # noqa: E501
        :type: int
        """

        self._withdrawn_year = withdrawn_year

    @property
    def ext_ids(self):
        """Gets the ext_ids of this ReleaseEntity.  # noqa: E501


        :return: The ext_ids of this ReleaseEntity.  # noqa: E501
        :rtype: ReleaseExtIds
        """
        return self._ext_ids

    @ext_ids.setter
    def ext_ids(self, ext_ids):
        """Sets the ext_ids of this ReleaseEntity.


        :param ext_ids: The ext_ids of this ReleaseEntity.  # noqa: E501
        :type: ReleaseExtIds
        """
        if ext_ids is None:
            raise ValueError("Invalid value for `ext_ids`, must not be `None`")  # noqa: E501

        self._ext_ids = ext_ids

    @property
    def volume(self):
        """Gets the volume of this ReleaseEntity.  # noqa: E501

        Volume number of container that this release was published in. Often corresponds to the \"Nth\" year of publication, but can be any string. See guide.   # noqa: E501

        :return: The volume of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._volume

    @volume.setter
    def volume(self, volume):
        """Sets the volume of this ReleaseEntity.

        Volume number of container that this release was published in. Often corresponds to the \"Nth\" year of publication, but can be any string. See guide.   # noqa: E501

        :param volume: The volume of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._volume = volume

    @property
    def issue(self):
        """Gets the issue of this ReleaseEntity.  # noqa: E501

        Issue number of volume/container that this release was published in. Sometimes coresponds to a month number in the year, but can be any string. See guide.   # noqa: E501

        :return: The issue of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._issue

    @issue.setter
    def issue(self, issue):
        """Sets the issue of this ReleaseEntity.

        Issue number of volume/container that this release was published in. Sometimes coresponds to a month number in the year, but can be any string. See guide.   # noqa: E501

        :param issue: The issue of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._issue = issue

    @property
    def pages(self):
        """Gets the pages of this ReleaseEntity.  # noqa: E501

        Either a single page number (\"first page\") or a range of pages separated by a dash (\"-\"). See guide for details.   # noqa: E501

        :return: The pages of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._pages

    @pages.setter
    def pages(self, pages):
        """Sets the pages of this ReleaseEntity.

        Either a single page number (\"first page\") or a range of pages separated by a dash (\"-\"). See guide for details.   # noqa: E501

        :param pages: The pages of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._pages = pages

    @property
    def number(self):
        """Gets the number of this ReleaseEntity.  # noqa: E501

        For, eg, technical reports, which are published in series or assigned some other institutional or container-specific identifier.   # noqa: E501

        :return: The number of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this ReleaseEntity.

        For, eg, technical reports, which are published in series or assigned some other institutional or container-specific identifier.   # noqa: E501

        :param number: The number of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._number = number

    @property
    def version(self):
        """Gets the version of this ReleaseEntity.  # noqa: E501

        For, eg, updated technical reports or software packages, where the version string may be the only field disambiguating between releases.   # noqa: E501

        :return: The version of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this ReleaseEntity.

        For, eg, updated technical reports or software packages, where the version string may be the only field disambiguating between releases.   # noqa: E501

        :param version: The version of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def publisher(self):
        """Gets the publisher of this ReleaseEntity.  # noqa: E501

        Name, usually English, of the entity or institution responsible for publication of this release. Not necessarily the imprint/brand. See guide.   # noqa: E501

        :return: The publisher of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._publisher

    @publisher.setter
    def publisher(self, publisher):
        """Sets the publisher of this ReleaseEntity.

        Name, usually English, of the entity or institution responsible for publication of this release. Not necessarily the imprint/brand. See guide.   # noqa: E501

        :param publisher: The publisher of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._publisher = publisher

    @property
    def language(self):
        """Gets the language of this ReleaseEntity.  # noqa: E501

        Primary language of the content of the full release. Two-letter RFC1766/ISO639-1 language code, with some custom extensions/additions. See guide.   # noqa: E501

        :return: The language of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this ReleaseEntity.

        Primary language of the content of the full release. Two-letter RFC1766/ISO639-1 language code, with some custom extensions/additions. See guide.   # noqa: E501

        :param language: The language of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._language = language

    @property
    def license_slug(self):
        """Gets the license_slug of this ReleaseEntity.  # noqa: E501

        Short string (slug) name of license under which release is openly published (if applicable).   # noqa: E501

        :return: The license_slug of this ReleaseEntity.  # noqa: E501
        :rtype: str
        """
        return self._license_slug

    @license_slug.setter
    def license_slug(self, license_slug):
        """Sets the license_slug of this ReleaseEntity.

        Short string (slug) name of license under which release is openly published (if applicable).   # noqa: E501

        :param license_slug: The license_slug of this ReleaseEntity.  # noqa: E501
        :type: str
        """

        self._license_slug = license_slug

    @property
    def contribs(self):
        """Gets the contribs of this ReleaseEntity.  # noqa: E501


        :return: The contribs of this ReleaseEntity.  # noqa: E501
        :rtype: list[ReleaseContrib]
        """
        return self._contribs

    @contribs.setter
    def contribs(self, contribs):
        """Sets the contribs of this ReleaseEntity.


        :param contribs: The contribs of this ReleaseEntity.  # noqa: E501
        :type: list[ReleaseContrib]
        """

        self._contribs = contribs

    @property
    def refs(self):
        """Gets the refs of this ReleaseEntity.  # noqa: E501


        :return: The refs of this ReleaseEntity.  # noqa: E501
        :rtype: list[ReleaseRef]
        """
        return self._refs

    @refs.setter
    def refs(self, refs):
        """Sets the refs of this ReleaseEntity.


        :param refs: The refs of this ReleaseEntity.  # noqa: E501
        :type: list[ReleaseRef]
        """

        self._refs = refs

    @property
    def abstracts(self):
        """Gets the abstracts of this ReleaseEntity.  # noqa: E501


        :return: The abstracts of this ReleaseEntity.  # noqa: E501
        :rtype: list[ReleaseAbstract]
        """
        return self._abstracts

    @abstracts.setter
    def abstracts(self, abstracts):
        """Sets the abstracts of this ReleaseEntity.


        :param abstracts: The abstracts of this ReleaseEntity.  # noqa: E501
        :type: list[ReleaseAbstract]
        """

        self._abstracts = abstracts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReleaseEntity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
