# coding: utf-8

"""
    fatcat

    Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata.   # noqa: E501

    The version of the OpenAPI document: 0.3.1
    Contact: webservices@archive.org
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Editor(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'editor_id': 'str',
        'username': 'str',
        'is_admin': 'bool',
        'is_bot': 'bool',
        'is_active': 'bool'
    }

    attribute_map = {
        'editor_id': 'editor_id',
        'username': 'username',
        'is_admin': 'is_admin',
        'is_bot': 'is_bot',
        'is_active': 'is_active'
    }

    def __init__(self, editor_id=None, username=None, is_admin=None, is_bot=None, is_active=None):  # noqa: E501
        """Editor - a model defined in OpenAPI"""  # noqa: E501

        self._editor_id = None
        self._username = None
        self._is_admin = None
        self._is_bot = None
        self._is_active = None
        self.discriminator = None

        if editor_id is not None:
            self.editor_id = editor_id
        self.username = username
        if is_admin is not None:
            self.is_admin = is_admin
        if is_bot is not None:
            self.is_bot = is_bot
        if is_active is not None:
            self.is_active = is_active

    @property
    def editor_id(self):
        """Gets the editor_id of this Editor.  # noqa: E501

        Fatcat identifier for the editor. Can not be changed.   # noqa: E501

        :return: The editor_id of this Editor.  # noqa: E501
        :rtype: str
        """
        return self._editor_id

    @editor_id.setter
    def editor_id(self, editor_id):
        """Sets the editor_id of this Editor.

        Fatcat identifier for the editor. Can not be changed.   # noqa: E501

        :param editor_id: The editor_id of this Editor.  # noqa: E501
        :type: str
        """
        if editor_id is not None and len(editor_id) > 26:
            raise ValueError("Invalid value for `editor_id`, length must be less than or equal to `26`")  # noqa: E501
        if editor_id is not None and len(editor_id) < 26:
            raise ValueError("Invalid value for `editor_id`, length must be greater than or equal to `26`")  # noqa: E501
        if editor_id is not None and not re.search(r'[a-zA-Z2-7]{26}', editor_id):  # noqa: E501
            raise ValueError(r"Invalid value for `editor_id`, must be a follow pattern or equal to `/[a-zA-Z2-7]{26}/`")  # noqa: E501

        self._editor_id = editor_id

    @property
    def username(self):
        """Gets the username of this Editor.  # noqa: E501

        Username/handle (short slug-like string) to identify this editor. May be changed at any time by the editor; use the `editor_id` as a persistend identifer.   # noqa: E501

        :return: The username of this Editor.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this Editor.

        Username/handle (short slug-like string) to identify this editor. May be changed at any time by the editor; use the `editor_id` as a persistend identifer.   # noqa: E501

        :param username: The username of this Editor.  # noqa: E501
        :type: str
        """
        if username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    @property
    def is_admin(self):
        """Gets the is_admin of this Editor.  # noqa: E501

        Whether this editor has the `admin` role.   # noqa: E501

        :return: The is_admin of this Editor.  # noqa: E501
        :rtype: bool
        """
        return self._is_admin

    @is_admin.setter
    def is_admin(self, is_admin):
        """Sets the is_admin of this Editor.

        Whether this editor has the `admin` role.   # noqa: E501

        :param is_admin: The is_admin of this Editor.  # noqa: E501
        :type: bool
        """

        self._is_admin = is_admin

    @property
    def is_bot(self):
        """Gets the is_bot of this Editor.  # noqa: E501

        Whether this editor is a bot (as opposed to a human making manual edits)   # noqa: E501

        :return: The is_bot of this Editor.  # noqa: E501
        :rtype: bool
        """
        return self._is_bot

    @is_bot.setter
    def is_bot(self, is_bot):
        """Sets the is_bot of this Editor.

        Whether this editor is a bot (as opposed to a human making manual edits)   # noqa: E501

        :param is_bot: The is_bot of this Editor.  # noqa: E501
        :type: bool
        """

        self._is_bot = is_bot

    @property
    def is_active(self):
        """Gets the is_active of this Editor.  # noqa: E501

        Whether this editor's account is enabled (if not API tokens and web logins will not work).   # noqa: E501

        :return: The is_active of this Editor.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this Editor.

        Whether this editor's account is enabled (if not API tokens and web logins will not work).   # noqa: E501

        :param is_active: The is_active of this Editor.  # noqa: E501
        :type: bool
        """

        self._is_active = is_active

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Editor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
