# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['irobot_edu_sdk', 'irobot_edu_sdk.backend']

package_data = \
{'': ['*']}

install_requires = \
['bleak>=0.19.0,<0.20.0', 'pyserial>=3.4,<4.0']

setup_kwargs = {
    'name': 'irobot-edu-sdk',
    'version': '0.2.0',
    'description': 'Python SDK for iRobot Edu robots',
    'long_description': "# iRobot® Education Python® SDK\n\nThis is an installable Python SDK for the iRobot Education robots.\nIt supports the iRobot® Root® rt0, Root® rt1 and Create® 3 educational robots.\n\nThis SDK uses a similar format as Learning Level 3 of the iRobot® Coding App ([code.irobot.com](https://code.irobot.com)) and the iRobot® Python Web Playground ([python.irobot.com](https://python.irobot.com)).\nAs such, it uses async execution and is compatible with Python® 3.9 or greater. MicroPython may work, but it is not tested.\n\nThis SDK is designed to communicate with robots via Bluetooth® Low Energy on Windows®, macOS®, and Linux® systems.\nExperimental backends are provided for communicating over USB serial and USB on MicroPython boards with native USB ports.\nThese are not currently supported.\n\n## Disclaimer: this is a BETA release.\nThe BETA version of the iRobot® Python SDK is provided “as is” to conduct testing and gather user feedback. There is no guarantee on its performance or compatibility, continued availability, or on a timeline for improvements.\n\nPlease do file [issues](https://github.com/iRobotEducation/irobot-edu-python-sdk/issues) as they are found, so that the team (or the community) can address them.\n\n\n## Installation using pip\n\n```\npip3 install irobot_edu_sdk\n```\n\n\n## Optional: Installation from Source\n\n```\ngit clone https://github.com/iRobotEducation/irobot-edu-python-sdk.git\n```\n\nFrom the newly cloned SDK's directory, run:\n\n```\npip3 install .\n```\n\n\n## Usage\n\nA robot object is created from one of the communication backends.\nThis robot object has a number of event callbacks that can be registered and commands that can be sent to the robot.\nAfter a program is setup, the `play()` method will start execution and block until the robot's nose or power button is pressed, the robot is disconnected, or `Ctrl-C` is pressed.\n\n\n## Examples\n\nA good way of getting started is by looking at the examples provided [here](https://github.com/iRobotEducation/irobot-edu-python-sdk/tree/main/examples).\n\nThese examples mirror the iRobot Education [Python Web Playground](http://python.irobot.com).\n\n## Backend\n\n### Bluetooth\n\niRobot Education's robots communicate using a common Bluetooth Low Energy serial protocol, the details of which can be found [here](https://github.com/iRobotEducation/root-robot-ble-protocol).\n\n```python\nfrom irobot_edu_sdk.backend.bluetooth import Bluetooth\n\n# Connect to robot over Bluetooth Low Energy.\nbackend0 = Bluetooth('') # Connects to the first BLE robot detected.\nbackend1 = Bluetooth('ROOT') # Use robot named 'ROOT'\n```\n\n## ALPHA features\n**The features detailed below are included as ALPHA versions, which provide limited functionality and are likely to contain several known or unknown bugs.**\n**Support is not provided for ALPHA features at this time.**\n\n### Serial\n\nSome Root® robots support a serial port over USB.\n\n```python\nfrom irobot_edu_sdk.backend.serial import Serial\n\n# Connect to robot over USB-C cable.\nbackend = Serial('COM1')                          # Windows\nbackend = Serial('/dev/cu.usbmodemRT0123F456789') # macOS\nbackend = Serial('/dev/ttyACM0')                  # Linux\n```\n\n### MicroPython\n\nThis SDK requires MicroPython firmware that includes the `uasyncio` library -- version 1.13 or greater.\nDownload the latest release for your board from http://micropython.org/download.\nThen, copy the `irobot_edu_sdk` directory and all contents to the `PYBFLASH` drive.\n\n```python\nfrom irobot_edu_sdk.backend.usb import USB\n\n# Connect to robot from MicroPython-compatible board over USB.\nbackend = USB() # MicroPython-compatible board is powered from USB-C port\n```\n\nNOTE: You may need to use a USB-C to USB-A adapter or a USB-C to micro USB cable.\n\n**© 2022 iRobot Corporation. All rights reserved.**\n* [Terms and Conditions](https://about.irobot.com/en-us/legal/terms-and-conditions)\n* [Privacy Policy](https://edu.irobot.com/privacy-policy)\n\n## Attributions\n* Python® 3 is governed by and a trademark of the Python Software Foundation.\n* The Bluetooth® word mark and logos are registered trademarks owned by Bluetooth SIG, Inc. and any use of such marks by iRobot is under license.\n* Windows® is a trademark of Microsoft Corporation, registered in the U.S. and other countries and regions.\n* macOS® is a trademark of Apple Inc., registered in the U.S. and other countries and regions.\n* Linux® is a trademark of Linus Torvalds, registered in the U.S. and other countries and regions.\n* USB-C™ is a trademark of USB Implementers Forum.\n* All other trademarks mentioned are the property of their respective owners.\n\n\nThis library is made possible thanks to other community software.\nThe following are direct required dependencies:\n* [Bleak](https://github.com/hbldh/bleak), licensed under the MIT license, available [here](https://github.com/hbldh/bleak/blob/develop/LICENSE)\n* [pySerial](https://github.com/pyserial/pyserial/), licensed under the BSD 3-Clause license, available [here](https://github.com/pyserial/pyserial/blob/master/LICENSE.txt)\n* [Root Robot Python Web App](https://github.com/mogenson/root-robot-python-web-app), licensed under the MIT license, available [here](https://github.com/mogenson/root-robot-python-web-app/blob/main/LICENSE)\n\nTo build, the following is recommended:\n* [Poetry](https://github.com/python-poetry/poetry), licensed under the MIT license, available [here](https://github.com/python-poetry/poetry/blob/master/LICENSE)\n\nThe iRobot Education Python SDK provided is licensed under the 3-Clause BSD license, found [here](https://github.com/iRobotEducation/irobot-edu-python-sdk/tree/main/LICENSE.txt)\n",
    'author': 'iRobot Corporation',
    'author_email': 'education@irobot.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://python.irobot.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
