# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ValidateWorkPlanMessages(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ValidateWorkPlanMessages - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'violation_messages': 'list[WorkPlanConfigurationViolationMessage]',
            'constraint_conflict_message': 'ConstraintConflictMessage'
        }

        self.attribute_map = {
            'violation_messages': 'violationMessages',
            'constraint_conflict_message': 'constraintConflictMessage'
        }

        self._violation_messages = None
        self._constraint_conflict_message = None

    @property
    def violation_messages(self):
        """
        Gets the violation_messages of this ValidateWorkPlanMessages.
        Messages for work plan violating some rules such as no shifts in a work plan

        :return: The violation_messages of this ValidateWorkPlanMessages.
        :rtype: list[WorkPlanConfigurationViolationMessage]
        """
        return self._violation_messages

    @violation_messages.setter
    def violation_messages(self, violation_messages):
        """
        Sets the violation_messages of this ValidateWorkPlanMessages.
        Messages for work plan violating some rules such as no shifts in a work plan

        :param violation_messages: The violation_messages of this ValidateWorkPlanMessages.
        :type: list[WorkPlanConfigurationViolationMessage]
        """
        
        self._violation_messages = violation_messages

    @property
    def constraint_conflict_message(self):
        """
        Gets the constraint_conflict_message of this ValidateWorkPlanMessages.
        This field is not null when there is a set of work plan constraints that conflict thus agent schedules cannot be generated

        :return: The constraint_conflict_message of this ValidateWorkPlanMessages.
        :rtype: ConstraintConflictMessage
        """
        return self._constraint_conflict_message

    @constraint_conflict_message.setter
    def constraint_conflict_message(self, constraint_conflict_message):
        """
        Sets the constraint_conflict_message of this ValidateWorkPlanMessages.
        This field is not null when there is a set of work plan constraints that conflict thus agent schedules cannot be generated

        :param constraint_conflict_message: The constraint_conflict_message of this ValidateWorkPlanMessages.
        :type: ConstraintConflictMessage
        """
        
        self._constraint_conflict_message = constraint_conflict_message

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

