# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Relationship(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Relationship - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'user': 'User',
            'external_organization': 'ExternalOrganization',
            'relationship': 'str',
            'external_data_sources': 'list[ExternalDataSource]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'user': 'user',
            'external_organization': 'externalOrganization',
            'relationship': 'relationship',
            'external_data_sources': 'externalDataSources',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._user = None
        self._external_organization = None
        self._relationship = None
        self._external_data_sources = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Relationship.
        The globally unique identifier for the object.

        :return: The id of this Relationship.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Relationship.
        The globally unique identifier for the object.

        :param id: The id of this Relationship.
        :type: str
        """
        
        self._id = id

    @property
    def user(self):
        """
        Gets the user of this Relationship.
        The user associated with the external organization. When creating or updating a relationship, only User.id is required. User object is fully populated when expanding a note.

        :return: The user of this Relationship.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this Relationship.
        The user associated with the external organization. When creating or updating a relationship, only User.id is required. User object is fully populated when expanding a note.

        :param user: The user of this Relationship.
        :type: User
        """
        
        self._user = user

    @property
    def external_organization(self):
        """
        Gets the external_organization of this Relationship.
        The external organization this relationship is attached to

        :return: The external_organization of this Relationship.
        :rtype: ExternalOrganization
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization):
        """
        Sets the external_organization of this Relationship.
        The external organization this relationship is attached to

        :param external_organization: The external_organization of this Relationship.
        :type: ExternalOrganization
        """
        
        self._external_organization = external_organization

    @property
    def relationship(self):
        """
        Gets the relationship of this Relationship.
        The relationship or role of the user to this external organization.Examples: Account Manager, Sales Engineer, Implementation Consultant

        :return: The relationship of this Relationship.
        :rtype: str
        """
        return self._relationship

    @relationship.setter
    def relationship(self, relationship):
        """
        Sets the relationship of this Relationship.
        The relationship or role of the user to this external organization.Examples: Account Manager, Sales Engineer, Implementation Consultant

        :param relationship: The relationship of this Relationship.
        :type: str
        """
        
        self._relationship = relationship

    @property
    def external_data_sources(self):
        """
        Gets the external_data_sources of this Relationship.
        Links to the sources of data (e.g. one source might be a CRM) that contributed data to this record.  Read-only, and only populated when requested via expand param.

        :return: The external_data_sources of this Relationship.
        :rtype: list[ExternalDataSource]
        """
        return self._external_data_sources

    @external_data_sources.setter
    def external_data_sources(self, external_data_sources):
        """
        Sets the external_data_sources of this Relationship.
        Links to the sources of data (e.g. one source might be a CRM) that contributed data to this record.  Read-only, and only populated when requested via expand param.

        :param external_data_sources: The external_data_sources of this Relationship.
        :type: list[ExternalDataSource]
        """
        
        self._external_data_sources = external_data_sources

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Relationship.
        The URI for this object

        :return: The self_uri of this Relationship.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Relationship.
        The URI for this object

        :param self_uri: The self_uri of this Relationship.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

