# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Program(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Program - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'published': 'bool',
            'topics': 'list[BaseTopicEntitiy]',
            'tags': 'list[str]',
            'modified_by': 'AddressableEntityRef',
            'date_modified': 'datetime',
            'published_by': 'AddressableEntityRef',
            'date_published': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'published': 'published',
            'topics': 'topics',
            'tags': 'tags',
            'modified_by': 'modifiedBy',
            'date_modified': 'dateModified',
            'published_by': 'publishedBy',
            'date_published': 'datePublished',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._published = None
        self._topics = None
        self._tags = None
        self._modified_by = None
        self._date_modified = None
        self._published_by = None
        self._date_published = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Program.
        The globally unique identifier for the object.

        :return: The id of this Program.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Program.
        The globally unique identifier for the object.

        :param id: The id of this Program.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Program.


        :return: The name of this Program.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Program.


        :param name: The name of this Program.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Program.


        :return: The description of this Program.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Program.


        :param description: The description of this Program.
        :type: str
        """
        
        self._description = description

    @property
    def published(self):
        """
        Gets the published of this Program.


        :return: The published of this Program.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this Program.


        :param published: The published of this Program.
        :type: bool
        """
        
        self._published = published

    @property
    def topics(self):
        """
        Gets the topics of this Program.


        :return: The topics of this Program.
        :rtype: list[BaseTopicEntitiy]
        """
        return self._topics

    @topics.setter
    def topics(self, topics):
        """
        Sets the topics of this Program.


        :param topics: The topics of this Program.
        :type: list[BaseTopicEntitiy]
        """
        
        self._topics = topics

    @property
    def tags(self):
        """
        Gets the tags of this Program.


        :return: The tags of this Program.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this Program.


        :param tags: The tags of this Program.
        :type: list[str]
        """
        
        self._tags = tags

    @property
    def modified_by(self):
        """
        Gets the modified_by of this Program.


        :return: The modified_by of this Program.
        :rtype: AddressableEntityRef
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this Program.


        :param modified_by: The modified_by of this Program.
        :type: AddressableEntityRef
        """
        
        self._modified_by = modified_by

    @property
    def date_modified(self):
        """
        Gets the date_modified of this Program.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this Program.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this Program.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this Program.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def published_by(self):
        """
        Gets the published_by of this Program.


        :return: The published_by of this Program.
        :rtype: AddressableEntityRef
        """
        return self._published_by

    @published_by.setter
    def published_by(self, published_by):
        """
        Sets the published_by of this Program.


        :param published_by: The published_by of this Program.
        :type: AddressableEntityRef
        """
        
        self._published_by = published_by

    @property
    def date_published(self):
        """
        Gets the date_published of this Program.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_published of this Program.
        :rtype: datetime
        """
        return self._date_published

    @date_published.setter
    def date_published(self, date_published):
        """
        Sets the date_published of this Program.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_published: The date_published of this Program.
        :type: datetime
        """
        
        self._date_published = date_published

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Program.
        The URI for this object

        :return: The self_uri of this Program.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Program.
        The URI for this object

        :param self_uri: The self_uri of this Program.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

