# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ManagementUnit(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ManagementUnit - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'business_unit': 'BusinessUnitReference',
            'start_day_of_week': 'str',
            'time_zone': 'str',
            'settings': 'ManagementUnitSettingsResponse',
            'metadata': 'WfmVersionedEntityMetadata',
            'division': 'DivisionReference',
            'version': 'int',
            'date_modified': 'datetime',
            'modified_by': 'UserReference',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'business_unit': 'businessUnit',
            'start_day_of_week': 'startDayOfWeek',
            'time_zone': 'timeZone',
            'settings': 'settings',
            'metadata': 'metadata',
            'division': 'division',
            'version': 'version',
            'date_modified': 'dateModified',
            'modified_by': 'modifiedBy',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._business_unit = None
        self._start_day_of_week = None
        self._time_zone = None
        self._settings = None
        self._metadata = None
        self._division = None
        self._version = None
        self._date_modified = None
        self._modified_by = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ManagementUnit.
        The globally unique identifier for the object.

        :return: The id of this ManagementUnit.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ManagementUnit.
        The globally unique identifier for the object.

        :param id: The id of this ManagementUnit.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this ManagementUnit.


        :return: The name of this ManagementUnit.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ManagementUnit.


        :param name: The name of this ManagementUnit.
        :type: str
        """
        
        self._name = name

    @property
    def business_unit(self):
        """
        Gets the business_unit of this ManagementUnit.
        The business unit to which this management unit belongs

        :return: The business_unit of this ManagementUnit.
        :rtype: BusinessUnitReference
        """
        return self._business_unit

    @business_unit.setter
    def business_unit(self, business_unit):
        """
        Sets the business_unit of this ManagementUnit.
        The business unit to which this management unit belongs

        :param business_unit: The business_unit of this ManagementUnit.
        :type: BusinessUnitReference
        """
        
        self._business_unit = business_unit

    @property
    def start_day_of_week(self):
        """
        Gets the start_day_of_week of this ManagementUnit.
        Start day of week for scheduling and forecasting purposes. Moving to Business Unit

        :return: The start_day_of_week of this ManagementUnit.
        :rtype: str
        """
        return self._start_day_of_week

    @start_day_of_week.setter
    def start_day_of_week(self, start_day_of_week):
        """
        Sets the start_day_of_week of this ManagementUnit.
        Start day of week for scheduling and forecasting purposes. Moving to Business Unit

        :param start_day_of_week: The start_day_of_week of this ManagementUnit.
        :type: str
        """
        allowed_values = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
        if start_day_of_week.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for start_day_of_week -> " + start_day_of_week)
            self._start_day_of_week = "outdated_sdk_version"
        else:
            self._start_day_of_week = start_day_of_week

    @property
    def time_zone(self):
        """
        Gets the time_zone of this ManagementUnit.
        The time zone for the management unit in standard Olson format.  Moving to Business Unit

        :return: The time_zone of this ManagementUnit.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """
        Sets the time_zone of this ManagementUnit.
        The time zone for the management unit in standard Olson format.  Moving to Business Unit

        :param time_zone: The time_zone of this ManagementUnit.
        :type: str
        """
        
        self._time_zone = time_zone

    @property
    def settings(self):
        """
        Gets the settings of this ManagementUnit.
        The configuration settings for this management unit

        :return: The settings of this ManagementUnit.
        :rtype: ManagementUnitSettingsResponse
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """
        Sets the settings of this ManagementUnit.
        The configuration settings for this management unit

        :param settings: The settings of this ManagementUnit.
        :type: ManagementUnitSettingsResponse
        """
        
        self._settings = settings

    @property
    def metadata(self):
        """
        Gets the metadata of this ManagementUnit.
        Version info metadata for this management unit. Deprecated, use settings.metadata

        :return: The metadata of this ManagementUnit.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this ManagementUnit.
        Version info metadata for this management unit. Deprecated, use settings.metadata

        :param metadata: The metadata of this ManagementUnit.
        :type: WfmVersionedEntityMetadata
        """
        
        self._metadata = metadata

    @property
    def division(self):
        """
        Gets the division of this ManagementUnit.
        The division to which this entity belongs.

        :return: The division of this ManagementUnit.
        :rtype: DivisionReference
        """
        return self._division

    @division.setter
    def division(self, division):
        """
        Sets the division of this ManagementUnit.
        The division to which this entity belongs.

        :param division: The division of this ManagementUnit.
        :type: DivisionReference
        """
        
        self._division = division

    @property
    def version(self):
        """
        Gets the version of this ManagementUnit.
        The version of the underlying entity.  Deprecated, use field from settings.metadata instead

        :return: The version of this ManagementUnit.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ManagementUnit.
        The version of the underlying entity.  Deprecated, use field from settings.metadata instead

        :param version: The version of this ManagementUnit.
        :type: int
        """
        
        self._version = version

    @property
    def date_modified(self):
        """
        Gets the date_modified of this ManagementUnit.
        The date and time at which this entity was last modified.  Deprecated, use field from settings.metadata instead. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ManagementUnit.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this ManagementUnit.
        The date and time at which this entity was last modified.  Deprecated, use field from settings.metadata instead. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ManagementUnit.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def modified_by(self):
        """
        Gets the modified_by of this ManagementUnit.
        The user who last modified this entity.  Deprecated, use field from settings.metadata instead

        :return: The modified_by of this ManagementUnit.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this ManagementUnit.
        The user who last modified this entity.  Deprecated, use field from settings.metadata instead

        :param modified_by: The modified_by of this ManagementUnit.
        :type: UserReference
        """
        
        self._modified_by = modified_by

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ManagementUnit.
        The URI for this object

        :return: The self_uri of this ManagementUnit.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ManagementUnit.
        The URI for this object

        :param self_uri: The self_uri of this ManagementUnit.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

