# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CobrowseSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CobrowseSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'allow_agent_control': 'bool',
            'mask_selectors': 'list[str]'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'allow_agent_control': 'allowAgentControl',
            'mask_selectors': 'maskSelectors'
        }

        self._enabled = None
        self._allow_agent_control = None
        self._mask_selectors = None

    @property
    def enabled(self):
        """
        Gets the enabled of this CobrowseSettings.
        Whether or not cobrowse is enabled

        :return: The enabled of this CobrowseSettings.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this CobrowseSettings.
        Whether or not cobrowse is enabled

        :param enabled: The enabled of this CobrowseSettings.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def allow_agent_control(self):
        """
        Gets the allow_agent_control of this CobrowseSettings.
        Whether the viewer should have option to request control

        :return: The allow_agent_control of this CobrowseSettings.
        :rtype: bool
        """
        return self._allow_agent_control

    @allow_agent_control.setter
    def allow_agent_control(self, allow_agent_control):
        """
        Sets the allow_agent_control of this CobrowseSettings.
        Whether the viewer should have option to request control

        :param allow_agent_control: The allow_agent_control of this CobrowseSettings.
        :type: bool
        """
        
        self._allow_agent_control = allow_agent_control

    @property
    def mask_selectors(self):
        """
        Gets the mask_selectors of this CobrowseSettings.
        Mask patterns that will apply to pages being shared

        :return: The mask_selectors of this CobrowseSettings.
        :rtype: list[str]
        """
        return self._mask_selectors

    @mask_selectors.setter
    def mask_selectors(self, mask_selectors):
        """
        Sets the mask_selectors of this CobrowseSettings.
        Mask patterns that will apply to pages being shared

        :param mask_selectors: The mask_selectors of this CobrowseSettings.
        :type: list[str]
        """
        
        self._mask_selectors = mask_selectors

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

