"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_redshift_1 = require("aws-cdk-lib/aws-redshift");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends aws_cdk_lib_1.Resource {
}
/**
 * A cluster parameter group
 *
 * @resource AWS::Redshift::ClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_ClusterParameterGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new aws_redshift_1.CfnClusterParameterGroup(this, 'Resource', {
            description: props.description || 'Cluster parameter group for family redshift-1.0',
            parameterGroupFamily: 'redshift-1.0',
            parameters: Object.entries(props.parameters).map(([name, value]) => {
                return { parameterName: name, parameterValue: value };
            }),
        });
        this.clusterParameterGroupName = resource.ref;
    }
    /**
     * Imports a parameter group
     */
    static fromClusterParameterGroupName(scope, id, clusterParameterGroupName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterParameterGroupName = clusterParameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.ClusterParameterGroup", version: "2.24.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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