"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({ username: props.username }),
                generateStringKey: 'password',
                excludeCharacters: '"@/\\\ \'',
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_DatabaseSecretProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.DatabaseSecret = DatabaseSecret;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.DatabaseSecret", version: "2.24.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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