# pylint: disable=invalid-name


"""Djaizz base DataSchema & DataSet classes."""


import json.decoder
import uuid


import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone

import model_utils.fields


class Migration(migrations.Migration):
    """Create Djaizz base DataSchema & DataSet classes."""

    initial = True

    dependencies = (('contenttypes', '0002_remove_content_type_name'),)

    operations = (
        migrations.CreateModel(
            name='DataSchema',

            fields=(
                ('polymorphic_ctype',
                 models.ForeignKey(
                    editable=False,
                    null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='polymorphic_aidata.dataschema_set+',
                    to='contenttypes.contenttype')),

                ('uuid',
                 models.UUIDField(
                    db_index=True,
                    default=uuid.uuid4,
                    editable=False,
                    help_text='UUID',
                    primary_key=True,
                    serialize=False,
                    unique=True,
                    verbose_name='UUID')),

                ('name',
                 models.CharField(
                    blank=True,
                    db_index=True,
                    default=None,
                    help_text='(optional) Unique Name',
                    max_length=255,
                    null=True,
                    unique=True,
                    verbose_name='(optional) Unique Name')),

                ('specs',
                 models.JSONField(
                    decoder=json.decoder.JSONDecoder,
                    default=None,
                    encoder=django.core.serializers.json.DjangoJSONEncoder,
                    help_text='Data Schema Specifications',
                    verbose_name='Data Schema Specifications')),

                ('created',
                 model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='created')),
                ('modified',
                 model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='modified'))
            ),

            options={
                'verbose_name': 'Data Schema',
                'verbose_name_plural': 'Data Schemas',
                'db_table': 'AIData_DataSchema',
                'ordering': ('name', '-modified'),
                'permissions': (),
                'get_latest_by': 'modified',
                'abstract': False,
                'managed': True,
                'proxy': False,
                'default_permissions': ('add', 'change', 'delete', 'view'),
                'select_on_save': False,
                'default_related_name': 'data_schemas',
                'required_db_features': (),
                'base_manager_name': 'objects',
                'default_manager_name': 'objects'
            }
        ),

        migrations.CreateModel(
            name='DataSet',

            fields=(
                ('polymorphic_ctype',
                 models.ForeignKey(
                    editable=False,
                    null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='polymorphic_aidata.dataset_set+',
                    to='contenttypes.contenttype')),

                ('uuid',
                 models.UUIDField(
                    db_index=True,
                    default=uuid.uuid4,
                    editable=False,
                    help_text='UUID',
                    primary_key=True,
                    serialize=False,
                    unique=True,
                    verbose_name='UUID')),

                ('name',
                 models.CharField(
                    blank=True,
                    db_index=True,
                    default=None,
                    help_text='(optional) Unique Name',
                    max_length=255,
                    null=True,
                    unique=True,
                    verbose_name='(optional) Unique Name')),

                ('schema',
                 models.ForeignKey(
                    blank=True,
                    default=None,
                    help_text='Data Set Schema',
                    null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    related_name='data_sets',
                    related_query_name='data_set',
                    to='AIData.dataschema',
                    verbose_name='Data Set Schema')),

                ('created',
                 model_utils.fields.AutoCreatedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='created')),
                ('modified',
                 model_utils.fields.AutoLastModifiedField(
                    default=django.utils.timezone.now,
                    editable=False,
                    verbose_name='modified'))
            ),

            options={
                'verbose_name': 'Data Set',
                'verbose_name_plural': 'Data Sets',
                'db_table': 'AIData_DataSet',
                'ordering': ('name', '-modified'),
                'permissions': (),
                'get_latest_by': 'modified',
                'abstract': False,
                'managed': True,
                'proxy': False,
                'default_permissions': ('add', 'change', 'delete', 'view'),
                'select_on_save': False,
                'default_related_name': 'data_sets',
                'required_db_features': (),
                'base_manager_name': 'objects',
                'default_manager_name': 'objects'
            }
        )
    )
