/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.curl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jmeter.protocol.http.curl.ArgumentHolder;

public class FileArgumentHolder
implements ArgumentHolder {
    private String name;
    private Map<String, String> metadata;

    private FileArgumentHolder(String name, Map<String, String> metadata) {
        this.name = name;
        this.metadata = metadata;
    }

    public static FileArgumentHolder of(String name) {
        if (name == null) {
            return new FileArgumentHolder("", Collections.emptyMap());
        }
        Pair<String, Map<String, String>> parsed = ArgumentHolder.parse(name);
        return new FileArgumentHolder((String)parsed.getLeft(), (Map)parsed.getRight());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileArgumentHolder other = (FileArgumentHolder)obj;
        return Objects.equals(this.name, other.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "FileArgumentHolder(" + this.name + ", " + this.metadata + ")";
    }

    @Override
    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }
}

