/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.geometry;

import java.util.ArrayList;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleSegment;
import jetbrains.datalore.base.geometry.DoubleVector;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0001:B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\rJ\u0011\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\rH\u0086\u0002J\u000e\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\rJ\u0013\u0010-\u001a\u00020*2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010/\u001a\u00020\u0000J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0004\u0018\u00010\u00002\u0006\u00103\u001a\u00020\u0000J\u000e\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020\u0000J\u000e\u00106\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\rJ\b\u00107\u001a\u000208H\u0016J\u000e\u00109\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0000J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\tR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010#\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012\u00a8\u0006;"}, d2={"Ljetbrains/datalore/base/geometry/DoubleRectangle;", "", "x", "", "y", "w", "h", "(DDDD)V", "xRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "yRange", "(Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;)V", "origin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "dimension", "(Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "bottom", "getBottom", "()D", "center", "getCenter", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getDimension", "height", "getHeight", "left", "getLeft", "getOrigin", "parts", "", "Ljetbrains/datalore/base/geometry/DoubleSegment;", "getParts", "()Ljava/lang/Iterable;", "right", "getRight", "top", "getTop", "width", "getWidth", "add", "v", "contains", "", "distance", "to", "equals", "other", "flip", "hashCode", "", "intersect", "r", "intersects", "rect", "subtract", "toString", "", "union", "Companion", "base-portable"})
public final class DoubleRectangle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector origin;
    @NotNull
    private final DoubleVector dimension;

    public DoubleRectangle(@NotNull DoubleVector origin, @NotNull DoubleVector dimension) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.origin = origin;
        this.dimension = dimension;
    }

    @NotNull
    public final DoubleVector getOrigin() {
        return this.origin;
    }

    @NotNull
    public final DoubleVector getDimension() {
        return this.dimension;
    }

    @NotNull
    public final DoubleVector getCenter() {
        return this.origin.add(this.dimension.mul(0.5));
    }

    public final double getLeft() {
        return this.origin.getX();
    }

    public final double getRight() {
        return this.origin.getX() + this.dimension.getX();
    }

    public final double getTop() {
        return this.origin.getY();
    }

    public final double getBottom() {
        return this.origin.getY() + this.dimension.getY();
    }

    public final double getWidth() {
        return this.dimension.getX();
    }

    public final double getHeight() {
        return this.dimension.getY();
    }

    @NotNull
    public final Iterable<DoubleSegment> getParts() {
        ArrayList<DoubleSegment> result = new ArrayList<DoubleSegment>();
        result.add(new DoubleSegment(this.origin, this.origin.add(new DoubleVector(this.dimension.getX(), 0.0))));
        result.add(new DoubleSegment(this.origin, this.origin.add(new DoubleVector(0.0, this.dimension.getY()))));
        result.add(new DoubleSegment(this.origin.add(this.dimension), this.origin.add(new DoubleVector(this.dimension.getX(), 0.0))));
        result.add(new DoubleSegment(this.origin.add(this.dimension), this.origin.add(new DoubleVector(0.0, this.dimension.getY()))));
        return result;
    }

    public DoubleRectangle(double x2, double y2, double w, double h) {
        this(new DoubleVector(x2, y2), new DoubleVector(w, h));
    }

    public DoubleRectangle(@NotNull ClosedRange<Double> xRange, @NotNull ClosedRange<Double> yRange) {
        Intrinsics.checkNotNullParameter(xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter(yRange, (String)"yRange");
        this(((Number)xRange.getLowerEnd()).doubleValue(), ((Number)yRange.getLowerEnd()).doubleValue(), ((Number)xRange.getUpperEnd()).doubleValue() - ((Number)xRange.getLowerEnd()).doubleValue(), ((Number)yRange.getUpperEnd()).doubleValue() - ((Number)yRange.getLowerEnd()).doubleValue());
    }

    @NotNull
    public final ClosedRange<Double> xRange() {
        return new ClosedRange<Comparable>(Double.valueOf(this.origin.getX()), Double.valueOf(this.origin.getX() + this.dimension.getX()));
    }

    @NotNull
    public final ClosedRange<Double> yRange() {
        return new ClosedRange<Comparable>(Double.valueOf(this.origin.getY()), Double.valueOf(this.origin.getY() + this.dimension.getY()));
    }

    public final boolean contains(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.origin.getX() <= v.getX() && this.origin.getX() + this.dimension.getX() >= v.getX() && this.origin.getY() <= v.getY() && this.origin.getY() + this.dimension.getY() >= v.getY();
    }

    @NotNull
    public final DoubleRectangle flip() {
        return new DoubleRectangle(this.origin.flip(), this.dimension.flip());
    }

    @NotNull
    public final DoubleRectangle union(@NotNull DoubleRectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        DoubleVector newOrigin = this.origin.min(rect.origin);
        DoubleVector corner = this.origin.add(this.dimension);
        DoubleVector rectCorner = rect.origin.add(rect.dimension);
        DoubleVector newCorner = corner.max(rectCorner);
        DoubleVector newDimension = newCorner.subtract(newOrigin);
        return new DoubleRectangle(newOrigin, newDimension);
    }

    public final boolean intersects(@NotNull DoubleRectangle rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        DoubleVector t1 = this.origin;
        DoubleVector t2 = this.origin.add(this.dimension);
        DoubleVector r1 = rect.origin;
        DoubleVector r2 = rect.origin.add(rect.dimension);
        return r2.getX() >= t1.getX() && t2.getX() >= r1.getX() && r2.getY() >= t1.getY() && t2.getY() >= r1.getY();
    }

    @Nullable
    public final DoubleRectangle intersect(@NotNull DoubleRectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        DoubleVector t1 = this.origin;
        DoubleVector t2 = this.origin.add(this.dimension);
        DoubleVector r1 = r.origin;
        DoubleVector r2 = r.origin.add(r.dimension);
        DoubleVector res1 = t1.max(r1);
        DoubleVector res2 = t2.min(r2);
        DoubleVector dim = res2.subtract(res1);
        return dim.getX() < 0.0 || dim.getY() < 0.0 ? (DoubleRectangle)null : new DoubleRectangle(res1, dim);
    }

    @NotNull
    public final DoubleRectangle add(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleRectangle(this.origin.add(v), this.dimension);
    }

    @NotNull
    public final DoubleRectangle subtract(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleRectangle(this.origin.subtract(v), this.dimension);
    }

    public final double distance(@NotNull DoubleVector to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        double result = 0.0;
        boolean hasResult = false;
        for (DoubleSegment s : this.getParts()) {
            if (!hasResult) {
                result = s.distance(to);
                hasResult = true;
                continue;
            }
            double distance = s.distance(to);
            if (!(distance < result)) continue;
            result = distance;
        }
        return result;
    }

    public int hashCode() {
        return this.origin.hashCode() * 31 + this.dimension.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DoubleRectangle)) {
            return false;
        }
        DoubleRectangle r = (DoubleRectangle)other;
        return r.origin.equals(this.origin) && r.dimension.equals(this.dimension);
    }

    @NotNull
    public String toString() {
        return "[rect " + this.origin + ", " + this.dimension + ']';
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/base/geometry/DoubleRectangle$Companion;", "", "()V", "span", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "leftTop", "Ljetbrains/datalore/base/geometry/DoubleVector;", "rightBottom", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleRectangle span(@NotNull DoubleVector leftTop, @NotNull DoubleVector rightBottom) {
            Intrinsics.checkNotNullParameter((Object)leftTop, (String)"leftTop");
            Intrinsics.checkNotNullParameter((Object)rightBottom, (String)"rightBottom");
            return new DoubleRectangle(leftTop, rightBottom.subtract(leftTop));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

