/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;

public class RandomBufferedReader
extends BufferedReader {
    private final RandomAccessFile raf;
    private InputStream is;
    private BufferedReader reader;
    private String encoding;
    private long markedPosition;

    public RandomBufferedReader(Reader in, RandomAccessFile raf, String encoding) throws UnsupportedEncodingException {
        super(in);
        this.raf = raf;
        this.encoding = encoding;
        this.is = Channels.newInputStream(raf.getChannel());
        this.initBufferedReader();
    }

    private void initBufferedReader() throws UnsupportedEncodingException {
        InputStreamReader isr = new InputStreamReader(this.is, this.encoding);
        this.reader = new BufferedReader(isr);
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
        this.initBufferedReader();
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.markedPosition = this.raf.getFilePointer();
    }

    @Override
    public void reset() throws IOException {
        this.raf.seek(this.markedPosition);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.is.close();
    }
}

