/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.control;

import com.blazemeter.jmeter.control.WeightedSwitchController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.Grid;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WeightedSwitchControllerGui
extends AbstractControllerGui {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String WEIGHTS = "Weight";
    private Grid grid;
    private JCheckBox isRandomChoiceCheckBox;

    public WeightedSwitchControllerGui() {
        this.init();
        this.clearGui();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel((Container)this.makeTitlePanel(), (String)((Object)((Object)this)).getClass().getSimpleName()), "North");
        JTable table = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && Boolean.parseBoolean((String)this.getModel().getValueAt(row, 2));
            }
        };
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                try {
                    String val = table.getModel().getValueAt(row, 2).toString();
                    cellComponent.setEnabled(Boolean.parseBoolean(val));
                }
                catch (Exception ex) {
                    cellComponent.setEnabled(true);
                }
                return cellComponent;
            }
        });
        this.grid = new Grid("Child Item Weights", new String[]{"Name", WEIGHTS, "Enabled"}, new Class[]{String.class, String.class, String.class}, (Object[])new String[]{"", "100", "true"}, table);
        table.removeColumn(table.getColumn("Enabled"));
        this.grid.getComponent(2).setVisible(false);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Random choice: ", 4));
        this.isRandomChoiceCheckBox = new JCheckBox();
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.isRandomChoiceCheckBox);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        container.add((Component)this.grid);
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public String getStaticLabel() {
        return "bzm - Weighted Switch Controller";
    }

    public TestElement createTestElement() {
        WeightedSwitchController te = new WeightedSwitchController();
        this.modifyTestElement((TestElement)te);
        return te;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof WeightedSwitchController) {
            WeightedSwitchController wsc = (WeightedSwitchController)element;
            if (this.grid.getModel().getRowCount() > 0) {
                wsc.setData(this.grid.getModel());
            }
            wsc.setIsRandomChoice(this.isRandomChoiceCheckBox.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        log.debug("Props: " + this.isShowing() + " " + this.isVisible() + " " + this.isEnabled() + " " + this.isFocusOwner());
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null && element instanceof WeightedSwitchController) {
            WeightedSwitchController wsc = (WeightedSwitchController)element;
            CollectionProperty oldData = wsc.getData();
            this.grid.getModel().clearData();
            this.isRandomChoiceCheckBox.setSelected(wsc.isRandomChoice());
            if (this.isShowing()) {
                this.fillGridFromTree(wsc, oldData);
            } else {
                JMeterPluginsUtils.collectionPropertyToTableModelRows((CollectionProperty)oldData, (PowerTableModel)this.grid.getModel());
            }
        }
    }

    private void fillGridFromTree(WeightedSwitchController wsc, CollectionProperty oldData) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        JMeterTreeNode root = (JMeterTreeNode)treeModel.getRoot();
        Map<JMeterTreeNode, Boolean> childItems = this.getChildItems(root, wsc);
        for (JMeterTreeNode node : childItems.keySet()) {
            String w = "100";
            JMeterProperty row = this.getRowByName(node.getTestElement().getName(), oldData);
            if (row != null) {
                w = ((CollectionProperty)row).get(1).getStringValue();
            }
            this.grid.getModel().addRow((Object[])new String[]{node.getTestElement().getName(), w, childItems.get(node).toString()});
        }
    }

    private JMeterProperty getRowByName(String rowName, CollectionProperty oldData) {
        for (int i = 0; i < oldData.size(); ++i) {
            JMeterProperty row = oldData.get(i);
            if (!(row instanceof CollectionProperty) || !rowName.equals(((CollectionProperty)row).get(0).getStringValue())) continue;
            return row;
        }
        return null;
    }

    private Map<JMeterTreeNode, Boolean> getChildItems(JMeterTreeNode root, WeightedSwitchController element) {
        LinkedHashMap<JMeterTreeNode, Boolean> result = new LinkedHashMap<JMeterTreeNode, Boolean>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            JMeterTreeNode child = (JMeterTreeNode)root.getChildAt(i);
            TestElement te = child.getTestElement();
            if (element != root.getTestElement()) {
                result.putAll(this.getChildItems(child, element));
                continue;
            }
            if (!(te instanceof Sampler) && !(te instanceof Controller)) continue;
            result.put(child, te.isEnabled());
        }
        return result;
    }

    public void clearGui() {
        super.clearGui();
        this.grid.getModel().clearData();
    }
}

