/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads;

import com.blazemeter.jmeter.gui.ArrangedLabelFieldPanel;
import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.ParamsPanel;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import kg.apc.jmeter.JMeterVariableEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadParamsFieldsPanel
extends ArrangedLabelFieldPanel
implements ParamsPanel {
    private static final Logger log = LoggerFactory.getLogger(LoadParamsFieldsPanel.class);
    protected JTextField targetRate = new JTextField();
    protected JTextField rampUpTime = new JTextField();
    protected JTextField steps = new JTextField();
    protected JTextField holdFor = new JTextField();
    protected JLabel targetRateLabel = new JLabel();
    protected JLabel rampUpLabel = new JLabel();
    protected JLabel holdLabel = new JLabel();

    public LoadParamsFieldsPanel(String targetLbl, String rampUpLbl, String holdLbl) {
        this.targetRateLabel.setText(targetLbl);
        this.rampUpLabel.setText(rampUpLbl);
        this.holdLabel.setText(holdLbl);
        this.add((Component)this.targetRateLabel, (Component)this.targetRate);
        this.add((Component)this.rampUpLabel, (Component)this.rampUpTime);
        this.add("Ramp-Up Steps Count: ", (Component)this.steps);
        this.add((Component)this.holdLabel, (Component)this.holdFor);
    }

    @Override
    public void modelToUI(AbstractDynamicThreadGroup tg) {
        this.targetRate.setText(tg.getTargetLevel());
        this.rampUpTime.setText(tg.getRampUp());
        this.steps.setText(tg.getSteps());
        this.holdFor.setText(tg.getHold());
    }

    @Override
    public void UItoModel(AbstractDynamicThreadGroup tg, JMeterVariableEvaluator evaluator) {
        tg.setTargetLevel(evaluator.evaluate(this.targetRate.getText()));
        tg.setRampUp(evaluator.evaluate(this.rampUpTime.getText()));
        tg.setSteps(evaluator.evaluate(this.steps.getText()));
        tg.setHold(evaluator.evaluate(this.holdFor.getText()));
    }

    @Override
    public void clearUI() {
        this.targetRate.setText("12");
        this.rampUpTime.setText("60");
        this.steps.setText("3");
        this.holdFor.setText("180");
    }

    public void addUpdateListener(DocumentListener listener) {
        this.targetRate.getDocument().addDocumentListener(listener);
        this.rampUpTime.getDocument().addDocumentListener(listener);
        this.steps.getDocument().addDocumentListener(listener);
        this.holdFor.getDocument().addDocumentListener(listener);
    }

    public void changeUnitInLabels(String unit) {
        String oldUnit = unit.equals("M") ? "S" : "M";
        String oldUnitStr = AbstractDynamicThreadGroup.getUnitStr(oldUnit);
        String unitStr = AbstractDynamicThreadGroup.getUnitStr(unit);
        log.debug(oldUnit + " " + oldUnitStr + "=>" + unitStr);
        this.targetRateLabel.setText(this.targetRateLabel.getText().replace("/" + oldUnitStr + ")", "/" + unitStr + ")"));
        this.rampUpLabel.setText(this.rampUpLabel.getText().replace("(" + oldUnitStr + ")", "(" + unitStr + ")"));
        this.holdLabel.setText(this.holdLabel.getText().replace("(" + oldUnitStr + ")", "(" + unitStr + ")"));
    }
}

