/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads;

import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.AdditionalFieldsPanel;
import com.blazemeter.jmeter.threads.LoadParamsFieldsPanel;
import com.blazemeter.jmeter.threads.ParamsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.GraphPanelChart;
import kg.apc.charting.rows.GraphRowExactValues;
import kg.apc.jmeter.DummyEvaluator;
import kg.apc.jmeter.JMeterVariableEvaluator;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jorphan.gui.NumberRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicThreadGroupGui
extends AbstractThreadGroupGui
implements DocumentListener,
Runnable,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamicThreadGroupGui.class);
    protected GraphPanelChart previewChart;
    protected ConcurrentHashMap<String, AbstractGraphRow> chartModel;
    protected boolean uiCreated = false;
    private ParamsPanel loadFields = null;
    private AdditionalFieldsPanel additionalFields = null;
    private JMeterVariableEvaluator evaluator = new DummyEvaluator();

    public void configure(TestElement element) {
        super.configure(element);
        if (!this.uiCreated) {
            this.initUI();
        }
        if (element instanceof AbstractDynamicThreadGroup) {
            AbstractDynamicThreadGroup tg = (AbstractDynamicThreadGroup)element;
            this.loadFields.modelToUI(tg);
            this.additionalFields.modelToUI(tg);
            this.updateUI();
        }
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (!this.uiCreated) {
            this.initUI();
        }
        if (element instanceof AbstractDynamicThreadGroup) {
            AbstractDynamicThreadGroup tg = (AbstractDynamicThreadGroup)element;
            this.loadFields.UItoModel(tg, this.evaluator);
            this.additionalFields.UItoModel(tg, this.evaluator);
        }
    }

    protected void initUI() {
        VerticalPanel container = new VerticalPanel();
        this.loadFields = this.createLoadPanel();
        container.add((Component)((Object)this.loadFields), "North");
        container.add((Component)GuiBuilderHelper.getComponentWithMargin((Component)this.getPreviewChart(), (int)2, (int)2, (int)0, (int)2), "Center");
        this.additionalFields = this.getAdditionalFieldsPanel();
        this.additionalFields.addActionListener(this);
        container.add((Component)this.additionalFields, "South");
        this.add((Component)container, "Center");
        this.uiCreated = true;
    }

    protected abstract AdditionalFieldsPanel getAdditionalFieldsPanel();

    public void clearGui() {
        super.clearGui();
        if (this.uiCreated) {
            this.loadFields.clearUI();
            this.additionalFields.clearUI();
        }
    }

    protected abstract ParamsPanel createLoadPanel();

    protected abstract AbstractDynamicThreadGroup createThreadGroupObject();

    protected abstract void setChartPropertiesFromTG(AbstractDynamicThreadGroup var1);

    protected abstract String getRowLabel(double var1);

    protected abstract Color getRowColor();

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(this);
    }

    public TestElement createTestElement() {
        AbstractDynamicThreadGroup te = this.createThreadGroupObject();
        this.modifyTestElement((TestElement)te);
        return te;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI() {
        super.updateUI();
        if (!this.uiCreated) {
            log.debug("Won't update UI");
            return;
        }
        log.debug("Updating UI");
        AbstractDynamicThreadGroup atg = this.createThreadGroupObject();
        JMeterVariableEvaluator evaluator = new JMeterVariableEvaluator();
        this.loadFields.UItoModel(atg, evaluator);
        this.additionalFields.UItoModel(atg, evaluator);
        try {
            this.updateChart(atg);
        }
        catch (NumberFormatException e) {
            this.previewChart.setErrorMessage("The values entered cannot be rendered in preview...");
        }
        finally {
            this.setChartPropertiesFromTG(atg);
            this.previewChart.invalidateCache();
            this.previewChart.repaint();
        }
        if (this.loadFields instanceof LoadParamsFieldsPanel) {
            LoadParamsFieldsPanel panel = (LoadParamsFieldsPanel)this.loadFields;
            panel.changeUnitInLabels(atg.getUnit());
        }
    }

    protected void updateChart(AbstractDynamicThreadGroup atg) {
        double targetRate = atg.getTargetLevelAsDouble();
        long rampUp = atg.getRampUpSeconds();
        long holdFor = atg.getHoldSeconds();
        long stepsCount = atg.getStepsAsLong();
        double unitFactor = atg.getUnitFactor();
        this.chartModel.clear();
        this.previewChart.clearErrorMessage();
        GraphRowExactValues row = new GraphRowExactValues();
        row.setColor(this.getRowColor());
        row.setDrawLine(true);
        row.setMarkerSize(0);
        row.setDrawThickLines(true);
        row.add(0L, 0.0);
        double totalArrivals = 0.0;
        if (stepsCount > 0L) {
            double stepSize = targetRate / (double)stepsCount;
            double stepLen = (double)rampUp / (double)stepsCount;
            int n = 1;
            while ((long)n <= stepsCount) {
                double stepRate = stepSize * (double)n;
                row.add(Math.round((double)(n - 1) * stepLen * 1000.0), stepRate);
                row.add(Math.round((double)n * stepLen * 1000.0), stepRate);
                totalArrivals += stepLen * stepRate;
                ++n;
            }
        } else {
            row.add(rampUp * 1000L, targetRate);
            totalArrivals += (double)rampUp * targetRate / 2.0;
        }
        row.add((rampUp + holdFor) * 1000L, targetRate);
        totalArrivals += (double)holdFor * targetRate;
        this.previewChart.setxAxisLabelRenderer((NumberRenderer)new DateTimeRenderer("HH:mm:ss", 0L));
        this.chartModel.put(this.getRowLabel(totalArrivals /= unitFactor), (AbstractGraphRow)row);
    }

    public Component getPreviewChart() {
        this.previewChart = new GraphPanelChart(false, true);
        this.chartModel = new ConcurrentHashMap();
        this.previewChart.setRows(this.chartModel);
        this.previewChart.setxAxisLabel("Elapsed Time");
        this.previewChart.setBorder(BorderFactory.createBevelBorder(1));
        return this.previewChart;
    }
}

