/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.rows.GraphRowAverages;
import kg.apc.charting.rows.GraphRowExactValues;
import kg.apc.charting.rows.GraphRowOverallAverages;
import kg.apc.charting.rows.GraphRowPercentiles;
import kg.apc.charting.rows.GraphRowSimple;
import kg.apc.charting.rows.GraphRowSumValues;

public abstract class AbstractGraphRow {
    public static final int MARKER_SIZE_NONE = 0;
    public static final int MARKER_SIZE_SMALL = 2;
    public static final int MARKER_SIZE_BIG = 4;
    public static final float LINE_THICKNESS_BIG = 3.0f;
    public static final int ROW_AVERAGES = 0;
    public static final int ROW_EXACT_VALUES = 1;
    public static final int ROW_OVERALL_AVERAGES = 2;
    public static final int ROW_PERCENTILES = 3;
    public static final int ROW_SUM_VALUES = 4;
    public static final int ROW_ROLLING_SUM_VALUES = 5;
    public static final int ROW_SIMPLE = 6;
    protected boolean drawLine = false;
    private boolean drawValueLabel = false;
    private boolean showInLegend = true;
    private boolean drawThickLines = false;
    protected int markerSize = 0;
    protected Color color = Color.BLACK;
    protected Rectangle legendColorBox = null;
    protected String label = "";
    protected long maxX = Long.MIN_VALUE;
    protected long minX = Long.MAX_VALUE;
    private boolean drawOnChart = true;
    private boolean drawBar = false;
    private boolean drawSpline = false;
    private int granulation = 0;
    private long firstTime = Long.MIN_VALUE;

    public void setDrawThickLines(boolean isThickLine) {
        this.drawThickLines = isThickLine;
    }

    public boolean isDrawThickLines() {
        return this.drawThickLines;
    }

    public void setDrawLine(boolean b) {
        this.drawLine = b;
    }

    public void setMarkerSize(int aMarkerSize) {
        this.markerSize = aMarkerSize;
    }

    public boolean isDrawLine() {
        return this.drawLine;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color nextColor) {
        this.color = nextColor;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public double[] getMinMaxY(int maxPoints) {
        double[] minMax = new double[]{Double.MAX_VALUE, 0.0};
        int factor = maxPoints > 0 ? (int)Math.floor((double)this.size() / (double)maxPoints) + 1 : 1;
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> it = this.iterator();
        while (it.hasNext()) {
            Map.Entry<Long, AbstractGraphPanelChartElement> element;
            double calcY = 0.0;
            if (factor == 1) {
                element = it.next();
                AbstractGraphPanelChartElement elt = element.getValue();
                calcY = elt.getValue();
            } else {
                double nbPointProcessed = 0.0;
                for (int i = 0; i < factor; ++i) {
                    if (!it.hasNext()) continue;
                    element = it.next();
                    calcY += element.getValue().getValue();
                    nbPointProcessed += 1.0;
                }
                calcY /= nbPointProcessed;
            }
            if (minMax[0] > calcY) {
                minMax[0] = calcY;
            }
            if (!(minMax[1] < calcY)) continue;
            minMax[1] = calcY;
        }
        if (this.isDrawBar()) {
            minMax[0] = 0.0;
        }
        return minMax;
    }

    public long getMinX() {
        return this.minX;
    }

    public void add(long xVal, double yVal) {
        if (this.getFirstTime() == Long.MIN_VALUE) {
            this.firstTime = xVal;
        }
        if (xVal > this.maxX) {
            this.maxX = xVal;
        }
        if (xVal < this.minX) {
            this.minX = xVal;
        }
    }

    public abstract Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> iterator();

    public boolean isDrawValueLabel() {
        return this.drawValueLabel;
    }

    public void setDrawValueLabel(boolean drawValueLabel) {
        this.drawValueLabel = drawValueLabel;
    }

    public boolean isShowInLegend() {
        return this.showInLegend;
    }

    public void setShowInLegend(boolean showInLegend) {
        this.showInLegend = showInLegend;
    }

    public boolean isDrawOnChart() {
        return this.drawOnChart;
    }

    public void setDrawOnChart(boolean drawOnChart) {
        this.drawOnChart = drawOnChart;
    }

    public void setDrawBar(boolean b) {
        this.drawBar = b;
    }

    public boolean isDrawBar() {
        return this.drawBar;
    }

    public boolean isDrawSpline() {
        return this.drawSpline;
    }

    public void setDrawSpline(boolean drawSpline) {
        this.drawSpline = drawSpline;
    }

    public int getGranulationValue() {
        return this.granulation;
    }

    public void setGranulationValue(int value) {
        this.granulation = value;
    }

    public void setExcludeOutOfRangeValues(boolean excludeOutOfRangeValues) {
    }

    public abstract AbstractGraphPanelChartElement getElement(long var1);

    public AbstractGraphPanelChartElement getLowerElement(long value) {
        throw new UnsupportedOperationException();
    }

    public Long getHigherKey(long value) {
        throw new UnsupportedOperationException();
    }

    public abstract int size();

    public static AbstractGraphRow instantiateNewRow(int rowType) {
        switch (rowType) {
            case 0: {
                return new GraphRowAverages();
            }
            case 1: {
                return new GraphRowExactValues();
            }
            case 2: {
                return new GraphRowOverallAverages();
            }
            case 3: {
                return new GraphRowPercentiles();
            }
            case 4: {
                return new GraphRowSumValues(false);
            }
            case 5: {
                return new GraphRowSumValues(true);
            }
            case 6: {
                return new GraphRowSimple();
            }
        }
        return null;
    }

    public long getFirstTime() {
        return this.firstTime;
    }

    public void setLegendColorBox(Rectangle val) {
        this.legendColorBox = val;
    }

    public Rectangle getLegendColorBox() {
        return this.legendColorBox;
    }
}

