/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.data;

import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\b&\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0004J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0003H\u0004R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00038F@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "", "myError", "", "(D)V", "<set-?>", "", "isMesh", "()Z", "setMesh", "(Z)V", "resolution", "getResolution", "()D", "setResolution", "equalsEnough", "d1", "d2", "nearZero", "d", "Companion", "MyColumnDetector", "MyRowDetector", "plot-common-portable"})
public abstract class RegularMeshDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double myError;
    private boolean isMesh;
    private double resolution;
    @NotNull
    private static final RegularMeshDetector NO_MESH = new RegularMeshDetector(){

        public boolean isMesh() {
            return false;
        }

        protected void setMesh(boolean value) {
            super.setMesh(value);
        }
    };

    protected RegularMeshDetector(double myError) {
        this.myError = myError;
    }

    public boolean isMesh() {
        return this.isMesh;
    }

    protected void setMesh(boolean bl) {
        this.isMesh = bl;
    }

    public final double getResolution() {
        boolean bl = this.isMesh();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Not a mesh";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.resolution;
    }

    protected final void setResolution(double d) {
        this.resolution = d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean equalsEnough(double d1, double d2) {
        if (d1 == d2) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        double d = d1 - d2;
        boolean bl2 = false;
        if (!(Math.abs(d) <= this.myError)) return false;
        return true;
    }

    protected final boolean nearZero(double d) {
        boolean bl = false;
        return Math.abs(d) <= this.myError;
    }

    public static final /* synthetic */ RegularMeshDetector access$getNO_MESH$cp() {
        return NO_MESH;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector$MyRowDetector;", "Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "myMinRowSize", "", "error", "", "values", "", "(IDLjava/lang/Iterable;)V", "init", "", "plot-common-portable"})
    private static final class MyRowDetector
    extends RegularMeshDetector {
        private final int myMinRowSize;

        public MyRowDetector(int myMinRowSize, double error, @NotNull Iterable<Double> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            super(error);
            this.myMinRowSize = myMinRowSize;
            this.init(values2);
        }

        private final void init(Iterable<Double> values2) {
            this.setMesh(false);
            double distance = 0.0;
            boolean distanceInitialized = false;
            Double prevValue = null;
            int count2 = this.myMinRowSize;
            for (Double value : values2) {
                if (!SeriesUtil.INSTANCE.isFinite(value)) {
                    return;
                }
                if (prevValue != null) {
                    Double d = value;
                    Intrinsics.checkNotNull((Object)d);
                    double dist = d - prevValue;
                    if (this.nearZero(dist)) {
                        return;
                    }
                    if (distanceInitialized) {
                        if (!this.equalsEnough(dist, distance)) {
                            return;
                        }
                    } else {
                        distance = dist;
                        distanceInitialized = true;
                    }
                }
                prevValue = value;
                if (--count2 != 0) continue;
            }
            if (distanceInitialized && count2 == 0) {
                boolean bl = false;
                this.setResolution(Math.abs(distance));
                this.setMesh(true);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector$MyColumnDetector;", "Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "myMinRowSize", "", "error", "", "values", "", "(IDLjava/lang/Iterable;)V", "init", "", "plot-common-portable"})
    private static final class MyColumnDetector
    extends RegularMeshDetector {
        private final int myMinRowSize;

        public MyColumnDetector(int myMinRowSize, double error, @NotNull Iterable<Double> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            super(error);
            this.myMinRowSize = myMinRowSize;
            this.init(values2);
        }

        private final void init(Iterable<Double> values2) {
            this.setMesh(false);
            int[] nArray = new int[]{0, 0};
            int[] rowSize = nArray;
            Double[] doubleArray = new Double[]{null, null};
            Double[] rowValue = doubleArray;
            int rowIndex = 0;
            for (Double value : values2) {
                int n;
                int n2;
                int[] nArray2;
                if (!SeriesUtil.INSTANCE.isFinite(value)) break;
                if (rowValue[rowIndex] == null) {
                    rowValue[rowIndex] = value;
                    nArray2 = rowSize;
                    n2 = rowIndex;
                    n = nArray2[n2];
                    nArray2[n2] = n + 1;
                    continue;
                }
                Double d = rowValue[rowIndex];
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                Double d3 = value;
                Intrinsics.checkNotNull((Object)d3);
                if (this.equalsEnough(d2, d3)) {
                    nArray2 = rowSize;
                    n2 = rowIndex;
                    n = nArray2[n2];
                    nArray2[n2] = n + 1;
                    continue;
                }
                if (rowIndex != 0) break;
                int n3 = rowIndex;
                rowIndex = n3 + 1;
                rowValue[rowIndex] = value;
                nArray2 = rowSize;
                n2 = rowIndex;
                n = nArray2[n2];
                nArray2[n2] = n + 1;
            }
            if (rowSize[0] == rowSize[1] && rowSize[0] >= this.myMinRowSize) {
                this.setMesh(true);
                Double d = rowValue[1];
                Intrinsics.checkNotNull((Object)d);
                double d4 = d;
                Double d5 = rowValue[0];
                Intrinsics.checkNotNull((Object)d5);
                double d6 = d4 - d5;
                boolean bl = false;
                this.setResolution(Math.abs(d6));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bJ\u0016\u0010\u0005\u001a\u00020\u00042\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bJ&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector$Companion;", "", "()V", "NO_MESH", "Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "tryColumn", "minRowSize", "", "error", "", "values", "", "tryRow", "plot-common-portable"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final RegularMeshDetector tryRow(@NotNull Iterable<Double> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            valuesIterator = values.iterator();
            v0 = valuesIterator.hasNext() != false ? valuesIterator.next() : null;
            v0 = v1 = valuesIterator.hasNext() != false ? valuesIterator.next() : null;
            if (v0 == null || v1 == null) {
                return RegularMeshDetector.access$getNO_MESH$cp();
            }
            var7_5 = v1 - v0;
            var9_6 = false;
            var7_5 = delta = Math.abs(var7_5);
            var9_6 = false;
            var10_8 = var7_5;
            var12_9 = false;
            if (Double.isInfinite(var10_8)) ** GOTO lbl-1000
            var10_8 = var7_5;
            var12_9 = false;
            if (!Double.isNaN(var10_8)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) {
                return RegularMeshDetector.access$getNO_MESH$cp();
            }
            error = delta / 10000.0;
            return this.tryRow(50, error, values);
        }

        @NotNull
        public final RegularMeshDetector tryRow(int minRowSize, double error, @NotNull Iterable<Double> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            return new MyRowDetector(minRowSize, error, values2);
        }

        @NotNull
        public final RegularMeshDetector tryColumn(@NotNull Iterable<Double> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            return this.tryColumn(50, 1.0E-50, values2);
        }

        @NotNull
        public final RegularMeshDetector tryColumn(int minRowSize, double error, @NotNull Iterable<Double> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            return new MyColumnDetector(minRowSize, error, values2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

