/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.base.stat.CorrelationStat;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00062\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tJB\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t2\b\b\u0002\u0010\u0012\u001a\u00020\u0004J&\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationUtil;", "", "()V", "correlation", "", "lxs", "", "lys", "correlationFunction", "Lkotlin/Function2;", "", "correlationMatrix", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "type", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "fillDiagonal", "", "threshold", "createComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "vars", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "plot-base-portable"})
public final class CorrelationUtil {
    @NotNull
    public static final CorrelationUtil INSTANCE = new CorrelationUtil();

    private CorrelationUtil() {
    }

    public final double correlation(@NotNull List<Double> lxs, @NotNull List<Double> lys, @NotNull Function2<? super double[], ? super double[], Double> correlationFunction) {
        Intrinsics.checkNotNullParameter(lxs, (String)"lxs");
        Intrinsics.checkNotNullParameter(lys, (String)"lys");
        Intrinsics.checkNotNullParameter(correlationFunction, (String)"correlationFunction");
        Pair<double[], double[]> pair2 = RegressionUtilKt.allFinite(lxs, lys);
        double[] xs = (double[])pair2.component1();
        double[] ys = (double[])pair2.component2();
        return ((Number)correlationFunction.invoke((Object)xs, (Object)ys)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Comparator<String> createComparator(List<DataFrame.Variable> vars) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)vars);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)((DataFrame.Variable)it.getValue()).getLabel(), (Object)it.getIndex());
            collection.add(pair2);
        }
        Map indexMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return (arg_0, arg_1) -> CorrelationUtil.createComparator$lambda-1(indexMap, arg_0, arg_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame correlationMatrix(@NotNull DataFrame data, @NotNull CorrelationStat.Type type, boolean fillDiagonal, @NotNull Function2<? super double[], ? super double[], Double> correlationFunction, double threshold) {
        int i;
        void $this$filterTo$iv$iv222;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(correlationFunction, (String)"correlationFunction");
        Iterable $this$filter$iv = data.variables();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv22 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv222) {
            DataFrame.Variable it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            if (!DataFrameUtil.INSTANCE.isNumeric(data, it.getName())) continue;
            destination$iv$iv22.add(element$iv$iv);
        }
        List numerics = (List)destination$iv$iv22;
        $i$f$filter = false;
        Set knownVars = new LinkedHashSet();
        boolean $this$filterTo$iv$iv222 = false;
        Map corrData = new LinkedHashMap();
        Iterator $this$filterTo$iv$iv222 = numerics.iterator();
        int destination$iv$iv22 = 0;
        while ($this$filterTo$iv$iv222.hasNext()) {
            int it;
            i = destination$iv$iv22++;
            DataFrame.Variable vx = (DataFrame.Variable)$this$filterTo$iv$iv222.next();
            List<Double> xs = data.getNumeric(vx);
            if (fillDiagonal) {
                CorrelationUtil.correlationMatrix$addCorrelation(threshold, knownVars, corrData, vx.getLabel(), vx.getLabel(), 1.0);
            }
            if ((it = 0) >= i) continue;
            do {
                int j = it++;
                DataFrame.Variable vy = (DataFrame.Variable)numerics.get(j);
                List<Double> ys = data.getNumeric(vy);
                double c = this.correlation(xs, ys, correlationFunction);
                if (type == CorrelationStat.Type.FULL || type == CorrelationStat.Type.LOWER) {
                    CorrelationUtil.correlationMatrix$addCorrelation(threshold, knownVars, corrData, vx.getLabel(), vy.getLabel(), c);
                }
                if (type != CorrelationStat.Type.FULL && type != CorrelationStat.Type.UPPER) continue;
                CorrelationUtil.correlationMatrix$addCorrelation(threshold, knownVars, corrData, vy.getLabel(), vx.getLabel(), c);
            } while (it < i);
        }
        destination$iv$iv22 = 0;
        ArrayList<String> var1 = new ArrayList<String>();
        i = 0;
        ArrayList<String> var2 = new ArrayList<String>();
        boolean vx = false;
        ArrayList corr = new ArrayList();
        List sortedVars = CollectionsKt.sortedWith((Iterable)knownVars, this.createComparator(numerics));
        for (String x2 : sortedVars) {
            for (String y2 : sortedVars) {
                var1.add(x2);
                var2.add(y2);
                corr.add(corrData.get(TuplesKt.to((Object)x2, (Object)y2)));
            }
        }
        return new DataFrame.Builder().putDiscrete(Stats.INSTANCE.getX(), (List)var1).putDiscrete(Stats.INSTANCE.getY(), (List)var2).putNumeric(Stats.INSTANCE.getCORR(), corr).build();
    }

    public static /* synthetic */ DataFrame correlationMatrix$default(CorrelationUtil correlationUtil, DataFrame dataFrame, CorrelationStat.Type type, boolean bl, Function2 function2, double d, int n, Object object) {
        if ((n & 0x10) != 0) {
            d = 0.0;
        }
        return correlationUtil.correlationMatrix(dataFrame, type, bl, (Function2<? super double[], ? super double[], Double>)function2, d);
    }

    private static final int createComparator$lambda-1(Map $indexMap, String a, String b) {
        Intrinsics.checkNotNullParameter((Object)$indexMap, (String)"$indexMap");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Integer n = (Integer)$indexMap.get(a);
        if (n == null) {
            String string = "Unknown variable label " + a + '.';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int lhsWeight = n;
        Integer n2 = (Integer)$indexMap.get(b);
        if (n2 == null) {
            String string = "Unknown variable label " + b + '.';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int rhsWeight = n2;
        return lhsWeight - rhsWeight;
    }

    private static final void correlationMatrix$addCorrelation(double $threshold, Set<String> knownVars, Map<Pair<String, String>, Double> corrData, String varX, String varY, double v) {
        boolean bl = false;
        if (Math.abs(v) >= $threshold) {
            knownVars.add(varX);
            knownVars.add(varY);
            Map<Pair<String, String>, Double> map2 = corrData;
            Pair pair2 = TuplesKt.to((Object)varX, (Object)varY);
            Double d = v;
            boolean bl2 = false;
            map2.put((Pair<String, String>)pair2, d);
        }
    }
}

