/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.HLineGeom;
import jetbrains.datalore.plot.base.geom.SmoothGeom;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintsCollection;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/base/geom/SmoothGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildHints", "", "dataPoints", "", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "Companion", "plot-base-portable"})
public final class SmoothGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = true;
    @NotNull
    private static final Function1<Double, Double> PROPORTION = Companion.PROPORTION.1.INSTANCE;
    @NotNull
    private static final Function1<Double, Double> ZERO = Companion.ZERO.1.INSTANCE;

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return HLineGeom.Companion.getLEGEND_KEY_ELEMENT_FACTORY();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterable<DataPointAesthetics> dataPoints2 = GeomUtil.INSTANCE.ordered_X((Iterable<? extends DataPointAesthetics>)GeomUtil.INSTANCE.with_X_Y(aesthetics.dataPoints()));
        LinesHelper helper = new LinesHelper(pos, coord, ctx2);
        helper.setAlphaEnabled(false);
        List<LinePath> regressionLines = helper.createLines(dataPoints2, GeomUtil.INSTANCE.getTO_LOCATION_X_Y());
        GeomBase.Companion.appendNodes(regressionLines, root);
        helper.setAlphaFilter(PROPORTION);
        helper.setWidthFilter(ZERO);
        List<LinePath> bands = helper.createBands(dataPoints2, GeomUtil.INSTANCE.getTO_LOCATION_X_YMAX(), GeomUtil.INSTANCE.getTO_LOCATION_X_YMIN());
        GeomBase.Companion.appendNodes(bands, root);
        this.buildHints(dataPoints2, pos, coord, ctx2);
    }

    private final void buildHints(Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2) {
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            Double d = dataPointAesthetics.x();
            Intrinsics.checkNotNull((Object)d);
            double xCoord = d;
            double objectRadius = 0.0;
            HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(objectRadius).defaultX(xCoord).defaultKind(ctx2.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
            Color color = dataPointAesthetics.fill();
            Intrinsics.checkNotNull((Object)color);
            HintsCollection.HintConfigFactory hint = hintConfigFactory.defaultColor(color, (Double)PROPORTION.invoke((Object)dataPointAesthetics.alpha()));
            HintsCollection hintsCollection = new HintsCollection(dataPointAesthetics, helper).addHint(hint.create(Aes.Companion.getYMAX())).addHint(hint.create(Aes.Companion.getYMIN()));
            HintsCollection.HintConfigFactory.HintConfig hintConfig = hint.create(Aes.Companion.getY());
            Color color2 = dataPointAesthetics.color();
            Intrinsics.checkNotNull((Object)color2);
            HintsCollection hintsCollection2 = hintsCollection.addHint(hintConfig.color(color2));
            DoubleVector clientCoord = helper.toClient(dataPointAesthetics.x(), dataPointAesthetics.y(), dataPointAesthetics);
            GeomTargetCollector.DefaultImpls.addPoint$default(ctx2.getTargetCollector(), dataPointAesthetics.index(), clientCoord, objectRadius, GeomTargetCollector.TooltipParams.Companion.params().setTipLayoutHints(hintsCollection2.getHints()), null, 16, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/SmoothGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "PROPORTION", "Lkotlin/Function1;", "", "ZERO", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

