/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action.template;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.template.Template;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TemplateManager {
    private static final String TEMPLATE_FILES = JMeterUtils.getPropDefault("template.files", "/bin/templates/templates.xml");
    private static final Logger log = LoggerFactory.getLogger(TemplateManager.class);
    private static final TemplateManager SINGLETON = new TemplateManager();
    private final Map<String, Template> allTemplates = this.readTemplates();

    public static TemplateManager getInstance() {
        return SINGLETON;
    }

    private TemplateManager() {
    }

    public void addTemplate(Template template) {
        this.allTemplates.put(template.getName(), template);
    }

    public TemplateManager reset() {
        this.allTemplates.clear();
        this.allTemplates.putAll(this.readTemplates());
        return this;
    }

    public String[] getTemplateNames() {
        return this.allTemplates.keySet().toArray(new String[this.allTemplates.size()]);
    }

    private Map<String, Template> readTemplates() {
        String[] templateFiles;
        TreeMap<String, Template> temps = new TreeMap<String, Template>();
        for (String templateFile : templateFiles = TEMPLATE_FILES.split(",")) {
            if (StringUtils.isEmpty((CharSequence)templateFile)) continue;
            File file = new File(JMeterUtils.getJMeterHome(), templateFile);
            try {
                if (file.exists() && file.canRead()) {
                    if (log.isInfoEnabled()) {
                        log.info("Reading templates from: {}", (Object)file.getAbsolutePath());
                    }
                    Map<String, Template> templates = this.parseTemplateFile(file);
                    File parent = file.getParentFile();
                    for (Template t : templates.values()) {
                        if (t.getFileName().startsWith("/")) continue;
                        t.setParent(parent);
                    }
                    temps.putAll(templates);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Ignoring template file:'{}' as it does not exist or is not readable", (Object)file.getAbsolutePath());
            }
            catch (Exception ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn("Ignoring template file:'{}', an error occurred parsing the file", (Object)file.getAbsolutePath(), (Object)ex);
            }
        }
        return temps;
    }

    public Map<String, Template> parseTemplateFile(File file) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder bd = dbf.newDocumentBuilder();
        bd.setEntityResolver(new DefaultEntityResolver());
        LoggingErrorHandler errorHandler = new LoggingErrorHandler(log, file);
        bd.setErrorHandler(errorHandler);
        Document document = bd.parse(file);
        document.getDocumentElement().normalize();
        TreeMap<String, Template> templates = new TreeMap<String, Template>();
        NodeList templateNodes = document.getElementsByTagName("template");
        for (int i = 0; i < templateNodes.getLength(); ++i) {
            Node node = templateNodes.item(i);
            this.parseTemplateNode(templates, node);
        }
        return templates;
    }

    void parseTemplateNode(Map<String, Template> templates, Node templateNode) {
        if (templateNode.getNodeType() == 1) {
            Template template = new Template();
            Element element = (Element)templateNode;
            template.setTestPlan("true".equals(element.getAttribute("isTestPlan")));
            template.setName(this.textOfFirstTag(element, "name"));
            template.setDescription(this.textOfFirstTag(element, "description"));
            template.setFileName(this.textOfFirstTag(element, "fileName"));
            NodeList nl = element.getElementsByTagName("parameters");
            if (nl.getLength() > 0) {
                NodeList parameterNodes = ((Element)nl.item(0)).getElementsByTagName("parameter");
                Map<String, String> parameters = this.parseParameterNodes(parameterNodes);
                template.setParameters(parameters);
            }
            templates.put(template.getName(), template);
        }
    }

    private String textOfFirstTag(Element element, String tagName) {
        return element.getElementsByTagName(tagName).item(0).getTextContent();
    }

    private Map<String, String> parseParameterNodes(NodeList parameterNodes) {
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        for (int i = 0; i < parameterNodes.getLength(); ++i) {
            Element element = (Element)parameterNodes.item(i);
            parametersMap.put(element.getAttribute("key"), element.getAttribute("defaultValue"));
        }
        return parametersMap;
    }

    public Template getTemplateByName(String selectedTemplate) {
        return this.allTemplates.get(selectedTemplate);
    }

    public static class DefaultEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("templates.dtd")) {
                return new InputSource(TemplateManager.class.getResourceAsStream("/org/apache/jmeter/gui/action/template/templates.dtd"));
            }
            return null;
        }
    }

    public static final class LoggingErrorHandler
    implements ErrorHandler {
        private Logger logger;
        private File file;

        public LoggingErrorHandler(Logger logger, File file) {
            this.logger = logger;
            this.file = file;
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            this.logger.warn("Warning parsing file {}", (Object)this.file, (Object)ex);
        }
    }
}

