/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.CLUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.JMeterGuiLauncher;
import org.apache.jmeter.NewDriver;
import org.apache.jmeter.ProxyAuthenticator;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.DistributedRunner;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.RemoteJMeterEngineImpl;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.action.LoadRecentProject;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.plugin.JMeterPlugin;
import org.apache.jmeter.plugin.PluginManager;
import org.apache.jmeter.report.config.ConfigurationException;
import org.apache.jmeter.report.dashboard.ReportGenerator;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.rmi.RmiUtils;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.RemoteThreadsListenerTestElement;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellServer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SecurityProviderLoader;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.jorphan.reflect.ClassTools;
import org.apache.jorphan.util.HeapDumper;
import org.apache.jorphan.util.JMeterException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.jorphan.util.ThreadDumper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMeter
implements JMeterPlugin {
    private static final String JSR223_INIT_FILE = "jsr223.init.file";
    private static final Logger log = LoggerFactory.getLogger(JMeter.class);
    public static final int UDP_PORT_DEFAULT = 4445;
    public static final String HTTP_PROXY_PASS = "http.proxyPass";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String JMETER_NON_GUI = "JMeter.NonGui";
    public static final String JMETER_REPORT_OUTPUT_DIR_PROPERTY = "jmeter.reportgenerator.outputdir";
    public static final String TREE_ICON_SIZE = "jmeter.tree.icons.size";
    public static final String DEFAULT_TREE_ICON_SIZE = "19x19";
    protected static final String KEY_SIZE = "<SIZE>";
    private static final String USE_LAST_JMX = "LAST";
    private static final int PROXY_PASSWORD = 97;
    private static final int JMETER_HOME_OPT = 100;
    private static final int HELP_OPT = 104;
    private static final int OPTIONS_OPT = 63;
    private static final int JMLOGCONF_OPT = 105;
    private static final int JMLOGFILE_OPT = 106;
    private static final int LOGFILE_OPT = 108;
    private static final int NONGUI_OPT = 110;
    private static final int PROPFILE_OPT = 112;
    private static final int PROPFILE2_OPT = 113;
    private static final int REMOTE_OPT = 114;
    private static final int SERVER_OPT = 115;
    private static final int TESTFILE_OPT = 116;
    private static final int PROXY_USERNAME = 117;
    private static final int VERSION_OPT = 118;
    private static final int REPORT_GENERATING_OPT = 103;
    private static final int REPORT_AT_END_OPT = 101;
    private static final int REPORT_OUTPUT_FOLDER_OPT = 111;
    private static final int FORCE_DELETE_RESULT_FILE = 102;
    private static final int SYSTEM_PROPERTY = 68;
    private static final int JMETER_GLOBAL_PROP = 71;
    private static final int PROXY_SCHEME = 69;
    private static final int PROXY_HOST = 72;
    private static final int JMETER_PROPERTY = 74;
    private static final int LOGLEVEL = 76;
    private static final int NONPROXY_HOSTS = 78;
    private static final int PROXY_PORT = 80;
    private static final int REMOTE_OPT_PARAM = 82;
    private static final int SYSTEM_PROPFILE = 83;
    private static final int REMOTE_STOP = 88;
    private static final String JMX_SUFFIX = ".JMX";
    private static final String PACKAGE_PREFIX = "org.apache.";
    private static final CLOptionDescriptor D_OPTIONS_OPT = new CLOptionDescriptor("?", 8, 63, "print command line options and exit");
    private static final CLOptionDescriptor D_HELP_OPT = new CLOptionDescriptor("help", 8, 104, "print usage information and exit");
    private static final CLOptionDescriptor D_VERSION_OPT = new CLOptionDescriptor("version", 8, 118, "print the version information and exit");
    private static final CLOptionDescriptor D_PROPFILE_OPT = new CLOptionDescriptor("propfile", 2, 112, "the jmeter property file to use");
    private static final CLOptionDescriptor D_PROPFILE2_OPT = new CLOptionDescriptor("addprop", 34, 113, "additional JMeter property file(s)");
    private static final CLOptionDescriptor D_TESTFILE_OPT = new CLOptionDescriptor("testfile", 2, 116, "the jmeter test(.jmx) file to run. \"-t LAST\" will load last used file");
    private static final CLOptionDescriptor D_LOGFILE_OPT = new CLOptionDescriptor("logfile", 2, 108, "the file to log samples to");
    private static final CLOptionDescriptor D_JMLOGCONF_OPT = new CLOptionDescriptor("jmeterlogconf", 2, 105, "jmeter logging configuration file (log4j2.xml)");
    private static final CLOptionDescriptor D_JMLOGFILE_OPT = new CLOptionDescriptor("jmeterlogfile", 2, 106, "jmeter run log file (jmeter.log)");
    private static final CLOptionDescriptor D_NONGUI_OPT = new CLOptionDescriptor("nongui", 8, 110, "run JMeter in nongui mode");
    private static final CLOptionDescriptor D_SERVER_OPT = new CLOptionDescriptor("server", 8, 115, "run the JMeter server");
    private static final CLOptionDescriptor D_PROXY_SCHEME = new CLOptionDescriptor("proxyScheme", 2, 69, "Set a proxy scheme to use for the proxy server");
    private static final CLOptionDescriptor D_PROXY_HOST = new CLOptionDescriptor("proxyHost", 2, 72, "Set a proxy server for JMeter to use");
    private static final CLOptionDescriptor D_PROXY_PORT = new CLOptionDescriptor("proxyPort", 2, 80, "Set proxy server port for JMeter to use");
    private static final CLOptionDescriptor D_NONPROXY_HOSTS = new CLOptionDescriptor("nonProxyHosts", 2, 78, "Set nonproxy host list (e.g. *.apache.org|localhost)");
    private static final CLOptionDescriptor D_PROXY_USERNAME = new CLOptionDescriptor("username", 2, 117, "Set username for proxy server that JMeter is to use");
    private static final CLOptionDescriptor D_PROXY_PASSWORD = new CLOptionDescriptor("password", 2, 97, "Set password for proxy server that JMeter is to use");
    private static final CLOptionDescriptor D_JMETER_PROPERTY = new CLOptionDescriptor("jmeterproperty", 48, 74, "Define additional JMeter properties");
    private static final CLOptionDescriptor D_JMETER_GLOBAL_PROP = new CLOptionDescriptor("globalproperty", 48, 71, "Define Global properties (sent to servers)\n\t\te.g. -Gport=123 or -Gglobal.properties");
    private static final CLOptionDescriptor D_SYSTEM_PROPERTY = new CLOptionDescriptor("systemproperty", 48, 68, "Define additional system properties");
    private static final CLOptionDescriptor D_SYSTEM_PROPFILE = new CLOptionDescriptor("systemPropertyFile", 34, 83, "additional system property file(s)");
    private static final CLOptionDescriptor D_LOGLEVEL = new CLOptionDescriptor("loglevel", 48, 76, "[category=]level e.g. jorphan=INFO, jmeter.util=DEBUG or com.example.foo=WARN");
    private static final CLOptionDescriptor D_REMOTE_OPT = new CLOptionDescriptor("runremote", 8, 114, "Start remote servers (as defined in remote_hosts)");
    private static final CLOptionDescriptor D_REMOTE_OPT_PARAM = new CLOptionDescriptor("remotestart", 2, 82, "Start these remote servers (overrides remote_hosts)");
    private static final CLOptionDescriptor D_JMETER_HOME_OPT = new CLOptionDescriptor("homedir", 2, 100, "the jmeter home directory to use");
    private static final CLOptionDescriptor D_REMOTE_STOP = new CLOptionDescriptor("remoteexit", 8, 88, "Exit the remote servers at end of test (non-GUI)");
    private static final CLOptionDescriptor D_REPORT_GENERATING_OPT = new CLOptionDescriptor("reportonly", 2, 103, "generate report dashboard only, from a test results file", new CLOptionDescriptor[]{D_NONGUI_OPT, D_REMOTE_OPT, D_REMOTE_OPT_PARAM, D_LOGFILE_OPT});
    private static final CLOptionDescriptor D_REPORT_AT_END_OPT = new CLOptionDescriptor("reportatendofloadtests", 8, 101, "generate report dashboard after load test");
    private static final CLOptionDescriptor D_REPORT_OUTPUT_FOLDER_OPT = new CLOptionDescriptor("reportoutputfolder", 2, 111, "output folder for report dashboard");
    private static final CLOptionDescriptor D_FORCE_DELETE_RESULT_FILE = new CLOptionDescriptor("forceDeleteResultFile", 8, 102, "force delete existing results files and web report folder if present before starting the test");
    private static final String[][] DEFAULT_ICONS = new String[][]{{"org.apache.jmeter.control.gui.TestPlanGui", "org/apache/jmeter/images/beaker.gif"}, {"org.apache.jmeter.timers.gui.AbstractTimerGui", "org/apache/jmeter/images/timer.gif"}, {"org.apache.jmeter.threads.gui.ThreadGroupGui", "org/apache/jmeter/images/thread.gif"}, {"org.apache.jmeter.visualizers.gui.AbstractListenerGui", "org/apache/jmeter/images/meter.png"}, {"org.apache.jmeter.config.gui.AbstractConfigGui", "org/apache/jmeter/images/testtubes.png"}, {"org.apache.jmeter.processor.gui.AbstractPreProcessorGui", "org/apache/jmeter/images/leafnode.gif"}, {"org.apache.jmeter.processor.gui.AbstractPostProcessorGui", "org/apache/jmeter/images/leafnodeflip.gif"}, {"org.apache.jmeter.control.gui.AbstractControllerGui", "org/apache/jmeter/images/knob.gif"}, {"org.apache.jmeter.control.gui.WorkBenchGui", "org/apache/jmeter/images/clipboard.gif"}, {"org.apache.jmeter.samplers.gui.AbstractSamplerGui", "org/apache/jmeter/images/pipet.png"}, {"org.apache.jmeter.assertions.gui.AbstractAssertionGui", "org/apache/jmeter/images/question.gif"}};
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{D_OPTIONS_OPT, D_HELP_OPT, D_VERSION_OPT, D_PROPFILE_OPT, D_PROPFILE2_OPT, D_TESTFILE_OPT, D_LOGFILE_OPT, D_JMLOGCONF_OPT, D_JMLOGFILE_OPT, D_NONGUI_OPT, D_SERVER_OPT, D_PROXY_SCHEME, D_PROXY_HOST, D_PROXY_PORT, D_NONPROXY_HOSTS, D_PROXY_USERNAME, D_PROXY_PASSWORD, D_JMETER_PROPERTY, D_JMETER_GLOBAL_PROP, D_SYSTEM_PROPERTY, D_SYSTEM_PROPFILE, D_FORCE_DELETE_RESULT_FILE, D_LOGLEVEL, D_REMOTE_OPT, D_REMOTE_OPT_PARAM, D_JMETER_HOME_OPT, D_REMOTE_STOP, D_REPORT_GENERATING_OPT, D_REPORT_AT_END_OPT, D_REPORT_OUTPUT_FOLDER_OPT};
    private Properties remoteProps;
    private boolean remoteStop;
    private boolean deleteResultFile = false;

    public void start(String[] args) {
        block23: {
            CLArgsParser parser = new CLArgsParser(args, options);
            String error = parser.getErrorString();
            if (error == null) {
                boolean nonGuiOnly;
                boolean gui = parser.getArgumentById(110) == null;
                boolean bl = nonGuiOnly = parser.getArgumentById(114) != null || parser.getArgumentById(82) != null || parser.getArgumentById(88) != null;
                if (gui && nonGuiOnly) {
                    error = "-r and -R and -X are only valid in non-GUI mode";
                }
            }
            if (null != error) {
                System.err.println("Error: " + error);
                System.out.println("Usage");
                System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
                System.out.println("Error: " + error);
                return;
            }
            try {
                CLOption testReportOpt;
                this.initializeProperties(parser);
                SecurityProviderLoader.addSecurityProvider(JMeterUtils.getJMeterProperties());
                Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
                    if (!(e instanceof ThreadDeath)) {
                        log.error("Uncaught exception in thread {}", (Object)t, (Object)e);
                        System.err.println("Uncaught Exception " + e + " in thread " + t + ". See log file for details.");
                    }
                });
                if (log.isInfoEnabled()) {
                    log.info(JMeterUtils.getJMeterCopyright());
                    log.info("Version {}", (Object)JMeterUtils.getJMeterVersion());
                    log.info("java.version={}", (Object)System.getProperty("java.version"));
                    log.info("java.vm.name={}", (Object)System.getProperty("java.vm.name"));
                    log.info("os.name={}", (Object)System.getProperty("os.name"));
                    log.info("os.arch={}", (Object)System.getProperty("os.arch"));
                    log.info("os.version={}", (Object)System.getProperty("os.version"));
                    log.info("file.encoding={}", (Object)System.getProperty("file.encoding"));
                    log.info("java.awt.headless={}", (Object)System.getProperty("java.awt.headless"));
                    log.info("Max memory     ={}", (Object)Runtime.getRuntime().maxMemory());
                    log.info("Available Processors ={}", (Object)Runtime.getRuntime().availableProcessors());
                    log.info("Default Locale={}", (Object)Locale.getDefault().getDisplayName());
                    log.info("JMeter  Locale={}", (Object)JMeterUtils.getLocale().getDisplayName());
                    log.info("JMeterHome={}", (Object)JMeterUtils.getJMeterHome());
                    log.info("user.dir  ={}", (Object)System.getProperty("user.dir"));
                    log.info("PWD       ={}", (Object)new File(".").getCanonicalPath());
                    log.info("IP: {} Name: {} FullName: {}", new Object[]{JMeterUtils.getLocalHostIP(), JMeterUtils.getLocalHostName(), JMeterUtils.getLocalHostFullName()});
                }
                this.setProxy(parser);
                this.updateClassLoader();
                if (log.isDebugEnabled()) {
                    String jcp = System.getProperty("java.class.path");
                    String[] bits = jcp.split(File.pathSeparator);
                    log.debug("ClassPath");
                    for (String bit : bits) {
                        log.debug(bit);
                    }
                }
                Instant now = Instant.now();
                JMeterUtils.setProperty("START.MS", Long.toString(now.toEpochMilli()));
                JMeterUtils.setProperty("START.YMD", JMeter.getFormatter("yyyyMMdd").format(now));
                JMeterUtils.setProperty("START.HMS", JMeter.getFormatter("HHmmss").format(now));
                if (parser.getArgumentById(118) != null) {
                    this.displayAsciiArt();
                    break block23;
                }
                if (parser.getArgumentById(104) != null) {
                    this.displayAsciiArt();
                    System.out.println(JMeterUtils.getResourceFileAsText("org/apache/jmeter/help.txt"));
                    break block23;
                }
                if (parser.getArgumentById(63) != null) {
                    this.displayAsciiArt();
                    System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
                    break block23;
                }
                if (parser.getArgumentById(115) != null) {
                    try {
                        RemoteJMeterEngineImpl.startServer(RmiUtils.getRmiRegistryPort());
                        this.startOptionalServers();
                        break block23;
                    }
                    catch (Exception ex) {
                        System.err.println("Server failed to start: " + ex);
                        log.error("Giving up, as server failed with:", (Throwable)ex);
                        throw ex;
                    }
                }
                String testFile = null;
                CLOption testFileOpt = parser.getArgumentById(116);
                if (testFileOpt != null && USE_LAST_JMX.equals(testFile = testFileOpt.getArgument())) {
                    testFile = LoadRecentProject.getRecentFile(0);
                }
                if ((testReportOpt = parser.getArgumentById(103)) != null) {
                    String reportFile = testReportOpt.getArgument();
                    this.extractAndSetReportOutputFolder(parser, this.deleteResultFile);
                    ReportGenerator generator = new ReportGenerator(reportFile, null);
                    generator.generate();
                } else if (parser.getArgumentById(110) == null) {
                    PluginManager.install(this, true);
                    String initialTestFile = testFile;
                    JMeterGuiLauncher.startGui(initialTestFile);
                    this.startOptionalServers();
                } else {
                    CLOption reportAtEndOpt;
                    this.extractAndSetReportOutputFolder(parser, this.deleteResultFile);
                    CLOption remoteTest = parser.getArgumentById(82);
                    if (remoteTest == null) {
                        remoteTest = parser.getArgumentById(114);
                    }
                    CLOption jtl = parser.getArgumentById(108);
                    String jtlFile = null;
                    if (jtl != null) {
                        jtlFile = this.processLAST(jtl.getArgument(), ".jtl");
                    }
                    if ((reportAtEndOpt = parser.getArgumentById(101)) != null && jtlFile == null) {
                        throw new IllegalUserActionException("Option -e requires -l option");
                    }
                    this.startNonGui(testFile, jtlFile, remoteTest, reportAtEndOpt != null);
                    this.startOptionalServers();
                }
            }
            catch (IllegalUserActionException e2) {
                System.out.println("Incorrect Usage:" + e2.getMessage());
                System.out.println(CLUtil.describeOptions((CLOptionDescriptor[])options).toString());
            }
            catch (Throwable e3) {
                log.error("An error occurred: ", e3);
                System.out.println("An error occurred: " + e3.getMessage());
                System.exit(1);
            }
        }
    }

    private static DateTimeFormatter getFormatter(String pattern) {
        return DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.systemDefault());
    }

    private void extractAndSetReportOutputFolder(CLArgsParser parser, boolean deleteReportFolder) {
        CLOption reportOutputFolderOpt = parser.getArgumentById(111);
        if (reportOutputFolderOpt != null) {
            String reportOutputFolder = parser.getArgumentById(111).getArgument();
            File reportOutputFolderAsFile = new File(reportOutputFolder);
            JOrphanUtils.canSafelyWriteToFolder((File)reportOutputFolderAsFile, (boolean)deleteReportFolder);
            String reportOutputFolderAbsPath = reportOutputFolderAsFile.getAbsolutePath();
            log.info("Setting property '{}' to:'{}'", (Object)JMETER_REPORT_OUTPUT_DIR_PROPERTY, (Object)reportOutputFolderAbsPath);
            JMeterUtils.setProperty(JMETER_REPORT_OUTPUT_DIR_PROPERTY, reportOutputFolderAbsPath);
        }
    }

    private void displayAsciiArt() {
        try (InputStream inputStream = JMeter.class.getResourceAsStream("jmeter_as_ascii_art.txt");){
            if (inputStream != null) {
                String text = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                System.out.println(text);
            }
        }
        catch (Exception e1) {
            System.out.println(JMeterUtils.getJMeterCopyright());
            System.out.println("Version " + JMeterUtils.getJMeterVersion());
        }
    }

    private void updateClassLoader() throws MalformedURLException {
        this.updatePath("search_paths", ";", true);
        this.updatePath("user.classpath", File.pathSeparator, true);
        this.updatePath("plugin_dependency_paths", ";", false);
    }

    private void updatePath(String property, String sep, boolean cp) throws MalformedURLException {
        String userpath = JMeterUtils.getPropDefault(property, "");
        if (userpath.length() <= 0) {
            return;
        }
        log.info("{}={}", (Object)property, (Object)userpath);
        StringTokenizer tok = new StringTokenizer(userpath, sep);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            File f = new File(path);
            if (!f.canRead() && !f.isDirectory()) {
                log.warn("Can't read {}", (Object)path);
                continue;
            }
            if (cp) {
                log.info("Adding to classpath and loader: {}", (Object)path);
                NewDriver.addPath((String)path);
                continue;
            }
            log.info("Adding to loader: {}", (Object)path);
            NewDriver.addURL((String)path);
        }
    }

    private void startOptionalServers() {
        int bshport = JMeterUtils.getPropDefault("beanshell.server.port", 0);
        String bshfile = JMeterUtils.getPropDefault("beanshell.server.file", "");
        if (bshport > 0) {
            log.info("Starting Beanshell server ({},{})", (Object)bshport, (Object)bshfile);
            BeanShellServer t = new BeanShellServer(bshport, bshfile);
            t.run();
        }
        this.runInitScripts();
        int mirrorPort = JMeterUtils.getPropDefault("mirror.server.port", 0);
        if (mirrorPort > 0) {
            log.info("Starting Mirror server ({})", (Object)mirrorPort);
            try {
                Object instance = ClassTools.construct((String)"org.apache.jmeter.protocol.http.control.HttpMirrorControl", (int)mirrorPort);
                ClassTools.invoke((Object)instance, (String)"startHttpMirror");
            }
            catch (JMeterException e) {
                log.warn("Could not start Mirror server", (Throwable)e);
            }
        }
    }

    void runInitScripts() {
        String jsr223Init;
        block21: {
            String bshinit = JMeterUtils.getProperty("beanshell.init.file");
            if (bshinit != null) {
                log.info("Running Beanshell on file: {}", (Object)bshinit);
                try {
                    BeanShellInterpreter bsi = new BeanShellInterpreter();
                    bsi.source(bshinit);
                }
                catch (ClassNotFoundException | JMeterException e) {
                    if (!log.isWarnEnabled()) break block21;
                    log.warn("Could not process Beanshell file: {}", (Object)e.getMessage());
                }
            }
        }
        if ((jsr223Init = JMeterUtils.getProperty(JSR223_INIT_FILE)) != null) {
            log.info("Running JSR-223 init script in file: {}", (Object)jsr223Init);
            File file = new File(jsr223Init);
            if (file.exists() && file.canRead()) {
                String extension = (String)StringUtils.defaultIfBlank((CharSequence)FilenameUtils.getExtension((String)jsr223Init), (CharSequence)"Groovy");
                try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
                    ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                    ScriptEngine engine = scriptEngineManager.getEngineByExtension(extension);
                    if (engine == null) {
                        log.warn("No script engine found for [{}]. Will try to use Groovy. Possible engines and their extensions are: {}", (Object)extension, this.getEnginesAndExtensions(scriptEngineManager));
                        extension = "Groovy";
                        engine = scriptEngineManager.getEngineByName(extension);
                    }
                    Bindings bindings = engine.createBindings();
                    Logger logger = LoggerFactory.getLogger((String)JSR223_INIT_FILE);
                    bindings.put("log", (Object)logger);
                    Properties props = JMeterUtils.getJMeterProperties();
                    bindings.put("props", (Object)props);
                    bindings.put("OUT", (Object)System.out);
                    engine.eval((Reader)reader, bindings);
                }
                catch (IOException | ScriptException ex) {
                    log.error("Error running init script {} with engine for {}: {}", new Object[]{jsr223Init, extension, ex});
                }
            } else {
                log.error("Script {} referenced by property {} is not readable or does not exist", (Object)file.getAbsolutePath(), (Object)JSR223_INIT_FILE);
            }
        }
    }

    private Map<String, List<String>> getEnginesAndExtensions(ScriptEngineManager scriptEngineManager) {
        return scriptEngineManager.getEngineFactories().stream().collect(Collectors.toMap(f -> f.getLanguageName() + " (" + f.getLanguageVersion() + ")", ScriptEngineFactory::getExtensions));
    }

    private void setProxy(CLArgsParser parser) throws IllegalUserActionException {
        if (parser.getArgumentById(117) != null) {
            String u;
            Properties jmeterProps = JMeterUtils.getJMeterProperties();
            if (parser.getArgumentById(97) != null) {
                u = parser.getArgumentById(117).getArgument();
                String p = parser.getArgumentById(97).getArgument();
                Authenticator.setDefault(new ProxyAuthenticator(u, p));
                log.info("Set Proxy login: {}/{}", (Object)u, (Object)p);
                jmeterProps.setProperty(HTTP_PROXY_USER, u);
                jmeterProps.setProperty(HTTP_PROXY_PASS, p);
            } else {
                u = parser.getArgumentById(117).getArgument();
                Authenticator.setDefault(new ProxyAuthenticator(u, ""));
                log.info("Set Proxy login: {}", (Object)u);
                jmeterProps.setProperty(HTTP_PROXY_USER, u);
            }
        }
        if (parser.getArgumentById(72) != null && parser.getArgumentById(80) != null) {
            String h = parser.getArgumentById(72).getArgument();
            String p = parser.getArgumentById(80).getArgument();
            System.setProperty("http.proxyHost", h);
            System.setProperty("https.proxyHost", h);
            System.setProperty("http.proxyPort", p);
            System.setProperty("https.proxyPort", p);
            String proxyScheme = null;
            if (parser.getArgumentById(69) != null && !StringUtils.isBlank((CharSequence)(proxyScheme = parser.getArgumentById(69).getArgument()))) {
                System.setProperty("http.proxyScheme", proxyScheme);
            }
            if (log.isInfoEnabled()) {
                log.info("Set proxy Host: {}, Port: {}, Scheme: {}", new Object[]{h, p, proxyScheme != null ? proxyScheme : "Not set"});
            }
        } else if (parser.getArgumentById(72) != null || parser.getArgumentById(80) != null) {
            throw new IllegalUserActionException(JMeterUtils.getResString("proxy_cl_error"));
        }
        if (parser.getArgumentById(78) != null) {
            String n = parser.getArgumentById(78).getArgument();
            System.setProperty("http.nonProxyHosts", n);
            System.setProperty("https.nonProxyHosts", n);
            log.info("Set http[s].nonProxyHosts: {}", (Object)n);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeProperties(CLArgsParser parser) {
        if (parser.getArgumentById(112) != null) {
            JMeterUtils.loadJMeterProperties(parser.getArgumentById(112).getArgument());
        } else {
            JMeterUtils.loadJMeterProperties(NewDriver.getJMeterDir() + File.separator + "bin" + File.separator + "jmeter.properties");
        }
        JMeterUtils.initLocale();
        if (parser.getArgumentById(100) == null) {
            JMeterUtils.setJMeterHome(NewDriver.getJMeterDir());
        } else {
            JMeterUtils.setJMeterHome(parser.getArgumentById(100).getArgument());
        }
        jmeterProps = JMeterUtils.getJMeterProperties();
        this.remoteProps = new Properties();
        userProp = JMeterUtils.getPropDefault("user.properties", "");
        if (userProp.length() > 0 && (file = JMeterUtils.findFile(userProp)).canRead()) {
            try {
                fis = new FileInputStream(file);
                var6_7 = null;
                try {
                    JMeter.log.info("Loading user properties from: {}", (Object)file);
                    tmp = new Properties();
                    tmp.load(fis);
                    jmeterProps.putAll((Map<?, ?>)tmp);
                }
                catch (Throwable tmp) {
                    var6_7 = tmp;
                    throw tmp;
                }
                finally {
                    if (fis != null) {
                        if (var6_7 != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable tmp) {
                                var6_7.addSuppressed(tmp);
                            }
                        } else {
                            fis.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                JMeter.log.warn("Error loading user property file: {}", (Object)userProp, (Object)e);
            }
        }
        if ((sysProp = JMeterUtils.getPropDefault("system.properties", "")).length() > 0 && (file = JMeterUtils.findFile(sysProp)).canRead()) {
            try {
                fis = new FileInputStream(file);
                tmp = null;
                try {
                    JMeter.log.info("Loading system properties from: {}", (Object)file);
                    System.getProperties().load(fis);
                }
                catch (Throwable var8_14) {
                    tmp = var8_14;
                    throw var8_14;
                }
                finally {
                    if (fis != null) {
                        if (tmp != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable var8_13) {
                                tmp.addSuppressed(var8_13);
                            }
                        } else {
                            fis.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                JMeter.log.warn("Error loading system property file: {}", (Object)sysProp, (Object)e);
            }
        }
        clOptions = parser.getArguments();
        block65: for (CLOption option : clOptions) {
            name = option.getArgument(0);
            value = option.getArgument(1);
            switch (option.getDescriptor().getId()) {
                case 0: {
                    throw new IllegalArgumentException("Unknown arg: " + option.getArgument());
                }
                case 113: {
                    JMeter.log.info("Loading additional properties from: {}", (Object)name);
                    try {
                        fis = new FileInputStream(new File(name));
                        var11_24 = null;
                        tmp = new Properties();
                        tmp.load(fis);
                        jmeterProps.putAll((Map<?, ?>)tmp);
                        if (fis == null) continue block65;
                        if (var11_24 == null) ** GOTO lbl89
                        try {
                            fis.close();
                        }
                        catch (Throwable var12_28) {
                            var11_24.addSuppressed(var12_28);
                        }
                        continue block65;
lbl89:
                        // 1 sources

                        fis.close();
                        ** break;
                        catch (Throwable var12_29) {
                            try {
                                var11_24 = var12_29;
                                throw var12_29;
                            }
                            catch (Throwable var13_33) {
                                if (fis != null) {
                                    if (var11_24 != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Throwable var14_35) {
                                            var11_24.addSuppressed(var14_35);
                                        }
                                    } else {
                                        fis.close();
                                    }
                                }
                                throw var13_33;
lbl106:
                                // 1 sources

                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        JMeter.log.warn("Can't find additional property file: {}", (Object)name, (Object)e);
                    }
                    catch (IOException e) {
                        JMeter.log.warn("Error loading additional property file: {}", (Object)name, (Object)e);
                    }
                    break;
                }
                case 83: {
                    JMeter.log.info("Setting System properties from file: {}", (Object)name);
                    try {
                        fis = new FileInputStream(new File(name));
                        var11_24 = null;
                        System.getProperties().load(fis);
                        if (fis == null) continue block65;
                        if (var11_24 == null) ** GOTO lbl128
                        try {
                            fis.close();
                        }
                        catch (Throwable var12_30) {
                            var11_24.addSuppressed(var12_30);
                        }
                        continue block65;
lbl128:
                        // 1 sources

                        fis.close();
                        ** break;
                        catch (Throwable var12_31) {
                            try {
                                var11_24 = var12_31;
                                throw var12_31;
                            }
                            catch (Throwable var15_36) {
                                if (fis != null) {
                                    if (var11_24 != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Throwable var16_37) {
                                            var11_24.addSuppressed(var16_37);
                                        }
                                    } else {
                                        fis.close();
                                    }
                                }
                                throw var15_36;
lbl145:
                                // 1 sources

                            }
                        }
                    }
                    catch (IOException e) {
                        if (!JMeter.log.isWarnEnabled()) continue block65;
                        JMeter.log.warn("Cannot find system property file. {}", (Object)e.getLocalizedMessage());
                    }
                    break;
                }
                case 68: {
                    if (value.length() > 0) {
                        JMeter.log.info("Setting System property: {}={}", (Object)name, (Object)value);
                        System.getProperties().setProperty(name, value);
                        break;
                    }
                    JMeter.log.warn("Removing System property: {}", (Object)name);
                    System.getProperties().remove(name);
                    break;
                }
                case 74: {
                    if (value.length() > 0) {
                        JMeter.log.info("Setting JMeter property: {}={}", (Object)name, (Object)value);
                        jmeterProps.setProperty(name, value);
                        break;
                    }
                    JMeter.log.warn("Removing JMeter property: {}", (Object)name);
                    jmeterProps.remove(name);
                    break;
                }
                case 71: {
                    if (value.length() > 0) {
                        JMeter.log.info("Setting Global property: {}={}", (Object)name, (Object)value);
                        this.remoteProps.setProperty(name, value);
                        break;
                    }
                    propFile = new File(name);
                    if (!propFile.canRead()) continue block65;
                    JMeter.log.info("Setting Global properties from the file {}", (Object)name);
                    try {
                        fis = new FileInputStream(propFile);
                        var12_27 = null;
                        this.remoteProps.load(fis);
                        if (fis == null) continue block65;
                        if (var12_27 == null) ** GOTO lbl192
                        try {
                            fis.close();
                        }
                        catch (Throwable var13_32) {
                            var12_27.addSuppressed(var13_32);
                        }
                        continue block65;
lbl192:
                        // 1 sources

                        fis.close();
                        ** break;
                        catch (Throwable var13_34) {
                            try {
                                var12_27 = var13_34;
                                throw var13_34;
                            }
                            catch (Throwable var17_38) {
                                if (fis != null) {
                                    if (var12_27 != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Throwable var18_39) {
                                            var12_27.addSuppressed(var18_39);
                                        }
                                    } else {
                                        fis.close();
                                    }
                                }
                                throw var17_38;
lbl209:
                                // 1 sources

                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        if (!JMeter.log.isWarnEnabled()) continue block65;
                        JMeter.log.warn("Could not find properties file: {}", (Object)e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        if (!JMeter.log.isWarnEnabled()) continue block65;
                        JMeter.log.warn("Could not load properties file: {}", (Object)e.getLocalizedMessage());
                    }
                    break;
                }
                case 76: {
                    if (value.length() > 0) {
                        JMeter.log.info("LogLevel: {}={}", (Object)name, (Object)value);
                        logLevel = Level.getLevel((String)value);
                        if (logLevel != null) {
                            loggerName = name;
                            if (name.startsWith("jmeter") || name.startsWith("jorphan")) {
                                loggerName = "org.apache." + name;
                            }
                            Configurator.setAllLevels((String)loggerName, (Level)logLevel);
                            break;
                        }
                        JMeter.log.warn("Invalid log level, '{}' for '{}'.", (Object)value, (Object)name);
                        break;
                    }
                    JMeter.log.warn("LogLevel: {}", (Object)name);
                    logLevel = Level.getLevel((String)name);
                    if (logLevel != null) {
                        Configurator.setRootLevel((Level)logLevel);
                        break;
                    }
                    JMeter.log.warn("Invalid log level, '{}', for the root logger.", (Object)name);
                    break;
                }
                case 88: {
                    this.remoteStop = true;
                    break;
                }
                case 102: {
                    this.deleteResultFile = true;
                    break;
                }
            }
        }
        sampleVariables = (String)jmeterProps.get("sample_variables");
        if (sampleVariables != null) {
            this.remoteProps.put("sample_variables", sampleVariables);
        }
        jmeterProps.put("jmeter.version", JMeterUtils.getJMeterVersion());
    }

    private String processLAST(String jmlogfile, String suffix) {
        String last;
        if ((USE_LAST_JMX.equals(jmlogfile) || USE_LAST_JMX.concat(suffix).equals(jmlogfile)) && (last = LoadRecentProject.getRecentFile(0)).toUpperCase(Locale.ENGLISH).endsWith(JMX_SUFFIX)) {
            return last.substring(0, last.length() - JMX_SUFFIX.length()).concat(suffix);
        }
        return jmlogfile;
    }

    private void startNonGui(String testFile, String logFile, CLOption remoteStart, boolean generateReportDashboard) throws IllegalUserActionException, ConfigurationException {
        System.setProperty(JMETER_NON_GUI, "true");
        JMeter driver = new JMeter();
        driver.remoteProps = this.remoteProps;
        driver.remoteStop = this.remoteStop;
        driver.deleteResultFile = this.deleteResultFile;
        PluginManager.install(this, false);
        String remoteHostsString = null;
        if (remoteStart != null && (remoteHostsString = remoteStart.getArgument()) == null) {
            remoteHostsString = JMeterUtils.getPropDefault("remote_hosts", "127.0.0.1");
        }
        if (testFile == null) {
            throw new IllegalUserActionException("Non-GUI runs require a test plan");
        }
        driver.runNonGui(testFile, logFile, remoteStart != null, remoteHostsString, generateReportDashboard);
    }

    void runNonGui(String testFile, String logFile, boolean remoteStart, String remoteHostsString, boolean generateReportDashboard) throws ConfigurationException {
        try {
            File f = new File(testFile);
            if (!f.exists() || !f.isFile()) {
                throw new ConfigurationException("The file " + f.getAbsolutePath() + " doesn't exist or can't be opened");
            }
            FileServer.getFileServer().setBaseForScript(f);
            HashTree tree = SaveService.loadTree(f);
            JMeterTreeModel treeModel = new JMeterTreeModel(new Object());
            JMeterTreeNode root = (JMeterTreeNode)treeModel.getRoot();
            treeModel.addSubTree(tree, root);
            SearchByClass replaceableControllers = new SearchByClass(ReplaceableController.class);
            tree.traverse((HashTreeTraverser)replaceableControllers);
            Collection replaceableControllersRes = replaceableControllers.getSearchResults();
            for (ReplaceableController replaceableController : replaceableControllersRes) {
                replaceableController.resolveReplacementSubTree(root);
            }
            HashTree clonedTree = JMeter.convertSubTree(tree, true);
            Summariser summariser = null;
            String summariserName = JMeterUtils.getPropDefault("summariser.name", "");
            if (summariserName.length() > 0) {
                log.info("Creating summariser <{}>", (Object)summariserName);
                JMeter.println("Creating summariser <" + summariserName + ">");
                summariser = new Summariser(summariserName);
            }
            ResultCollector resultCollector = null;
            if (logFile != null) {
                resultCollector = new ResultCollector(summariser);
                resultCollector.setFilename(logFile);
                clonedTree.add(clonedTree.getArray()[0], (Object)resultCollector);
            } else if (summariser != null) {
                clonedTree.add(clonedTree.getArray()[0], summariser);
            }
            if (this.deleteResultFile) {
                SearchByClass resultListeners = new SearchByClass(ResultCollector.class);
                clonedTree.traverse((HashTreeTraverser)resultListeners);
                for (ResultCollector rc : resultListeners.getSearchResults()) {
                    File resultFile = new File(rc.getFilename());
                    if (!resultFile.exists() || resultFile.delete()) continue;
                    throw new IllegalStateException("Could not delete results file " + resultFile.getAbsolutePath() + "(canRead:" + resultFile.canRead() + ", canWrite:" + resultFile.canWrite() + ")");
                }
            }
            ReportGenerator reportGenerator = null;
            if (logFile != null && generateReportDashboard) {
                reportGenerator = new ReportGenerator(logFile, resultCollector);
            }
            clonedTree.add(clonedTree.getArray()[0], (Object)new RemoteThreadsListenerTestElement());
            ArrayList<JMeterEngine> engines = new ArrayList<JMeterEngine>();
            JMeter.println("Created the tree successfully using " + testFile);
            if (!remoteStart) {
                StandardJMeterEngine engine = new StandardJMeterEngine();
                clonedTree.add(clonedTree.getArray()[0], (Object)new ListenToTest(ListenToTest.RunMode.LOCAL, false, reportGenerator));
                engine.configure(clonedTree);
                Instant now = Instant.now();
                JMeter.println("Starting standalone test @ " + JMeter.formatLikeDate(now) + " (" + now.toEpochMilli() + ')');
                engines.add(engine);
                engine.runTest();
            } else {
                StringTokenizer st = new StringTokenizer(remoteHostsString.trim(), ",");
                ArrayList<String> hosts = new ArrayList<String>();
                while (st.hasMoreElements()) {
                    hosts.add(((String)st.nextElement()).trim());
                }
                ListenToTest testListener = new ListenToTest(ListenToTest.RunMode.REMOTE, this.remoteStop, reportGenerator);
                clonedTree.add(clonedTree.getArray()[0], (Object)testListener);
                DistributedRunner distributedRunner = new DistributedRunner(this.remoteProps);
                distributedRunner.setStdout(System.out);
                distributedRunner.setStdErr(System.err);
                distributedRunner.init(hosts, clonedTree);
                engines.addAll(distributedRunner.getEngines());
                testListener.setStartedRemoteEngines(engines);
                distributedRunner.start();
            }
            JMeter.startUdpDdaemon(engines);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("Error in NonGUIDriver " + e.toString());
            log.error("Error in NonGUIDriver", (Throwable)e);
            throw new ConfigurationException("Error in NonGUIDriver " + e.getMessage(), e);
        }
    }

    private static String formatLikeDate(Instant instant) {
        return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withLocale(Locale.ROOT).withZone(ZoneId.systemDefault()).format(instant);
    }

    @Deprecated
    public static void convertSubTree(HashTree tree) {
        JMeter.convertSubTree(tree, false);
    }

    public static HashTree convertSubTree(HashTree tree, boolean cloneAtEnd) {
        JMeter.pConvertSubTree(tree);
        if (cloneAtEnd) {
            TreeCloner cloner = new TreeCloner(false);
            tree.traverse((HashTreeTraverser)cloner);
            return cloner.getClonedTree();
        }
        return tree;
    }

    private static void pConvertSubTree(HashTree tree) {
        for (Object o : new ArrayList(tree.list())) {
            Cloneable item;
            if (o instanceof TestElement) {
                item = (TestElement)o;
                if (item.isEnabled()) {
                    if (item instanceof ReplaceableController) {
                        HashTree replacementTree;
                        ReplaceableController rc = JMeter.ensureReplaceableControllerIsLoaded((TestElement)item);
                        HashTree subTree = tree.getTree((Object)item);
                        if (subTree == null || (replacementTree = rc.getReplacementSubTree()) == null) continue;
                        JMeter.pConvertSubTree(replacementTree);
                        tree.replaceKey((Object)item, (Object)rc);
                        tree.set((Object)rc, replacementTree);
                        continue;
                    }
                    JMeter.pConvertSubTree(tree.getTree((Object)item));
                    continue;
                }
                tree.remove((Object)item);
                continue;
            }
            item = (JMeterTreeNode)o;
            if (((JMeterTreeNode)item).isEnabled()) {
                if (((DefaultMutableTreeNode)item).getUserObject() instanceof ReplaceableController) {
                    HashTree replacementTree;
                    TestElement controllerAsItem = ((JMeterTreeNode)item).getTestElement();
                    ReplaceableController rc = JMeter.ensureReplaceableControllerIsLoaded(controllerAsItem);
                    HashTree subTree = tree.getTree((Object)item);
                    if (subTree == null || (replacementTree = rc.getReplacementSubTree()) == null) continue;
                    JMeter.pConvertSubTree(replacementTree);
                    tree.replaceKey((Object)item, (Object)rc);
                    tree.set((Object)rc, replacementTree);
                    continue;
                }
                JMeter.pConvertSubTree(tree.getTree((Object)item));
                TestElement testElement = ((JMeterTreeNode)item).getTestElement();
                tree.replaceKey((Object)item, (Object)testElement);
                continue;
            }
            tree.remove((Object)item);
        }
    }

    private static ReplaceableController ensureReplaceableControllerIsLoaded(TestElement item) {
        ReplaceableController rc = "org.apache.jmeter.control.ModuleController".equals(item.getClass().getName()) ? (ReplaceableController)((Object)item) : (ReplaceableController)item.clone();
        return rc;
    }

    private static void println(String str) {
        System.out.println(str);
    }

    @Override
    public String[][] getIconMappings() {
        String defaultIconProp = "org/apache/jmeter/images/icon.properties";
        String iconSize = JMeterUtils.getPropDefault(TREE_ICON_SIZE, DEFAULT_TREE_ICON_SIZE);
        String iconProp = JMeterUtils.getPropDefault("jmeter.icons", "org/apache/jmeter/images/icon.properties");
        Properties p = JMeterUtils.loadProperties(iconProp);
        if (p == null && !iconProp.equals("org/apache/jmeter/images/icon.properties")) {
            log.info("{} not found - using {}", (Object)iconProp, (Object)"org/apache/jmeter/images/icon.properties");
            iconProp = "org/apache/jmeter/images/icon.properties";
            p = JMeterUtils.loadProperties(iconProp);
        }
        if (p == null) {
            log.info("{} not found - using inbuilt icon set", (Object)iconProp);
            return DEFAULT_ICONS;
        }
        log.info("Loaded icon properties from {}", (Object)iconProp);
        String[][] iconlist = new String[p.size()][3];
        Enumeration<Object> pe = p.keys();
        int i = 0;
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            String[] icons = JOrphanUtils.split((String)p.getProperty(key), (String)" ");
            iconlist[i][0] = key;
            iconlist[i][1] = icons[0].replace(KEY_SIZE, iconSize);
            if (icons.length > 1) {
                iconlist[i][2] = icons[1].replace(KEY_SIZE, iconSize);
            }
            ++i;
        }
        return iconlist;
    }

    @Override
    public String[][] getResourceBundles() {
        return new String[0][];
    }

    public static boolean isNonGUI() {
        return "true".equals(System.getProperty(JMETER_NON_GUI));
    }

    private static void startUdpDdaemon(final List<JMeterEngine> engines) {
        int port = JMeterUtils.getPropDefault("jmeterengine.nongui.port", 4445);
        int maxPort = JMeterUtils.getPropDefault("jmeterengine.nongui.maxport", 4455);
        if (port > 1000) {
            final DatagramSocket socket = JMeter.getSocket(port, maxPort);
            if (socket != null) {
                Thread waiter = new Thread("UDP Listener"){

                    @Override
                    public void run() {
                        JMeter.waitForSignals(engines, socket);
                    }
                };
                waiter.setDaemon(true);
                waiter.start();
            } else {
                System.out.println("Failed to create UDP port");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void waitForSignals(List<JMeterEngine> engines, DatagramSocket socket) {
        byte[] buf = new byte[80];
        System.out.println("Waiting for possible Shutdown/StopTestNow/HeapDump/ThreadDump message on port " + socket.getLocalPort());
        DatagramPacket request = new DatagramPacket(buf, buf.length);
        try {
            try {
                block17: while (true) {
                    socket.receive(request);
                    InetAddress address = request.getAddress();
                    if (!address.isLoopbackAddress()) continue;
                    String command = new String(request.getData(), request.getOffset(), request.getLength(), StandardCharsets.US_ASCII);
                    System.out.println("Command: " + command + " received from " + address);
                    log.info("Command: {} received from {}", (Object)command, (Object)address);
                    switch (command) {
                        case "StopTestNow": {
                            JMeterEngine engine;
                            Iterator<JMeterEngine> iterator = engines.iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block17;
                                engine = iterator.next();
                                engine.stopTest(true);
                            }
                        }
                        case "Shutdown": {
                            JMeterEngine engine;
                            Iterator<JMeterEngine> iterator = engines.iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block17;
                                engine = iterator.next();
                                engine.stopTest(false);
                            }
                        }
                        case "HeapDump": {
                            HeapDumper.dumpHeap();
                            continue block17;
                        }
                        case "ThreadDump": {
                            ThreadDumper.threadDump();
                            continue block17;
                        }
                    }
                    System.out.println("Command: " + command + " not recognised ");
                }
            }
            catch (Exception e) {
                System.out.println(e);
                return;
            }
        }
        finally {
            socket.close();
        }
    }

    private static DatagramSocket getSocket(int udpPort, int udpPortMax) {
        DatagramSocket socket = null;
        for (int i = udpPort; i <= udpPortMax; ++i) {
            try {
                socket = new DatagramSocket(i);
                break;
            }
            catch (SocketException e) {
                continue;
            }
        }
        return socket;
    }

    private static class ListenToTest
    implements TestStateListener,
    Remoteable {
        private AtomicInteger startedRemoteEngines = new AtomicInteger(0);
        private ConcurrentLinkedQueue<JMeterEngine> remoteEngines = new ConcurrentLinkedQueue();
        private final ReportGenerator reportGenerator;
        private RunMode runMode;
        private boolean remoteStop;

        public ListenToTest(RunMode runMode, boolean remoteStop, ReportGenerator reportGenerator) {
            this.runMode = runMode;
            this.remoteStop = remoteStop;
            this.reportGenerator = reportGenerator;
        }

        public void setStartedRemoteEngines(List<JMeterEngine> engines) {
            if (this.runMode != RunMode.REMOTE) {
                throw new IllegalArgumentException("This method should only be called in RunMode.REMOTE");
            }
            this.remoteEngines.clear();
            this.remoteEngines.addAll(engines);
            this.startedRemoteEngines = new AtomicInteger(this.remoteEngines.size());
        }

        @Override
        public void testEnded(String host) {
            long now = System.currentTimeMillis();
            log.info("Finished remote host: {} ({})", (Object)host, (Object)now);
            if (this.startedRemoteEngines.decrementAndGet() <= 0) {
                log.info("All remote engines have ended test, starting RemoteTestStopper thread");
                Thread stopSoon = new Thread(() -> this.endTest(true), "RemoteTestStopper");
                stopSoon.setDaemon(false);
                stopSoon.start();
            }
        }

        @Override
        public void testEnded() {
            this.endTest(false);
        }

        @Override
        public void testStarted(String host) {
            long now = System.currentTimeMillis();
            log.info("Started remote host:  {} ({})", (Object)host, (Object)now);
        }

        @Override
        public void testStarted() {
            if (log.isInfoEnabled()) {
                long now = System.currentTimeMillis();
                log.info("{} ({})", (Object)JMeterUtils.getResString("running_test"), (Object)now);
            }
        }

        private void endTest(boolean isDistributed) {
            Instant now = Instant.now();
            if (isDistributed) {
                JMeter.println("Tidying up remote @ " + JMeter.formatLikeDate(now) + " (" + now.toEpochMilli() + ')');
            } else {
                JMeter.println("Tidying up ...    @ " + JMeter.formatLikeDate(now) + " (" + now.toEpochMilli() + ')');
            }
            if (isDistributed) {
                if (this.remoteStop) {
                    JMeter.println("Exiting remote servers:" + this.remoteEngines);
                    for (JMeterEngine engine : this.remoteEngines) {
                        JMeter.println("Exiting remote server:" + engine);
                        engine.exit();
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                ClientJMeterEngine.tidyRMI(log);
            }
            if (this.reportGenerator != null) {
                try {
                    log.info("Generating Dashboard");
                    this.reportGenerator.generate();
                    log.info("Dashboard generated");
                }
                catch (Exception ex) {
                    System.err.println("Error generating the report: " + ex);
                    log.error("Error generating the report: {}", (Object)ex.getMessage(), (Object)ex);
                }
            }
            this.checkForRemainingThreads();
            JMeter.println("... end of run");
        }

        private void checkForRemainingThreads() {
            final int pauseToCheckForRemainingThreads = JMeterUtils.getPropDefault("jmeter.exit.check.pause", 0);
            if (pauseToCheckForRemainingThreads > 0) {
                Thread daemon = new Thread(){

                    @Override
                    public void run() {
                        try {
                            TimeUnit.MILLISECONDS.sleep(pauseToCheckForRemainingThreads);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                        System.out.println("The JVM should have exited but did not.");
                        System.out.println("The following non-daemon threads are still running (DestroyJavaVM is OK):");
                        JOrphanUtils.displayThreads((boolean)false);
                    }
                };
                daemon.setDaemon(true);
                daemon.start();
            } else if (pauseToCheckForRemainingThreads <= 0) {
                log.debug("jmeter.exit.check.pause is <= 0, JMeter won't check for unterminated non-daemon threads");
            }
        }

        static enum RunMode {
            LOCAL,
            REMOTE;

        }
    }
}

