/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.letsPlot.intern.standardizing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.letsPlot.intern.standardizing.Standardizing;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\u0014\u0010\u0006\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J\"\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Ljetbrains/letsPlot/intern/standardizing/SeriesStandardizing;", "", "()V", "isListy", "", "rawValue", "needToStandardizeValues", "series", "", "standardizeIterable", "standardizeList", "", "toList", "messageKey", "", "plot-api"})
public final class SeriesStandardizing {
    @NotNull
    public static final SeriesStandardizing INSTANCE = new SeriesStandardizing();

    private SeriesStandardizing() {
    }

    public final boolean isListy(@Nullable Object rawValue) {
        Object object = rawValue;
        return object instanceof List ? true : (object instanceof Iterable ? true : (object instanceof Sequence ? true : (object instanceof Object[] ? true : (object instanceof byte[] ? true : (object instanceof short[] ? true : (object instanceof int[] ? true : (object instanceof long[] ? true : (object instanceof float[] ? true : (object instanceof double[] ? true : (object instanceof char[] ? true : object instanceof Pair))))))))));
    }

    @NotNull
    public final List<Object> toList(@NotNull Object rawValue, @Nullable String messageKey) {
        List<?> list;
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        Object object = rawValue;
        if (object instanceof List) {
            list = this.standardizeList((List)rawValue);
        } else if (object instanceof Iterable) {
            list = CollectionsKt.toList(this.standardizeIterable((Iterable)rawValue));
        } else if (object instanceof Sequence) {
            list = CollectionsKt.toList(this.standardizeIterable(SequencesKt.asIterable((Sequence)((Sequence)rawValue))));
        } else if (object instanceof Object[]) {
            list = this.standardizeList(ArraysKt.asList((Object[])((Object[])rawValue)));
        } else if (object instanceof byte[]) {
            list = this.standardizeList(ArraysKt.asList((byte[])((byte[])rawValue)));
        } else if (object instanceof short[]) {
            list = this.standardizeList(ArraysKt.asList((short[])((short[])rawValue)));
        } else if (object instanceof int[]) {
            list = this.standardizeList(ArraysKt.asList((int[])((int[])rawValue)));
        } else if (object instanceof long[]) {
            list = this.standardizeList(ArraysKt.asList((long[])((long[])rawValue)));
        } else if (object instanceof float[]) {
            list = this.standardizeList(ArraysKt.asList((float[])((float[])rawValue)));
        } else if (object instanceof double[]) {
            list = this.standardizeList(ArraysKt.asList((double[])((double[])rawValue)));
        } else if (object instanceof char[]) {
            list = this.standardizeList(ArraysKt.asList((char[])((char[])rawValue)));
        } else if (object instanceof Pair) {
            list = this.standardizeList(TuplesKt.toList((Pair)((Pair)rawValue)));
        } else {
            String string;
            String string2 = messageKey;
            if (string2 == null) {
                string = "";
            } else {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                String string4 = '[' + messageKey + ']';
                string = string4 == null ? "" : string4;
            }
            String keyInfo = string;
            throw new IllegalArgumentException("Can't transform " + Reflection.getOrCreateKotlinClass(rawValue.getClass()).getSimpleName() + " to list" + keyInfo + '.');
        }
        return list;
    }

    public static /* synthetic */ List toList$default(SeriesStandardizing seriesStandardizing, Object object, String string, int n, Object object2) {
        if ((n & 2) != 0) {
            string = null;
        }
        return seriesStandardizing.toList(object, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToStandardizeValues(Iterable<?> series) {
        boolean bl;
        Iterable<?> $this$any$iv = series;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator<?> iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            if (it != null) {
                if (!(it instanceof String)) {
                    if (!(it instanceof Double)) return true;
                }
                if (it instanceof Double) {
                    double d = ((Number)it).doubleValue();
                    boolean bl3 = false;
                    double d2 = d;
                    boolean bl4 = false;
                    if (Double.isInfinite(d2)) return true;
                    d2 = d;
                    bl4 = false;
                    if (Double.isNaN(d2)) return true;
                    boolean bl5 = true;
                    if (!bl5) {
                        return true;
                    }
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final List<?> standardizeList(List<?> series) {
        return (List)this.standardizeIterable((Iterable)series);
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<?> standardizeIterable(Iterable<?> series) {
        Iterable iterable;
        if (this.needToStandardizeValues(series)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = series;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = Standardizing.INSTANCE.standardizeValue(it);
                collection.add(object);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = series;
        }
        return iterable;
    }
}

