/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.delegate.TableCellEditorDelegate;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.ui.table.TableConstants;
import com.github.weisj.darklaf.ui.table.renderer.DarkMultiCellEditor;
import com.github.weisj.darklaf.ui.table.renderer.IconWrapper;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class DarkTableCellEditorDelegate
extends TableCellEditorDelegate {
    private static final IconWrapper iconWrapper = new IconWrapper();

    public DarkTableCellEditorDelegate() {
        super(new DarkMultiCellEditor());
    }

    public DarkTableCellEditorDelegate(TableCellEditor editor) {
        super(editor);
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        Object value;
        int col;
        Point p;
        int row;
        if (anEvent == null) {
            return super.isCellEditable(null);
        }
        JTable table = (JTable)anEvent.getSource();
        if (anEvent instanceof KeyEvent && DarkTableUI.ignoreKeyCodeOnEdit((KeyEvent)anEvent, table)) {
            return false;
        }
        if (TableConstants.isBooleanRenderingEnabled(table) && anEvent instanceof MouseEvent && this.isValidIndex(table, row = table.rowAtPoint(p = ((MouseEvent)anEvent).getPoint()), col = table.columnAtPoint(p)) && TableConstants.useBooleanEditorForValue(value = table.getValueAt(row, col), table, col, false)) {
            return this.insideBooleanRenderer(table, row, col, p);
        }
        return super.isCellEditable(anEvent);
    }

    private boolean isValidIndex(JTable table, int row, int col) {
        return row >= 0 && row < table.getRowCount() && col >= 0 && col < table.getColumnCount();
    }

    private boolean insideBooleanRenderer(JTable table, int row, int col, Point p) {
        Rectangle rect = table.getCellRect(row, col, false);
        p.x -= rect.x;
        p.y -= rect.y;
        Component editor = table.getCellRenderer(row, col).getTableCellRendererComponent(table, true, false, false, row, col);
        editor.setBounds(rect);
        return editor.contains(p);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (TableConstants.useBooleanEditorForValue(value, table, column)) {
            table.setValueAt((Boolean)value == false, row, column);
            table.repaint();
            return null;
        }
        Component editor = this.getDelegate().getTableCellEditorComponent(table, value, isSelected, row, column);
        editor = this.prepareEditorComponent(editor, table, value, isSelected, row, column);
        return editor;
    }

    protected Component prepareEditorComponent(Component editor, JTable table, Object value, boolean isSelected, int row, int column) {
        return DarkTableCellEditorDelegate.prepareEditor(editor, table, value, isSelected, row, column);
    }

    public static Component prepareEditor(Component editor, JTable table, Object value, boolean isSelected, int row, int column) {
        Component renderer = table.getCellRenderer(row, column).getTableCellRendererComponent(table, value, isSelected, false, row, column);
        DarkTableCellEditorDelegate.setupEditorComponent(editor, value, renderer);
        Component comp = DarkTableCellEditorDelegate.applyRendererIcon(editor, renderer);
        CellUtil.setupTableBackground(comp, table, false, row);
        return comp;
    }

    protected static void setupEditorComponent(Component editorComponent, Object value, Component rendererComp) {
        int alignment;
        if (editorComponent instanceof JSpinner && (alignment = DarkTableCellEditorDelegate.getHorizontalAlignment(rendererComp)) >= 0) {
            ((JComponent)editorComponent).putClientProperty("JSpinner.cellEditorAlignment", alignment);
        }
        if (editorComponent instanceof JTextField && (alignment = DarkTableCellEditorDelegate.getHorizontalAlignment(rendererComp)) >= 0) {
            ((JTextField)editorComponent).setHorizontalAlignment(alignment);
        }
    }

    protected static int getHorizontalAlignment(Component rendererComp) {
        if (rendererComp instanceof JTextField) {
            return ((JTextField)rendererComp).getHorizontalAlignment();
        }
        if (rendererComp instanceof JLabel) {
            return ((JLabel)rendererComp).getHorizontalAlignment();
        }
        return -1;
    }

    protected static Component applyRendererIcon(Component editorComponent, Component rendererComponent) {
        Icon icon;
        Component comp = editorComponent;
        if (rendererComponent instanceof JLabel && comp instanceof JComponent && (icon = ((JLabel)rendererComponent).getIcon()) != null) {
            iconWrapper.init((JComponent)comp, icon, rendererComponent.getComponentOrientation());
            iconWrapper.setIconGap(((JLabel)rendererComponent).getIconTextGap() - 1);
            comp = iconWrapper;
        }
        return comp;
    }
}

